/*
 * $Id: hotkey.c 1.3 1996/09/15 22:51:36 Madsen Exp $
 *
 * Hot key functions
 *
 */

#include <ctype.h>
#include <stdlib.h>
#include "frotz.h"

extern int stream_record;
extern int replaying;

static int aborting;

char init_name[MAX_FILE_NAME + 1] = DEFAULT_INIT_NAME;

/*
 * hot_key_alias
 *
 */

static void hot_key_alias (void)
{
  int c;
  char alias[11] = "";
  char expansion[(MAX_FILE_NAME > 79) ? MAX_FILE_NAME+1 : 80] = "";
  char* s;

  print_string("Alias A)dd C)lear D)elete L)oad O)");
  print_string(use_aliases ? "ff" : "n");
  print_string(" S)ave V)iew: ");
  c = read_char(0);
  if (isalnum(c)) print_char(c);
  z_new_line();

  switch (tolower(c)) {
   case 'a':
    print_string("Add alias: ");
    while (read_line(sizeof(alias)-1, alias, 0, 0) != 13);
    z_new_line();
    for (s = alias; *s; ++s)
      if (!isalnum(*s)) return;
    if (!alias[0]) return;

    print_string("Expansion: ");
    while (read_line(sizeof(expansion)-1, expansion, 0, 0) != 13);
    z_new_line();
    if (!expansion[0]) return;
    add_alias(alias, expansion);
    break;

   case 'c':
    print_string("Clear all aliases (yes/no): ");
    while (read_line(sizeof(alias)-1, alias, 0, 0) != 13);
    z_new_line();
    if (alias[0] == 'y') {
      clear_aliases();
      print_string("Aliases cleared\n");
    }
    break;

   case 'd':
    print_string("Delete alias: ");
    while (read_line(sizeof(alias)-1, alias, 0, 0) != 13);
    z_new_line();
    delete_alias(alias);
    break;

   case 'l':
    if (os_get_file_name(expansion, init_name, FILE_LOAD_INIT)) {
      strcpy(init_name, expansion);
      load_aliases(init_name);
    }
    break;

   case 'o':
    use_aliases = !use_aliases;
    print_string("Alias expansion o");
    print_string(use_aliases ? "n" : "ff");
    z_new_line();
    break;

   case 's':
    if (os_get_file_name(expansion, init_name, FILE_SAVE_INIT)) {
      strcpy(init_name, expansion);
      save_aliases(init_name);
    }
    break;

   case 'v':
    list_aliases();
    break;
  }
} /* end hot_key_alias */

/*
 * hot_key_playback
 *
 */

static void hot_key_playback (void)
{

    print_string ("Playback on\n");
    z_input_stream (1);

}/* hot_key_playback */

/*
 * hot_key_recording
 *
 */

static void hot_key_recording (void)
{

    if (replaying) {
	print_string ("Playback off\n");
	z_input_stream (0);
    } else if (stream_record) {
	print_string ("Recording off\n");
	z_output_stream (1, -4, 0, 0);
    } else {
	print_string ("Recording on\n");
	z_output_stream (1, 4, 0, 0);
    }

}/* hot_key_recording */

/*
 * hot_key_seed
 *
 */

static void hot_key_seed (void)
{
    char buffer[6];

    print_string ("Seed random numbers\n");
    print_string ("Enter seed value (or return to randomize): ");

    /* Read new seed value */

    buffer[0] = 0;

    while (read_line (5, buffer, 0, 0) != 13);
    z_new_line ();

    /* Set new seed value */

    seed_random (atoi (buffer));

}/* hot_key_seed */

/*
 * hot_key_undo
 *
 */

static void hot_key_undo (void)
{

    print_string ("Undo one turn\n");

    /* Attempt to undo */

    undo_flag = 0;

    z_restore_undo (1);

    if (undo_flag == 0) {
	print_string ("No more undo information available.\n");
	return;
    }

    /* See if this a V5+ game... */

    if (h_version >= V5) {

	/* Store 2 for successful undo */

	store (2);

	/* Abort current input action */

	aborting = 1;
    }

}/* hot_key_undo */

/*
 * hot_key_restart
 *
 */

static void hot_key_restart (void)
{
    int key;

    print_string ("New game\n");
    print_string ("Do you wish to restart? (y/n) >");

    /* Read yes or no */

    key = read_char (0);
    z_new_line ();

    if (key != 'y' && key != 'Y')
	return;

    /* Restart */

    z_restart ();

    /* Abort current input action */

    aborting = 1;

}/* hot_key_restart */

/*
 * hot_key_quit
 *
 */

static void hot_key_quit (void)
{
    int key;

    print_string ("Exit game\n");
    print_string ("Do you wish to quit? (y/n) >");

    /* Read yes or no */

    key = read_char (0);
    z_new_line ();

    if (key != 'y' && key != 'Y')
	return;

    /* Quit */

    z_quit ();

    /* Abort current input action */

    aborting = 1;

}/* hot_key_quit */

/*
 * hot_key
 *
 * Perform the action associated with a so-called hot key. Returns true
 * to signal that the current input instruction should be aborted.
 *
 */

int hot_key (int key)
{

    aborting = 0;

    if (cwin == 0) {

	print_string ("\nHot key -- ");

	if (key == HOT_KEY_RECORDING)
	    hot_key_recording ();
	if (key == HOT_KEY_PLAYBACK)
	    hot_key_playback ();
	if (key == HOT_KEY_SEED)
	    hot_key_seed ();
	if (key == HOT_KEY_UNDO)
	    hot_key_undo ();
	if (key == HOT_KEY_RESTART)
	    hot_key_restart ();
	if (key == HOT_KEY_QUIT)
	    hot_key_quit ();
        if (key == HOT_KEY_ALIAS)
            hot_key_alias ();
    }

    return aborting;

}/* hot_key */
