/* Quake OS/2 Warp WorkPlace Shell installation script		*/
/* First Draft - series C					*/
/* duanec@ibm.net   Duane Chamblee 			dAc0696	*/
/*--------------------------------------------------------------*/
/*   I've thrown in some Icons here, just as place fillers	*/
/*								*/
/*-----------------------INSTALLATION---------------------------*/
/*  Copy all these files to the directory where QUAKE is	*/
/* installed. Type(or double click) MAKEOBJ.CMD			*/


/* Load OS/2 REXX Utilities.					*/
Call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
Call SysLoadFuncs;

/* Get source directory (path to .CMD)				*/
parse source . . CMDname
CMDdir=FILESPEC('D',CMDname)FILESPEC('P',CMDname)

/* Check for existance of required file(key) */
  rc=SysFileTree(CMDdir'QUAKE.EXE',Pres)
 
if Pres.0=0 then do
    Say 'Make sure all the .ICO and .CMD files are placed'
    Say 'in the same directory that QUAKE was installed.'
    '@pause'
    exit
    End

Say 'Giving home directory it''s new icon.'
/* Strip the trailing '\' from the path				*/
tempName=LEFT(CMDdir,LENGTH(CMDdir)-1)
say tempName
rc=SysSetObjectData(tempName,'OBJECTID=<QUAKE_HOME>;'||,
          'ICONFILE='CMDdir'Home.ICO;'||,
	  'ICONNFILE=1,'CMDdir'HomeO.ICO;')

Say ''
Say 'Creating Quake Desktop folder...'
classname='WPFolder'
title    ='QUAKE'
location ='<WP_DESKTOP>'
setup    ='OBJECTID=<QUAKE_DESKTOP>;'||,
          'ALWAYSSORT=YES;'||,
          'ICONFILE='CMDdir'\Folder.ICO;'||,
	  'ICONNFILE=1,'CMDdir'\FolderO.ICO;'
Call BldObj

/* Open Desktop Folder, twice for foreground			*/
Call SysSetObjectData  '<QUAKE_DESKTOP>', 'OPEN=DEFAULT'
Call SysSetObjectData  '<QUAKE_DESKTOP>', 'OPEN=DEFAULT'

Say 'Creating Quake Application Object...'
classname='WPProgram'
title    ='QUAKE'
location ='<QUAKE_DESKTOP>'
setup    ='OBJECTID=<QUAKE_APP>;'||,
          'EXENAME='CMDdir'QUAKE.EXE;'||,
	  'PARAMETERS=%;'||,
          'STARTUPDIR='CMDdir';'||,
          'PROGTYPE=VDM;'||,
          'ICONFILE='CMDdir'\QUAKE.ICO;'||,
	  'SET DOS_DEVICE=;' ||,
	  'SET DOS_HIGH=0;' ||,
	  'SET DOS_BACKGROUND_EXECUTION=0;' ||,
	  'SET DPMI_MEMORY_LIMIT=16;' ||,
	  'SET SESSION_PRIORITY=31;' ||,
	  'SET DPMI_DOS_API=ENABLED;' ||,
	  'SET VIDEO_ROM_EMULATION=0;' ||,
	  'SET VIDEO_8514A_XGA_IOTRAP=0;'
Call BldObj

/* Apply icons to shadowed files */
call SysSetObjectData CMDdir'README.TXT','ICONFILE='CMDdir'readme.ico;'
call SysSetObjectData CMDdir'HELP.TXT','ICONFILE='CMDdir'help.ico;'
call SysSetObjectData CMDdir'TECHINFO.TXT','ICONFILE='CMDdir'techinfo.ico;'
call SysSetObjectData CMDdir'MANUAL.TXT','ICONFILE='CMDdir'manual.ico;'

Say 'Creating Shadow of README.TXT...'
classname='WPShadow'
title    ='Read Me!!'
location ='<QUAKE_DESKTOP>'
setup    ='SHADOWID='CMDdir'README.TXT;'||,
	  'OBJECTID=<QUAKE_README>;'
Call BldObj

Say 'Creating Shadow of HELP.TXT...'
classname='WPShadow'
title    ='Help file'
location ='<QUAKE_DESKTOP>'
setup    ='SHADOWID='CMDdir'HELP.TXT;'||,
	  'OBJECTID=<QUAKE_HELP>;'
Call BldObj

Say 'Creating Shadow of TECHINFO.TXT...'
classname='WPShadow'
title    ='Tech.Info.'
location ='<QUAKE_DESKTOP>'
setup    ='SHADOWID='CMDdir'TECHINFO.TXT;'||,
	  'OBJECTID=<QUAKE_TECHINFO>;'
Call BldObj

Say 'Creating Shadow of SLICNSE.TXT...'
classname='WPShadow'
title    ='Software License'
location ='<QUAKE_DESKTOP>'
setup    ='SHADOWID='CMDdir'SLICNSE.TXT;'||,
	  'OBJECTID=<QUAKE_SLICNSE>;'
Call BldObj

Say 'Creating Shadow of LICINFO.TXT...'
classname='WPShadow'
title    ='License Info'
location ='<QUAKE_DESKTOP>'
setup    ='SHADOWID='CMDdir'LICINFO.TXT;'||,
	  'OBJECTID=<QUAKE_LICINFO>;'
Call BldObj

Say 'Creating Shadow of MANUAL.TXT...'
classname='WPShadow'
title    ='Manual'
location ='<QUAKE_DESKTOP>'
setup    ='SHADOWID='CMDdir'MANUAL.TXT;'||,
	  'OBJECTID=<QUAKE_MANUAL>;'
Call BldObj

Say 'Creating Shadow of ORDER.TXT...'
classname='WPShadow'
title    ='ordering'
location ='<QUAKE_DESKTOP>'
setup    ='SHADOWID='CMDdir'ORDER.TXT;'||,
	  'OBJECTID=<QUAKE_ORDER>;'
Call BldObj


/* Open Readme, twice for foreground				*/
Call SysSetObjectData  '<QUAKE_README>', 'OPEN=DEFAULT'
Call SysSetObjectData  CMDdir'os2Read.txt', 'OPEN=DEFAULT'

Exit

BldObj:

/*The basic call is listed next.                                           */
/*rc=SysCreateObject(classname, title, location <,setup>, <,duplicateflag>)*/

result = SysCreateObject(classname, title, location, setup, 'U')

If result \= 1 Then 
   Do
      say title'...   Not created! Return code='result
      pause
   End

Say '';
Return

