/*
    K Video Accelerator library for OS/2
    Copyright (C) 2007 by KO Myung-Hun <komh@chollian.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Changes :
        KO Myung-Hun <komh@chollian.net> 2007/02/25
            - Added KVAE_NO_ATTRIBUTE macro
            - Added KVAA_* macros
            - Added prototypes for kvaQueryAttr(), kvaSetAttr() and
              kvaResetAttr()
*/

#ifndef __KVA_H__
#define __KVA_H__

#include <os2.h>
#include <mmioos2.h>

#ifdef __cplusplus
extern "C" {
#endif

#define KVAM_AUTO   0
#define KVAM_DIVE   1
#define KVAM_WO     2

#define KVAR_NONE       0
#define KVAR_ORIGINAL   1
#define KVAR_FORCE43    2
#define KVAR_FORCE169   3

#define KVAE_NO_ERROR                  0
#define KVAE_NOT_INITIALIZED        ( -1 )
#define KVAE_ALREADY_INITIALIZED    ( -2 )
#define KVAE_INVALID_PARAMETER      ( -3 )
#define KVAE_ALREADY_LOCKED         ( -4 )
#define KVAE_NOT_LOCKED             ( -5 )
#define KVAE_CANNOT_SUBCLASS        ( -6 )
#define KVAE_CANNOT_LOAD_WO         ( -7 )
#define KVAE_NO_SUPPORTED_FOURCC    ( -8 )
#define KVAE_WO_PALETTIZED_MODE     ( -9 )
#define KVAE_NO_ATTRIBUTE           ( -10 )

#define KVAA_BRIGHTNESS 0
#define KVAA_CONTRAST   1
#define KVAA_SATURATION 2
#define KVAA_HUE        3
#define KVAA_LAST       ( KVAA_HUE + 1 )

#pragma pack( 1 )

typedef struct tagKVASETUP
{
    ULONG       ulLength;         //size of structure in bytes
    RECTL       rclSrcRect;       //displayed subrectangle
    SIZEL       szlSrcSize;       //source image size
    ULONG       ulRatio;          //aspect ratio
    ULONG       fccSrcColor;      //image format, only for DIVE
    BOOL        fInvert;          //image invert, only for DIVE
    BOOL        fDither;          //image dither, only for DIVE
} KVASETUP, *PKVASETUP;

typedef struct tagKVACAPS
{
    ULONG   ulMode;
    ULONG   ulDepth;
    ULONG   cxScreen;
    ULONG   cyScreen;
    FOURCC  fccScreen;
} KVACAPS, *PKVACAPS;

#pragma pack()

APIRET APIENTRY kvaInit( ULONG kvaMode, HWND hwnd, ULONG ulKeyColor );
APIRET APIENTRY kvaDone( VOID );
APIRET APIENTRY kvaLockBuffer( PPVOID ppBuffer, PULONG pulBPL );
APIRET APIENTRY kvaUnlockBuffer( VOID );
APIRET APIENTRY kvaSetup( PKVASETUP pkvas );
APIRET APIENTRY kvaCaps( PKVACAPS pkvac );
APIRET APIENTRY kvaClearRect( PRECTL prcl );
APIRET APIENTRY kvaQueryAttr( ULONG ulAttr, PULONG pulValue );
APIRET APIENTRY kvaSetAttr( ULONG ulAttr, PULONG pulValue );
APIRET APIENTRY kvaResetAttr( VOID );

#ifdef __cplusplus
}
#endif

#endif
