/* $Id: denise.c,v 1.2 1999-09-04 08:53:08-04 rl Exp $ */


/*************************************************************************
 *                                                                       *
 * denise.c                                                              *
 * Original code of revision 1 of RenamePics, modified to fit into       *
 * new code that can also handle EXIF                                    *
 *                                                                       *
 *************************************************************************/


#include "renamepics.h"
#include "denise.h"


/* Old Olympus file tags */

char *pictureInfoKey = "[picture info]";
char *timeDateKey = "TimeDate=";
char *shutterKey = "Shutter=";
char *flashKey = "Flash=";
char *imageSizeKey = "ImageSize=";
char *apertureKey = "FNumber=F";
char *macroKey = "Macro=";
char *ptr;


/*************************************************************************
 *                                                                       *
 * searchMemoryForString()                                               *
 * Search an an area of memory for a given string                        *
 * The search returns a pointer to the string, or NULL if the string     *
 * is not contained in the memory area                                   *
 *                                                                       *
 *************************************************************************/
char *searchMemoryForString ( char *start, char *end, char *target ) 
  {

  char *t;
  char *b;
  char *buffer = start;

  while( buffer != end) 
    {

    t = target;
    b = buffer;

    while( (*t == *b) && (*t != 0) && (b != end) ) 
      {
      t += 1;
      b += 1;
      }

    if( *t == 0 ) 
      return( buffer );

    buffer += 1;

    }

  return( NULL );

  }


/*************************************************************************
 *                                                                       *
 * writeCommentEA()                                                      *
 * Write a .COMMENT extended attribute                                   *
 *                                                                       *
 *************************************************************************/
void writeCommentEA ( char *fileName, char *comment )
  {

  EAOP2 eaop2;
  FEA2 *pFEA2;
  char *szNamePtr;
  int rc;

  eaop2.fpGEA2List = 0;
  eaop2.fpFEA2List = malloc( sizeof(FEA2LIST) );
  pFEA2 = &eaop2.fpFEA2List->list[0];

  pFEA2->fEA = 0;
  pFEA2->cbName = strlen( ".COMMENTS" );
  pFEA2->cbValue = strlen(comment) + 5 * sizeof(unsigned short);
 
  szNamePtr = pFEA2->szName;
  strcpy( szNamePtr, ".COMMENTS" );
  szNamePtr += strlen(".COMMENTS") + 1;
  *(unsigned short *)szNamePtr = 0xFFDF;
  ((unsigned short *)szNamePtr)++;
  *(unsigned short *)szNamePtr = 0x0000;
  ((unsigned short *)szNamePtr)++;
  *(unsigned short *)szNamePtr = 1;
  ((unsigned short *)szNamePtr)++;
  *(unsigned short *)szNamePtr = 0xFFFD;
  ((unsigned short *)szNamePtr)++;
  *(unsigned short *)szNamePtr = strlen(comment);
  ((unsigned short *)szNamePtr)++;
  strcpy( szNamePtr, comment );
  
  pFEA2->oNextEntryOffset = 0;
  eaop2.fpFEA2List->cbList = sizeof(FEA2LIST) - 1 + pFEA2->cbName + pFEA2->cbValue;
 
  rc = DosSetPathInfo(
         fileName,
         2, /* FIL_QUERYEASIZE */
         &eaop2,
         sizeof(eaop2),
         0 );

  if( 0 != rc )
    printf( "*Error* Cannot store EAs for file %s\n", fileName );

  free( eaop2.fpFEA2List );

  return;

  }


/*************************************************************************
 *                                                                       *
 * denise()                                                              *
 * The original main() procedure                                         *
 *                                                                       *
 *************************************************************************/
int denise( char* oldName ) 
  {

  int i;
  FILE *fp;
  struct stat statBuf;
  struct tm *pictureTime;
  struct _ea picEa;
  char buffer[500];
  char newName[500];
  char fileName[500];
  char dotExtension[10];
  char *status[2] = { "off", "on" };
  int flashState;
  int macroState;
  char shutterSpeed[20];
  char aperture[20];
  char imageSize[20];
  char eaName[20];
  char tmpBuf[300];
  char *bufPtr;
  int fileIndex;
  char *fileImage;
  char *bufferEnd;
  char *dataArea;
  char *timeAndDate;
  long longTimeAndDate;
  char *flash;
  char *macro;

  /* stat the file to make sure it's not a directory */ 
  /* and to note it's length                         */ 
  if( stat(oldName, &statBuf) ) 
    {
    printf( "*Error* Unable to find file %s\n", oldName );
    return RET_ERROR;
    }

  if( statBuf.st_mode & S_IFDIR ) 
    {
    printf( "*Error* %s is a directory, not a file.\n", oldName );
    return RET_ERROR;
    }

  /* determine the extension of the existing file name */ 
  /* so we can reinstate it later                      */

  ptr = oldName + strlen(oldName);

  while( *ptr != '.' && ptr > oldName )
    ptr--;

  if( *ptr == '.' )
    strcpy( dotExtension, ptr );
  else
    dotExtension[0] = 0;	

  /* prepare new file name buffer by inserting */ 
  /* the path to the file's directory          */
  strcpy( newName, oldName );

  /* this is path+file name so remove the file name from the end */
  /* also save file name without path */
  ptr = newName + strlen(newName);

  if( *ptr != 0 )
    ptr--;

  while( *ptr != '\\' && ptr > newName )
    ptr--;

  if( *ptr == '\\' ) 
    {
    strcpy( fileName, ptr + 1 );
    ptr[1] = 0;
    }
  else 
    {
    strcpy( fileName, ptr );
    newName[0] = 0;
    }

  /* open file for reading */
  fp = fopen( oldName, "rb" );

  if( fp == NULL ) 
    {
    printf( "*Error* Unable to open file %s for reading\n", oldName );
    fclose( fp );
    return RET_ERROR;
    }

  /* allocate memory to hold the file */
  fileImage = malloc( statBuf.st_size );

  if( fileImage == NULL ) 
    {
    printf( "*Error* Insufficient memory to read file of length %ld bytes", statBuf.st_size );
    fclose( fp );
    free( fileImage );
    return RET_ERROR;
    }

  /* read the entire file into memory */
  if( fread(fileImage, 1, statBuf.st_size, fp) != (unsigned)(statBuf.st_size) ) 
    {
    printf( "*Error* Read failed on file %s\n", oldName );
    fclose( fp );
    free( fileImage );
    return RET_ERROR;
    }

  fclose( fp );

  /* Calculate where the file ends in memory to */
  /* limit the scope of the searches to follow  */

  bufferEnd = fileImage + statBuf.st_size;

  /* search for the Olympus exposure info */
  dataArea = searchMemoryForString( fileImage, bufferEnd, pictureInfoKey );
  if( dataArea == NULL)
    {
    printf( "*Error* File %s does not contain Olympus exposure information\n" ,oldName );
    free( fileImage );
    return RET_ERROR;
    }

  /* extract the picture's exposure time */
  timeAndDate = searchMemoryForString( dataArea, bufferEnd, timeDateKey );
  if( timeAndDate == NULL ) 
    {
    printf( "*Error* File %s does not contain Olympus time/date information\n", oldName );
    free( fileImage );
    return RET_ERROR;
    }
  timeAndDate += strlen( timeDateKey );

  /* convert time and date to ascii string */
  longTimeAndDate = atol( timeAndDate );
  if( longTimeAndDate <= 0 ) 
    {
    printf( "*Error* File %s does not contain valid Olympus time/date information\n", oldName );
    free( fileImage );
    return RET_ERROR;
    }
  pictureTime = gmtime( &longTimeAndDate );

  /* extract the flash status */
  flash = searchMemoryForString( dataArea, bufferEnd, flashKey );
  if( flash == NULL ) 
    {
    printf( "*Error* File %s does not contain Olympus flash information\n", oldName );
    free( fileImage );
    return RET_ERROR;
    }
  flash += strlen(flashKey);
  if( *flash == '1') 
    flashState = 1;
  else 
    flashState = 0;

  /* extract the shutter speed */
  ptr = searchMemoryForString( dataArea, bufferEnd, shutterKey );
  if( ptr == NULL) 
    {
    printf( "*Error* File %s does not contain Olympus shutter information\n", oldName );
    free( fileImage );
    return RET_ERROR;
    }
  ptr += strlen( shutterKey );
  strncpy( shutterSpeed, ptr, sizeof(shutterSpeed) - 1 ); 
  ptr = shutterSpeed;
  while( *ptr >= '0' && *ptr <= '9' )
    ptr++;
  *ptr = 0;

  /* extract the aperture setting */
  ptr = searchMemoryForString( dataArea, bufferEnd, apertureKey );
  if( ptr == NULL ) 
    {
    printf( "*Error* File %s does not contain Olympus aperture information\n", oldName );
    free( fileImage );
    return RET_ERROR;
    }
  ptr += strlen(apertureKey);
  strncpy(aperture, ptr, sizeof(aperture) - 1);
  ptr = aperture;
  while( (*ptr >= '0' && *ptr <= '9') || *ptr == '.' )
    ptr++;
  *ptr = 0;

  /* extract the image size */
  ptr = searchMemoryForString( dataArea, bufferEnd, imageSizeKey );
  if( ptr == NULL ) 
    {
    printf( "*Error* File %s does not contain Olympus image size information\n", oldName );
    free( fileImage );
    return RET_ERROR;
    }
  ptr += strlen( imageSizeKey );
  strncpy( imageSize, ptr, sizeof(imageSize) - 1 );
  ptr = imageSize;
  while( (*ptr >= '0' && *ptr <= '9') || *ptr == '-') 
    ptr++;
  *ptr = 0;

  /* extract the macro setting */
  macro = searchMemoryForString( dataArea, bufferEnd, macroKey );
  if( macro == NULL ) 
    {
    printf( "*Error* File %s does not contain Olympus macro information\n", oldName );
    free( fileImage );
    return RET_ERROR;
    }
  macro += strlen( macroKey );
  if( *macro == '1') 
    macroState = 1;
  else
    macroState = 0;

  free( fileImage );

  /* if thumbnail, put "t" at beginning of name */
  if( fileName[0] == 't' )
    strcat( newName, "t" );

  /* Add the exposure date and time to the new name */
  sprintf( buffer, "%02d-%02d-%02d_%02d-%02d-%02d", 
    pictureTime->tm_year,
     pictureTime->tm_mon + 1, 
     pictureTime->tm_mday, 
     pictureTime->tm_hour,
     pictureTime->tm_min, 
     pictureTime->tm_sec );
  strcat( newName, buffer );

  /* put the .extension back on */
  strcat( newName, dotExtension );

  /* rename the file */
  printf( "Renaming %s to %s\n", oldName, newName );

  if( rename(oldName, newName) ) 
    {
    printf( "*Error* Failed to rename %s to %s: %s\n", oldName, newName, strerror(errno) );
    return RET_ERROR;
    }

  /* Set WPS name to file name */
  writeLongnameEa( newName, newName );

  /* build comment from image info */
  sprintf( tmpBuf, "Date/time: %02d-%02d-%02d, %02d:%02d:%02d\n", 
    pictureTime->tm_year, 
    pictureTime->tm_mon + 1, 
    pictureTime->tm_mday, 
    pictureTime->tm_hour, 
    pictureTime->tm_min, 
    pictureTime->tm_sec );
  strcat( tmpBuf, "Shutter speed: " );
  strcat( tmpBuf, shutterSpeed );
  strcat( tmpBuf, "\n" );
  strcat( tmpBuf, "Flash status: " );
  strcat( tmpBuf, status[flashState] );
  strcat( tmpBuf, "\n" );
  strcat( tmpBuf, "Aperture: F" ); 
  strcat( tmpBuf, aperture );
  strcat( tmpBuf, "\n" );
  strcat( tmpBuf, "Macro status: " ); 
  strcat( tmpBuf, status[macroState] );
  strcat( tmpBuf, "\n" );
  strcat( tmpBuf, "Image size: " ); 
  strcat( tmpBuf, imageSize );

  /* put comment into ea */
  writeCommentEA( newName, tmpBuf );

  return RET_OK;

  }

