/*
 * Copyright 1997-2003 Samuel Audet <guardia@step.polymtl.ca>
 *                     Taneli Lepp <rosmo@sektori.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. The name of the author may not be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* Code that uses ooura1d.dll to make some interesting data to display */

#define INCL_PM
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#include <utilfct.h>

#include "ooura1d.h"
#include "format.h"
#include "decoder_plug.h"
#include "output_plug.h"
#include "filter_plug.h"
#include "plugin.h"
#include "plugman.h"

#define LIMIT 4096
#define SQRTLIMIT 40

float data[LIMIT];
float window[LIMIT];
float sincostable[LIMIT/2];
int workarea[SQRTLIMIT];

int numsamples;
int inited = FALSE;

#define M_PI    3.14159265358979323846

/* von Hann */
#define WINDOW_HANN(n,N) (0.5-0.5*cos(2*M_PI*n/N))

/* Hamming */
#define WINDOW_HAMMING(n,N) (0.54-0.46*cos(2*M_PI*n/N))

/* Blackman */
#define WINDOW_BLACKMAN(n,N) (0.42-0.50*cos(2*M_PI*n/N)+0.08*cos(4*M_PI*n/N))

int _System specana_init(int setnumsamples)
{
   int i;

   _control87(EM_INVALID | EM_DENORMAL | EM_ZERODIVIDE | EM_OVERFLOW | EM_UNDERFLOW | EM_INEXACT, MCW_EM);

   inited = FALSE;

   /* must be a power of 2 bigger than 1 */
   if( setnumsamples<2 ||
       (setnumsamples & (setnumsamples - 1)) ||
       setnumsamples > LIMIT)
      return 0;
   
   numsamples = setnumsamples;

   for(i = 0; i<numsamples; i++)
      window[i] = WINDOW_HAMMING(i,numsamples-1);

   workarea[0] = 0;
//   rdft(numsamples, 1, data, workarea, sincostable);

   inited = TRUE;

   return numsamples/2+1;
}

int _System specana_dobands(float bands[])
{
   if(!inited) return 0;

   _control87(EM_INVALID | EM_DENORMAL | EM_ZERODIVIDE | EM_OVERFLOW | EM_UNDERFLOW | EM_INEXACT, MCW_EM);

   if(bands)
   {
      FORMAT_INFO bufferinfo;
      int i,e,len;

      if(out_playing_samples(&bufferinfo,NULL,0) != 0) return 0;

      /* to reduce spectral leakage, the samples are multipled with a window */

      if(bufferinfo.bits <= 8)
      {
         unsigned char *sample;

         len = bufferinfo.channels * numsamples;
         sample = _alloca(len);

         if(out_playing_samples(&bufferinfo,sample,len) != 0) return 0;

         for(i=0; i<numsamples; i++)
         {
            data[i] = 0.0;
            for(e=0; e<bufferinfo.channels; e++)
               data[i] += *sample++ - 128 ;
            data[i] = data[i] * window[i] / bufferinfo.channels;
         }
      }
      else if(bufferinfo.bits <= 16)
      {
         signed short *sample;

         len = bufferinfo.channels * 2 * numsamples;
         sample = _alloca(len);

         if(out_playing_samples(&bufferinfo,(char *)sample,len) != 0) return 0;

         for(i=0; i<numsamples; i++)
         {
            data[i] = 0.0;
            for(e=0; e<bufferinfo.channels; e++)
               data[i] += *sample++;
            data[i] = data[i] * window[i] / bufferinfo.channels;
         }
      }
      else if(bufferinfo.bits <= 32)
      {
         signed long *sample;

         len = 4 * bufferinfo.channels * numsamples;
         sample = _alloca(len);

         if(out_playing_samples(&bufferinfo,(char *)sample,len) != 0) return 0;

         for(i=0; i<numsamples; i++)
         {
            data[i] = 0.0;
            for(e=0; e<bufferinfo.channels; e++)
               data[i] += *sample++;
            data[i] = data[i] * window[i] / bufferinfo.channels;
         }
      }
      else return 0;

      rdft(numsamples, 1, data, workarea, sincostable);

      bands[0] = fabs(data[0])*5/numsamples;

      /* it looks as if I need to multiple by ~5 and divide by the number of samples
         to get approx. the original wave amplitudes */
      for(i=1;i<numsamples/2;i++)
         bands[i] = sqrt(data[2*i]*data[2*i] + data[2*i+1]*data[2*i+1])*5/numsamples;

      bands[i] = fabs(data[1])*5/numsamples;

      return 1<<(bufferinfo.bits-1); /* max amplitude */
   }

   return 0;
}
