/*
 * decoder MPEG Layer III
 * handle Xing header
 * mod 12/7/98 add vbr scale
 * Copyright 1998 Xing Technology Corp.
 *
 * A Xing header may be present in the ancillary
 * data field of the first frame of an mp3 bitstream
 * The Xing header (optionally) contains
 *      frames      total number of audio frames in the bitstream
 *      bytes       total number of bytes in the bitstream
 *      toc         table of contents
 *
 * toc (table of contents) gives seek points
 * for random access
 * the ith entry determines the seek point for
 * i-percent duration
 * seek point in bytes = (toc[i]/256.0) * total_bitstream_bytes
 * e.g. half duration seek point = (toc[50]/256.0) * total_bitstream_bytes
 */

#define FRAMES_FLAG     0x0001
#define BYTES_FLAG      0x0002
#define TOC_FLAG        0x0004
#define VBR_SCALE_FLAG  0x0008

#define FRAMES_AND_BYTES ( FRAMES_FLAG | BYTES_FLAG )

// structure to receive extracted header
// toc may be NULL
typedef struct
{
  int h_id;           // from MPEG header, 0=MPEG2, 1=MPEG1
  int samprate;       // determined from MPEG header
  int flags;          // from Xing header data
  int frames;         // total bit stream frames from Xing header data
  int bytes;          // total bit stream bytes from Xing header data
  int vbr_scale;      // encoded vbr scale from Xing header data
  unsigned char* toc; // pointer to unsigned char toc_buffer[100]
                      // may be NULL if toc not desired
} XHEADDATA;

// X   structure to receive header data (output)
// buf bitstream input
// return 0 = fail, 1 = success
int GetXingHeader( XHEADDATA* X, unsigned char* buf );

// TOC = table of contents from Xing header
// file_bytes = number of bytes in mp3 file
// percent = play time percentage of total playtime. May be
//           fractional (e.g. 87.245)
// return seekpoint in bytes ( may be at eof if percent == 100.0 )
int SeekPoint( unsigned char TOC[100], int file_bytes, float percent );

