/*
 * Copyright 1997-2003 Samuel Audet <guardia@step.polymtl.ca>
 *                     Taneli Lepp <rosmo@sektori.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. The name of the author may not be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
  The very first PM123 visual plugin - the spectrum analyzer
*/

//#define CPUMON

#define  INCL_DOS
#define  INCL_WIN
#define  INCL_GPI
#define  INCL_OS2MM
#include <os2.h>
#include <os2me.h>
#include <stdio.h>
#include <stdlib.h>
#include <dive.h>
#include <fourcc.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

#include <utilfct.h>

#ifdef CPUMON
#include "perfutil.h"
#endif
#include <format.h>
#include <decoder_plug.h>
#include <plugin.h>

#define MCW_EM             0x003f
#define EM_INVALID            0x0001
#define EM_DENORMAL        0x0002
#define EM_ZERODIVIDE         0x0004
#define EM_OVERFLOW        0x0008
#define EM_UNDERFLOW       0x0010
#define EM_INEXACT            0x0020

#define MCW_IC             0x1000
#define IC_PROJECTIVE         0x0000
#define IC_AFFINE          0x1000

#define MCW_RC             0x0c00
#define RC_NEAR            0x0000
#define RC_DOWN            0x0400
#define RC_UP              0x0800
#define RC_CHOP            0x0c00

#define MCW_PC             0x0300
#define PC_24              0x0000
#define PC_53              0x0200
#define PC_64              0x0300

#define CW_DEFAULT            (RC_NEAR | PC_64 | MCW_EM)

#define SW_INVALID            0x0001
#define SW_DENORMAL        0x0002
#define SW_ZERODIVIDE         0x0004
#define SW_OVERFLOW        0x0008
#define SW_UNDERFLOW       0x0010
#define SW_INEXACT            0x0020
#define SW_STACKFAULT         0x0040
#define SW_STACKOVERFLOW      0x0200


#define DIVE_TBM_EXCLUDE_SOURCE_VALUE           0x01
#define DIVE_TBM_EXCLUDE_SOURCE_RGB_RANGE       0x02

HWND       hwndClient = 0;
HDIVE      hdive;
ULONG      divebufnum = 0;
PVOID      divebuffer;
DIVE_CAPS     DiveCaps;
SETUP_BLITTER setup;
RGB2       palette[256];
HPAL       hpal;
VISPLUGININIT plug;
float      bands[2049];
int        numbands, fftsize;
int        active = 0, ds[2049], ls[2049];
int        colors;
APIRET     rc;
HAB        hab;
int        blank_timer = 0;
POINTL     ptlMouse;

#ifdef CPUMON
int        cpu[2048];
double        ts_val, ts_val_prev;
double        idle_val, idle_val_prev = 0.0;
double        busy_val, busy_val_prev = 0.0;
double        intr_val, intr_val_prev = 0.0, ts_delta;
CPUUTIL    CPUUtil;
int        iter, sleep_sec, cpuindex = 0;
#endif

PFN        _decoderPlayingSamples, _decoderPlaying, _specana_init, _specana_dobands;
HWND       hwndCfg;
int eq_colors;
POINTERINFO pi;

struct analyzer_cfg {
  ULONG update_delay;
  int   default_mode;
  int   falloff;
  int   falloff_speed;
  int   display_percent;
} cfg;

/* Display buffer */
static unsigned char *scr;

// removes comments starting with //
static char *uncomment(char *something)
{
   int i = 0;
   BOOL inquotes = FALSE;

   while(something[i])
   {
      if(something[i] == '\"')
         inquotes = !inquotes;
      else if(something[i] == '/' && something[i+1] == '/' && !inquotes)
      {
         something[i] = 0;
         break;
      }
      i++;
   }

   return something;
}


char *fix_buffer(char *buf)
{
 int i,e;
 char *bufpos = buf;

 while (*bufpos == ' ') bufpos++;
 i = strlen(bufpos) - 1;
 for (;i > 0;i--)
    if (bufpos[i] != ' ' && bufpos[i] != '\t' && bufpos[i] != '\n') break;
 for(e = 0; e < i+1; e++)
    buf[e] = bufpos[e];
 buf[e] = 0;
 return(buf);
}

int read_color(FILE *f, RGB2 *color)
{
 char buf[256];
 char buf1[256];
 char buf2[256];
 char buf3[256];

 fgets(buf, sizeof(buf), f);
 uncomment(buf);
 sscanf(buf,"%[^,],%[^,],%[^,]",buf1,buf2,buf3);
 color->bRed = atoi(buf1);
 color->bGreen = atoi(buf2);
 color->bBlue = atoi(buf3);
 return 0;
}

MRESULT EXPENTRY PlugWinProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
 HPS      hps;
 HRGN     hrgn;
 RGNRECT  rgnCtl;
 SWP      swp, swp2;
 RECTL    rcls[64];
 POINTL   pointl;
 ULONG    i, o, x, y, z, cx, cy;
 int      fooz;
 FORMAT_INFO bufferinfo;

 switch (msg) {
   case DM_DRAGOVER:
   case DM_DROP:
   case 0x041f:
   case 0x041e:
   case WM_CONTEXTMENU:
   case WM_BUTTON2MOTIONSTART:
        WinSendMsg(plug.hwnd, msg, mp1, mp2);
        break;

   case WM_BUTTON1DBLCLK:
   case WM_BUTTON1CLICK:
      active++;
#ifdef CPUMON
      if (active > 3) active = 0;
#else
      if (active > 2) active = 0;
#endif
      DiveBeginImageBufferAccess(hdive, divebufnum, &scr, &cx, &cy);
      memset(scr, 0, cx * cy);
      DiveEndImageBufferAccess(hdive, divebufnum);
      DiveBlitImage(hdive, divebufnum, 0);

      break;
#if 0
   case WM_CLOSE:
        cfgf = fopen("analyzer.ini", "wb");
        if (cfgf)
         {
          fwrite(&cfg, 1, sizeof(cfg), cfgf);
          fclose(cfgf);
         }
        WinStopTimer(NULLHANDLE, hwndClient, TID_USERMAX - 1);
      DiveFreeImageBuffer(hdive, divebufnum);
      DiveClose(hdive);
      DosFreeMem(scr);
      WinDestroyWindow(hwnd);
      break;
#endif

   case WM_TIMER:

      DiveBeginImageBufferAccess(hdive, divebufnum, &scr, &cx, &cy);
      memset(scr, 0, cx * cy);

      if (!eq_colors)
      {
         for (y = 0; y < plug.cy; y += 2)
            for (x = 0; x < plug.cx; x += 2)
               scr[(y * cx) + x] = 1;
      }

      if (active == 0 && _decoderPlaying() == 1)
      {
        int max = _specana_dobands(bands);
#if 0
        More efficient method would be:

          Make an array of size plug.cy, and fill this array with
          corresponding values so that to fill a particular pixel, a band
          would need to have a lower value.

        The function will go over plug.cy, but the sound is already
        pretty high for our ears when it reaches that plug.cy.
#endif
        for (i = 0; i < numbands*cfg.display_percent/100; i++)
           ds[i] = (int) (plug.cy/4)*log(bands[i]/max*100+1);
#if 0
           if(bands[i] <= 64)
              ds[i] = 0;
           else
              ds[i] = (int) (plug.cy*log(bands[i]/64)/6.24);
#endif
        for (     ; i < plug.cx;        i++)
           ds[i] = 0;

        for (x = 0; x < plug.cx; x++)
        {
           if (cfg.falloff)
           {
              if (ds[x] > ls[x])
                 ls[x] = ds[x];
              else
                 ls[x] -= cfg.falloff_speed;

              if(ls[x] < 0) ls[x] = 0;

              z = ls[x];
           }
           else
              z = ds[x];

         if (z > (plug.cy - 1)) z = plug.cy - 1;
         for (y = 0; y < z; y++)
          {
          fooz = y*plug.cy/(plug.cy - z);
          if (fooz > colors-1) fooz = colors-1;
          else if (fooz < 2) fooz = 2;
          scr[(plug.cy - y) * cx + x] = fooz;
          }
        }
      }
      else if (active == 1 && _decoderPlaying() == 1)
      {
         _decoderPlayingSamples(&bufferinfo,NULL,0);

         if(bufferinfo.bits <= 8)
         {
            unsigned char *usample;
            int len;

            len = bufferinfo.channels * plug.cx;
            usample = alloca(len);

            _decoderPlayingSamples(&bufferinfo,usample,len);
            for (i = 0; i < plug.cx; i++)
             {
              if (bufferinfo.channels == 2)
               o = ((usample[(i * 2) + 1] + usample[(i * 2)]) / 2 - 128) * (plug.cy>>2) * 5 / (1<<bufferinfo.bits);
              else
               o = (usample[i] - 128) * (plug.cy>>2) * 5 / (1<<bufferinfo.bits);

              y = (plug.cy/2) + o;
              //if (y < 0) y = 0;
              if (y > plug.cy) y = plug.cy;
              scr[y * cx + i] = colors-1;
             }
         }
         else
         {
            signed short *usample;
            int len;

            len = 2 * bufferinfo.channels * plug.cx;
            usample = alloca(len);

            _decoderPlayingSamples(&bufferinfo,usample,len);
            for (i = 0; i < plug.cx; i++)
             {
              if (bufferinfo.channels == 2)
               o = ((usample[(i * 2) + 1] + usample[(i * 2)]) / 2) * (plug.cy>>2) * 5 / (1<<bufferinfo.bits);
              else
               o = usample[i] * (plug.cy>>2) * 5 / (1<<bufferinfo.bits);

              y = (plug.cy/2) + o;
              //if (y < 0) y = 0;
              if (y > plug.cy) y = plug.cy;
              scr[y * cx + i] = colors-1;
             }
         }
       }
#ifdef CPUMON
      else if (active == 2)
       {
        if (iter < 3) { iter++; break; }
        iter = 0;

        rc = DosPerfSysCall(CMD_KI_RDCNT,(ULONG) &CPUUtil, 0, 0);

        ts_val = LL2F(CPUUtil.ulTimeHigh, CPUUtil.ulTimeLow);
        idle_val = LL2F(CPUUtil.ulIdleHigh, CPUUtil.ulIdleLow);
        busy_val = LL2F(CPUUtil.ulBusyHigh, CPUUtil.ulBusyLow);
        intr_val = LL2F(CPUUtil.ulIntrHigh, CPUUtil.ulIntrLow);

        ts_delta = ts_val - ts_val_prev;

        cpu[cpuindex++] = (int)((busy_val - busy_val_prev)/ts_delta*(double)(plug.cy - 2));
        if (cpuindex > plug.cx-1)
        {
            memmove(&cpu[0], &cpu[1], sizeof(int)*(plug.cx-1));
            cpuindex--;
        }

       ts_val_prev = ts_val;
       idle_val_prev = idle_val;
       busy_val_prev = busy_val;
       intr_val_prev = intr_val;

         for (i = 0; i < plug.cx; i++)
         {
         for (x = 0; x < cpu[i]; x++)
          {
           y = plug.cy - x;
           fooz = colors - x*colors/plug.cy; /* this is probably fucked */
           scr[(y * cx + i)] = fooz;
          }
         }
       }
#endif

      DiveEndImageBufferAccess(hdive, divebufnum);
#ifdef CPUMON
      if (active < 3) DiveBlitImage(hdive, divebufnum, 0);
#else
      if (_decoderPlaying() == 0 && blank_timer == 0)
       {
        blank_timer = 1;
        DiveBlitImage(hdive, divebufnum, 0);
       } else if (_decoderPlaying() == 1) blank_timer = 0;
      if (_decoderPlaying() == 1 && active < 2) DiveBlitImage(hdive, divebufnum, 0);

//      WinQueryPointerInfo(WinQueryPointer(HWND_DESKTOP), &pi);
//      WinQueryPointerPos(HWND_DESKTOP, &ptlMouse);
//      WinDrawPointer(WinGetScreenPS(HWND_DESKTOP), ptlMouse.x - pi.xHotSpot, ptlMouse.y - pi.yHotSpot, WinQueryPointer(HWND_DESKTOP), DP_NORMAL);
#endif
      break;

   case WM_REALIZEPALETTE:
//      hps = WinBeginPaint(hwnd, 0, NULL);
//      GpiSelectPalette(hps, hpal);
//      WinRealizePalette(hwnd, hps, &i);
      DiveSetDestinationPalette(hdive, 0, 0, 0);
//      WinEndPaint(hps);
      break;

   case WM_VRNDISABLED:
      DiveSetupBlitter(hdive, 0);
      GpiSelectPalette(hps, NULLHANDLE);
      GpiDeletePalette(hpal);
      break;

   case WM_VRNENABLED:
      hps = WinGetPS(hwnd);

      hpal = GpiCreatePalette(hab,
                              LCOL_PURECOLOR,
                              LCOLF_CONSECRGB,
                              colors,
                              (PULONG)palette);

      GpiSelectPalette(hps, hpal);
      WinRealizePalette(hwnd, hps, &i);
      WinSendMsg(plug.hwnd, WM_REALIZEPALETTE, 0, 0);

      DiveSetSourcePalette(hdive, 0, colors, (char*)&palette);
      DiveSetDestinationPalette(hdive, 0, 0, 0);

      hrgn = GpiCreateRegion(hps, 0, NULL);
      if (hrgn) {
        WinQueryVisibleRegion(hwnd, hrgn);
        rgnCtl.ircStart  = 0;
        rgnCtl.crc       = 50;
        rgnCtl.ulDirection = RECTDIR_LFRT_TOPBOT;
        if (GpiQueryRegionRects(hps, hrgn, NULL, &rgnCtl, rcls)) {
         WinQueryWindowPos(plug.hwnd, &swp);
         WinQueryWindowPos(hwnd, &swp2);
         pointl.x = swp.x + plug.x;
         pointl.y = swp.y + plug.y;
         WinMapWindowPoints(plug.hwnd, HWND_DESKTOP, (POINTL *)&pointl, 1);
         setup.ulStructLen    = sizeof(SETUP_BLITTER);
         setup.fInvert        = FALSE;
         setup.fccSrcColorFormat = FOURCC_LUT8;
         setup.ulSrcWidth     = plug.cx;
         setup.ulSrcHeight    = plug.cy;
         setup.ulSrcPosX      = 0;
         setup.ulSrcPosY      = 0;
         setup.ulDitherType      = 0;
         setup.fccDstColorFormat = FOURCC_SCRN;
         setup.ulDstWidth     = plug.cx;
         setup.ulDstHeight    = plug.cy;
         setup.lDstPosX       = 0;
         setup.lDstPosY       = 0;
         setup.lScreenPosX    = pointl.x;
         setup.lScreenPosY    = pointl.y;
         setup.ulNumDstRects  = rgnCtl.crcReturned;
         setup.pVisDstRects   = rcls;
         rc = DiveSetupBlitter(hdive, &setup);
        }
        GpiDestroyRegion(hps, hrgn);
      }

      WinReleasePS(hps);

      WinStartTimer(hab, hwndClient, TID_USERMAX - 1, cfg.update_delay);

      break;
   default:
      return WinDefWindowProc (hwnd, msg, mp1, mp2);
 }
 return 0;
}


HWND _System vis_init(PVISPLUGININIT init)
{
   HINI INIhandle;
   FILE *dat;
   int i;

   memcpy(&plug, init, sizeof(VISPLUGININIT));

   cfg.update_delay  = 31;
   cfg.default_mode  = 0;
   cfg.falloff       = 0;
   cfg.falloff_speed = 5;
   cfg.display_percent = 100;

   if((INIhandle = open_module_ini()) != NULLHANDLE)
   {
      load_ini_value(INIhandle,cfg.update_delay);
      load_ini_value(INIhandle,cfg.default_mode);
      load_ini_value(INIhandle,cfg.falloff);
      load_ini_value(INIhandle,cfg.falloff_speed);
      load_ini_value(INIhandle,cfg.display_percent);

      close_ini(INIhandle);
   }

   /* First get the routines */
   _decoderPlayingSamples = (PFN) init->procs->output_playing_samples;
   _decoderPlaying     = (PFN) init->procs->decoder_playing;
   _specana_init       = init->procs->specana_init;
   _specana_dobands    = init->procs->specana_dobands;

   fftsize = (plug.cx<<1)*100/cfg.display_percent;
   while(fftsize & (fftsize-1)) fftsize--; /* find a power of two */

   /* prevent crash from hard coded array limit */
   do
   {
      numbands = _specana_init(fftsize);
      fftsize /= 2;
   }
   while(!numbands || numbands > sizeof(bands) );

   active = cfg.default_mode;

   /* Open up DIVE */
   hdive = 0;
   rc = DiveOpen(&hdive, FALSE, 0);
   if(rc != DIVE_SUCCESS)
     return 0;

   DosAllocMem((void *)&scr, (plug.cx/4+1)*4 * plug.cy, PAG_WRITE | PAG_READ | PAG_COMMIT);
   memset(scr, 0, (plug.cx/4+1)*4 * plug.cy);

   /* Allocate image buffer (256-color) */
   divebufnum = 0;
   rc = DiveAllocImageBuffer(hdive, &divebufnum, FOURCC_LUT8, plug.cx, plug.cy, 0, scr);
   if(rc != DIVE_SUCCESS)
   {
      DosFreeMem(scr);
      scr = NULL;
      DiveClose(hdive);
      hdive = 0;
      hwndClient = 0;
      return 0;
   }

   /* Initialize PM */
   hab = WinQueryAnchorBlock(plug.hwnd);

   WinRegisterClass(hab, "Spectrum Analyzer", PlugWinProc, CS_SIZEREDRAW | CS_MOVENOTIFY, 0);

   hwndClient = WinCreateWindow(plug.hwnd,
                       "Spectrum Analyzer",
                       "PM123 Spectrum Analyzer",
                       WS_VISIBLE,
                       plug.x,
                       plug.y,
                       plug.cx,
                       plug.cy,
                       plug.hwnd,
                       HWND_TOP,
                       plug.id,
                       NULL,
                       NULL);

   if (plug.param && *plug.param && (dat = fopen(plug.param, "r")))
   {
      read_color(dat, &palette[0]);
      read_color(dat, &palette[1]); /* shade color */
      for (i = 18; i > 2; i--)
         read_color(dat, &palette[i-1]);
      colors = 18;
      fclose(dat);
   }
   else
   {
      for (i = 0; i < plug.cy/2+1; i++)
      {
         palette[i].bRed   = 255 - (255 * 2 * i/plug.cy);
         palette[i].bGreen = 255 * 2 * i/plug.cy;
         palette[i].bBlue  = 0;
      }

      colors = plug.cy/2+1;

      palette[0].bRed = palette[0].bGreen = palette[0].bBlue = 0;
      palette[1].bRed = palette[1].bGreen = palette[1].bBlue = 0;
   }

   eq_colors = !memcmp(&palette[0], &palette[1], sizeof(RGB2));

   WinSetVisibleRegionNotify(hwndClient, TRUE);
   // Apparently the WM_VRNENABLED message not necessarily automatically
   // follows WinSetVisibleRegionNotify call. We posts it manually.
   WinPostMsg(hwndClient,WM_VRNENABLED,MPFROMLONG(TRUE),0);
   return(hwndClient);
}

int _System plugin_query(PPLUGIN_QUERYPARAM query)
{
 query->type       = PLUGIN_VISUAL;
 query->author     = "Taneli Lepp & Samuel Audet";
 query->desc       = "Spectrum Analyzer";
 query->configurable = 1;
 return 0;
}

void amp_setradio(HWND hwnd, USHORT id, BOOL enable)
{
  WinSendDlgItemMsg(hwnd, id, BM_SETCHECK, MPFROMSHORT(enable), 0);
}

int amp_getradio(HWND hwnd, USHORT id)
{
 return (ULONG)WinSendDlgItemMsg(hwnd, id, BM_QUERYCHECK, 0, 0);
}

MRESULT EXPENTRY AboutDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
 hwndCfg = hwnd;

 switch (msg)
  {
    case WM_CONTROL:
     switch (SHORT1FROMMP(mp1))
      {
       case 104:
        amp_setradio(hwnd, 107, FALSE);
        amp_setradio(hwnd, 106, FALSE);
        amp_setradio(hwnd, 108, FALSE);
        break;
       case 106:
        amp_setradio(hwnd, 104, FALSE);
        amp_setradio(hwnd, 107, FALSE);
        amp_setradio(hwnd, 108, FALSE);
        break;
/*       case 107:
        amp_setradio(hwnd, 104, FALSE);
        amp_setradio(hwnd, 106, FALSE);
        amp_setradio(hwnd, 108, FALSE);
        break;   */
       case 108:
        amp_setradio(hwnd, 104, FALSE);
        amp_setradio(hwnd, 107, FALSE);
        amp_setradio(hwnd, 106, FALSE);
        break;
      }

    break;
   case WM_INITDLG:
    switch (cfg.default_mode)
     {
      case 0: amp_setradio(hwnd, 104, TRUE); break;
      case 1: amp_setradio(hwnd, 106, TRUE); break;
      case 2: amp_setradio(hwnd, 108, TRUE); break;
     }
    if (cfg.falloff) amp_setradio(hwnd, 115, TRUE);

    WinSendMsg(WinWindowFromID(hwnd, 111),
               SPBM_SETLIMITS,
               MPFROMLONG(100),
               MPFROMLONG(0));
    WinSendMsg(WinWindowFromID(hwnd, 111),
               SPBM_SETCURRENTVALUE,
               MPFROMLONG(cfg.display_percent),
               0);

    WinSendMsg(WinWindowFromID(hwnd, 102),
               SPBM_SETLIMITS,
               MPFROMLONG(200),
               MPFROMLONG(0));
    WinSendMsg(WinWindowFromID(hwnd, 102),
               SPBM_SETCURRENTVALUE,
               MPFROMLONG(1000/cfg.update_delay),
               0);

    WinSendMsg(WinWindowFromID(hwnd, 114),
               SPBM_SETLIMITS,
               MPFROMLONG(plug.cy),
               MPFROMLONG(1));
    WinSendMsg(WinWindowFromID(hwnd, 114),
               SPBM_SETCURRENTVALUE,
               MPFROMLONG(cfg.falloff_speed),
               0);
    break;
   case WM_DESTROY:
   {
    ULONG temp;
    if (amp_getradio(hwnd, 104)) cfg.default_mode = 0;
    if (amp_getradio(hwnd, 106)) cfg.default_mode = 1;
    if (amp_getradio(hwnd, 108)) cfg.default_mode = 2;
    WinSendMsg(WinWindowFromID(hwnd, 102),
               SPBM_QUERYVALUE,
               MPFROMP(&temp),
               MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
    cfg.update_delay = 1000/temp;
    WinStopTimer(NULLHANDLE, hwndClient, TID_USERMAX - 1);
    WinStartTimer(hab, hwndClient, TID_USERMAX - 1, cfg.update_delay);

    if (amp_getradio(hwnd, 115)) cfg.falloff = 1; else cfg.falloff = 0;
    WinSendMsg(WinWindowFromID(hwnd, 114),
               SPBM_QUERYVALUE,
               MPFROMP(&temp),
               MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
    cfg.falloff_speed = temp;

    WinSendMsg(WinWindowFromID(hwnd, 111),
               SPBM_QUERYVALUE,
               MPFROMP(&temp),
               MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
    cfg.display_percent = temp;

    fftsize = (plug.cx<<1)*100/cfg.display_percent;
    while(fftsize & (fftsize-1)) fftsize--; /* find a power of two */

    /* prevent crash from hard coded array limit */
    do
    {
       numbands = _specana_init(fftsize);
       fftsize /= 2;
    }
    while(!numbands || numbands > (sizeof(bands)/sizeof(bands[0])) );

    hwndCfg = 0;
    break;
   }
  }
 return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

int _System plugin_configure(HWND hwnd, HMODULE module)
{
   WinDlgBox(HWND_DESKTOP, HWND_DESKTOP, AboutDlgProc, module, 1, NULL);
   return 0;
}

int _System plugin_deinit(int unload)
{
   HINI INIhandle;

   if((INIhandle = open_module_ini()) != NULLHANDLE)
   {
      save_ini_value(INIhandle,cfg.update_delay);
      save_ini_value(INIhandle,cfg.default_mode);
      save_ini_value(INIhandle,cfg.falloff);
      save_ini_value(INIhandle,cfg.falloff_speed);
      save_ini_value(INIhandle,cfg.display_percent);

      close_ini(INIhandle);
   }

   WinStopTimer(NULLHANDLE, hwndClient, TID_USERMAX - 1);
   DiveFreeImageBuffer(hdive, divebufnum);
   WinDestroyWindow(hwndClient);
   DiveClose(hdive);
   DosFreeMem(scr);

   if(hwndCfg)
      WinDismissDlg(hwndCfg, 0);

   return 0;
}
