#define INCL_PM
#define INCL_WIN
#define INCL_GPI
#define INCL_DOSPROCESS
#define INCL_DOSERRORS

#include <stdarg.h>
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>

#include "filerequester.h"

#define FONT_WARPSANS "9.WarpSans"
#define FONT_HELV     "8.Helv"

HWND hwndFrame, hwndClient, hwndFileContainer, hwndDirContainer, hwndDriveBox, hwndMain;
HMQ hmq;
QMSG qmsg;
HAB haba;
HPS hps;
RECTL rcl;
POINTL ptlMouse;
int File_Populating = 0;
SWP swp;
HPOINTER hptrFolderOpen, hptrFolderClosed;
HBITMAP  hbmFolderOpen, hbmFolderClosed;
char startDir[_MAX_PATH];

void freq_calc_totals(HWND hwnd, PULONG totalFiles, PULONG totalBytes, PULONG allFiles, PULONG allBytes);

int dprintf(char *format, ...) {
  va_list args; char putbuf[1024]; FILE *debug;
  memset(&putbuf, '\0', sizeof(putbuf)); va_start(args, format);
  vsprintf(putbuf, format, args); va_end(args); debug = fopen("debug.log", "at");
  fprintf(debug, "%s", putbuf); fclose(debug);
  return 0;
}


void filereq_setdircontainer(HWND hwnd)
{
 CNRINFO cnrInfo;

 /* Set container attributes */
 cnrInfo.flWindowAttr          = CV_TREE | CV_TEXT;
 cnrInfo.hbmExpanded           = NULLHANDLE;
 cnrInfo.hbmCollapsed          = NULLHANDLE;
 cnrInfo.cxTreeIndent          = 8;
 cnrInfo.slTreeBitmapOrIcon.cx = 0;
 cnrInfo.slTreeBitmapOrIcon.cy = 0;

 WinSendMsg(hwnd, CM_SETCNRINFO, MPFROMP(&cnrInfo), MPFROMLONG(CMA_FLWINDOWATTR | CMA_CXTREEINDENT | CMA_TREEBITMAP | CMA_SLTREEBITMAPORICON));
}

void filereq_setfilecontainer(HWND hwnd)
{
 CNRINFO cnrInfo;

 /* Set container attributes */
 cnrInfo.flWindowAttr          = CV_TEXT | CV_FLOW;
 WinSendMsg(hwnd, CM_SETCNRINFO, MPFROMP(&cnrInfo), MPFROMLONG(CMA_FLWINDOWATTR));
}

PFILEREC filereq_container_additem(HWND hwnd, PFILEREC src, PFILEREC parent)
{
 PFILEREC      file;
 PTREEITEMDESC treeItem;
 RECORDINSERT  insert;

 /* Allocate a record in the container */
 file = (PFILEREC) WinSendMsg(hwnd,
                              CM_ALLOCRECORD,
                              MPFROMLONG(sizeof(FILEREC) - sizeof(RECORDCORE)),
                              MPFROMLONG(1));

 if (file == NULL) { DosBeep(500, 100); return NULL; }
 /* Allocate a TreeItemDesc for the item */
/* treeItem = malloc(sizeof(TREEITEMDESC));
 if (!treeItem)
  {
   DosBeep(500, 100); return;
  } */

 /* It never hurts to zero the contest of the allocated structs */
 memset(file,     '\0', sizeof(FILEREC));
 memset(&insert,  '\0', sizeof(RECORDINSERT));

 memcpy(file, src, sizeof(FILEREC));
 file->rc.cb              = sizeof(RECORDCORE);
 file->rc.flRecordAttr    = 0;

 insert.cb                = sizeof(RECORDINSERT);
 insert.pRecordOrder      = (PRECORDCORE) CMA_END;
 insert.pRecordParent     = (PRECORDCORE) parent;
 insert.fInvalidateRecord = TRUE;
 insert.zOrder            = CMA_TOP;
 insert.cRecordsInsert    = 1;

 WinSendMsg(hwnd,
            CM_INSERTRECORD,
            MPFROMP(file),
            MPFROMP(&insert));

 return file;
}

void filereq_clear_container(HWND hwnd)
{
 PFILEREC file, del, todelete[1];

 file = (PFILEREC) WinSendMsg(hwnd,
                              CM_QUERYRECORD,
                              MPFROMP(NULL),
                              MPFROM2SHORT(CMA_FIRST, CMA_ITEMORDER));

 if (!file) return; /* The container is empty! */

 do
  {
   del = file;
   file = (PFILEREC) WinSendMsg(hwnd,
                                CM_QUERYRECORD,
                                MPFROMP(file),
                                MPFROM2SHORT(CMA_NEXT, CMA_ITEMORDER));

   /* Free the data, so we don't get any leaks */
   if (del->rc.pTreeItemDesc != NULL) free(del->rc.pTreeItemDesc);

   todelete[0] = del;
   WinSendMsg(hwnd,
              CM_REMOVERECORD,
              MPFROMP(&todelete),
              MPFROM2SHORT(1, CMA_FREE));
  } while (file != NULL);
}

PFILEREC filereq_update_directory(HWND hwnd, char *currentDir)
{
 UCHAR    buf[_MAX_PATH], buf2[_MAX_PATH];
 ULONG    i;
 PFILEREC last = NULL;
 FILEREC  file = { 0 };

 if (!*currentDir) return NULL;
 if (strlen(currentDir) > 2)
  /* Does the directory have trailing blackslashes? If it has, strip them. */
  while (currentDir[strlen(currentDir) - 1] == '\\')
    currentDir[strlen(currentDir) - 1] = 0;

 filereq_clear_container(hwnd);

 /* Add drive letter to our buf2 */
 *buf2 = '\0';

 /* Now start parsing the directory by skipping the drive letter (it sucks!) */
// while (*currentDir != '\\') currentDir++; currentDir++;
 while (*currentDir)
  {
   *buf = '\0';
   while (*currentDir != '\\' && *currentDir)
    {
     strncat(buf, currentDir, 1);
     currentDir++;
    }
   if (*currentDir) currentDir++;

   strcat(buf2, buf); strcat(buf2, "\\");
   file.rc.pszTree = strdup(buf);
   file.full       = strdup(buf2); /* Full path */
   /* Ok, now add the item as a child of the last item */
   last = filereq_container_additem(hwnd, &file, last);

   /* Now expand the tree as it is already open */
   WinSendMsg(hwnd,
              CM_EXPANDTREE,
              MPFROMP(last),
              0);
  }
  /* Select last item */
  WinSendMsg(hwnd,
             CM_SETRECORDEMPHASIS,
             MPFROMP(last),
             MPFROM2SHORT(TRUE, CRA_SELECTED));

  return last;
}

void _Optlink File_Populate(void *arg)
{
 UCHAR *directory = (UCHAR *) arg;
 char         buf[_MAX_PATH];
 HDIR         hdir = HDIR_CREATE;
 FILEFINDBUF3 filebuf = { 0 };
 ULONG        filebufCb = sizeof(FILEFINDBUF3);
 ULONG        filecount = 1;
 APIRET       rc;
 HAB          hab;
 HMQ          hmq;
 FILEREC      file = { 0 };
 FILESTATUS3  filestat;
 ULONG        selFiles, selBytes, totFiles, totBytes;

 File_Populating = 1;

 hab = WinInitialize(0);
 hmq = WinCreateMsgQueue(hab, 0);

 strncpy(buf, directory, 250);
 if (buf[strlen(buf) - 1] == '\\') buf[strlen(buf) - 1] = 0;
 strcat(buf, "\\*.*");

 filereq_clear_container(hwndFileContainer);

 rc = DosFindFirst(buf,
                   &hdir,
                   FILE_NORMAL,
                   &filebuf,
                   filebufCb,
                   &filecount,
                   FIL_STANDARD);

 if (rc != NO_ERROR)
  {
   DosFindClose(hdir);
   return;
  }

 while (rc != ERROR_NO_MORE_FILES)
  {
    file.rc.pszText = strdup(filebuf.achName);
    strncpy(buf, directory, 250); strcat(buf, "\\"); strcat(buf, filebuf.achName);
    file.full       = strdup(buf);

    if (DosQueryPathInfo(buf, FIL_STANDARD, &filestat, sizeof(FILESTATUS3)) == NO_ERROR)
     file.size = filestat.cbFile;

    filereq_container_additem(hwndFileContainer, &file, NULL);

    filecount = 1;
    rc = DosFindNext(hdir,
                     &filebuf,
                     filebufCb,
                     &filecount);
  }

 DosFindClose(hdir);
 WinDestroyMsgQueue(hmq);
 WinTerminate(hab);

 freq_calc_totals(hwndFileContainer, &selFiles, &selBytes, &totFiles, &totBytes);

 if (selFiles > 0)
   sprintf(buf, "Selected %u/%u kB of %u/%u kB", selFiles, selBytes, totFiles, totBytes);
  else
   sprintf(buf, "%u/%u kB", totFiles, totBytes);

 WinSetDlgItemText(hwndMain, 114, buf);

 File_Populating = 0;
}

void _Optlink Drive_Populate(void *arg)
{
 PFILEREC parent = (PFILEREC) arg;
 char         buf[_MAX_PATH];
 ULONG        curDisk, logDrives, i, o;
 APIRET       rc;
 HAB          hab;
 HMQ          hmq;
 FSINFO       fsinfo;
 int          indexes[26];

 hab = WinInitialize(0);
 hmq = WinCreateMsgQueue(hab, 0);

 memset(&indexes[0], '\0', sizeof(int) * 26);

 /* Query logical drive setup */
 DosQueryCurrentDisk(&curDisk, &logDrives);

 for (i = 0; i < 26; i++)
  {
   if (logDrives & (1 << i))
    {
     sprintf(buf, "%c:", 65 + i);
     indexes[i] = LONGFROMMR(WinSendMsg(hwndDriveBox, LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(buf)));
    }
  }

 for (i = 0; i < 26; i++)
  {
   if (logDrives & (1 << i))
    {
     /* Query volume label */
     if (DosQueryFSInfo(i + 1,
                        FSIL_VOLSER,
                        &fsinfo,
                        sizeof(fsinfo)) == NO_ERROR)
      {
       sprintf(buf, "%c: %s", 65 + i, fsinfo.vol.szVolLabel);
       WinSendMsg(hwndDriveBox, LM_SETITEMTEXT, MPFROMSHORT(indexes[i]), MPFROMP(buf));
       if (i == (curDisk - 1))
        WinSendMsg(hwndDriveBox, LM_SELECTITEM, MPFROMSHORT(indexes[i]), MPFROMSHORT(TRUE));
      }
    }
  }

 WinDestroyMsgQueue(hmq);
 WinTerminate(hab);
}

void _Optlink Directory_Populate(void *arg)
{
 PFILEREC parent = (PFILEREC) arg;
 char         buf[_MAX_PATH];
 HDIR         hdir = HDIR_CREATE;
 FILEFINDBUF3 filebuf = { 0 };
 ULONG        filebufCb = sizeof(FILEFINDBUF3);
 ULONG        filecount = 1;
 ULONG        freshcount = 0;
 APIRET       rc;
 HAB          hab;
 HMQ          hmq;
 FILEREC      file = { 0 };
 PFILEREC     last;

 hab = WinInitialize(0);
 hmq = WinCreateMsgQueue(hab, 0);

 if (parent->full == NULL) return;

 strncpy(buf, parent->full, 250);
 if (buf[strlen(buf) - 1] == '\\') buf[strlen(buf) - 1] = 0;
 strcat(buf, "\\*.*");

// dprintf("buf: [%s]\n", buf);

 rc = DosFindFirst(buf,
                   &hdir,
                   MUST_HAVE_DIRECTORY,
                   &filebuf,
                   filebufCb,
                   &filecount,
                   FIL_STANDARD);

 if (rc != NO_ERROR)
  {
   DosFindClose(hdir);
   return;
  }

 while (rc != ERROR_NO_MORE_FILES)
  {
    if (strcmp(filebuf.achName, ".") != 0 && strcmp(filebuf.achName, "..") != 0)
     {
      dprintf("-%s-\n", filebuf.achName);
      file.rc.pszTree = strdup(filebuf.achName);
      strncpy(buf, parent->full, 250);
      if (buf[strlen(buf) - 1] == '\\') buf[strlen(buf) - 1] = 0; strcat(buf, "\\");
      strcat(buf, filebuf.achName);
      file.full       = strdup(buf);
      last = filereq_container_additem(hwndDirContainer, &file, parent);
      WinSendMsg(hwndDirContainer,
                 CM_EXPANDTREE,
                 MPFROMP(last),
                 0);

     }

    filecount = 1;
    rc = DosFindNext(hdir,
                     &filebuf,
                     filebufCb,
                     &filecount);
  }

 DosFindClose(hdir);
 WinDestroyMsgQueue(hmq);
 WinTerminate(hab);
}

int filereq_destroy_children(HWND hwnd, PFILEREC rec)
{
 PFILEREC file, del, todelete[1];

 do
  {
   file = (PFILEREC) WinSendMsg(hwnd,
                                CM_QUERYRECORD,
                                MPFROMP(rec),
                                MPFROM2SHORT(CMA_FIRSTCHILD, CMA_ITEMORDER));

   todelete[0] = file;
   WinSendMsg(hwnd,
              CM_REMOVERECORD,
              MPFROMP(&todelete),
              MPFROM2SHORT(1, CMA_FREE));
  } while (file != NULL);
  return 0;
}

int filereq_destroy_parent_children(HWND hwnd, PFILEREC rec)
{
 PFILEREC file, del, todelete[1];

 del = (PFILEREC) WinSendMsg(hwnd,
                             CM_QUERYRECORD,
                             MPFROMP(rec),
                             MPFROM2SHORT(CMA_PARENT, CMA_ITEMORDER));

 do
  {
   file = (PFILEREC) WinSendMsg(hwnd,
                                CM_QUERYRECORD,
                                MPFROMP(del),
                                MPFROM2SHORT(CMA_FIRSTCHILD, CMA_ITEMORDER));
   if (file != rec)
    {
     todelete[0] = file;
     WinSendMsg(hwnd,
                CM_REMOVERECORD,
                MPFROMP(&todelete),
                MPFROM2SHORT(1, CMA_FREE));
    } else
     {
      file = (PFILEREC) WinSendMsg(hwnd,
                                   CM_QUERYRECORD,
                                   MPFROMP(del),
                                   MPFROM2SHORT(CMA_LASTCHILD, CMA_ITEMORDER));
      if (file == rec) break;

      todelete[0] = file;
      WinSendMsg(hwnd,
                 CM_REMOVERECORD,
                 MPFROMP(&todelete),
                 MPFROM2SHORT(1, CMA_FREE));
     }
  } while (file != NULL);

  WinSendMsg(hwnd,
             CM_INVALIDATERECORD,
             MPFROMP(NULL),
             MPFROM2SHORT(0, 0));
  return 0;

}

void freq_calc_totals(HWND hwnd, PULONG totalFiles, PULONG totalBytes, PULONG allFiles, PULONG allBytes)
{
 PFILEREC sel = NULL;

 *totalFiles = *totalBytes = *allFiles = *allBytes = 0;

 sel = (PFILEREC) WinSendMsg(hwnd,
                             CM_QUERYRECORDEMPHASIS,
                             MPFROMP(CMA_FIRST),
                             MPFROMSHORT(CRA_SELECTED));

 if (sel != NULL && sel != (PFILEREC)-1)
  {
   do {
    if (sel != NULL && sel != (PFILEREC)-1)
     {
      (*totalFiles)++;
      (*totalBytes) += (sel->size / 1024);
     }

    sel = (PFILEREC) WinSendMsg(hwnd,
                                CM_QUERYRECORDEMPHASIS,
                                MPFROMP(sel),
                                MPFROMSHORT(CRA_SELECTED));
   } while (sel != NULL && sel != (PFILEREC)-1);
  }

 sel = (PFILEREC) WinSendMsg(hwnd,
                             CM_QUERYRECORD,
                             MPFROMP(NULL),
                             MPFROM2SHORT(CMA_FIRST, CMA_ITEMORDER));

 if (sel == NULL || sel == (PFILEREC)-1) return;

 do
  {
  if (sel != NULL && sel != (PFILEREC)-1)
   {
    (*allFiles)++;
    (*allBytes) += (sel->size / 1024);
   }

   sel = (PFILEREC) WinSendMsg(hwnd,
                               CM_QUERYRECORD,
                               MPFROMP(sel),
                               MPFROM2SHORT(CMA_NEXT, CMA_ITEMORDER));
  } while (sel != NULL && sel != (PFILEREC)-1);
}

MRESULT EXPENTRY FileDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
 HPS                   hps;
 static UCHAR          buf[_MAX_PATH];
 ULONG                 i, o;
 RECTL                 rcl;
 POINTL                ptl;
 SWP                   swp;
 PFILEREC              last, sel;
 static PFILEREC       lastsel = NULL;
 PNOTIFYRECORDENTER    enter;
 PNOTIFYRECORDEMPHASIS emphasis;
 HENUM                 henum;
 HWND                  hwndNext;
 static ULONG          selFiles, selBytes, totFiles, totBytes;
 RGB                   rgbBlack, rgbGreen;

 hwndMain = hwnd;

 switch (msg) {
   case WM_CONTROL:
       if (SHORT2FROMMP(mp1) == CN_EMPHASIS && !File_Populating)
        {
         if (SHORT1FROMMP(mp1) == 113)
          {
           emphasis = (PNOTIFYRECORDEMPHASIS)mp2;
           freq_calc_totals(hwndFileContainer, &selFiles, &selBytes, &totFiles, &totBytes);

           if (selFiles > 0)
             sprintf(buf, "Selected %u/%u kB of %u/%u kB", selFiles, selBytes, totFiles, totBytes);
            else
             sprintf(buf, "%u/%u kB", totFiles, totBytes);

           WinSetDlgItemText(hwnd, 114, buf);
          }
         return (MRESULT)0;
        }
       if (SHORT2FROMMP(mp1) == CN_ENTER)
        {
         /* File container select */
         if (SHORT1FROMMP(mp1) == 113)
          {
           enter = (PNOTIFYRECORDENTER)mp2;
           sel   = (PFILEREC)enter->pRecord;
          }
         /* Directory container select */
         if (SHORT1FROMMP(mp1) == 111)
          {
           enter = (PNOTIFYRECORDENTER)mp2;
           sel   = (PFILEREC)enter->pRecord;

           if (sel != NULL)
            {
             filereq_destroy_parent_children(hwndDirContainer, sel);
             filereq_destroy_children(hwndDirContainer, sel);

/*             if (lastsel)
              WinSendMsg(hwnd,
                         CM_COLLAPSETREE,
                         MPFROMP(lastsel),
                         0); */

             _beginthread(Directory_Populate, NULL, 0xFFFF, sel);
             _beginthread(File_Populate, NULL, 0xFFFF, sel->full);
            }
           lastsel = sel;
          }
        }

       break;
   case WM_INITDLG:
       hps = WinGetPS(hwnd);
       hbmFolderClosed = GpiLoadBitmap(hps, NULLHANDLE, BMP_FOLDERCLOSED, 0, 0);
       hbmFolderOpen   = GpiLoadBitmap(hps, NULLHANDLE, BMP_FOLDEROPEN,   0, 0);
       WinReleasePS(hps);

       /* Bring directory container to the top */
       WinSetWindowPos(WinWindowFromID(hwnd, 111),
                       HWND_TOP, 0, 0, 0, 0,
                       SWP_SHOW | SWP_ZORDER);


       /* Bring file container to the top */
       WinSetWindowPos(WinWindowFromID(hwnd, 113),
                       HWND_TOP, 0, 0, 0, 0,
                       SWP_SHOW | SWP_ZORDER);

       hwndFileContainer = WinWindowFromID(hwnd, 113);
       hwndDirContainer  = WinWindowFromID(hwnd, 111);
       hwndDriveBox      = WinWindowFromID(hwnd, 107);

       if (!WinSetPresParam(hwndDirContainer, PP_FONTNAMESIZE, strlen(FONT_WARPSANS) + 1, FONT_WARPSANS))
         WinSetPresParam(hwndDirContainer, PP_FONTNAMESIZE, strlen(FONT_HELV) + 1, FONT_HELV);

       if (!WinSetPresParam(hwndFileContainer, PP_FONTNAMESIZE, strlen(FONT_WARPSANS) + 1, FONT_WARPSANS))
         WinSetPresParam(hwndFileContainer, PP_FONTNAMESIZE, strlen(FONT_HELV) + 1, FONT_HELV);

//       WinSendMsg(hwndDriveBox, CBM_SHOWLIST, MPFROMSHORT(TRUE), 0);

       rgbBlack.bRed = rgbBlack.bGreen = rgbBlack.bBlue = 0;
       rgbGreen.bRed = rgbGreen.bBlue = 0; rgbGreen.bGreen = 0xFF;

/*       henum = WinBeginEnumWindows(WinQueryWindow(hwndDriveBox, QW_OWNER));
       while ((hwndNext = WinGetNextWindow(henum)) != NULLHANDLE)
        {
         WinSetPresParam(hwndNext, PP_BACKGROUNDCOLOR, sizeof(RGB), &rgbBlack);
        }
       WinEndEnumWindows(henum); */

//       WinSendMsg(hwndDriveBox, CBM_SHOWLIST, MPFROMSHORT(FALSE), 0);

       filereq_setdircontainer(WinWindowFromID(hwnd, 111));
       filereq_setfilecontainer(WinWindowFromID(hwnd, 113));

       if (!*startDir)
        {
         /* Query current directory and drive */
         *buf = '\0'; i = _MAX_PATH - 2;
         DosQueryCurrentDisk((PULONG)&buf[0], &o);
         *buf = (*buf) + 64; *(buf + 1) = ':'; *(buf + 2) = '\\';
         DosQueryCurrentDir(0, &buf[3], &i);
         last = filereq_update_directory(WinWindowFromID(hwnd, 111), buf);
        } else last = filereq_update_directory(WinWindowFromID(hwnd, 111), startDir);

       _beginthread(File_Populate, NULL, 0xFFFF, buf);
       _beginthread(Directory_Populate, NULL, 0xFFFF, last);
       _beginthread(Drive_Populate, NULL, 0xFFFF, sel);
       break;
   default: return WinDefDlgProc (hwnd, msg, mp1, mp2);
 }
 return 0;
}

void main() {
 haba = WinInitialize(0);
 hmq = WinCreateMsgQueue(haba, 0);

 *startDir = '\0';

 /* Load icons */
/* hptrFolderClosed = WinLoadPointer(HWND_DESKTOP, NULLHANDLE, BMP_FOLDERCLOSED);
 hptrFolderOpen   = WinLoadPointer(HWND_DESKTOP, NULLHANDLE, BMP_FOLDEROPEN); */

 WinDlgBox(HWND_DESKTOP, HWND_DESKTOP, FileDlgProc, NULLHANDLE, FILEREQ, NULL);

 /* Destroy icons */
 WinDestroyPointer(hptrFolderClosed);
 WinDestroyPointer(hptrFolderOpen);
}

