
!IFNDEF ROOT_PATH
!ERROR ROOT_PATH not defined
!ENDIF

!IF "$(LANGUAGE)" == "DEU"
!ELSE
!IF "$(LANGUAGE)" == "ENG"
!ELSE
!ERROR Invalid or no language defined
!ENDIF
!ENDIF

!IFDEF SHAREWARE
RES_PATH = $(ROOT_PATH)\RES\$(LANGUAGE)\SHAREWAR
SOURCE_PATH = $(ROOT_PATH)\OBJ\SHAREWAR
TARGET_PATH = $(ROOT_PATH)\EXE\SHAREWAR
LINK_OPTIONS = /f /pmtype:pm /packc /packd /nologo /exepack /runfromvdm /align:4 /m:full
!ENDIF

!IFDEF RELEASE
!IFNDEF USERNAME
!ERROR USERNAME not defined
!ENDIF
!IFNDEF REGID
!ERROR REGID not defined
!ENDIF
RES_PATH = $(ROOT_PATH)\RES\$(LANGUAGE)\RELEASE
SOURCE_PATH = $(ROOT_PATH)\OBJ\RELEASE
TARGET_PATH = $(ROOT_PATH)\EXE\RELEASE
LINK_OPTIONS = /f /pmtype:pm /packc /packd /nologo /exepack /runfromvdm /align:4

MAIN: CLEANUP ALL

CLEANUP:
  -del $(TARGET_PATH)\$(LANGUAGE)\CDPLAYER.EXE

!ENDIF

!IFDEF TEST
RES_PATH = $(ROOT_PATH)\RES\$(LANGUAGE)\TEST
SOURCE_PATH = $(ROOT_PATH)\OBJ\TEST
TARGET_PATH = $(ROOT_PATH)\EXE\TEST
LINK_OPTIONS = /f /pmtype:pm /packc /packd /nologo /exepack /runfromvdm /align:4
!ENDIF

!IFDEF DEBUG
RES_PATH = $(ROOT_PATH)\RES\$(LANGUAGE)\DEBUG
SOURCE_PATH = $(ROOT_PATH)\OBJ\DEBUG
TARGET_PATH = $(ROOT_PATH)\EXE\DEBUG
LINK_OPTIONS = /de /pmtype:pm /nop /nologo /m:full
!ENDIF

!IFNDEF TARGET_PATH
!ERROR Unknown target
!ENDIF

.SUFFIXES:

ALL: PREPARE $(TARGET_PATH)\$(LANGUAGE)\CDPLAYER.EXE

PREPARE:
  CD $(ROOT_PATH)\OBJ
  NMAKE /F OBJ.MAK
  CD $(ROOT_PATH)\RES
  NMAKE /F RES.MAK

$(TARGET_PATH)\$(LANGUAGE)\CDPLAYER.EXE: $(TARGET_PATH)\CDPLAYER.EXE \
    $(RES_PATH)\CDPLAYER.RES
  COPY $(TARGET_PATH)\CDPLAYER.EXE $(TARGET_PATH)\$(LANGUAGE)\CDPLAYER.EXE
  RC $(RES_PATH)\CDPLAYER.RES $(TARGET_PATH)\$(LANGUAGE)\CDPLAYER.EXE

$(TARGET_PATH)\CDPLAYER.EXE:  \
  $(SOURCE_PATH)\CDCTL.OBJ \
  $(SOURCE_PATH)\CDDEVICE.OBJ \
  $(SOURCE_PATH)\CDGLOBAL.OBJ \
  $(SOURCE_PATH)\CDMENU.OBJ \
  $(SOURCE_PATH)\CDMSG.OBJ \
  $(SOURCE_PATH)\CDPLAYER.OBJ \
  $(SOURCE_PATH)\CDPOS.OBJ \
  $(SOURCE_PATH)\CDPRF.OBJ \
  $(SOURCE_PATH)\CDTITLE.OBJ \
  $(SOURCE_PATH)\CDTSET.OBJ \
  $(SOURCE_PATH)\CDTSLIDE.OBJ \
  $(SOURCE_PATH)\CDVOLUME.OBJ \
  $(SOURCE_PATH)\SUBCLASS.OBJ \
  $(SOURCE_PATH)\WUTIL.OBJ \
  $(ROOT_PATH)\EXE\CDPLAYER.DEF \
  $(ROOT_PATH)\EXE\EXE.MAK
!IFDEF DEBUG
    LINK386.EXE @<<
$(SOURCE_PATH)\CDCTL.OBJ+
$(SOURCE_PATH)\CDDEVICE.OBJ+
$(SOURCE_PATH)\CDGLOBAL.OBJ+
$(SOURCE_PATH)\CDMENU.OBJ+
$(SOURCE_PATH)\CDMSG.OBJ+
$(SOURCE_PATH)\CDPLAYER.OBJ+
$(SOURCE_PATH)\CDPOS.OBJ+
$(SOURCE_PATH)\CDPRF.OBJ+
$(SOURCE_PATH)\CDTITLE.OBJ+
$(SOURCE_PATH)\CDTSET.OBJ+
$(SOURCE_PATH)\CDTSLIDE.OBJ+
$(SOURCE_PATH)\CDVOLUME.OBJ+
$(SOURCE_PATH)\SUBCLASS.OBJ+
$(SOURCE_PATH)\WUTIL.OBJ$(LINK_OPTIONS)
$(TARGET_PATH)\CDPLAYER.EXE
$(TARGET_PATH)\CDPLAYER.MAP
os2386.LIB+mmpm2.LIB
$(ROOT_PATH)\EXE\CDPLAYER.DEF
<<
    CD $(TARGET_PATH)
    MAPSYM CDPLAYER.MAP
!ELSE
    LINK386.EXE @<<
$(SOURCE_PATH)\CDCTL.OBJ+
$(SOURCE_PATH)\CDDEVICE.OBJ+
$(SOURCE_PATH)\CDGLOBAL.OBJ+
$(SOURCE_PATH)\CDMENU.OBJ+
$(SOURCE_PATH)\CDMSG.OBJ+
$(SOURCE_PATH)\CDPLAYER.OBJ+
$(SOURCE_PATH)\CDPOS.OBJ+
$(SOURCE_PATH)\CDPRF.OBJ+
$(SOURCE_PATH)\CDTITLE.OBJ+
$(SOURCE_PATH)\CDTSET.OBJ+
$(SOURCE_PATH)\CDTSLIDE.OBJ+
$(SOURCE_PATH)\CDVOLUME.OBJ+
$(SOURCE_PATH)\SUBCLASS.OBJ+
$(SOURCE_PATH)\WUTIL.OBJ$(LINK_OPTIONS)
$(TARGET_PATH)\CDPLAYER.EXE

os2386.LIB+mmpm2.LIB
$(ROOT_PATH)\EXE\CDPLAYER.DEF
<<
!ENDIF

