/*ͻ
                                                                      
     Program : StealTXT.CMD                                           
                                                                      
     Purpose : Add On for Albatros CD Player to "steal" the INI       
               Entries of the following CD Player                     
                                                                      
                                                                      
              - Michael Bock CDPLAYER                                 
                                                                      
              - CD EXPLORER ( IBM EWS, tested with Version 2.3 )      
                                                                      
              - Albatros CD Player ( Hey, Mine ? )                    
                                                                      
                                                                      
              And to convert into the ALBATROS Format                 
                                                                      
                                                                      
                                                                      
     Autor : Norbert Heller (c) 1994                                  
                                                                      
                                                                      
                                                                      
                                                                      
     Usage : StealTXT /x INIFILE                                      
                                                                      
                                                                      
     /x : Switch where                                                
                                                                      
           /A : Source is from Albatros                               
           /C : Source is from Michael Bocks CDPLAYER                 
           /E : Source is from IBM CD Explorer                        
                                                                      
     Example : StealTXT /C CDPLAYER.INI                               
                                                                      
     StealTXT will then produce a backup TXT file named CDPLAYER.TX0  
                                                                      
                                                                      
                                                                      
     Based on the file SHOWINI.CMD by RONY G. Flatscher               
     Though my conversion is probably not the very best :-))          
                                                                      
  ͼ*/


SIGNAL ON HALT
SIGNAL ON ERROR

global. = ""                    /* default to empty string */

PARSE SOURCE . . name_path      /* get full name & path of this program */

CALL initialize                 /* initialize array "global."           */

IF ARG(1) <> "" THEN         /* arguments are given */
   CALL backup_restore_update ARG(1)

IF ARG(1) = "" THEN SIGNAL usage    /* No Arguments -> Show Usage */

EXIT 0                          /* normal exit */



/************************************************************/

INITIALIZE: PROCEDURE EXPOSE global.
    /* check whether RxFuncs are loaded, if not, load them */
    IF RxFuncQuery('SysLoadFuncs') THEN
    DO
        /* load the load-function */
        CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'       

        /* load the Sys* utilities */
        CALL SysLoadFuncs                                                 
    END


    global.iNonPrintable = XRANGE("00"x, "1F"x) || D2C(255)
    global.iFilter       = COPIES("FA"x, 256)
    global.iFiletype     = "";


    RETURN





/* 
   one of Knuth's algorithms to sort
   ARG(1) ... stemname of array to sort
   ARG(2) ... optional, if given, exact comparison (no forced uppercase), taking leading
              and trailing blanks into account
*/
SORT_GENERIC: PROCEDURE EXPOSE stemIni. stemTopLevel. stemKey. stemTargetTopLevel. stemTargetKey. 

   /* define M for passes, build REXX-code */
   dynCode = "M = 1; DO WHILE (9 * M + 4) <" ARG(1) || ".0 ; M = M * 3 + 1; END"
   INTERPRET dynCode                /* execute REXX-code in variable dynCode */

   /* sort stem, build REXX-code */
   dynCode = "DO WHILE M > 0; K = " ARG(1) || ".0 - M; DO J = 1 TO K; Q = J;"
   dynCode = dynCode "DO WHILE Q > 0; L = Q + M;"

   IF ARG() < 2 THEN    /* uppercase comparison, ignore leading and trailing blanks */
      dynCode = dynCode "IF TRANSLATE(" || ARG(1) || ".Q) <= TRANSLATE(" || ARG(1) || ".L) THEN LEAVE;"
   ELSE                 /* exact comparison */ 
      dynCode = dynCode "IF" ARG(1) || ".Q <<=" ARG(1) || ".L THEN LEAVE;"

   dynCode = dynCode "tmp =" ARG(1) || ".Q; tmp.origValue =" ARG(1) || ".Q.origValue;"
   dynCode = dynCode "tmp.type =" ARG(1) || ".Q.type; tmp.filterValue =" ARG(1) || ".Q.filterValue;"

   dynCode = dynCode ARG(1) || ".Q =" ARG(1) || ".L;" ARG(1) || ".Q.origValue =" ARG(1) || ".L.origValue;"
   dynCode = dynCode ARG(1) || ".Q.type =" ARG(1) || ".L.type;" ARG(1) || ".Q.filterValue =" ARG(1) || ".L.filterValue;"

   dynCode = dynCode ARG(1) || ".L = tmp;" ARG(1) || ".L.origValue = tmp.origValue;"
   dynCode = dynCode ARG(1) || ".L.type = tmp.type;" ARG(1) || ".L.filterValue  = tmp.filterValue;"

   dynCode = dynCode "Q = Q - M; END; END; M = M % 3; END"

   INTERPRET dynCode                /* execute REXX-code in variable dynCode */

   RETURN



/*
        read TopLevel-entries
*/
READ_TOPLEVEL: PROCEDURE EXPOSE stemIni. stemTopLevel. stemKey. global. 
    DROP stemTopLevel.
    stemTopLevel. = ""

    iIni = ARG(1)
    ok = SysIni(stemIni.iIni, 'ALL:', 'stemTopLevel')
    IF ok = "ERROR:" THEN
    DO
       stemTopLevel.0 = 0
    END
    ELSE
    DO i = 1 TO stemTopLevel.0
       CALL check_value stemTopLevel.i  /* determine and prepare value in hand */
       stemTopLevel.i.origValue   = stemTopLevel.i
       stemTopLevel.i             = strings.displayValue
       stemTopLevel.i.type        = strings.type
       stemTopLevel.i.filterValue = strings.filterValue
    END

    RETURN 



/*
        read KEY-entries
*/
READ_KEY: PROCEDURE EXPOSE stemIni. stemTopLevel. stemKey. global. strings. 
    DROP stemKey.
    stemKey. = ""

    iIni     = ARG(1)
    iTopL    = ARG(2)

    ok = SysIni(stemIni.iIni, stemTopLevel.iTopL.origValue, 'ALL:', 'stemKey')
    IF ok = "ERROR:" THEN
    DO
       stemKey.0 = 0
    END
    ELSE
    DO i = 1 TO stemKey.0
       CALL check_value stemKey.i  /* determine and prepare value in hand */
       stemKey.i.origValue   = stemKey.i
       stemKey.i             = strings.displayValue
       stemKey.i.type        = strings.type
       stemKey.i.filterValue = strings.filterValue
    END

    RETURN 



/* 
   check data-type of argument and set up a structure containing different representations
   of it
*/
CHECK_VALUE: PROCEDURE EXPOSE global. strings. 
   DROP strings.
   strings. = ""

   length_arg1 = LENGTH(ARG(1))         /* length of ARG(1) */

   IF length_arg1 = 0 THEN              /* unknown key-value, key-value not set. */
   DO
      strings.type = "H"
      strings.displayValue = "x''"
      strings.filterValue = ""
      RETURN
   END

   /* last character \0 ? */

   IF SUBSTR(ARG(1), length_arg1, 1) = "00"x THEN    /* ASCIIZ ? */
   DO
      work = SUBSTR(ARG(1), 1, length_arg1 - 1)
      asciiz = "0"
   END
   ELSE                                                 
   DO
      work = ARG(1)
      asciiz = ""
   END

   ascii = (VERIFY(work, global.iNonPrintable, "Match") = 0)    /* plain ASCII ? */

   IF ascii THEN                                        /* ASCII-type value in hand */
   DO
      IF asciiz = "0" THEN strings.type = "A0"
                      ELSE strings.type = "A"
      strings.displayValue = work
   END
   ELSE                                                 /* hexadecimal value in hand */
   DO
      strings.type = "H"
      strings.displayValue = "x'" || C2X(ARG(1)) || "'"
      strings.filterValue = TRANSLATE(ARG(1), global.iFilter, global.iNonPrintable)
   END
   RETURN




/***************************************************************************/
/*
    print to file
*/
PRINT: PROCEDURE EXPOSE global. strings. stemIni. stemTopLevel. stemKey. 
    iIni  = ARG(1)      /* INI-file to be printed */
    iTopL = ARG(2)      /* TopLevel to be printed */
    iKey  = ARG(3)      /* Key to be printed */


    DO
              i = iIni

               CALL sort_generic "stemTopLevel"         /* sort them */
                                                       
               DO j = 1 TO stemTopLevel.0              

                  IF POS(global.config.showDepth, "KV") > 0 THEN    /* show more than TopLevel ? */
                  DO
                     CALL read_key i, j                   /* read keys */
                     CALL sort_generic "stemKey"    /* sort them */



               SELECT

                  WHEN     global.iFiletype     = "E" THEN
                  DO

                     /* Fuer die Eintraege des CD EXPLORER */
                     /*

                        Beim CD Explorer sind die eintraege anders : alles steht unter einem
                        Key eintrag als value mit <RETURN> getrennt

                     */

                     DO k = 1 TO stemKey.0            /* k = Variable fuer key name */

                        IF POS(global.config.showDepth, "V") > 0 THEN      /* show key-values too ? */
                        DO

                           SAY "Track"||k
                           val = SysIni(stemIni.i, stemTopLevel.j.origValue, stemKey.i.origValue)

                           IF val = "ERROR:" THEN
                           DO
                              LEAVE    /* schleife verlassen */
                           END
                           ELSE
                              DO
                                 CALL LINEOUT global.outFile, val /* write value to file */
                                 /* CALL LINEOUT global.outFile, "#"  write separator   */
                              END
                        END
                     END
                  END      /* CDEXPLORER CD Player */


                  WHEN     global.iFiletype     = "C" THEN
                  DO

                     /* Fuer die Eintraege des Michael Bock CD Player */

                     val = SysIni(stemIni.i, stemTopLevel.j.origValue, "CDTitle")
                     CALL LINEOUT global.outFile, val /* write Value to File */

                     DO k = 1 TO stemKey.0            /* k = Variable fuer key name */

                        IF POS(global.config.showDepth, "V") > 0 THEN      /* show key-values too ? */
                        DO

                           SAY "Track"||k
                           val = SysIni(stemIni.i, stemTopLevel.j.origValue, 'Track'||k)

                           IF val = "ERROR:" THEN
                           DO
                              LEAVE    /* schleife verlassen */
                           END
                           ELSE
                              DO
                                 CALL LINEOUT global.outFile, val /* write value to file */
                                 CALL LINEOUT global.outFile, "#" /* write separator   */
                             END
                        END
                     END
                  END      /* When Bock CD Player */
 


                  WHEN global.iFiletype     = "A" THEN
                  DO

                     /* Fuer die Eintraege des Albatros CD Player */

                     val = SysIni(stemIni.i, stemTopLevel.j.origValue, "CD-Titel")
                     CALL LINEOUT global.outFile, val /* write Value to File */

                     DO k = 1 TO stemKey.0            /* k = Variable fuer key name */

                        IF POS(global.config.showDepth, "V") > 0 THEN      /* show key-values too ? */
                        DO

                           SAY "Track"||k
                           val = SysIni(stemIni.i, stemTopLevel.j.origValue, 'TITEL'||k)

                           IF val = "ERROR:" THEN
                           DO
                              LEAVE    /* schleife verlassen */
                           END
                           ELSE
                              DO
                                 CALL LINEOUT global.outFile, val /* write value to file */

                         /* noch schauen ob Interpret angegeben worden ist */
                                    val = SysIni(stemIni.i, stemTopLevel.j.origValue, 'INTERPRET'||k)
                                    IF LENGTH(val) > 2 THEN
                                       IF val = "ERROR:"  THEN
                                          CALL LINEOUT global.outFile, "#" /* write separator   */
                                       ELSE
                                          CALL LINEOUT global.outFile, val /* write value */
                                    ELSE
                                        CALL LINEOUT global.outFile, "#" /* write separator   */
                                    END
                              END
                        END
                     END
                 /* END      When ALBATROS CD Player */

          OTHERWISE NOP
          END

                     SAY
                     SAY   ' ******  Processing Next Entry ****** '
                     SAY

                     CALL LINEOUT global.outFile, ""    /* write empty line */
                     CALL LINEOUT global.outFile, ""    /* write empty line */
                     CALL LINEOUT global.outFile, ""    /* write empty line */
                  END
               END
            END
    SAY
    CALL STREAM global.outFile, "C", "CLOSE"            /* close output file */

    RETURN




HALT:
   IF global.outFile <> "" THEN         /* interrupted while writing to file */
   DO
      CALL STREAM global.outFile, "C", "CLOSE"  /* close file */
   END


   SAY 
   SAY   "User interrupted application."
   EXIT -1                              /* user interrupt       */




/* ********************** ********************** *********************** ****************** */

BACKUP_RESTORE_UPDATE: PROCEDURE EXPOSE global. 

command_line = ARG(1)

IF command_line = "?" |  TRANSLATE(command_line) = "H" THEN SIGNAL usage

/* PARSE ARG filename */

PARSE ARG WITH '/'switch filename 

/* defaults */
stemFiles. = ""                 /* set default to empty */
stemFiles.0 = 0                 /* no element in array  */

/* defaults for ASCII-backup */
IF global.config.showDepth <> "V" THEN       /* show everything ? */
   global.config.showDepth = "V"     /* set switch to show everything */

IF global.config.showHexAs = "F" THEN        /* show filtered ASCII-string only ? */               
   global.config.showHexAs = "B"             /* show both, hexadecimal and filtered value */


/* check  arguments */
switch = TRANSLATE(switch)

/* extract number of generations */
generations = ""
DO i = LENGTH(switch) TO 1 BY -1
   tmp = SUBSTR(switch, i, 1)
   IF DATATYPE(tmp, "N") THEN generations = generations || tmp
   ELSE LEAVE
END


IF generations = "" THEN generations = 10               /* 10 generations, numbered from 0 thru 9 by default */
ELSE IF generations < 1 | generations > 10 THEN
DO
   SAY "Invalid number of generations (minimum = 1, maximum = 10):" || generations ||  
   EXIT -2
END

switch = SUBSTR(switch, 1, i)           /* remaining switch */

/* check whether switch is valid */
IF switch <> "A" & switch <> "C" & switch <> "E" THEN
DO
   SIGNAL usage    /* WRONG Arguments -> Show Usage */
   EXIT -2
END
ELSE global.iFiletype     = switch     /* ansonsten den Switch ins Globale Feld Kopieren */


filename = STRIP(filename)              /* get rid of blanks */

global.eMultipleFiles = 1               /* default: multiple files to process */


DO
   /* check whether file exists */
   IF filename = "" THEN sourceFile = ""
   ELSE sourceFile = STREAM(filename, "C", "QUERY EXISTS")

   IF sourceFile = "" THEN
   DO
      SAY "Error: file does not exist !"
      EXIT -3
   END

   stemFiles.0 = 1              /* default, one entry only     */
   stemFiles.1 = sourceFile
   global.eMultipleFiles = 0    /* one distinct file to process */
END


global.iBackupMode = "Quiet !"
DO  iI = 1 TO stemFiles.0               /* cycle thru all given files */
   sourceFile = stemFiles.iI            /* assign file to work-variable */
   SAY COPIES("=", 20)

   global.iBackupMode.iDrive = FILESPEC("drive", sourceFile)
   global.iBackupMode.iPath  = FILESPEC("path",  sourceFile)

           DO
              tmp = "Albatros INI-STEALER"
              SAY   tmp 
              SAY
/*
              IF \global.eMultipleFiles & check_if_ini(sourceFile) < 0 THEN
              DO
                 SAY "***Error: not an OS/2-INI-file !"  
              END
              ELSE      // single file 
              DO
*/
                 /* backup-ASCII-file gets a file extension of "TXT", hence 10 backups from "TX0" thru "TX9" */
                 tmpName  = FILESPEC("name",  sourceFile)
      
                 pointPos = LASTPOS(".", tmpName)
                 IF pointPos = 0 THEN tmpName = tmpName || ".TXT"
                                 ELSE tmpName = SUBSTR(tmpName, 1, pointPos) || "txt"
      
                 /* build name of the new backup-file */
                 global.outFile = get_next_file(global.iBackupMode.iDrive ||, /* get name of the new backup-file */
                                                global.iBackupMode.iPath ||,
                                                tmpName, generations)
   
      
                 stemIni.0 = 1                  /* number of entries */
                 stemIni.1 = sourceFile         /* assign OS/2-INI-file-name to be printed into an ASCII-file */
      
                 SAY
                 SAY   "Source " || sourceFile
                 SAY   "Target " || global.outFile 
                 SAY
      
                 CALL read_toplevel 1           /* read & prepare TopLevel entries, do not sort them */
      
                 CALL print 1                   /* call print-procedure, have all TopLevels printed */
  /*            END */
   
              CALL STREAM global.outFile, "C", "CLOSE"     /* close output file */
           END

END 

EXIT 0          /* finished batch-mode */



/*
        Backup-files contain at the last character position a number ranging
        from 0 (oldest) to 9 (youngest backup) == total of 10 generations

        ARG(1): filename with full path, e.g. "D:\OS2\OS2.INI" or "D:\OS2\OS2.TXT"
        ARG(2): number of maximum generations (1-10, expressed in filetype as 0-9)

*/
GET_NEXT_FILE: PROCEDURE EXPOSE global. 
     file        = ARG(1)
     generations = ARG(2)

     testname    = SUBSTR(file, 1, LENGTH(file)-1)

     /* find number of backups already present */
     DO last_backup = 9 TO 0 BY -1
        new_name = testname || last_backup
        IF STREAM(new_name, "C", "QUERY EXISTS") <> "" THEN LEAVE       /* last backup found ! */
     END

     to_delete = (last_backup + 1) - generations 
     IF to_delete >= 0 THEN                                             /* erase superfluos backups */
     DO
        DO i = 0 TO to_delete
           ADDRESS CMD "@erase" '"' || testname || i || '" 2>nul'       /* erase oldest file */

        END

        /* move youngest backups down */
        j = 0
        DO i = i TO last_backup
           old_name = testname || i
           new_name = testname || j
           ADDRESS CMD "@ren" '"' || old_name || '" "' || FILESPEC("Name",new_name) || '"'
           j = j + 1
        END
        new_name = testname || (generations - 1)
     END
     ELSE new_name = testname || (last_backup + 1)

     RETURN new_name





USAGE:
   CLS
   SAY
   SAY 'ͻ'
   SAY '   Program : StealTXT.CMD                                           '
   SAY '                                                                    '
   SAY '   Autor : Norbert Heller (c) 1994                                  '
   SAY '                                                                    '
   SAY '   Usage : StealTXT /x INIFILE                                      '
   SAY '                                                                    '
   SAY '   /x : Switch where                                                '
   SAY '                                                                    '
   SAY '         /A : Source is from Albatros                               '
   SAY '         /C : Source is from Michael Bocks CDPLAYER                 '
   SAY '         /E : Source is from IBM CD Explorer                        '
   SAY '                                                                    '
   SAY '                                                                    '
   SAY '   Example : StealTXT /C CDPLAYER.INI                               '
   SAY '                                                                    '
   SAY '   StealTXT will then produce a backup TXT file named CDPLAYER.TX0  '
   SAY '                                                                    '
   SAY 'ͼ'

   EXIT 0



ERROR:        
   myrc = RC
   SAY 'StealTXT.CMD: error occurred !'
   SAY
   SAY 'REXX error' myrc 'in line' SIGL':' ERRORTEXT(myrc)
   SAY Substr('     ',1,6-Length(SIGL))(SIGL)' *-*   'Sourceline(sigl)
   SAY
   SAY 'Please contact the author with a description of the error.'

   EXIT -99
