#include "Load_BMP.h"
/*==========================================================================*/
/*  This function is will return a pointer to the bitmap image. Also the    */
/* height and width will be filled in. As I allocate memory for the image   */
/* you must free it yourself when your done.                                */
/*==========================================================================*/
PCHAR LoadBitmapFile ( PSZ filename, int *height, int *width )
{
   PBITMAPFILEHEADER2   pbfh = NULL;
   PBITMAPINFOHEADER2   pbih = NULL;
   ULONG                ulcbSize = 0L, 
                        cbRead = 0L;
   PVOID                memoryBuffer = NULL;
   FILESTATUS3          fileInfo;
   HFILE                hfFile;
   APIRET               returnCode;
   PCHAR                pImage;          

   /* Open the Bitmap file. */
   DosOpen( filename, &hfFile, &cbRead, 0L, FILE_READONLY, OPEN_ACTION_OPEN_IF_EXISTS, OPEN_SHARE_DENYNONE, 0L);

   if ( DosQueryFileInfo( hfFile, 1, (PVOID)&fileInfo, sizeof(FILESTATUS3)) != 0 ) 
       DosClose( hfFile );

   /* Get the file size and allocate the memory to hold it. */
   ulcbSize = fileInfo.cbFile;
   returnCode = DosAllocMem( &memoryBuffer, ulcbSize, fALLOC );

   if ( returnCode == 0 )
   {
      /* Now we have a memory buffer the size of the Bitmap load it into memory. */
      returnCode = DosRead( hfFile, memoryBuffer, ulcbSize, &cbRead );

      /* Cast the data to the structure which should be at the head of an OS/2 BMP2 file. */
      if ( returnCode == 0 )
      {
         /* Assign pointers to the bitmap header information and the data for the image bits. */
         pbfh = (PBITMAPFILEHEADER2)memoryBuffer;

         /* Set the return values. */
         pbih = &pbfh->bmp2;
         *height = pbih->cy;
         *width = pbih->cx; 

         /* Set the pointer to image. */
         pImage = (PBYTE)((PBYTE)pbfh + pbfh->offBits);
      }

      /* Free the memory for the bitmap. */
      DosFreeMem( &memoryBuffer );      
   }

   /* Close the file. */
   DosClose( hfFile );

   /* Return the pointer to the image. */
   return pImage;
}


