import java.awt.*;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;

import java.util.Hashtable;
import java.util.Vector;

// JMParseRC replaces the deprecated ParseINI file - January 24, 1999


/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class JMParseRC{

	/**
	 * Read .jamocha.rc and make an
	 * array of available MU*s, window positions, etc.
	 */
	
	private boolean stillLines, readLoop;
	private Hashtable jmSections;
	private FileOutputStream outFile;
	private int sectionFlag, t1, t2, t3;
	private PrintWriter out;
	public RandomAccessFile file;
	private String str, temp1, temp2, temp3, temp4;
	private Frame workingFrame;

	Vector muckName = new Vector(0, 1);
	Vector muckAddy = new Vector(0, 1);
	Vector muckPort = new Vector(0, 1);

	public JMParseRC() {	
		// Set INI-field flags to 0
		jmSections = new Hashtable();
		workingFrame = new Frame("Loading...."); 	// This frame is created
								// so that the dialogue
								// box has a parent

		// Set SectionFlag to 0, which indicates a non-valid INI group
		sectionFlag = 0;

		// Initialise other variables
		temp1 = new String("");
		temp2 = new String("");
		temp3 = new String("");
		temp4 = new String("");
	
		// First, set 'stillLines' to True.  
		// When 'stillLines' is false, end reading the file
		
		stillLines = true;

		// Open the file to allow subroutine to read
		
		try {
			System.out.println("Searching for " + MuckConn.jmVars.get("UserDirectory") + ".jamocha.rc");
			file = new RandomAccessFile((String)MuckConn.jmVars.get("UserDirectory") + ".jamocha.rc", "r");
			
			// Start a WHILE loop, using 'stillLines'
		
			while (stillLines) {
				// Read in a line of the ini file
				str = readParse();
				
				// Is this a new INI section flag?
				if ((str.substring(0, 1)).equals("[")) {
					if (str.equalsIgnoreCase("[worlds]")) {
						sectionFlag = 1;
					}

					if (str.equalsIgnoreCase("[FGColour]")) {
						sectionFlag = 2;
						SetColours(readParse());
					}

					if (str.equalsIgnoreCase("[BGColour]")) {
						sectionFlag = 3;
						SetColours(readParse());
					}

					if (str.equalsIgnoreCase("[mainwindow]")) {
						sectionFlag = 4;
						MainWindow(readParse());
					}

					if (str.equalsIgnoreCase("[databar]")) {
						sectionFlag = 5;
						MainWindow(readParse());
					}
					if (str.equalsIgnoreCase("[macrobar]")) {
						MacroWindow(readParse());
					}

					if (str.equalsIgnoreCase("[fontface]")) {
						FontFace(readParse());
					}

					if (str.equalsIgnoreCase("[macros]")) {
						sectionFlag = 8;
					}

					if (str.equalsIgnoreCase("[browser1]")) {
						sectionFlag = 9;
						Browser(readParse());
					}

					if (str.toLowerCase().equals("[browser2]")) {
						sectionFlag = 10;
						Browser(readParse());
					}

					if (str.toLowerCase().equals("[ftp client]")) {
						FTPClient(readParse());
					}

					if (str.toLowerCase().equals("[e-mail client]")) {
						sectionFlag = 12;
						EMailClient(readParse());

					}

					if (str.toLowerCase().equals("[autofocusinput]")) {
						// sectionFlag = 13;
						AutoFocusInput(readParse());
					}

					if (str.toLowerCase().equals("[unicode]")) {
						JMUseUnicode(readParse());
					}

				} else {
					// INI Section flag
					if (sectionFlag == 1) {
						MuckWorld(str);
					}
					if (sectionFlag == 8) {
						// Macros(str);
					}

					if (sectionFlag != 1) {
						sectionFlag = 0;
					}
				} 		
				
			} // end WHILE loop

		} catch (IOException e) {
			// No .jamocha.rc available, create a new one
			CreateRC();
		} catch (NullPointerException e) {
			// Run out of file to parse
		} catch (Exception e) {
			// This is the catchall exception, just to end JMParseRC
			System.out.println("JMParseRC Exception " + e);
		}
		
		// Check section flags, to see if important information is missing,
		// perhaps from using an older version of .jamocha.rc
		
		// Open file for any subsequent output
		try {
//			outFile = new FileOutputStream(EnumPlugIns.userDirectory + ".jamocha.rc", true);
			outFile = new FileOutputStream((String)MuckConn.jmVars.get("UserDirectory") + ".jamocha.rc", true);
			out = new PrintWriter(outFile, true);
			
			if (!jmSections.containsKey("MUWorlds")) {
				NewWorlds();
			}

			if (!jmSections.containsKey("MainWindow")) {
				NewMainWindow();
			}

			if (!jmSections.containsKey("MacroFrame")) {
				NewMacroBar();
			}

			if (!jmSections.containsKey("DataBar")) {
				NewDataBar();
			}

			if (!jmSections.containsKey("ForegroundColour")) {
				NewFGColour();
			}

			if (!jmSections.containsKey("BackgroundColour")) {
				NewBGColour();
			}

			if (!jmSections.containsKey("FontFace")) {
				NewFontFace();
			}

			if (!jmSections.containsKey("Macros")) {
				ReadSerialisedMacros();
				// If ReadSerialisedMacros fails, it will call NewMacros();
				// NewMacros();
			}

			if (!jmSections.containsKey("AutoFocusInput")) {
				NewAutoFocusInput();
			}	

			if (!jmSections.containsKey("Unicode")) {
				JMUseUnicode("false");
			}

			try {
				outFile.close();
			} catch (Exception oc) {
				System.out.println("JMParseRC: outFile.close error");
			}

		} catch (Exception e) {
			System.out.println("JMParseRC: An exception was caught " + e);
		}		

		// Add the worlds to the hashtable
		MuckConn.jmVars.put("MuckName", muckName);
		MuckConn.jmVars.put("MuckAddy", muckAddy);
		MuckConn.jmVars.put("MuckPort", muckPort);

		// and finally, return control to MuckConn
//		MuckConn.editor = false;
		
	}

	// Section to read line and parse out remarks and/or blank lines
	public String readParse() {
		readLoop = true;

		while (readLoop) {
			try {
				// Read in the line from the file, and trim extra characters
				str = (file.readLine()).trim();
				
				// Check for relevant information
				if (str.equals(null)) {
					// We've run out of lines to read
					readLoop = false;
					stillLines = false;
				}
				if (str.equals("")) {
					// Blank line, disregard
				} else {
					if ((str.substring(0, 1)).equals("#")) {
						// Disregard as comment
					} else {
						// This line is a keeper!
						readLoop = false;  // This terminates the loop
					}
				}
			} catch (NullPointerException ex) {
				// End of the file
				System.out.println("JMParseRC: End of file processed" + ex);
				readLoop = false;
				stillLines = false;
			} catch (StringIndexOutOfBoundsException ex) {
				// Hmmm...
			} catch (Exception ex) {
				// Mark for exception... probably no lines left
				System.out.println("JMParseRC: Exception... " + ex);
				readLoop = false;
				stillLines = false;
			}
		}
			
		return str;
	} 

	public static void Content() {
		JMParseRC a = new JMParseRC();
	}

	public void AutoFocusInput(String temp1) {
		MuckConn.jmVars.put("AutoFocusInput", temp1);
		jmSections.put("AutoFocusInput", "false");
	}

	public void MuckWorld(String temp1) {

		// Parse the remaining 2 required MuckWorld lines, checking for section flags
		temp2 = readParse();
		temp3 = readParse();
		if ((temp2.substring(0, 1)).equals("[") || (temp3.substring(0, 1)).equals("[")) {
			System.out.println("Improperly formatted world.");
			sectionFlag = 0;
		} else {
			muckName.addElement(temp1);
			muckAddy.addElement(temp2);
			muckPort.addElement(temp3);
			jmSections.put("MUWorlds", "true");
		}					
	}
	
	public void SetColours(String temp1) {
		// Set either the foreground or the background colours
		temp2 = readParse();
		temp3 = readParse();
		if ((temp2.substring(0, 1)).equals("[") || (temp3.substring(0, 1)).equals("[")) {
			System.out.println("Improperly formatted colour section");
			sectionFlag = 0;
		}
		try {
			t1 = Integer.parseInt(temp1.trim());
			t2 = Integer.parseInt(temp2.trim());
			t3 = Integer.parseInt(temp3.trim());
			
			// Section 2 represents the foreground (font) colour
			if (sectionFlag == 2) {
				MuckConn.jmVars.put("ForeGroundColour", new Color(t1, t2, t3));
				
				jmSections.put("ForegroundColour", "true");
			} else {

			// Section 3 represents the background Colour
				MuckConn.jmVars.put("BackGroundColour", new Color(t1, t2, t3));

				jmSections.put("BackgroundColour", "true");
			}
			sectionFlag = 0;
		} catch (Exception e) {
			System.out.println("Your colours are buggered." + e);
		}
	}

	public void MainWindow(String temp1) {
		// Set the location of the main text window
		try {
			temp2 = readParse();
			temp3 = readParse();
			temp4 = readParse();

			// Check to see if any of of these values contain flags
			if ((temp2.substring(0, 1)).equals("[") || (temp3.substring(0, 1)).equals("[") || (temp4.substring(0, 1)).equals("[")) {
				// Improperly formatted main text area window
				sectionFlag = 0;
			} else {
				if (sectionFlag == 5) {
					// Set the variables for the databar's 
					// initial position and size


					MuckConn.jmVars.put("DataBar", new Rectangle(Integer.parseInt(temp1.trim()), Integer.parseInt(temp2.trim()), Integer.parseInt(temp3.trim()), Integer.parseInt(temp4.trim())));


					jmSections.put("DataBar", "true");
					sectionFlag = 0;
				} else {
					// Set the variables for the window's
					// initial position and size
					Rectangle tempD = new Rectangle(Integer.parseInt(temp1.trim()), Integer.parseInt(temp2.trim()), Integer.parseInt(temp3.trim()), Integer.parseInt(temp4.trim()));
		
					MuckConn.jmVars.put("MainWindow", tempD);
					jmSections.put("MainWindow", "true");
					sectionFlag = 0;
				}
			}
		} catch (Exception mwe) {
			System.out.println("Main window error" + mwe);
		}
	}

	public void MacroWindow(String str) {
		// Determine the size of the macro-window, and if visible.
		temp1 = readParse();
		temp2 = readParse();
		temp3 = readParse();
		temp4 = readParse();
		
		if ((str.substring(0, 1)).equals("[") || (temp1.substring(0, 1)).equals("[") || (temp2.substring(0, 1)).equals("[") || (temp3.substring(0, 1)).equals("[") || (temp4.substring(0, 1)).equals("[")) {
			// Macro information
			sectionFlag = 0;
		} else {
			MuckConn.jmVars.put("MacroFrame", new Rectangle(Integer.parseInt(temp1.trim()), Integer.parseInt(temp2.trim()), Integer.parseInt(temp3.trim()), Integer.parseInt(temp4.trim())));
						

			jmSections.put("MacroFrame", "true");
			sectionFlag = 0;

			// Determine macroVisible boolean
			if (str.equalsIgnoreCase("false")) {
				MuckConn.jmVars.put("MacroVisible", "false");
			} else {
				MuckConn.jmVars.put("MacroVisible", "true");
			}
		}					
	}

	public void FontFace(String temp1) {
		temp2 = readParse();
		temp3 = readParse();

		// Try and cast the second two variables into ints
		// temp2 and temp3 are font style and font size respectively

		try {
			int tempInt2 = Integer.parseInt(temp2);
			int tempInt3 = Integer.parseInt(temp3);
			
			// Transfer this information into the font
			MuckConn.jmVars.put("FontFace", new Font(temp1, tempInt2, tempInt3));
			
		} catch (Exception e) {
			// The font section is corrupt
			System.out.println("Font section corrupt " + e);
			// This section will be expanded for multiple exception types
		}

		jmSections.put("FontFace", "true");

	}

	public void Browser(String temp1) {
		// Assign the browser
		// This section does not check to see if the location is valid or not
		if (temp1.equals("empty")) {
			temp1 = new String("");
		}

		if ((temp1.substring(0, 1)).equals("[")) {
			// This is a faulty entry
		} else {
			// Determine if this is to be the 
			// primary browser, or the secondary
			if (sectionFlag == 9) {
				MuckConn.jmVars.put("Browser1", temp1);
			} else {
				// MuckConn.jmVars.put("Browser2", temp2);
				MuckConn.jmVars.put("Browser2", temp1);
			}
		}
	}

	public void FTPClient(String temp1) {
		// Set the FTP client location
		if (temp1.equals("empty")) {
			temp1 = new String("");
		}

		MuckConn.jmVars.put("FTPClient", temp1);
	}

	public void EMailClient(String temp1) {
		// Set E-Mail Client location
		if (temp1.equals("empty")) {
			temp1 = new String("");
		}

		MuckConn.jmVars.put("EMailClient", temp1);
	}	

	public void JMUseUnicode(String temp1) {
		if (temp1.toLowerCase().equals("true")) {
			MuckConn.jmVars.put("UseUnicode", "true");
		} else {
			MuckConn.jmVars.put("UseUnicode", "false");
		}
		jmSections.put("Unicode", "true");		
	}	

	public void CreateRC() {
		// Section to create .jamocha.rc if one doesn't exist.
		// Prompt user to make sure this is okay, if not
		// program will end (can't think of anything else to do, otherwise, hee!)
		
		// Prompt user that a .jamocha.rc file will be create
		MuckConn.jmVars.put("Okay", "true");
		MuckConn.jmVars.put("Cancel", "true");
		MuckConn.jmVars.put("Ignore", "false");
		Vector tempVector = new Vector();
		OKBox.RunOkay(workingFrame, null, null, false, false, null, null, true, RBL("createSettingsFile"), "Create file .jamocha.rc (settings file) ?", 300, 250);
				
		if (((String)MuckConn.jmVars.get("Okay")).equals("true")) {
			// The user has okay'd the creation of the file
			try {
				outFile = new FileOutputStream((String)MuckConn.jmVars.get("UserDirectory") + ".jamocha.rc", false);
				out = new PrintWriter(outFile, true);
				out.println("# JamochaMUD INI file version 1.0");
				out.println("# JamochaMUD is Copyright (C) 1998-1999 Jeff Robinson");
				out.println("# Format is MU* name, MU* address (either name or IP), MU* port");
				out.println("");
				outFile.close();
			} catch (Exception e) {
				System.out.println(e);
			}
		} else {
			// User has declined the creation of the .jamocha.rc files
			// Give them a dialogue explaining how one can be created
		}
	}

	public void NewAutoFocusInput() {
		out.println("[AutoFocusInput]");
		out.println("true");
		MuckConn.jmVars.put("AutoFocusInput", "true");
		jmSections.put("AutoFocusInput", "false");
	}
	
	public void NewWorlds() {
		out.println("[Worlds]");
		out.println("FurryMuck");
		out.println("muck.furry.org");
		out.println("8888");
		out.println("");
		Vector muckName = new Vector(0, 1);
		Vector muckAddy = new Vector(0, 1);
		Vector muckPort = new Vector(0, 1);
		muckName.addElement("FurryMuck");
		muckAddy.addElement("muck.furry.org");
		muckPort.addElement("8888");
		MuckConn.jmVars.put("MuckName", muckName);
		MuckConn.jmVars.put("MuckAddy", muckAddy);
		MuckConn.jmVars.put("MuckPort", muckPort);		

	}
	
	public void NewFGColour() {
		out.println("# Foreground colour, format of Red, Green, Blue");
		out.println("# Maximum values of 255, minimum of 0, each");
		out.println("[FGColour]");
		out.println("0");
		out.println("255");
		out.println("85");
		out.println("");
		MuckConn.jmVars.put("ForeGroundColour", new Color(0, 255, 85));
		
		MuckMain.mainText.setForeground(new Color(0, 255, 85));
		DataIn.dataText.setForeground(new Color(0, 255, 85));
				
	}

	public void NewBGColour() {				
		out.println("#Background colour, format of Red, Green, Blue");
		out.println("# Maximum values of 255, minimum of 0, each");
		out.println("[BGColour]");
		out.println("0");
		out.println("0");
		out.println("0");
		out.println("");
		MuckConn.jmVars.put("BackGroundColour", new Color(0, 0, 0));
		MuckMain.mainText.setBackground(new Color(0, 0, 0));
		DataIn.dataText.setBackground(new Color(0, 0, 0));
				
	}
	
	public void NewMainWindow() {
		out.println("# Format of X location, Y location, Width, and height");
		out.println("[MainWindow]");
		out.println("0");
		out.println("10");
		out.println("600");
		out.println("355");
		out.println("");
		MuckMain.textWindow.setLocation(0, 10);
		MuckMain.textWindow.setSize(600, 355);
		
	}

	public void NewDataBar() {
		out.println("# Format of X location, Y location, Width, and height");
		out.println("[databar]");
		out.println("0");  // Left edge of databar
		out.println("385");  // Top edge of databar
		out.println("600");  // Width of databar
		out.println("60");  // Height of databar
		out.println("");
		MuckConn.jmVars.put("DataBar", new Rectangle(0, 385, 600, 60));

	}

	public void NewMacroBar() {
		out.println("# Format of (boolean) window visible, X location, Y location, Width, and height");
		out.println("[macrobar]");
		out.println("true");
		out.println("445");
		out.println("30");
		out.println("175");
		out.println("165");
		out.println("");
		MuckConn.jmVars.put("MacroVisible", "true");
//		Dimension d = new Dimension((Dimension)MuckConn.jmVars.get("ScreenSize"));
		MuckConn.jmVars.put("MacroFrame", new Rectangle(445, 30, 175, 165)); 
			
	}

	public void NewFontFace() {
		out.println("# Format of Font Type, Font Style, and Font Size");
		out.println("[FontFace]");
		out.println("Monospaced");
		out.println("0");
		out.println("12");
		out.println("");
		MuckMain.mainText.setFont(new Font("Monospaced", 0, 12));
		DataIn.dataText.setFont(new Font("Monospaced", 0, 12));
	}
	
	public void NewMacros() {
		// System.out.println("Going to label the macros");
		
		String mLabel[] = new String[8];
		String mDef[] = new String[8];
	
		// System.out.println("Doing loop to fill in Macro arrays");
		for (int i = 0; i < 8; i++) {
			mLabel[i] = ("Macro" + (i + 1));
			mDef[i] = ("");
		}
		MuckConn.jmVars.put("MacroLabels", mLabel);
		MuckConn.jmVars.put("MacroDefs", mDef);

		// As of 12/09/98, this method has been altered to serialise
		// macros in the .macros.rc file, instead of placing them in
		// the basic .jamocha.rc file
		try {
			FileOutputStream outputFile = new FileOutputStream((String)MuckConn.jmVars.get("UserDirectory") + ".macros.rc");
			ObjectOutputStream serializeStream = new ObjectOutputStream(outputFile);
			serializeStream.writeObject(mLabel);
			serializeStream.writeObject(mDef);
			serializeStream.flush();
		} catch (Exception e) {
			System.out.println("Macro serialization error " + e);
		}

	}

	public void ReadSerialisedMacros() {
		// This is the new method (as of 12/09/98) to read in
		// the now serialised macros

		try {
			FileInputStream inputFile = new FileInputStream((String)MuckConn.jmVars.get("UserDirectory") + ".macros.rc");
			ObjectInputStream serializeStream = new ObjectInputStream(inputFile);

			MuckConn.jmVars.put("MacroLabels", (String[]) serializeStream.readObject());
			MuckConn.jmVars.put("MacroDefs", (String[]) serializeStream.readObject());

		} catch (FileNotFoundException e) {
			// The file does not exist, but will be written later
			// This is not a bad thing
			// We'll create the info needed now:
			NewMacros();
				
			return;	
		} catch (Exception e) {
			System.out.println("Error during serialization " + e);
			// The file probably does not exist
			// We'll create the info needed now:
			NewMacros();
			return;
		}

	}

	/*
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "JMParseRC", itemTarget);
	}
	// This supports multi-line messages
	private static Vector RBL(String itemTarget) {
		return ResReader.LangVector("JamochaMUDBundle", "JMParseRC", itemTarget);
	}

}