import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.DataOutputStream;

import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 * A thread dedicated to reading data from a socket connection.
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class FromNet extends Thread {
	public Socket connectionSocket;    // the socket you are reading from
	protected BufferedReader inStream; // Replaces deprecated DataInputStream
	static Socket connSock;
	boolean empty;
	public static boolean isConnected;
	public static DataOutputStream outStream;
	// These two belong to the ASCII method
	// public static PrintWriter outPrintWriter;
	// public static OutputStreamWriter outStreamWriter;
		
	/**
 	* Closes down the socket connection using the socket's close method
 	*/
	public void closeConnection() {
		try {
			connSock.close();
			System.out.println("Closed the socket");
			MuckMain.DisconnectMenu();
		
			// Reset frame name
			MuckMain.textWindow.setTitle(MuckMain.muckMainTitle);
                        DataIn.dataBar.setTitle(DataIn.dataBarTitle);
		} catch (Exception oops) {
			// Some sort've exception goes here
			System.out.println("FromNet exception " + oops);
		}

		stop();
	}

/**
 * Continuously read a string from the socket and then calls dataReady in the 
 * read callback.  If you want to read something other than a string, change
 * this method and the dataReady callback to handle the appropriate data.
 */

/**
 * Creates an instance of a ReadThread on a Socket and indentifies the callback
 * that will receive all data from the socket.
 *
 * @param callback the object to be notified when data is ready
 * @param connSock the socket this ReadThread will read data from
 * @exception IOException if there is an error getting an input stream for the socket
 */

	public void run() {
		 
		MuckMain.ConnectMenu();
		MuckConn.minimizedLineCount = 0;
		
		try {
//			connSock = new Socket(MuckConn.connMuck, MuckConn.connPort);
			connSock = new Socket((String)MuckConn.jmVars.get("ConnMuck"), Integer.parseInt((String)MuckConn.jmVars.get("ConnPort")));
			outStream = new DataOutputStream(connSock.getOutputStream());
		} catch (NoRouteToHostException oops) {
			// No route to host, or operation timed out
			MuckMain.DisconnectMenu();
			System.out.println("From Net, NoRouteToHostException " + oops);
			String tempString = new String(oops + "");
			if (tempString.endsWith("unreachable")) {
				// Host unreachable
				MuckMain.mainText.append("JamochaMUD has experienced trouble connecting.  The host you are attempting to contact is currently unreachable." + '\n');		
			} else {
				MuckMain.mainText.append("JamochaMUD has experience trouble connecting.  We have experienced a time-out, and have been disconnected" + '\n');
			}
		} catch (UnknownHostException oops) {
			MuckMain.DisconnectMenu();
				MuckMain.mainText.append("JamochaMUD cannot connect to the address given.  Please check to make sure the address is valid, and then try again." + '\n');
		} catch (Exception oops) {
			MuckMain.DisconnectMenu();
			System.out.println("From Net, no socket " + oops);

			MuckMain.mainText.append("No socket to connect to." + '\n');
			closeConnection();
		}

		try {
			inStream = new BufferedReader(new InputStreamReader(connSock.getInputStream()));
		} catch (IOException oops) {
			System.out.println("No inStream");
		}
		
		// Change frame title
		MuckMain.textWindow.setTitle(MuckMain.muckMainTitle + " (" + (String)MuckConn.jmVars.get("ConnMuck") + ")");
		DataIn.dataBar.setTitle(DataIn.dataBarTitle + " (" + (String)MuckConn.jmVars.get("ConnMuck") + ")");
		isConnected = true; // This notifies the program of true connection
		empty = true;
	
		while (empty) {
			try {
				String str = inStream.readLine();
				// Notify the callback that you have a string
				if (str == null) {closeConnection();}
				
				// Send the string to the timer, if running
				if (MuckMain.tWTimers.getState()) {
					// Timer is running
					try {
						Timers.CompareStrings(str);
					} catch (Exception timer) {
						System.out.println("Timer exception: " + timer);
					}
				}

				// Now show the output
				if (MuckMain.pauseStatus) {
					// Text is paused, spool to 'heldResponse
					MuckMain.heldResponse.addElement(str);
				} else {
					str = EnumPlugIns.CallPlugin(str, "output");
					MuckMain.mainText.append(str + '\n');
					if (!MuckMain.textWindowStatus) {
						// Change title bar of MuckMain window
						MuckConn.minimizedLineCount++;
						MuckMain.textWindow.setTitle("(" + MuckConn.minimizedLineCount +") " + str);
					}
				}
			} catch (Exception oops) {
				// Tell the callback there was an error
				// readCallback.dataReady(null);
				System.out.println("Error " + oops);
				closeConnection();
			}
		}
	}

}
