
import java.awt.*;
import java.awt.event.*;

import java.util.Hashtable;

/*
 * FontFace (allows changing of colours and font faces)
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class FontFace extends Dialog implements ActionListener, MouseListener{
	protected Button okayButton, cancelButton, fontColourButton, backgroundColourButton;
	protected Color backgroundColour, fontColour;
	protected Choice fontBody, fontStyle, fontSize;
	protected static Frame fFFrame;
	protected int a;
	protected Panel fFPanel, fFsubPanel1, fFsubPanel2, fFsubPanel3, fFsubPanel4, 			fFsubPanel5;
						
	public FontFace(Frame frameParent){

		super(frameParent, "JamochaMUD - "+ RB("title"), true);
		
		fFPanel = new Panel();
		fFsubPanel1 = new Panel();
		fFsubPanel2 = new Panel();
		fFsubPanel3 = new Panel();
		fFsubPanel4 = new Panel();
		fFsubPanel5 = new Panel();
		fontBody = new Choice();
		fontStyle = new Choice();
		fontSize = new Choice();
		backgroundColour = MuckMain.mainText.getBackground();
		fontColour = MuckMain.mainText.getForeground();

		// Set Gridbag layout
		GridBagLayout fFLayout = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();
		this.setLayout(fFLayout);
		
		// Add dialogue components	
		Label fFLabel = new Label(RB("font"));
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.insets = new Insets(7, 7, 2, 2);
		constraints.fill = GridBagConstraints.BOTH;
		fFLayout.setConstraints(fFLabel, constraints);
		add(fFLabel);

		fontBody = new Choice();
			fontBody.add("Serif");
			fontBody.add("SansSerif");
			fontBody.add("Monospaced");
			fontBody.add("Dialog");
			// Determine existing name style, and make that default choice
			fontBody.select(MuckMain.mainText.getFont().getName());

		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 2;
		constraints.gridy = 0;
		constraints.insets = new Insets(7, 2, 2, 2);
		constraints.fill = GridBagConstraints.BOTH;
		fFLayout.setConstraints(fontBody, constraints);
		add(fontBody);
		fontBody.addMouseListener(this);

		fontStyle = new Choice();
			fontStyle.add(RB("fontStyle.plain"));
			fontStyle.add(RB("fontStyle.bold"));
			fontStyle.add(RB("fontStyle.italic"));
			fontStyle.add(RB("fontStyle.bold&italic"));
			// Determine existing font style, and make it the default choice
			fontStyle.select(MuckMain.mainText.getFont().getStyle());
			fFsubPanel1.add(fontStyle);
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 0;
			constraints.insets = new Insets(7, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.gridwidth = GridBagConstraints.RELATIVE;
			fFLayout.setConstraints(fontStyle, constraints);
		add(fontStyle);		
		fontStyle.addMouseListener(this);

		fFLabel = new Label(RB("fontSize"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 1;
			constraints.gridy = 1;
			constraints.insets = new Insets(7, 2, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			// constraints.gridwidth = GridBagConstraints.RELATIVE;
			fFLayout.setConstraints(fFLabel, constraints);
		add(fFLabel);
		
		fontSize = new Choice();
			for (int fs = 6; fs < 41; fs++) {
				fontSize.add(fs + "");
			}
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 3;
			constraints.gridy = 1;
			constraints.insets = new Insets(2, 2, 2, 7);
			// constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.WEST;
			constraints.gridwidth = GridBagConstraints.RELATIVE;
			fFLayout.setConstraints(fontSize, constraints);
		fontSize.select((MuckMain.mainText.getFont().getSize()) - 6);
		add(fontSize);

		fFLabel = new Label(RB("change"));
			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 2;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			fFLayout.setConstraints(fFLabel, constraints);
			add(fFLabel);		

		fontColourButton = new Button(RB("fontColourButton"));
			// fFsubPanel2.add(fFButton);
			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 3;
			constraints.gridy = 2;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.gridwidth = GridBagConstraints.RELATIVE;
			fFLayout.setConstraints(fontColourButton, constraints);
			fontColourButton.addActionListener(this);
			add(fontColourButton);

		fFLabel = new Label(RB("change"));
			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 3;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			fFLayout.setConstraints(fFLabel, constraints);
			add(fFLabel);

		backgroundColourButton = new Button(RB("backgroundColourButton"));
			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 3;
			constraints.gridy = 3;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.gridwidth = GridBagConstraints.RELATIVE;
			fFLayout.setConstraints(backgroundColourButton, constraints);
			add(backgroundColourButton);
			backgroundColourButton.addActionListener(this);

		fFLabel = new Label("");
			constraints.gridwidth = 6;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 4;
			constraints.fill = GridBagConstraints.BOTH;
			constraints.gridwidth = GridBagConstraints.RELATIVE;
			fFLayout.setConstraints(fFLabel, constraints);
			// add(fFLabel);

		okayButton = new Button(RB("okayButton"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 1;
			constraints.gridy = 5;
			constraints.insets = new Insets(7, 7, 7, 7);
			constraints.fill = GridBagConstraints.BOTH;
			fFLayout.setConstraints(okayButton, constraints);
			add(okayButton);
			okayButton.addActionListener(this);

		cancelButton = new Button(RB("cancelButton"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 5;
			constraints.insets = new Insets(7, 7, 7, 7);
			constraints.fill = GridBagConstraints.BOTH;
			fFLayout.setConstraints(cancelButton, constraints);
			add(cancelButton);
			cancelButton.addActionListener(this);

		pack();
	}


	public static void RunOkay(Frame frameParent){
		fFFrame = new Frame();
		FontFace editIt = new FontFace(frameParent);
		Dimension d = (Dimension) (MuckConn.jmVars.get(new String("ScreenSize")));
		int swidth = (int) d.width; // Cast 'd' to integer
		int bwidth = (int) ((swidth / 2) - 100);
		editIt.setLocation(bwidth, 160);
		editIt.setSize(300, 250);
		editIt.setResizable(false);
		editIt.show();
	}

	/*
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "FontFace", itemTarget);
	}

	
	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();

		if (arg.equals(fontColourButton.getLabel())) {
			ColourPicker.RunOkay(fFFrame, "Font Colour", fontColour);		
			if (ColourPicker.newColour != null) {
				fontColour = ColourPicker.newColour;
			}
		}

		if (arg.equals(backgroundColourButton.getLabel())) {
			ColourPicker.RunOkay(fFFrame, "Background Colour", backgroundColour);
			if (ColourPicker.newColour != null) {
				backgroundColour = ColourPicker.newColour;
			}
		}

		if (arg.equals(okayButton.getLabel())){
			// Okay was selected, get the information
			JMSetNewColour();
			// Get information from fontBody and fontStyle, and apply them
			setVisible(false);
			
			// Write to the .jamocha.rc file
			JMWriteRC.Content();

			dispose();
		}
		if (arg.equals(cancelButton.getLabel())){
			setVisible(false);
			dispose();
		}
		repaint();
	}

	// Mouse events
	public void mousePressed(MouseEvent e) {}

	public void mouseReleased(MouseEvent e) {
		repaint();
	}

        public void mouseClicked(MouseEvent e) {
		repaint();
	}

	public void mouseEntered(MouseEvent e) {}

	public void mouseExited(MouseEvent e) {}

	// Update the sample text
	public void paint(Graphics g) {
		g.setColor(backgroundColour);
		g.fill3DRect(25, 210, 250, 30, true);
		g.setColor(fontColour);
		g.setFont(new 	Font((fontBody.getItem(fontBody.getSelectedIndex())), 					(fontStyle.getSelectedIndex()), 12));
		g.drawString(RB("thePleasingRedFoxSipped"), 40, 230);
	}

	private void JMSetNewColour() {
		// Get information from fontBody and fontStyle, and apply them
		int a = fontStyle.getSelectedIndex();
		MuckMain.mainText.setFont(new 									Font((fontBody.getItem(fontBody.getSelectedIndex())), 					(fontStyle.getSelectedIndex()), ((fontSize.getSelectedIndex()) + 6)));
		DataIn.dataText.setFont(new Font((fontBody.getItem(fontBody.getSelectedIndex())), (fontStyle.getSelectedIndex()), ((fontSize.getSelectedIndex()) + 6)));
		MuckMain.mainText.setForeground(fontColour);
		MuckMain.mainText.setBackground(backgroundColour);
		DataIn.dataText.setForeground(fontColour);
		DataIn.dataText.setBackground(backgroundColour); 
	}
		
}
