
import java.awt.*;
import java.awt.event.*;

/*
 * Add / Edit MU*
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class AddEdit extends Dialog implements ActionListener{
	protected Button okay, cancel;
	protected static Frame editMuck;
	private GridBagLayout addEditLayout;			
	private GridBagConstraints constraints;
	private Label gLabel;
	private TextField editName, editAddy, editPort;

//	public AddEdit(Frame parent, TextField editName, TextField editAddy, TextField editPort, String boxLabel){
	public AddEdit(Frame frameParent, String boxLabel) {
		super(frameParent, "JamochaMUD - " + boxLabel, true);
		editName = new TextField((String)MuckConn.jmVars.get("EditName"));
		editAddy = new TextField((String)MuckConn.jmVars.get("EditAddy"));
		editPort = new TextField((String)MuckConn.jmVars.get("EditPort"));
			

		addEditLayout = new GridBagLayout();
		constraints = new GridBagConstraints();
		
		// Set new layout
		
		this.setLayout(addEditLayout);

		// Add elements to the layout
		// MU* name
		gLabel = new Label(RB("MUname"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 0;
			constraints.weightx = 2;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 7, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.WEST;
			addEditLayout.setConstraints(gLabel, constraints);
		add(gLabel);

			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 0;
			constraints.weightx = 3;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.WEST;
			addEditLayout.setConstraints(editName, constraints);
		add(editName);

		// MU* address
		gLabel = new Label(RB("MUaddress"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 1;
			constraints.weightx = 2;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.WEST;
			addEditLayout.setConstraints(gLabel, constraints);
		add(gLabel);

			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 1;
			constraints.weightx = 3;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.WEST;
			addEditLayout.setConstraints(editAddy, constraints);
		add(editAddy);

		// MU* port
		gLabel = new Label(RB("MUport"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 2;
			constraints.weightx = 2;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.WEST;
			addEditLayout.setConstraints(gLabel, constraints);
		add(gLabel);

			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 2;
			constraints.weightx = 3;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.WEST;
			addEditLayout.setConstraints(editPort, constraints);
		add(editPort);

		okay = new Button(RB("OK"));
			constraints.gridwidth = 1;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 3;
			constraints.weightx = 2;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 7, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.EAST;
			addEditLayout.setConstraints(okay, constraints);
		add(okay);
		okay.addActionListener(this);

		cancel = new Button(RB("cancel"));
			constraints.gridwidth = 1;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 3;
			constraints.weightx = 3;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 7, 7);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			addEditLayout.setConstraints(cancel, constraints);
		add(cancel);
		cancel.addActionListener(this);

		pack();
	}

//	public static void RunIt(Frame appletContainer, TextField editName, TextField editAddy, TextField editPort, String boxLabel){
	public static void RunIt(Frame parentFrame, String boxLabel, boolean editor) {
		editMuck = new Frame("Dialog");
//		AddEdit editIt = new AddEdit(editMuck, editName, editAddy, editPort, boxLabel);
		AddEdit editIt = new AddEdit(parentFrame, boxLabel);
		editIt.setLocation(180, 160);
		editIt.setSize(280, 160);
		editIt.show();
	}

	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		
		// Check for the 'cancel Button'
		if (arg.equals(cancel.getLabel())) {
			// System.out.println("Hit the cancel button!");
			setVisible(false);
			dispose();
//			MuckConn.editor = false;
			MuckConn.jmVars.put("EditName", null);
		}

		// Check for the 'okay button'
		if (arg.equals(okay.getLabel())) {
			// System.out.println("Hit the OK button!");
			MuckConn.jmVars.put("EditName", editName.getText());
			MuckConn.jmVars.put("EditAddy", editAddy.getText());
			MuckConn.jmVars.put("EditPort", editPort.getText());
			setVisible(false);
			dispose();
			// MuckConn.editor = true;
		}
	}

	/*
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "AddEdit", itemTarget);
	}
	
}
