/* REXX */
/* Sample user exit for pppdial.cmd */
/* Don Russell */
/* don_russell@ibm.net */

/* This particular exit determines the local IP address and displays it. */
/* You could modify this script to write the IP address to a file for further */
/* distribution. i.e. so people can FTP to/from you, obtaining your IP address */
/* by sending you e-mail. */

parse upper source env how self .
parse arg arguments

address cmd
'@ECHO OFF'

if how = 'FUNCTION' then do
   /* we were started as a function call from pppdial... */
   /* start us again as a separate session and return. */
   'START /C /I' self arguments
   return 0
end

/* The user exit actually ended but hasn't done anything yet... */
/* It started up the exit again asynchronously in order to let the dial */
/* connection be completed.... */

/* Let's wait a few seconds to let things settle a bit... */
call SysSleep 3

NewQueue = RXQUEUE( 'create' )
OldQueue = RXQUEUE( 'set', NewQueue )
/* What's our IP address this time? ... */
'NETSTAT -a | RXQUEUE' NewQueue
if queued() = 0 then
   MyIP = '*unknown*'
else
   parse pull . MyIP .

/* There may be more than one IP address in the queue */
/* if you're connected to more than one network at the same time. */
/* MyIP will be the FIRST adress, the others will be ignored. */
call RXQUEUE 'delete', NewQueue
call RXQUEUE 'set', OldQueue

parse var arguments DCERate .
say 'Our IP address is' MyIP
say "Connection speed to the 'net is" DCERate

/* Create file to send to people asking for my IP address... */
    /* code to be developed by user */
/* Start up my mail client so I can process requests for this file. */
    /* code to be developed by user */

'@PAUSE'

