/* ------------------------------------------------------------------ */
/* CMD to create object for POV-ray INF POVdoc2                       */
/*                                                                    */
/* Usage: INSTALL {os2BootDrive}                                      */
/*                                                                    */
/* Default: Search the OS/2 boot drive                                */
/*                                                                    */
/*                                                                    */
/* Last update: 11.05.1997                                            */
/*                                                                    */
/*                                                                    */
/* ------------------------------------------------------------------ */

                        /* check & process the parameter              */
  parse arg OS2BootDrive
  OS2BootDrive = substr( translate( strip( OS2BootDrive ) ),1,2 )
  if OS2BootDrive <> '' then
    if stream( OS2BootDrive || '\CONFIG.SYS', 'c', 'QUERY EXIST' ) = '' then
    do
                        /* show the usage                             */
      say 'Usage: INSTALL {os2BootDrive}'
      say ''
      say 'Default: Search the OS/2 boot drive'
      exit 253
    end /* if stream( ... */
  
                        /* init the return code                       */
  thisRC = 255

                        /* init some global variables                 */
  DocFile =           'POVdoc2.INF'
  InstDirectory =     directory() || '\'
  defaultTitle =      'POV-ray 3.0 OS/2 Docs'
  curObjectID =       '<POVdoc>'
  defaultLocation =   '<WP_DESKTOP>'

                        /* install some error handler                 */
  signal on halt name UserAbort
  signal on syntax name RexxUtilNotFound

  say ' Loading REXXUTIL ... '
  
                        /* load REXXUTIL                              */
  call rxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
  call SysLoadFuncs

                        /* turn on the default error handler again    */
  signal off Syntax

    say ' Creating desktop object ...'

                        /* create the object                          */
    tempRC = SysCreateObject( 'WPProgram' ,,
                              defaultTitle ,,
                              defaultLocation ,,
                             'EXENAME= VIEW.EXE;' || ,
                             'PARAMETERS=' || InstDirectory || DocFile 'Hyper-Doc' || ';' || ,
                             'TITLE=' || defaultTitle  || ';' || ,
                             'OBJECTID=' || curObjectID || ';' ,,
                             'U' )

    if tempRC = 1 then
    do
      thisRC = 0
      say ' ... object created.'
    end /* if tempRC = 1 then */
    else
      say 'Error creating the object!'

exit thisRC

/* ------------------------------------------------------------------ */
/* function:   search the boot drive                                  */
/*                                                                    */
/* parameters: none                                                   */
/*                                                                    */
/* returns:    boot drive (e.g. "C:")                                 */
/*                                                                    */
SearchBootDrive: PROCEDURE 

                        /* install a local error handler              */
  signal on syntax name BootDriveNotFound

                    /* try the new function from the new REXXUTIL DLL */
  OS2BootDrive = SysBootDrive()

BootDriveNotFound:

  if symbol( 'OS2BootDrive' ) <> 'VAR' then
  do
                        /* new REXXUTIL DLL not found  --             */
                        /* use the old method                         */
    OS2BootDrive = substr( value( 'RUNWORKPLACE' ,, 'OS2ENVIRONMENT' ), 1,2 )

    if OS2BootDrive = '' then
      OS2BootDrive = substr( value( 'COMSPEC' ,, 'OS2ENVIRONMENT' ), 1,2 )

    if OS2BootDrive = '' then
      OS2BootDrive = 'C:'

  end /* if symbol( 'OS2BootDrive' ) <> 'VAR' then */  
RETURN OS2BootDrive

/* ------------------------------------------------------------------ */
/* Error handler (called if the DLL REXXUTIL is not found)            */
/*                                                                    */
RexxUtilNotFound:
  say ''
  say 'Error: REXXUTIL.DLL not found!'
exit 255

/* ------------------------------------------------------------------ */
/* Error handler (called if the user presses CTRL-BREAK)              */
/*                                                                    */
UserAbort:
  say ''
  say ' Installation aborted by the user.'
exit 254
