/***************************************************
Example of using dosboxloader from a conf file as a .cmd file
***************************************************/
'@echo OFF'

/* Directory where dosbox is installed */

'set dosboxdir=f:\os2\mdos\DOSBox'

'dbldr.exe %0'

/* don't remove this line
DOSBOX_CONF  

# dosbox.conf starts here, modify these settings if needed

[sdl]
# fullscreen -- Start dosbox directly in fullscreen.
# fulldouble -- Use double buffering in fullscreen.
# fullfixed -- Don't resize the screen when in fullscreen.
# fullresolution -- What resolution to use for fullscreen, use together with fullfixed.
# output -- What to use for output: surface,overlay.
# hwscale -- Extra scaling of window if the output device supports hardware scaling.
# autolock -- Mouse will automatically lock, if you click on the screen.
# sensitiviy -- Mouse sensitivity.
# waitonerror -- Wait before closing the console if dosbox has an error.
# priority -- Priority levels for dosbox: lower,normal,higher,highest.
#             Second entry behind the comma is for when dosbox is not focused/minimized.
# mapperfile -- File used to load/save the key/event mappings from.

fullscreen=false
fulldouble=false
fullfixed=false
fullresolution=1024x768
output=surface
hwscale=1.00
autolock=true
sensitivity=100
waitonerror=true
priority=higher,normal
mapperfile=mapper.txt

[dosbox]
# language -- Select another language file.
# memsize -- Amount of memory dosbox has in megabytes.
# machine -- The type of machine tries to emulate:hercules,cga,tandy,vga.
# captures -- Directory where things like wave,midi,screenshot get captured.

language=
machine=vga
captures=capture
memsize=16

[render]
# frameskip -- How many frames dosbox skips before drawing one.
# aspect -- Do aspect correction.
# scaler -- Scaler used to enlarge/enhance low resolution modes.
#           Supported are none,normal2x,advmame2x,advmame3x,advinterp2x,interp2x,tv2x.

frameskip=0
aspect=false
scaler=normal2x

[cpu]
# core -- CPU Core used in emulation: simple,normal,full,dynamic.
# cycles -- Amount of instructions dosbox tries to emulate each millisecond.
#           Setting this higher than your machine can handle is bad!
# cycleup   -- Amount of cycles to increase/decrease with keycombo.
# cycledown    Setting it lower than 100 will be a percentage.

core=normal
cycles=3000
cycleup=500
cycledown=20

[mixer]
# nosound -- Enable silent mode, sound is still emulated though.
# rate -- Mixer sample rate, setting any devices higher than this will
#         probably lower their sound quality.
# blocksize -- Mixer block size, larger blocks might help sound stuttering
#              but sound will also be more lagged.
# prebuffer -- How many milliseconds of data to keep on top of the blocksize.

nosound=false
rate=22050
blocksize=2048
prebuffer=10

[midi]
# mpu401      -- Enable MPU-401 Emulation.
# intelligent -- Operate in Intelligent mode.
# device      -- Device that will receive the MIDI data from MPU-401.
#                This can be default,alsa,oss,win32,coreaudio, none.
# config      -- Special configuration options for the device.

mpu401=true
intelligent=true
device=default
config=

[sblaster]
# type -- Type of sblaster to emulate:none,sb1,sb2,sbpro1,sbpro2,sb16.
# base,irq,dma,hdma -- The IO/IRQ/DMA/High DMA address of the soundblaster.
# mixer -- Allow the soundblaster mixer to modify the dosbox mixer.
# oplmode -- Type of OPL emulation: auto,cms,opl2,dualopl2,opl3.
#            On auto the mode is determined by sblaster type.
# oplrate -- Sample rate of OPL music emulation.

type=sb16
base=220
irq=7
dma=1
hdma=5
mixer=true
oplmode=auto
oplrate=22050

[gus]
# gus -- Enable the Gravis Ultrasound emulation.
# base,irq1,irq2,dma1,dma2 -- The IO/IRQ/DMA addresses of the 
#            Gravis Ultrasound. (Same IRQ's and DMA's are OK.)
# rate -- Sample rate of Ultrasound emulation.
# ultradir -- Path to Ultrasound directory.  In this directory
#             there should be a MIDI directory that contains
#             the patch files for GUS playback.  Patch sets used
#             with Timidity should work fine.

gus=true
rate=22050
base=240
irq1=5
irq2=5
dma1=3
dma2=3
ultradir=C:\ULTRASND

[speaker]
# pcspeaker -- Enable PC-Speaker emulation.
# pcrate -- Sample rate of the PC-Speaker sound generation.
# tandyrate -- Sample rate of the Tandy 3-Voice generation.
#              Tandysound emulation is present if machine is set to tandy.
# disney -- Enable Disney Sound Source emulation.

pcspeaker=true
pcrate=22050
tandyrate=22050
disney=true

[bios]
# Nothing to setup yet!


[dos]
# xms -- Enable XMS support.
# ems -- Enable EMS support.

xms=true
ems=true

[modem]
# modem -- Enable virtual modem emulation.
# comport -- COM Port modem is connected to.
# listenport -- TCP Port the modem listens on for incoming connections.

modem=false
comport=2
listenport=23

[directserial]
# directserial -- Enable serial passthrough support.
# comport -- COM Port inside DOSBox.
# realport -- COM Port on the Host.
# defaultbps -- Default BPS.
# parity -- Parity of the packets. This can be N, E or O.
# bytesize -- Size of each packet. This can be 5 or 8.
# stopbit -- The number of stopbits. This can be 1 or 2.

directserial=false
comport=1
realport=COM1
defaultbps=1200
parity=N
bytesize=8
stopbit=1

[ipx]
# ipx -- Enable ipx over UDP/IP emulation.

ipx=false

[autoexec]
# Lines in this section will be run at startup.
# this is just an example
# modify to start your own game, this example starts 4dos
# CD to full path as seen from within dosbox

$echo off
PATH=Z:\;C:\DOS;C:\UTILITIE;C:\MM;
SET CTSYN=C:\MM
SET TMP=D:\SWAP
SET TEMP=D:\SWAP
SET SOUND=C:\MM
SET MIDI=SYNTH:1 MAP:E MODE:0
mount c: c:
mount d: d:
mount e: e:
mount s: s: -t cdrom -ioctl
mount t: t: -t cdrom  -ioctl
C:
cls
cd \dos
4dos.com


# END don't remove this line */
