/*** rexx ********************************************************************/
/*                                                                           */
/* SAMPLE2.CMD - Oracle-REXX Interface Sample                                */
/*                                                                           */
/* Sample REXX command file to demonstrate dynamic SQL method 4.             */
/*                                                                           */
/*****************************************************************************/

CALL RXFUNCADD "SQLEXEC", "RXORA", "SQLEXEC"

/*---------------------------------------------------------------------------*/

SAY "Oracle-REXX Interface - Sample 2: Dynamic SQL method 4"
SAY
SAY "Enter an Oracle connect string in the form: user/password@connect"
SAY "Or simply press enter to use the sample connect string: scott/tiger"
PULL connect .
if connect = "" then
  connect = "scott/tiger"

/*---------------------------------------------------------------------------*/

SAY "Connecting as" connect

CALL SQLEXEC "CONNECT :connect"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/
SAY
SAY "This sample command file allows you to enter SQL statements to be"
SAY "executed.  Enter an SQL statement without a terminating semicolon."
SAY "For example: select * from emp"

CALL SQLEXEC "DECLARE stmt STATEMENT"
CALL CheckSQLReturn

CALL SQLEXEC "DECLARE csr CURSOR FOR stmt"
CALL CheckSQLReturn

loop:
SAY
SAY "Enter a SQL statement or EXIT"
PARSE PULL sql
PARSE UPPER VAR sql stmt_type .

DO WHILE stmt_type <> "EXIT"
  SAY "  Preparing the statement"
  CALL SQLEXEC "PREPARE stmt FROM :sql"
  CALL CheckSQLReturn

  SAY "  Describing the statement"
  CALL SQLEXEC "DESCRIBE BIND VARIABLES FOR stmt INTO bind_desc"
  CALL CheckSQLReturn

  CALL SQLEXEC "DESCRIBE SELECT LIST FOR stmt INTO sel_desc"
  CALL CheckSQLReturn

  DO i = 1 TO bind_desc.sqld
    SAY "Enter value for" bind_desc.i.sqlname
    PARSE PULL bind_desc.i.sqldata
    bind_desc.i.sqltype = 5
    bind_desc.i.sqllen  = 0
    bind_desc.i.sqlind  = 0
  END

  DO i = 1 TO sel_desc.sqld
    sel_desc.i.sqltype = 5
    sel_desc.i.sqllen  = 0
  END

  SAY "  Executing the statement"
  IF stmt_type <> "SELECT" THEN DO
    CALL SQLEXEC "EXECUTE stmt USING DESCRIPTOR bind_desc"
    CALL CheckSQLReturn
  END
  ELSE DO
    CALL SQLEXEC "OPEN csr USING DESCRIPTOR bind_desc"
    CALL CheckSQLReturn

    CALL SQLEXEC "FETCH csr USING DESCRIPTOR sel_desc"
    CALL CheckSQLReturn
    DO WHILE (result = 0) & (sqlca.sqlcode = 0)
      SAY "  ---"
      DO i = 1 TO sel_desc.sqld
        SAY " " left(sel_desc.i.sqlname,15)  sel_desc.i.sqldata
      END
      CALL SQLEXEC "FETCH csr USING DESCRIPTOR sel_desc"
    END
    IF (result <> 0) | (sqlca.sqlcode <> 1403) THEN
      CALL CheckSQLReturn

    CALL SQLEXEC "CLOSE csr"
    CALL CheckSQLReturn
  END

  SAY
  SAY "Enter a SQL statement or EXIT"
  PARSE PULL sql
  PARSE UPPER VAR sql stmt_type .
END

/*---------------------------------------------------------------------------*/
disconnect:
SAY "Disconnect"

CALL SQLEXEC "ROLLBACK RELEASE"

/*---------------------------------------------------------------------------*/

SAY "Sample completed - Press Enter to exit"
PULL .

EXIT

/*---------------------------------------------------------------------------*/

CheckSQLReturn:
  IF result <> 0 THEN DO
    SAY "Invalid embedded SQL statement ("result")."
    SIGNAL loop
  END
  ELSE IF sqlca.sqlcode <> 0 THEN DO
    SAY sqlca.sqlerrmc
    IF sqlca.sqlcode <> 1403 THEN
      SIGNAL loop
  END
  RETURN result

