load data
infile *
preserve blanks
into table help append
fields terminated by '^'
TRAILING NULLCOLS
(
    topic, seq, info
)
BEGINDATA
BNF SYNTAX^1^
BNF SYNTAX^2^
BNF SYNTAX^3^                                BNF Syntax
BNF SYNTAX^4^
BNF SYNTAX^5^ {Braces} enclose required items; you MUST enter one from the list of
BNF SYNTAX^6^ items separated by vertical bars. [Brackets] enclose optional items;
BNF SYNTAX^7^ you MAY enter one from the list of items separated by vertical bars.
BNF SYNTAX^8^ Three periods mean that the preceding item may be repeated.  Do not
BNF SYNTAX^9^ enter the braces, brackets, or vertical bars.
BNF SYNTAX^10^
BNF SYNTAX^11^ Parentheses enclose parameter lists; commas separate items in a list.
BNF SYNTAX^12^ UPPERCASE indicates specific words to be used; lowercase shows names
BNF SYNTAX^13^ and expressions that vary.
BNF SYNTAX^14^
BNF SYNTAX^15^   COMMIT [WORK]
BNF SYNTAX^16^
BNF SYNTAX^17^   DELETE FROM [user.]table [alias] [WHERE condition]
BNF SYNTAX^18^
BNF SYNTAX^19^   INSERT INTO [user.]table [ (column [, column]...) ]
BNF SYNTAX^20^      { VALUES (value [, value]...) | query }
BNF SYNTAX^21^
BNF SYNTAX^22^   LOCK TABLE [user.]table [, [user.]table ]...
BNF SYNTAX^23^
BNF SYNTAX^24^   ROLLBACK [WORK] [TO [SAVEPOINT] savepoint]
BNF SYNTAX^25^
BNF SYNTAX^26^   SAVEPOINT savepoint
BNF SYNTAX^27^
BNF SYNTAX^28^   SELECT [ALL|DISTINCT] { * | table.* | expr [column_alias]}
BNF SYNTAX^29^          [, {table.* | expr [column_alias] } ]... }
BNF SYNTAX^30^     FROM [user.]table [table_alias] [,[user.]table [table_alias]]...
BNF SYNTAX^31^     [ WHERE condition ]
BNF SYNTAX^32^     [ CONNECT BY condition [START WITH condition] ]
BNF SYNTAX^33^     [ GROUP BY expr[, expr]... [HAVING condition] ]
BNF SYNTAX^34^     [ {UNION | INTERSECT | MINUS} SELECT ... ]
BNF SYNTAX^35^     [ ORDER BY {expr | position} [ASC | DESC]
BNF SYNTAX^36^          [, {expr | position} [ASC | DESC]] ]...
BNF SYNTAX^37^     [ FOR UPDATE OF column [, column]... [NOWAIT] ]
BNF SYNTAX^38^
BNF SYNTAX^39^   SET TRANSACTION [READ ONLY]
BNF SYNTAX^40^
BNF SYNTAX^41^   UPDATE [user.]table [alias]
BNF SYNTAX^42^     SET column = expr [,column = expr]...
BNF SYNTAX^43^     [WHERE condition]
BNF SYNTAX^44^
BNF SYNTAX^45^   UPDATE [user.]table [alias]
BNF SYNTAX^46^     SET (column [,column] ... ) = (query) [,...]
BNF SYNTAX^47^     [WHERE condition]
BNF SYNTAX^48^
BNF SYNTAX^49^
BNF SYNTAX^50^ See any command listed; see also: commands.
BNF SYNTAX^51^
ACCEPT^1^
ACCEPT^2^
ACCEPT^3^                                   ACCEPT
ACCEPT^4^
ACCEPT^5^ ACC[EPT] variable [NUM[BER]|CHAR|DATE] [FOR[MAT] format]
ACCEPT^6^    [DEF[AULT] default] [PROMPT text|NOPR[OMPT]] [HIDE]
ACCEPT^7^
ACCEPT^8^ ACCEPT reads a line of input and stores it in a given user variable.
ACCEPT^9^
ACCEPT^10^     variable
ACCEPT^11^         is the name of the variable in which you wish to store a value.
ACCEPT^12^         If variable doesn't exist, SQL*Plus creates it.
ACCEPT^13^
ACCEPT^14^     NUM[BER]
ACCEPT^15^         makes the datatype of variable the datatype NUMBER.  If the
ACCEPT^16^         reply does not match the datatype, ACCEPT gives an error message
ACCEPT^17^         and prompts again.
ACCEPT^18^
ACCEPT^19^     CHAR
ACCEPT^20^         makes the datatype of variable the datatype CHAR.  The maximum CHAR
ACCEPT^21^         length limit is 240 bytes.  If a multi-byte character set is used,
ACCEPT^22^         one CHAR may be more than one byte in size.
ACCEPT^23^
ACCEPT^24^     DATE
ACCEPT^25^         Expects the reply to be a valid DATE format.  If the reply is not
ACCEPT^26^         a valid DATE format, ACCEPT gives an error message and prompts
ACCEPT^27^         again.  The datatype is CHAR.
ACCEPT^28^
ACCEPT^29^     FOR[MAT]
ACCEPT^30^         specifies the input format for the reply.  If the reply does not
ACCEPT^31^         match the specified format, ACCEPT gives an error message and
ACCEPT^32^         prompts again for a reply.  The format element must be a text
ACCEPT^33^         constant such as A10 or 9.999.
ACCEPT^34^
ACCEPT^35^         Oracle date formats such as 'dd/mm/yy' are valid when the
ACCEPT^36^         datatype is DATE.  DATE without a specified format defaults to
ACCEPT^37^         the Oracle NLS_DATE_FORMAT of the current session.
ACCEPT^38^
ACCEPT^39^     DEF[AULT]
ACCEPT^40^         sets the default value if a reply is not given.  The reply must
ACCEPT^41^         be in the specified format if defined.
ACCEPT^42^
ACCEPT^43^     PROMPT text
ACCEPT^44^         displays text on-screen before accepting the value of variable
ACCEPT^45^         from the user.
ACCEPT^46^
ACCEPT^47^     NOPR[OMPT]
ACCEPT^48^         skips a line and waits for input; prompt not displayed.
ACCEPT^49^
ACCEPT^50^     HIDE
ACCEPT^51^         suppresses the display as you type the reply.
ACCEPT^52^
ACCEPT^53^ To define or reference variables, use the DEFINE command.
ACCEPT^54^
ACCEPT^55^
ACCEPT^56^ Examples: To display the prompt, "Password:  ", place the reply in a
ACCEPT^57^           CHAR variable named PSWD, and suppress the display, enter:
ACCEPT^58^
ACCEPT^59^               SQL> ACCEPT pswd CHAR PROMPT 'Password:  ' HIDE
ACCEPT^60^
ACCEPT^61^           To display the prompt, "Enter weekly salary:  ", place the
ACCEPT^62^           reply in a NUMBER variable named SALARY with a default of
ACCEPT^63^           000.0, enter:
ACCEPT^64^
ACCEPT^65^               SQL> ACCEPT salary NUMBER FORMAT '999.99' DEFAULT '000.0' -
ACCEPT^66^               >       PROMPT 'Enter weekly salary:  '
ACCEPT^67^
ACCEPT^68^           To display the prompt, "Enter date hired:  ", place the reply
ACCEPT^69^           in a DATE variable named HIRED with the format "dd/mm/yy" and
ACCEPT^70^           a default of "01/01/94", enter:
ACCEPT^71^
ACCEPT^72^               SQL> ACCEPT hired DATE FORMAT 'dd/mm/yy' DEFAULT '01/01/94'-
ACCEPT^73^               >       PROMPT 'Enter date hired:  '
ACCEPT^74^
ACCEPT^75^           To display the prompt, "Enter employee lastname:  ", and place
ACCEPT^76^           the reply in a CHAR variable named LASTNAME, enter:
ACCEPT^77^
ACCEPT^78^               SQL> ACCEPT lastname CHAR FORMAT 'A20' -
ACCEPT^79^               >       PROMPT 'Enter employee lastname:  '
ACCEPT^80^
ACCEPT^81^
ACCEPT^82^ See also: define, input, prompt, parameters, commands.
ACCEPT^83^
APPEND^1^
APPEND^2^
APPEND^3^                                     APPEND
APPEND^4^
APPEND^5^ A[PPEND] text
APPEND^6^
APPEND^7^ Use APPEND to add text to the end of the current line in the SQL buffer.
APPEND^8^
APPEND^9^     text
APPEND^10^         is the text you wish to append.  To separate text from preceding
APPEND^11^         characters with a space, enter two spaces between APPEND and the
APPEND^12^         text. To APPEND text that ends with a semicolon, end the APPEND
APPEND^13^         command with two semicolons (SQL*Plus interprets one semicolon as
APPEND^14^         an optional command terminator).
APPEND^15^
APPEND^16^
APPEND^17^ Examples: To append a space and the column name DEPT to the second line
APPEND^18^           of the buffer, make that line the current line by entering:
APPEND^19^
APPEND^20^               SQL> 2
APPEND^21^                 2* FROM EMP
APPEND^22^
APPEND^23^           Now enter APPEND:
APPEND^24^
APPEND^25^               SQL> APPEND , DEPT
APPEND^26^               SQL> 2
APPEND^27^                 2* FROM EMP, DEPT
APPEND^28^
APPEND^29^           The first space between APPEND and the comma separates APPEND
APPEND^30^           from the characters to be appended; the second space is the
APPEND^31^           first appended character.  To append a semicolon to the line,
APPEND^32^           enter:
APPEND^33^
APPEND^34^               SQL> APPEND ;;
APPEND^35^
APPEND^36^           SQL*Plus appends the first semicolon to the line.  The second
APPEND^37^           semicolon terminates the command.
APPEND^38^
APPEND^39^
APPEND^40^ See also: buffer, change, del, edit, input, list, save, spool,
APPEND^41^           commands.
APPEND^42^
@^1^
@^2^
@^3^                               @ ("at" sign)
@^4^
@^5^ @ file_name[.ext] [arg...]
@^6^
@^7^ Runs the specified command file.
@^8^
@^9^     file_name[.ext ]
@^10^         is the command file you wish to run. If you omit ext, SQL*Plus
@^11^         assumes the default command-file extension (usually SQL).  To
@^12^         change the default extension, use the SUFFIX clause of the SET
@^13^         command.  Use @file_name or @ file_name; the space is optional.
@^14^         Case may be significant in some operating environments.
@^15^
@^16^     arg...
@^17^         represent data items you wish to pass to parameters in the
@^18^         command file.  If you enter one or more arguments, SQL*Plus
@^19^         substitutes the values into the parameters (&1, &2, and so
@^20^         forth) in the command file.  The first argument replaces
@^21^         each occurrence of &1, the second replaces each occurrence
@^22^         of &2, and so forth.
@^23^
@^24^         The @ command DEFINEs the parameters with the values of the
@^25^         arguments; if you run the command file again in this session,
@^26^         you can enter new arguments or omit the arguments to use the
@^27^         current values.
@^28^
@^29^ You can include in a command file any typeable command--usually SQL or
@^30^ SQL*Plus commands or PL/SQL blocks.  EXIT or QUIT used in a command files
@^31^ terminates SQL*Plus.  The @ command functions similarly to START.
@^32^
@^33^ SQL*Plus removes the SQLTERMINATOR (a semicolon by default) before the
@^34^ @ command is issued.  A workaround for this is to add another
@^35^ SQLTERMINATOR.  See SET SQLTERMINATOR for more information on the
@^36^ SQLTERMINATOR.
@^37^
@^38^
@^39^ Examples:
@^40^
@^41^     To run a command file named PRINTRPT.SQL, enter:
@^42^
@^43^         SQL> @PRINTRPT
@^44^
@^45^
@^46^     To run the command file WKRPT with the extension QRY, enter:
@^47^
@^48^         SQL> @WKRPT.QRY
@^49^
@^50^
@^51^ See also: @@, set (suffix), start, /, edit, run, get, buffer, spool,
@^52^           list, save, parameters, commands.
@^53^
@@^1^
@@^2^
@@^3^                               @@ (double "at" sign)
@@^4^
@@^5^ @@ file_name[.ext]
@@^6^
@@^7^ Runs a nested command file.  This command is identical to the @
@@^8^ command except that it looks for the specified command file in the
@@^9^ same path as the command file from which it was called.
@@^10^
@@^11^     file_name[.ext ]
@@^12^         is the command file you wish to run. If you omit ext, SQL*Plus
@@^13^         assumes the default command-file extension (usually SQL).  To
@@^14^         change the default extension, use the SUFFIX clause of the SET
@@^15^         command.  Use @@file_name or @@ file_name; the space is optional.
@@^16^         Case may be significant in some operating environments.
@@^17^
@@^18^ You can include in a command file any typeable command--usually SQL or
@@^19^ SQL*Plus commands.  EXIT or QUIT used in a command file terminates
@@^20^ SQL*Plus.  The @@ command functions similarly to START.
@@^21^
@@^22^ SQL*Plus removes the SQLTERMINATOR (a semicolon by default) before the
@@^23^ @@ command is issued.  A workaround for this is to add another
@@^24^ SQLTERMINATOR.  See SET SQLTERMINATOR for more information on the
@@^25^ SQLTERMINATOR.
@@^26^
@@^27^ Example:
@@^28^
@@^29^     Suppose that you have the following command file named PRINTRPT:
@@^30^       SELECT * FROM EMP
@@^31^       @EMPRPT
@@^32^       @@WKRPT
@@^33^
@@^34^     When you START PRINTRPT and it reaches the @ command, it looks for
@@^35^     the command file named EMPRPT in the current working directory
@@^36^     and runs it.  When PRINTRPT reaches the @@ command, it looks for
@@^37^     the command file named WKRPT in the same path as PRINTRPT and
@@^38^     runs it.
@@^39^
@@^40^See also: @, set (suffix), start, /, edit, run, get, buffer, spool,
@@^41^           list, save, parameters, commands.
@@^42^
BREAK^1^
BREAK^2^
BREAK^3^                                  BREAK
BREAK^4^
BREAK^5^ BRE[AK] [ON report_element [action [action]]] ...
BREAK^6^
BREAK^7^ where report_element and action require the following syntax:
BREAK^8^         report_element: {column | expression | ROW | REPORT}
BREAK^9^         action: [SKI[P] n|[SKI[P]] PAGE] [NODUP[LICATES] | DUP[LICATES]]
BREAK^10^
BREAK^11^ BREAK specifies where and how to make format changes to a report.  You use
BREAK^12^ BREAK to:
BREAK^13^
BREAK^14^     -   suppress the display of duplicate values for a given column
BREAK^15^     -   skip a line each time a given column value changes
BREAK^16^     -   COMPUTE figures when a given column value changes, or at the end
BREAK^17^             of a report (see COMPUTE)
BREAK^18^     -   list the current BREAK definition (by issuing the BREAK command
BREAK^19^             without any clauses following)
BREAK^20^
BREAK^21^ BREAK also lists the current BREAK definition.  Each new BREAK command
BREAK^22^ replaces the preceding one.  Use CLEAR BREAKS to remove the BREAK command.
BREAK^23^
BREAK^24^ BREAK report_elements:
BREAK^25^
BREAK^26^     ON column [action [action]]
BREAK^27^         specifies action(s) for SQL*Plus to take when a break occurs in
BREAK^28^         the break column.  The column cannot have a table or view
BREAK^29^         appended to it.  To achieve this, use an alias in the
BREAK^30^         SQL statement.  A break is:
BREAK^31^
BREAK^32^         -   a change in the value of a column or expression
BREAK^33^         -   the output of a row
BREAK^34^         -   the end of a report
BREAK^35^
BREAK^36^         If you omit action(s), BREAK ON column suppresses printing of
BREAK^37^         duplicate values in the column, marking in the report where
BREAK^38^         SQL*Plus will perform the computation you specify in a matching
BREAK^39^         COMPUTE command.  You can specify ON column one or more times.
BREAK^40^
BREAK^41^         Example:  If you specify multiple ON clauses, as in:
BREAK^42^
BREAK^43^                   SQL> BREAK ON DEPTNO SKIP PAGE ON JOB SKIP 1 -
BREAK^44^                      > ON SAL SKIP 1
BREAK^45^
BREAK^46^             the first ON clause is the outermost break (ON DEPTNO), and
BREAK^47^             the last ON clause is the innermost break (ON SAL).  SQL*Plus
BREAK^48^             searches each output row for the break(s), starting with the
BREAK^49^             outermost break and proceeding to the innermost in the order
BREAK^50^             you've entered the clauses.  In the example above, SQL*Plus
BREAK^51^             searches for a change in the value of DEPTNO, then JOB, then
BREAK^52^             SAL.
BREAK^53^
BREAK^54^             Next, SQL*Plus executes the actions, beginning with the action
BREAK^55^             for the innermost break and proceeding in reverse order toward
BREAK^56^             the outermost break (from SKIP 1 for ON SAL toward SKIP PAGE
BREAK^57^             for ON DEPTNO). SQL*Plus executes each action, including the
BREAK^58^             action for the first occurring break found in the initial
BREAK^59^             search.
BREAK^60^
BREAK^61^             If, for example, the value of JOB in a given row changes, but
BREAK^62^             the values of DEPTNO and SAL stay the same, SQL*Plus skips two
BREAK^63^             lines before printing the row: one as a result of SKIP 1 in
BREAK^64^             the ON SAL clause, the other as a result of SKIP 1 in the
BREAK^65^             ON JOB clause.
BREAK^66^
BREAK^67^             When you use ON column, you should also use the ORDER BY clause
BREAK^68^
BREAK^69^             in the SELECT statement.  The columns usually should appear in
BREAK^70^             the same order in ORDER BY as they do in BREAK, so that breaks
BREAK^71^             do not occur at meaningless points in the report.  All the
BREAK^72^             columns listed in ORDER BY need not appear in the BREAK command.
BREAK^73^
BREAK^74^
BREAK^75^             The following SELECT produces meaningful results with the above
BREAK^76^
BREAK^77^             BREAK:
BREAK^78^
BREAK^79^                   SQL> SELECT DEPTNO, JOB, SAL,ENAME
BREAK^80^                     2  FROM EMP
BREAK^81^                     3  ORDER BY DEPTNO, JOB, SAL, ENAME;
BREAK^82^
BREAK^83^
BREAK^84^             All rows with the same DEPTNO print together on one page, and
BREAK^85^             within that page all rows with the same JOB print in groups.
BREAK^86^             Within each group of jobs, those with the same SAL print in
BREAK^87^             groups.  Breaks in ENAME cause no action, because ENAME does
BREAK^88^             not appear in the BREAK command.
BREAK^89^
BREAK^90^     ON expr [action [action]]
BREAK^91^         specifies action(s) for SQL*Plus to take when the value of the
BREAK^92^         expression changes.  If action(s) are omitted, BREAK ON expr
BREAK^93^         suppresses printing of duplicate values of expr, marking in the
BREAK^94^         report the place where SQL*Plus will perform the computation you
BREAK^95^         specify in a matching COMPUTE command.
BREAK^96^
BREAK^97^         You can use an expression involving one or more table columns, or
BREAK^98^         an alias assigned to a report column in a SELECT statement or a
BREAK^99^         COLUMN command.  If you use an expression in a BREAK command, you
BREAK^100^         must enter expr exactly as it appears in SELECT; if the expression
BREAK^101^         in the SELECT statement is a+b, for example, you cannot use b+a or
BREAK^102^         (a+b) in a BREAK command to refer to the expression in the SELECT
BREAK^103^         statement.  The information for ON column also applies to ON expr.
BREAK^104^
BREAK^105^     ON ROW [action [action]]
BREAK^106^         specifies action(s) for SQL*Plus to take when a SELECT statement
BREAK^107^         returns a row. The ROW break becomes the innermost break no matter
BREAK^108^         where it appears in the BREAK command.  You should always specify
BREAK^109^         an action when you BREAK on a row.
BREAK^110^
BREAK^111^     ON REPORT [action]
BREAK^112^         marks in a report the place where SQL*Plus will perform the
BREAK^113^         computation specified in a matching COMPUTE command.  Use BREAK
BREAK^114^         ON REPORT with COMPUTE to print grand totals or other "grand"
BREAK^115^         computed values.  The REPORT break becomes the outermost break
BREAK^116^         regardless of where you specify it in the BREAK command.  Note
BREAK^117^         that SQL*Plus will not skip a page at the end of a report, so you
BREAK^118^         cannot use BREAK ON REPORT SKIP PAGE.
BREAK^119^
BREAK^120^ BREAK actions:
BREAK^121^
BREAK^122^     SKI[P] n
BREAK^123^         skips n lines before printing the row where the break occurred.
BREAK^124^
BREAK^125^     [SKI[P]] PAGE
BREAK^126^         skips to a new page before printing the row where break occurred.
BREAK^127^
BREAK^128^     NODUP[LICATES]
BREAK^129^         prints blanks rather than the value of a break column when the
BREAK^130^         value is a duplicate of the column's value in the preceding row.
BREAK^131^
BREAK^132^     DUP[LICATES]
BREAK^133^         prints the value of a break column in every selected row.
BREAK^134^
BREAK^135^             Example:  The example report below, produces prints duplicate
BREAK^136^             job values, prints the average of SAL, inserts one blank line
BREAK^137^             when the JOB value changes, and (when the value of DEPTNO
BREAK^138^             changes) prints the sum of SAL and inserts another blank line:
BREAK^139^
BREAK^140^                   SQL> BREAK ON DEPTNO SKIP 1 ON JOB SKIP 1 DUPLICATES
BREAK^141^                   SQL> COMPUTE SUM OF SAL ON DEPTNO
BREAK^142^                   SQL> COMPUTE AVG OF SAL ON JOB
BREAK^143^                   SQL> SELECT DEPTNO, JOB, ENAME, SAL FROM EMP
BREAK^144^                     2  WHERE JOB IN ('CLERK', 'SALESMAN')
BREAK^145^                     3  AND DEPTNO IN (10, 30)
BREAK^146^                     4  ORDER BY DEPTNO, JOB;
BREAK^147^
BREAK^148^             Output:
BREAK^149^
BREAK^150^                  DEPTNO  JOB       ENAME       SAL
BREAK^151^                  ------ --------- --------- ------
BREAK^152^                      10  CLERK     MILLER     1300
BREAK^153^                          ********           ------
BREAK^154^                          avg                  1300
BREAK^155^
BREAK^156^                  ******                     ------
BREAK^157^                  sum                          1300
BREAK^158^
BREAK^159^                      30  CLERK     JAMES      1045
BREAK^160^                          ********           ------
BREAK^161^                          avg                  1045
BREAK^162^
BREAK^163^                          SALESMAN  ALLEN      1760
BREAK^164^                          SALESMAN  MARTIN     1375
BREAK^165^                          SALESMAN  TURNER     1650
BREAK^166^                          SALESMAN  WARD       1375
BREAK^167^                          ********           ------
BREAK^168^                          avg                  1540
BREAK^169^
BREAK^170^                  ******                     ------
BREAK^171^                   sum                         7205
BREAK^172^
BREAK^173^ See also: compute, order by, select, SQL in PL/SQL, commands.
BREAK^174^
BTITLE^1^
BTITLE^2^
BTITLE^3^                                   BTITLE
BTITLE^4^
BTITLE^5^ BTI[TLE] [printspec [text | variable] ...] | [OFF|ON]
BTITLE^6^
BTITLE^7^ BTITLE places and formats a title at the bottom of each report page, or
BTITLE^8^ lists the current BTITLE definition.  See TTITLE for a description of
BTITLE^9^ BTITLE clauses, and to learn how to print page numbers in the title. To
BTITLE^10^ list the current BTITLE definition, enter BTITLE with no clauses.
BTITLE^11^
BTITLE^12^ If you do not enter a printspec clause before the first occurrence of
BTITLE^13^ text, BTITLE left justifies the text.  SQL*Plus interprets BTITLE in
BTITLE^14^ the "new" form if a valid printspec clause (LEFT, SKIP, COL, etc)
BTITLE^15^ immediately follows BTITLE.  See OLD COMMANDS for a description of
BTITLE^16^ an alternative form of BTITLE.
BTITLE^17^
BTITLE^18^ Examples: To set a bottom title with CORPORATE PLANNING DEPARTMENT on the
BTITLE^19^           left and a date on the right, enter:
BTITLE^20^
BTITLE^21^               SQL> BTITLE LEFT 'CORPORATE PLANNING DEPARTMENT' -
BTITLE^22^               > RIGHT '11 Jan 1990'
BTITLE^23^
BTITLE^24^           To set a bottom title with CONFIDENTIAL in column 50, followed
BTITLE^25^           by six spaces and a date, enter:
BTITLE^26^
BTITLE^27^               SQL> BTITLE COL 50 'CONFIDENTIAL' TAB 6 '11 Jan 90'
BTITLE^28^
BTITLE^29^ See also: old commands, ttitle, commands.
BTITLE^30^
BUFFER^1^
BUFFER^2^
BUFFER^3^                                  Buffer
BUFFER^4^
BUFFER^5^ SQL Commands
BUFFER^6^     SQL commands you enter are stored in the SQL buffer.  You can continue
BUFFER^7^     a SQL command on one or more additional lines, ending and executing
BUFFER^8^     the command with a semicolon (;), a blank line, or a slash (/) on a
BUFFER^9^     line by itself.  SQL*Plus displays line numbers (matching the lines in
BUFFER^10^     the SQL buffer) for these additional lines.  Use SAVE to store the
BUFFER^11^     buffer's contents in a file.  Use RUN or slash (/) at the command
BUFFER^12^     prompt to execute commands in the SQL buffer.
BUFFER^13^
BUFFER^14^ PL/SQL Blocks
BUFFER^15^     SQL*Plus also stores PL/SQL programs (blocks) in the SQL buffer.
BUFFER^16^     To end a PL/SQL block, enter a . (period) by itself on a new line.
BUFFER^17^     Execute a block in the buffer with RUN or slash (/).  You can use
BUFFER^18^     REMARK and /*comments*/ with PL/SQL blocks as with SQL commands.
BUFFER^19^     In PL/SQL, you can also use "--" (two dashes) to begin a comment
BUFFER^20^     that ends with the next RETURN character.
BUFFER^21^
BUFFER^22^ SQL*Plus Commands
BUFFER^23^     Continue a long SQL*Plus command on additional lines by using a -
BUFFER^24^     (hyphen) at the end of each line; SQL*Plus prompts with a > for the
BUFFER^25^     next line.  A line not ended by a hyphen executes the command.
BUFFER^26^
BUFFER^27^
BUFFER^28^     Example: If you enter the COLUMN command:
BUFFER^29^
BUFFER^30^               SQL> COLUMN ENAME HEADING EMPLOYEES -
BUFFER^31^                  > FORMAT A10
BUFFER^32^               SQL>
BUFFER^33^
BUFFER^34^     You can end a SQL*Plus command with ; (semicolon).  It's not required.
BUFFER^35^     SQL*Plus commands are not stored in the SQL buffer. Use EDIT to create
BUFFER^36^     command files containing SQL*Plus commands. START runs a command file.
BUFFER^37^     Use REMARK to enter comments within SQL*Plus commands.  You can also
BUFFER^38^     use /*comment delimiters*/ on a separate line before or after a
BUFFER^39^     SQL*Plus command, but not on the same line.
BUFFER^40^
BUFFER^41^
BUFFER^42^ See also: substitution, commands.
BUFFER^43^
CHANGE^1^
CHANGE^2^
CHANGE^3^                                   CHANGE
CHANGE^4^
CHANGE^5^ C[HANGE] sepchar old [sepchar [new[sepchar]]]
CHANGE^6^
CHANGE^7^ Use CHANGE to replace the first occurrence of the specified text on the
CHANGE^8^ current line of the buffer with the new specified text.
CHANGE^9^
CHANGE^10^     sepchar
CHANGE^11^         is any non-alphanumeric character such as "/" or "!".  You can
CHANGE^12^         use any sepchar that does not appear in "old" or "new".  The
CHANGE^13^         space between CHANGE and the first sepchar is optional.
CHANGE^14^
CHANGE^15^     old
CHANGE^16^         is the text you wish to change.  CHANGE ignores case in searching
CHANGE^17^         for old.  For example,  CHANGE /aq/aw  finds the first occurrence
CHANGE^18^         of "aq", "AQ", "aQ", or "Aq", and change it to "aw".  SQL*Plus
CHANGE^19^         inserts the new text exactly as you specify it.
CHANGE^20^
CHANGE^21^         If old is prefixed with "...", it matches everything up to and
CHANGE^22^         including the first occurrence of old.  If it is suffixed with
CHANGE^23^         "...", it matches the first occurrence of old and everything that
CHANGE^24^         follows on that line.  If it contains an embedded "...", it
CHANGE^25^         matches everything from the preceding part of old through the
CHANGE^26^         following part of old.
CHANGE^27^
CHANGE^28^     new
CHANGE^29^         is the text with which you wish to replace old.  If you omit new
CHANGE^30^         and, optionally, the second and third sepchars, CHANGE deletes old
CHANGE^31^         from the current line of the buffer.
CHANGE^32^
CHANGE^33^ CHANGE changes the first occurrence of the text you specify on the current
CHANGE^34^ line in the buffer.  The current line is marked with an asterisk (*) in
CHANGE^35^ the LIST output.  You can also use CHANGE to modify a line in the buffer
CHANGE^36^ that has caused an Oracle error; SQL*Plus makes the erroneous line, the
CHANGE^37^ current line.  To re-enter an entire line, type its number, then the new
CHANGE^38^ contents of the line. Entering a line number larger than the number of
CHANGE^39^ lines in the buffer causes SQL*Plus to add the text in a new line at the
CHANGE^40^ end of the buffer. Entering 0 for the line number causes SQL*Plus insert
CHANGE^41^ that line before the other lines (it becomes line 1).
CHANGE^42^
CHANGE^43^ Examples: The current line of the buffer contains the following text:
CHANGE^44^
CHANGE^45^               4* WHERE JOB IS IN ('CLERK','ANALYST')
CHANGE^46^
CHANGE^47^     Entering this...                  Changes the buffer text to this.
CHANGE^48^     ----------------------------------------------------------------------
CHANGE^49^     SQL> C /ANALYST/GUARD/            4* WHERE JOB IS IN ('CLERK','GUARD')
CHANGE^50^
CHANGE^51^     SQL> C /'CLERK',.../'CLERK')/     4* WHERE JOB IS IN ('CLERK')
CHANGE^52^
CHANGE^53^     SQL> C /(...)/('COOK','BUTLER')/  4* WHERE JOB IS IN ('COOK','BUTLER')
CHANGE^54^
CHANGE^55^
CHANGE^56^         Use the line number to replace an entire line.  If you enter:
CHANGE^57^
CHANGE^58^               SQL> 2 FROM EMP e1
CHANGE^59^
CHANGE^60^         the second line of the buffer is replaced with:
CHANGE^61^
CHANGE^62^               FROM EMP e1
CHANGE^63^
CHANGE^64^
CHANGE^65^         NOTE: Entering a line number and a string always replaces the line
CHANGE^66^         with the string, no matter what the text of the string:
CHANGE^67^
CHANGE^68^               SQL> 2  c/old/new/
CHANGE^69^
CHANGE^70^         changes the second line of the buffer to:
CHANGE^71^
CHANGE^72^               2* c/old/new/
CHANGE^73^
CHANGE^74^
CHANGE^75^ See also: append, del, edit, input, list, save, buffer, spool,
CHANGE^76^           commands.
CHANGE^77^
CLEAR^1^
CLEAR^2^
CLEAR^3^                                    CLEAR
CLEAR^4^
CLEAR^5^ CL[EAR] option ...
CLEAR^6^
CLEAR^7^ CLEAR resets or erases the current value or setting for the option, where
CLEAR^8^ option is one of the following clauses:
CLEAR^9^
CLEAR^10^     BRE[AKS]
CLEAR^11^         clears breaks set by the BREAK command.
CLEAR^12^
CLEAR^13^     BUFF[ER]
CLEAR^14^         clears text from the buffer.  CLEAR BUFFER works like CLEAR SQL,
CLEAR^15^         unless you are using multiple buffers.
CLEAR^16^
CLEAR^17^     COL[UMNS]
CLEAR^18^         clears options set by the COLUMN command for all columns. To clear
CLEAR^19^         settings for a single column, use the CLEAR clause of the COLUMN
CLEAR^20^         command.
CLEAR^21^
CLEAR^22^     COMP[UTES]
CLEAR^23^         clears options set by the COMPUTE command.
CLEAR^24^
CLEAR^25^     SCR[EEN]
CLEAR^26^         clears your screen.
CLEAR^27^
CLEAR^28^     SQL
CLEAR^29^         clears text from the SQL buffer.  CLEAR SQL works the same as
CLEAR^30^         CLEAR BUFFER, unless you are using multiple buffers.
CLEAR^31^
CLEAR^32^     TIMI[NG]
CLEAR^33^         deletes all timing areas created by the TIMING command.
CLEAR^34^
CLEAR^35^
CLEAR^36^ Examples: To clear breaks, enter:
CLEAR^37^
CLEAR^38^               SQL> CLEAR BRE
CLEAR^39^
CLEAR^40^
CLEAR^41^           To clear column elements, enter:
CLEAR^42^
CLEAR^43^               SQL> CLEAR COL
CLEAR^44^
CLEAR^45^
CLEAR^46^ See also: break, buffer, column, compute, set (timing),
CLEAR^47^           commands.
CLEAR^48^
COLUMN^1^
COLUMN^2^
COLUMN^3^                                   COLUMN
COLUMN^4^
COLUMN^5^ COL[UMN] [{column | expr} [option...] ]
COLUMN^6^
COLUMN^7^ where option is one of the following:
COLUMN^8^
COLUMN^9^     ALI[AS] alias
COLUMN^10^     CLE[AR] | DEF[AULT]
COLUMN^11^     FOLD_A[FTER] n
COLUMN^12^     FOLD_B[EFORE] n
COLUMN^13^     FOR[MAT] format
COLUMN^14^     HEA[DING] text
COLUMN^15^     JUS[TIFY] {L[EFT] | C[ENTER] | C[ENTRE] | R[IGHT]}
COLUMN^16^     LIKE {expr | alias}
COLUMN^17^     NEWL[INE]
COLUMN^18^     NEW_V[ALUE] variable
COLUMN^19^     NOPRI[NT] | PRI[NT]
COLUMN^20^     NUL[L] text
COLUMN^21^     OLD_V[ALUE] variable
COLUMN^22^     ON|OFF
COLUMN^23^     WRA[PPED] | WOR[D_WRAPPED] | TRU[NCATED]
COLUMN^24^
COLUMN^25^ COLUMN sets display attributes for a given column, such as:
COLUMN^26^
COLUMN^27^     -   text for the column heading
COLUMN^28^     -   alignment of the column heading
COLUMN^29^     -   format for NUMBER data
COLUMN^30^     -   wrapping of column data
COLUMN^31^
COLUMN^32^ Enter COLUMN with column or expr to list the current display attributes
COLUMN^33^ for only the column or expression specified.  Enter COLUMN with no clauses
COLUMN^34^ to list all current column display attributes.
COLUMN^35^
COLUMN^36^     {column | expr}
COLUMN^37^         identifies the data item (typically, the column name) in a SELECT
COLUMN^38^         statement to which the column command refers.  You must enter an
COLUMN^39^         expression exactly as it appears in the SQL SELECT statement if
COLUMN^40^         you use it in a COLUMN command.  For example, if the expression
COLUMN^41^         in the SELECT statement is a+b, you cannot use b+a or (a+b) in a
COLUMN^42^         COLUMN command to refer to the expression in the SELECT statement.
COLUMN^43^
COLUMN^44^         If you select columns with the same name from different tables, a
COLUMN^45^         COLUMN command for that column name will apply to both columns.
COLUMN^46^         That is, a COLUMN command for the column ENAME applies to all
COLUMN^47^         columns named ENAME that you reference in this session.  COLUMN
COLUMN^48^         ignores table name prefixes in SELECT statements.
COLUMN^49^
COLUMN^50^         To format the columns differently, assign a unique alias to each
COLUMN^51^         column within the SELECT statement itself (do not use the ALIAS
COLUMN^52^         clause of the COLUMN command) and enter a COLUMN command for each
COLUMN^53^         column's alias.
COLUMN^54^
COLUMN^55^     ALI[AS] alias
COLUMN^56^         assigns a specified alias to a column, which can be used to refer
COLUMN^57^         to the column in BREAK, COMPUTE, and other COLUMN commands.
COLUMN^58^
COLUMN^59^     CLE[AR] | DEF[AULT]
COLUMN^60^         resets the display attributes for the column to default values.
COLUMN^61^         To reset the attributes for all columns, use the CLEAR COLUMNS
COLUMN^62^         command.
COLUMN^63^
COLUMN^64^     FOLD_A[FTER] n
COLUMN^65^         inserts a carriage return after the column heading and after each
COLUMN^66^         row in the column.  You must enter n; the particular value you
COLUMN^67^         choose for n has no effect on the format.  SQL*Plus does not
COLUMN^68^         insert an extra carriage return after the last column in the
COLUMN^69^         SELECT list.
COLUMN^70^
COLUMN^71^     FOLD_B[EFORE] n
COLUMN^72^         inserts a carriage return before the column heading and before
COLUMN^73^         each row of the column.  You must enter n; the particular value
COLUMN^74^         you choose for n has no effect on the format.  FOLD_BEFORE n has
COLUMN^75^         the same effect as NEWLINE.  SQL*Plus does not insert an extra
COLUMN^76^         carriage return before the first column in the SELECT list.
COLUMN^77^
COLUMN^78^     FOR[MAT] format
COLUMN^79^         sets the display format of the column.  The format specification
COLUMN^80^         must be a text constant such as $9,999 or A10, not a variable.
COLUMN^81^
COLUMN^82^         A CHAR or VARCHAR2 (VARCHAR) column's width defaults to the
COLUMN^83^         column's width in the database.  A LONG column's
COLUMN^84^         width defaults to the value of SET LONGCHUNKSIZE or
COLUMN^85^         SET LONG, whichever is smaller.  A Trusted
COLUMN^86^         Oracle column of datatype MLSLABEL or RAW MLSLABEL defaults
COLUMN^87^         to the column's width as defined in the database or to the
COLUMN^88^         length of the column's heading, whichever is longer.
COLUMN^89^         Note: A Trusted Oracle column with a name of ROWLABEL defaults
COLUMN^90^         to a width of 15.  To change the width of a CHAR,
COLUMN^91^         VARCHAR2 (VARCHAR), LONG, or Trusted Oracle column
COLUMN^92^         to n, use FORMAT An.  If you specify a width shorter
COLUMN^93^         than the column heading, SQL*Plus truncates the heading.
COLUMN^94^
COLUMN^95^         SQL*Plus formats CHAR, VARCHAR2 (VARCHAR), or Trusted Oracle
COLUMN^96^         data left-justified.  If a value does not fit within the
COLUMN^97^         column width, SQL*Plus wraps or truncates the character
COLUMN^98^         string depending on the setting of SET WRAP.
COLUMN^99^
COLUMN^100^         In Oracle7, the default width and format of unformatted DATE
COLUMN^101^         columns in SQL*Plus is derived from the NLS parameters in
COLUMN^102^         effect.  Otherwise, the default width is A9.  In Oracle7, the
COLUMN^103^         NLS parameters may be set in your database parameter file and
COLUMN^104^         may be environment variables or an equivalent platform-
COLUMN^105^         specific mechanism.  They may also be specified for each
COLUMN^106^         session with the ALTER SESSION command.  (See the
COLUMN^107^         documentation for the Oracle7 Server for a complete
COLUMN^108^         description of the NLS parameters).
COLUMN^109^
COLUMN^110^         You can change the format of any DATE column using the SQL
COLUMN^111^         function TO_CHAR in your SQL SELECT statement.  You can also
COLUMN^112^         use an explicit COLUMN FORMAT command to adjust the column
COLUMN^113^         width.
COLUMN^114^
COLUMN^115^         When you use SQL functions like TO_CHAR, Oracle automatically
COLUMN^116^         allows for a very wide column.
COLUMN^117^
COLUMN^118^         To change the width of a DATE column to n, use the COLUMN
COLUMN^119^         command with FORMAT An.  If you specify a width shorter than
COLUMN^120^         the column heading, the heading is truncated.
COLUMN^121^
COLUMN^122^         An example:
COLUMN^123^
COLUMN^124^         To change the default format of DATE columns to 'YYYY-MM-DD':
COLUMN^125^
COLUMN^126^             SQL> alter session set NLS_DATE_FORMAT = 'YYYY-MM-DD';
COLUMN^127^
COLUMN^128^             Session altered.
COLUMN^129^
COLUMN^130^             SQL> select hiredate
COLUMN^131^               2  from emp
COLUMN^132^               3  where empno = 7839;
COLUMN^133^
COLUMN^134^             HIREDATE
COLUMN^135^             ----------
COLUMN^136^             1981-11-17
COLUMN^137^
COLUMN^138^         See ALTER SESSION for more information on the ALTER SESSION
COLUMN^139^         command.
COLUMN^140^
COLUMN^141^         NOTE: In a SELECT statement some SQL calculations such as
COLUMN^142^         TO_CHAR may cause a column to be very wide.  In such a case,
COLUMN^143^         use the FORMAT option to alter the column width.
COLUMN^144^
COLUMN^145^         A NUMBER column's width equals the width of the heading, or
COLUMN^146^         the width of the FORMAT plus one space for the sign,
COLUMN^147^         whichever is greater.  If you do not explicitly use FORMAT, then
COLUMN^148^         the column's width will always be at least the value of SET
COLUMN^149^         NUMWIDTH.  To change the width, use FORMAT followed by a number
COLUMN^150^         format element.  See the COLUMN command in the SQL*Plus
COLUMN^151^         User's Guide and Reference for more information on number formats.
COLUMN^152^
COLUMN^153^         SQL*Plus formats NUMBER data right-justified.  SQL*Plus never
COLUMN^154^         truncates a NUMBER column heading.  If a value does not fit
COLUMN^155^         within the column width, SQL*Plus displays a pound sign (#) in
COLUMN^156^         place of each digit the width allows to indicate overflow.
COLUMN^157^
COLUMN^158^         With all number formats, SQL*Plus rounds a number to the specified
COLUMN^159^         number of significant digits.  When no format is given, a number's
COLUMN^160^         width defaults to the value of NUMWIDTH.  See the SET command.
COLUMN^161^
COLUMN^162^     HEA[DING] text
COLUMN^163^         defines a column heading.  If text contains blanks or punctuation
COLUMN^164^         characters, you must enclose it with single or double quotes.  If
COLUMN^165^         you omit a HEADING clause, the column's heading defaults to column
COLUMN^166^         or expr.  Each occurrence of the HEADSEP character (default = '|')
COLUMN^167^         begins a new line.  For example,
COLUMN^168^
COLUMN^169^               COLUMN ENAME HEADING 'Employee |Name'
COLUMN^170^
COLUMN^171^         produces a two-line column heading.  See the SET command's HEADSEP
COLUMN^172^         variable for information on changing the HEADSEP character.
COLUMN^173^
COLUMN^174^     JUS[TIFY] {L[EFT]|C[ENTER]|C[ENTRE]|R[IGHT]}
COLUMN^175^         aligns the heading.  If you do not use a JUSTIFY clause, headings
COLUMN^176^         for NUMBER columns default to RIGHT and headings for other column
COLUMN^177^         types default to LEFT.
COLUMN^178^
COLUMN^179^     LIKE {expr|alias}
COLUMN^180^         copies the display attributes of another column or expression
COLUMN^181^         (whose attributes you've defined with another COLUMN command).
COLUMN^182^         LIKE copies only attributes not defined by another clause in the
COLUMN^183^         current COLUMN command.
COLUMN^184^
COLUMN^185^     NEWL[INE]
COLUMN^186^         starts a new line before displaying the column's value. NEWLINE
COLUMN^187^         has the same effect as FOLD_BEFORE.
COLUMN^188^
COLUMN^189^     NEW_V[ALUE] variable
COLUMN^190^         specifies a variable to hold a column value, so you can reference
COLUMN^191^         the variable in TTITLE commands.  Use NEW_VALUE to display column
COLUMN^192^         values or the date in the top title.  You must include the column
COLUMN^193^         in a BREAK command with the SKIP PAGE action.
COLUMN^194^
COLUMN^195^         NEW_VALUE is useful for master/detail reports in which there is a
COLUMN^196^         new master record for each page.  For master/detail reporting, you
COLUMN^197^         must also include the column in the ORDER BY clause.
COLUMN^198^
COLUMN^199^         For information on displaying a column value in the bottom title,
COLUMN^200^         see COLUMN OLD_VALUE below.  See TTITLE for more information on
COLUMN^201^         referencing variables in titles.  See COLUMN FORMAT above for
COLUMN^202^         details on formatting and valid format models.
COLUMN^203^
COLUMN^204^     NOPRI[NT]|PRI[NT]
COLUMN^205^         controls the printing of the column (the column heading and all
COLUMN^206^         the selected values).  NOPRINT turns the printing of the column
COLUMN^207^         off; PRINT turns it on.
COLUMN^208^
COLUMN^209^     NUL[L] text
COLUMN^210^         controls the text SQL*Plus displays for null values in the given
COLUMN^211^         column.  The default is a white space.  SET NULL controls the text
COLUMN^212^         displayed for all null values for all columns, unless overridden
COLUMN^213^         for a specific column by the NULL clause of the COLUMN command.
COLUMN^214^
COLUMN^215^     OLD_V[ALUE] variable
COLUMN^216^         specifies a variable to hold a column value, so you can reference
COLUMN^217^         the variable in BTITLE commands.  Use OLD_VALUE to display column
COLUMN^218^         values in the bottom title.  You must include the column in a
COLUMN^219^         BREAK command with the SKIP PAGE action.
COLUMN^220^
COLUMN^221^         OLD_VALUE is useful for master/detail reports in which there is a
COLUMN^222^         new master record for each page.  For master/detail reporting, you
COLUMN^223^         must also include the column in the ORDER BY clause.
COLUMN^224^
COLUMN^225^         See COLUMN NEW_VALUE above for information on displaying a column
COLUMN^226^         value in the top title.  See TTITLE for more on referencing
COLUMN^227^         variables in titles.
COLUMN^228^
COLUMN^229^     ON|OFF
COLUMN^230^         controls the status of display attributes for a column.  OFF
COLUMN^231^         disables the attributes for a column without affecting the
COLUMN^232^         attributes' definition.  ON reinstates the attributes.
COLUMN^233^
COLUMN^234^     WRA[PPED]|WOR[D_WRAPPED]|TRU[NCATED]
COLUMN^235^         specifies how SQL*Plus treats a CHAR, VARCHAR2, LONG or DATE string
COLUMN^236^         that is too wide for a column.  WRAPPED wraps the string within
COLUMN^237^         the column bounds, beginning newlines when required.  WORD_WRAPPED
COLUMN^238^         left justifies each new line, skipping all leading whitespace,
COLUMN^239^         including embedded newline characters.  Embedded whitespace not
COLUMN^240^         on a line boundary is not skipped.  TRUNCATED cuts off the string
COLUMN^241^         at the end of the first display line.
COLUMN^242^
COLUMN^243^ You can enter any number of COLUMN commands for one or more columns.  All
COLUMN^244^ column attributes set for each column remain in effect for the remainder
COLUMN^245^ of the session, until you turn the column OFF, or until you use the CLEAR
COLUMN^246^ COLUMN command.  Thus, the COLUMN commands you enter can control a column's
COLUMN^247^ display attributes for multiple SQL SELECT statements.   When you enter
COLUMN^248^ multiple COLUMN commands for the same column, SQL*Plus applies their clauses
COLUMN^249^ collectively.  If several COLUMN commands apply the same clause to the same
COLUMN^250^ column, the last one entered will control the output.
COLUMN^251^
COLUMN^252^ Examples: To make the ENAME column 20 characters wide and display EMPLOYEE
COLUMN^253^           NAME on two lines at the top, enter:
COLUMN^254^
COLUMN^255^               SQL> COLUMN ENAME FORMAT A20 HEADING 'EMPLOYEE |NAME'
COLUMN^256^
COLUMN^257^           To format the SAL column so that it shows millions of dollars,
COLUMN^258^           rounds to cents, uses commas to separate thousands, and displays
COLUMN^259^           $0.00 when a value is zero:
COLUMN^260^
COLUMN^261^               SQL> COLUMN SAL FORMAT $9,999,990.99
COLUMN^262^
COLUMN^263^           To assign the alias NET to a column with a long expression,
COLUMN^264^           display the result in a dollar format, and display <NULL> for
COLUMN^265^           null values, enter:
COLUMN^266^
COLUMN^267^               SQL> COLUMN SAL+COMM+BONUS-EXPENSES-INS-TAX ALIAS NET
COLUMN^268^               SQL> COLUMN NET FORMAT $9,999,999.99 NULL '<NULL>'
COLUMN^269^
COLUMN^270^           This column specification is divided into two commands.  The
COLUMN^271^           first defines the alias NET, and the second uses NET to define
COLUMN^272^           the format.  In the first command, you must enter the expression
COLUMN^273^           exactly as in the SELECT statement.  Otherwise, SQL*Plus cannot
COLUMN^274^           match the COLUMN command to the appropriate column.  To wrap
COLUMN^275^           long values in a column named REMARKS, enter:
COLUMN^276^
COLUMN^277^               SQL> COLUMN REMARKS FORMAT A20 WRAP
COLUMN^278^
COLUMN^279^           Output:
COLUMN^280^
COLUMN^281^               CUSTOMER  DATE       QUANTITY   REMARKS
COLUMN^282^               --------  ---------  --------   --------------------
COLUMN^283^               123       25-AUG-89       144   This order must be s
COLUMN^284^                                               hipped by air freigh
COLUMN^285^                                               t to ORD.
COLUMN^286^
COLUMN^287^           If you replace WRAP with WORD_WRAP:
COLUMN^288^
COLUMN^289^               CUSTOMER  DATE       QUANTITY   REMARKS
COLUMN^290^               --------  ---------  --------   --------------------
COLUMN^291^               123       25-AUG-89       144   This order must be
COLUMN^292^                                               shipped by air
COLUMN^293^                                               freight to ORD.
COLUMN^294^
COLUMN^295^           If you specify TRUNCATE instead of WORD_WRAP:
COLUMN^296^
COLUMN^297^               CUSTOMER  DATE       QUANTITY   REMARKS
COLUMN^298^               --------  ---------  --------   --------------------
COLUMN^299^               123       25-AUG-89       144   This order must be s
COLUMN^300^
COLUMN^301^           To print the current date and the name of each job in the top
COLUMN^302^           title:
COLUMN^303^
COLUMN^304^               SQL> COLUMN JOB NOPRINT NEW_VALUE JOBVAR
COLUMN^305^               SQL> COLUMN TODAY NOPRINT NEW_VALUE DATEVAR
COLUMN^306^               SQL> BREAK ON JOB SKIP PAGE
COLUMN^307^               SQL> TTITLE CENTER 'Job Report' RIGHT DATEVAR  SKIP 2 -
COLUMN^308^                  > LEFT 'Job:     ' JOBVAR SKIP 2
COLUMN^309^               SQL> SELECT TO_CHAR(SYSDATE, 'MM/DD/YY') TODAY,
COLUMN^310^                 2  ENAME, JOB, MGR, HIREDATE, SAL, DEPTNO
COLUMN^311^                 3  FROM EMP WHERE JOB IN ('CLERK', 'SALESMAN')
COLUMN^312^                 4  ORDER BY JOB, ENAME;
COLUMN^313^
COLUMN^314^           Your 2-page report would look like this, with "Job Report"
COLUMN^315^           centered in your current line size:
COLUMN^316^
COLUMN^317^                                          Job Report             05/01/89
COLUMN^318^
COLUMN^319^           Job:     CLERK
COLUMN^320^
COLUMN^321^           ENAME            MGR HIREDATE          SAL     DEPTNO
COLUMN^322^           ---------- --------- --------- ----------- ----------
COLUMN^323^           ADAMS           7788 14-JAN-87        1100         20
COLUMN^324^           JAMES           7698 03-DEC-88         950         30
COLUMN^325^           MILLER          7782 23-JAN-89        1300         10
COLUMN^326^           SMITH           7902 17-DEC-88         800         20
COLUMN^327^
COLUMN^328^                                          Job Report             05/01/89
COLUMN^329^
COLUMN^330^           Job:     SALESMAN
COLUMN^331^
COLUMN^332^           ENAME            MGR HIREDATE          SAL     DEPTNO
COLUMN^333^           ---------- --------- --------- ----------- ----------
COLUMN^334^           ALLEN           7698 20-FEB-88        1600         30
COLUMN^335^           MARTIN          7698 28-SEP-86        1250         30
COLUMN^336^           TURNER          7698 08-SEP-83        1500         30
COLUMN^337^           WARD            7698 22-FEB-89        1250         30
COLUMN^338^
COLUMN^339^
COLUMN^340^ See also: break, compute, clear, order by, set (long, numwidth, wrap),
COLUMN^341^           ttitle, commands.
COLUMN^342^
COMPUTE^1^
COMPUTE^2^
COMPUTE^3^                                  COMPUTE
COMPUTE^4^
COMPUTE^5^ COMP[UTE] [function [LAB[EL] text] ...
COMPUTE^6^     OF {quoted_select_expr|column|alias} ...
COMPUTE^7^     ON {quoted_select_expr|column|alias|REPORT|ROW} ...]
COMPUTE^8^
COMPUTE^9^ COMPUTE calculates and prints summary lines, using various standard
COMPUTE^10^ computations, on subsets of selected rows.  It also lists all COMPUTE
COMPUTE^11^ definitions.
COMPUTE^12^
COMPUTE^13^         Function     Computes
COMPUTE^14^         --------------------------------------------------
COMPUTE^15^         AVG          Average of non-null values
COMPUTE^16^         COU[NT]      Count of non-null values
COMPUTE^17^         MAX[IMUM]    Maximum value
COMPUTE^18^         MIN[IMUM]    Minimum value
COMPUTE^19^         NUM[BER]     Count of rows
COMPUTE^20^         STD          Standard deviation of non-null values
COMPUTE^21^         SUM          Sum of non-null values
COMPUTE^22^         VAR[IANCE]   Variance of non-null values
COMPUTE^23^
COMPUTE^24^         If you specify more than one function, use spaces between them.
COMPUTE^25^
COMPUTE^26^     LAB[EL] text
COMPUTE^27^          defines the label to be printed for the computed value.  If no
COMPUTE^28^          LABEL clause is used, text defaults to the unabbreviated function
COMPUTE^29^          keyword.  If text contains spaces or punctuation, you must
COMPUTE^30^          enclose it with single quotes.  The label prints left justified
COMPUTE^31^          and truncates to the column width or linesize, whichever is
COMPUTE^32^          smaller.  The maximum length of a label is 500 characters.
COMPUTE^33^
COMPUTE^34^          The label for the computed value appears in the break column
COMPUTE^35^          specified.  To suppress the label use the NOPRINT option of the
COMPUTE^36^          COLUMN command on the break column.
COMPUTE^37^
COMPUTE^38^          If you repeat a function in a COMPUTE command, SQL*Plus issues
COMPUTE^39^          a warning and uses the first occurrence of the function.
COMPUTE^40^
COMPUTE^41^          With ON REPORT and ON ROW computations, the label appears in the
COMPUTE^42^          first column listed in the SELECT statement.  The label can be
COMPUTE^43^          suppressed by using a NOPRINT column first in the SELECT
COMPUTE^44^          statement.  When you compute a function of the first column in
COMPUTE^45^          the SELECT statement ON REPORT or ON ROW then the computed value
COMPUTE^46^          appears in the first column and the label is not displayed.  To
COMPUTE^47^          see the label, select a dummy column first in the select list.
COMPUTE^48^
COMPUTE^49^     OF {quoted_select_expr|column|alias} ...
COMPUTE^50^          specifies the column(s) or expression(s) to be used in the
COMPUTE^51^          computation.  You must also specify these columns in the SELECT
COMPUTE^52^          statement, or SQL*Plus will ignore the COMPUTE command.
COMPUTE^53^
COMPUTE^54^          If you use a SQL SELECT list alias, you must use the SQL alias in
COMPUTE^55^          the COMPUTE command, not the column name.  If you use the
COMPUTE^56^          column name in this case, SQL*Plus will ignore the COMPUTE
COMPUTE^57^          command.
COMPUTE^58^
COMPUTE^59^          If you don't want the computed values of a given column to appear
COMPUTE^60^          in the output of a SELECT statement, use the COLUMN command with
COMPUTE^61^          a NOPRINT clause.  Use spaces between multiple expressions,
COMPUTE^62^          columns, or aliases within the OF clause.
COMPUTE^63^
COMPUTE^64^          To reference a SELECT expression or function reference in an OF
COMPUTE^65^          clause, place the expression or function reference in "quotes".
COMPUTE^66^          Column names and aliases do not need quotes.
COMPUTE^67^
COMPUTE^68^     ON {quoted_select_expr|column|alias|REPORT|ROW} ...
COMPUTE^69^          specifies the event SQL*Plus will use as a break.  COMPUTE prints
COMPUTE^70^          the computed value and restarts the computation when the event
COMPUTE^71^          occurs (that is, when the value of the expression changes, a new
COMPUTE^72^          ROW is fetched, or the end of the report is reached).
COMPUTE^73^
COMPUTE^74^          If multiple COMPUTE commands reference the same column in the ON
COMPUTE^75^          clause, only the last COMPUTE command applies.
COMPUTE^76^
COMPUTE^77^          To reference a SQL SELECT expression or function reference in
COMPUTE^78^          an ON clause, put the expression or function reference in quotes.
COMPUTE^79^          Column names and aliases do not need quotes.  Enter COMPUTE
COMPUTE^80^          without clauses to list all COMPUTE definitions.
COMPUTE^81^
COMPUTE^82^ Enter COMPUTE without clauses to list all COMPUTE definitions.
COMPUTE^83^
COMPUTE^84^ Columns cannot have tables or views appended to them.  Use aliases
COMPUTE^85^ in the SQL statement to achieve this instead.
COMPUTE^86^
COMPUTE^87^ For SQL*Plus to perform the computations:
COMPUTE^88^
COMPUTE^89^     -  One or more of the expressions, columns, or column aliases
COMPUTE^90^        referenced in the OF clause must also be in the SELECT statement.
COMPUTE^91^
COMPUTE^92^     -  The expression, column, or column alias referenced in the ON clause
COMPUTE^93^        must be in the SELECT statement and in the most recent BREAK
COMPUTE^94^        command.
COMPUTE^95^
COMPUTE^96^     -  If you reference either ROW or REPORT in the ON clause, you must
COMPUTE^97^        also reference ROW or REPORT in the most recent BREAK command.
COMPUTE^98^
COMPUTE^99^ To remove all COMPUTE definitions, use the CLEAR COMPUTES command.
COMPUTE^100^
COMPUTE^101^
COMPUTE^102^ Examples: To subtotal the salary for the clerk, analyst, and salesman
COMPUTE^103^           jobs with a compute label of TOTAL, enter:
COMPUTE^104^
COMPUTE^105^               SQL> BREAK ON JOB SKIP 1
COMPUTE^106^               SQL> COMPUTE SUM LABEL 'TOTAL' OF SAL ON JOB
COMPUTE^107^               SQL> SELECT JOB, ENAME, SAL
COMPUTE^108^                  2  FROM EMP
COMPUTE^109^                  3  WHERE JOB IN ('CLERK', 'ANALYST', 'SALESMAN')
COMPUTE^110^                  4  ORDER BY JOB, SAL;
COMPUTE^111^
COMPUTE^112^           Output:
COMPUTE^113^
COMPUTE^114^               JOB       ENAME             SAL
COMPUTE^115^               --------- ---------- ----------
COMPUTE^116^               ANALYST   SCOTT            3000
COMPUTE^117^                         FORD             3000
COMPUTE^118^               *********            ----------
COMPUTE^119^               TOTAL                      6000
COMPUTE^120^
COMPUTE^121^               CLERK     SMITH             800
COMPUTE^122^                         JAMES             950
COMPUTE^123^                         ADAMS            1100
COMPUTE^124^                         MILLER           1300
COMPUTE^125^               *********            ----------
COMPUTE^126^               TOTAL                      4150
COMPUTE^127^
COMPUTE^128^               SALESMAN  WARD             1250
COMPUTE^129^                         MARTIN           1250
COMPUTE^130^                         TURNER           1500
COMPUTE^131^                         ALLEN            1600
COMPUTE^132^               *********            ----------
COMPUTE^133^               TOTAL                      5600
COMPUTE^134^
COMPUTE^135^
COMPUTE^136^           To compute the average and maximum salary for the accounting and
COMPUTE^137^           sales departments, enter:
COMPUTE^138^
COMPUTE^139^
COMPUTE^140^               SQL> BREAK ON DNAME SKIP 1
COMPUTE^141^               SQL> COMPUTE AVG LABEL 'Dept Average' -
COMPUTE^142^               >            MAX LABEL 'Dept Maximum' -
COMPUTE^143^               >       OF SAL ON DNAME
COMPUTE^144^               SQL> SELECT DNAME, ENAME, SAL
COMPUTE^145^                 2  FROM DEPT, EMP
COMPUTE^146^                 3  WHERE DEPT.DEPTNO=EMP.DEPTNO
COMPUTE^147^                 4  AND DNAME IN ('ACCOUNTING', 'SALES')
COMPUTE^148^                 5  ORDER BY DNAME;
COMPUTE^149^
COMPUTE^150^           Output:
COMPUTE^151^
COMPUTE^152^               DNAME          ENAME             SAL
COMPUTE^153^               -------------- ---------- ----------
COMPUTE^154^               ACCOUNTING     CLARK            2450
COMPUTE^155^                              KING             5000
COMPUTE^156^                              MILLER           1300
COMPUTE^157^               **************            ----------
COMPUTE^158^               Dept Average              2916.66667
COMPUTE^159^               Dept Maximum                    5000
COMPUTE^160^
COMPUTE^161^               SALES          ALLEN            1600
COMPUTE^162^                              WARD             1250
COMPUTE^163^                              MARTIN           1250
COMPUTE^164^                              TURNER           1500
COMPUTE^165^                              JAMES             950
COMPUTE^166^                              BLAKE            2850
COMPUTE^167^               **************            ----------
COMPUTE^168^               Dept Average              1566.66667
COMPUTE^169^               Dept Maximum                    2850
COMPUTE^170^
COMPUTE^171^
COMPUTE^172^           To calculate the total of salaries less than 1,000 on a
COMPUTE^173^           report, enter:
COMPUTE^174^
COMPUTE^175^               SQL> compute sum of sal on report
COMPUTE^176^               SQL> break on report
COMPUTE^177^               SQL> column dummy heading ''
COMPUTE^178^               SQL> select '   ' dummy, sal, empno
COMPUTE^179^                 2  from emp
COMPUTE^180^                 3  where sal < 1000
COMPUTE^181^                 4  order by sal;
COMPUTE^182^
COMPUTE^183^           Output:
COMPUTE^184^
COMPUTE^185^                          SAL       EMPNO
COMPUTE^186^               --- ---------- -----------
COMPUTE^187^                          800        7369
COMPUTE^188^                          950        7900
COMPUTE^189^                   ----------
COMPUTE^190^               sum       5350
COMPUTE^191^
COMPUTE^192^
COMPUTE^193^           To compute the sum of salaries for departments 10 and 20
COMPUTE^194^           without printing the compute labels:
COMPUTE^195^
COMPUTE^196^               SQL> COLUMN DUMMY NOPRINT
COMPUTE^197^               SQL> COMPUTE SUM OF SAL ON DUMMY
COMPUTE^198^               SQL> BREAK ON DUMMY SKIP 1
COMPUTE^199^               SQL> SELECT DEPTNO DUMMY, DEPTNO, ENAME, SAL
COMPUTE^200^                 2  FROM EMP
COMPUTE^201^                 3  WHERE DEPTNO <= 20
COMPUTE^202^                 4  ORDER BY DEPTNO;
COMPUTE^203^
COMPUTE^204^           Output:
COMPUTE^205^
COMPUTE^206^                   DEPTNO ENAME             SAL
COMPUTE^207^               ---------- ---------- ----------
COMPUTE^208^                       10 KING             5000
COMPUTE^209^                       10 CLARK            2450
COMPUTE^210^                       10 MILLER           1300
COMPUTE^211^                                     ----------
COMPUTE^212^                                           8750
COMPUTE^213^
COMPUTE^214^                       20 JONES            2975
COMPUTE^215^                       20 FORD             3000
COMPUTE^216^                       20 SMITH             800
COMPUTE^217^                       20 SCOTT            3000
COMPUTE^218^                       20 ADAMS            1100
COMPUTE^219^                                     ----------
COMPUTE^220^                                          10875
COMPUTE^221^
COMPUTE^222^
COMPUTE^223^           If, instead, you do not want to print the label, only the
COMPUTE^224^           salary total at the end of the report:
COMPUTE^225^
COMPUTE^226^               SQL> COLUMN DUMMY NOPRINT
COMPUTE^227^               SQL> COMPUTE SUM OF SAL ON DUMMY
COMPUTE^228^               SQL> BREAK ON DUMMY
COMPUTE^229^               SQL> SELECT NULL DUMMY, DEPTNO, ENAME, SAL
COMPUTE^230^                 2  FROM EMP
COMPUTE^231^                 3  WHERE DEPTNO <= 20
COMPUTE^232^                 4  ORDER BY DEPTNO;
COMPUTE^233^
COMPUTE^234^           Output:
COMPUTE^235^
COMPUTE^236^                   DEPTNO ENAME             SAL
COMPUTE^237^               ---------- ---------- ----------
COMPUTE^238^                       10 KING             5000
COMPUTE^239^                       10 CLARK            2450
COMPUTE^240^                       10 MILLER           1300
COMPUTE^241^                       20 JONES            2975
COMPUTE^242^                       20 FORD             3000
COMPUTE^243^                       20 SMITH             800
COMPUTE^244^                       20 SCOTT            3000
COMPUTE^245^                       20 ADAMS            1100
COMPUTE^246^                                     ----------
COMPUTE^247^                                          19625
COMPUTE^248^
COMPUTE^249^
COMPUTE^250^
COMPUTE^251^
COMPUTE^252^ See also: column, break, select, commands.
COMPUTE^253^
CONNECT^1^
CONNECT^2^
CONNECT^3^                                   CONNECT
CONNECT^4^
CONNECT^5^ CONN[ECT] username[/password][@database_specification]|/
CONNECT^6^
CONNECT^7^ CONNECT establishes a connection to an Oracle database.
CONNECT^8^
CONNECT^9^     username[/password]
CONNECT^10^         are the username and password connecting to Oracle.  If you omit
CONNECT^11^         the username or password, SQL*Plus prompts you for them.  If you
CONNECT^12^         enter a slash (/) or enter RETURN to the prompt for username,
CONNECT^13^         SQL*Plus logs you in with a default logon.
CONNECT^14^
CONNECT^15^     @database_specification
CONNECT^16^         is a SQL*Net connection string.  The syntax depends on the SQL*Net
CONNECT^17^         communications protocol of your Oracle installation.  SQL*Plus
CONNECT^18^         does not prompt you for a database_specification, but uses your
CONNECT^19^         default database if you omit a specification.
CONNECT^20^
CONNECT^21^     /   is a default logon using operating system authentication.  You
CONNECT^22^         can't use a database_specification if you use a default logon.  In
CONNECT^23^         a default logon, SQL*Plus tries to log in with OPS$ name; name is
CONNECT^24^         the operating system username.
CONNECT^25^
CONNECT^26^ CONNECT commits the current transaction to the database, disconnects the
CONNECT^27^ current username from Oracle, and reconnects with the specified username.
CONNECT^28^
CONNECT^29^
CONNECT^30^ Examples: To connect across SQL*Net using username SCOTT and password TIGER
CONNECT^31^           to the database known by the SQL*Net alias as FLEETDB, enter:
CONNECT^32^
CONNECT^33^               SQL> CONNECT SCOTT/TIGER@FLEETDB
CONNECT^34^
CONNECT^35^           To connect with username SCOTT, letting SQL*Plus prompt you for
CONNECT^36^           the password, enter:
CONNECT^37^
CONNECT^38^               SQL> CONNECT SCOTT
CONNECT^39^
CONNECT^40^
CONNECT^41^ See also: disconnect, exit, host, quit, commands.
CONNECT^42^
COPY^1^
COPY^2^
COPY^3^                                 COPY
COPY^4^
COPY^5^ COPY [FROM username [/password] [@database_specification]|
COPY^6^       TO username [/password] [@database_specification]]
COPY^7^       {APPEND|CREATE|INSERT|REPLACE} destination_table
COPY^8^       [(column, column, column, ...)] USING query
COPY^9^
COPY^10^       COPY copies data from a query to a table in a local or remote database.
COPY^11^
COPY^12^     username [/password]
COPY^13^         are the Oracle username/password  you wish to COPY FROM and TO.
COPY^14^         In the FROM clause, username/password identifies the data source;
COPY^15^         in the TO clause, username/password identifies the destination.
COPY^16^         If you do not specify password in either the FROM or TO clause,
COPY^17^         SQL*Plus prompts you for it.
COPY^18^
COPY^19^     @database_specification
COPY^20^         is a database link name or a SQL*Net connection string.  In the
COPY^21^         FROM clause, database_specification is the database at the source;
COPY^22^         in the TO clause, database_specification is the database at the
COPY^23^         destination.  The syntax depends upon the SQL*Net communications
COPY^24^         protocol of your Oracle installation.  SQL*Plus does not prompt
COPY^25^         you for a database specification, but uses your default database
COPY^26^         if you omit a specification.
COPY^27^
COPY^28^     destination_table
COPY^29^         is the table to be created or to which you wish to add data.
COPY^30^
COPY^31^     (column, column, column, ...)
COPY^32^         specifies the names of the columns in destination_table.  You must
COPY^33^         enclose a name in "double quotes" if it contains lowercase letters
COPY^34^         or spaces.  The number of columns you specify must equal the
COPY^35^         number of columns selected by the query.  If you don't specify any
COPY^36^         columns, they will have the same names in the destination table as
COPY^37^         they had in the source, if COPY creates destination_table.
COPY^38^
COPY^39^     USING query
COPY^40^          specifies a SQL query (SELECT statement) to determine which rows
COPY^41^          and columns to copy.
COPY^42^
COPY^43^     FROM username [/password] [@database_specification]
COPY^44^          specifies the username, password, and database with the data to be
COPY^45^          copied.  If the FROM clause is omitted, the source defaults to the
COPY^46^          database to which SQL*Plus is connected.  You must include this
COPY^47^          clause to specify a source database other than the default.
COPY^48^
COPY^49^     TO username [/password] [@database_specification]
COPY^50^          specifies the database containing the destination table.  If you
COPY^51^          omit the TO clause, the destination defaults to the database
COPY^52^          to which SQL*Plus is connected.  You must include this clause to
COPY^53^          specify a destination database other than the default.
COPY^54^
COPY^55^     APPEND
COPY^56^         inserts the rows from query into destination_table if the table
COPY^57^         exists.  If destination_table does not exist, COPY creates it.
COPY^58^
COPY^59^     CREATE
COPY^60^         inserts the rows from query into destination_table after creating
COPY^61^         the table.  If destination_table exists, COPY returns an error.
COPY^62^
COPY^63^     INSERT
COPY^64^         inserts the rows from query into destination_table. If
COPY^65^         destination_table doesn't exist, COPY returns an error.
COPY^66^
COPY^67^     REPLACE
COPY^68^         replaces destination_table and its contents with the rows from
COPY^69^         query.  If destination_table does not exist, COPY creates it.
COPY^70^         Otherwise, COPY drops the table and replaces it with a
COPY^71^         table containing the copied data.
COPY^72^
COPY^73^
COPY^74^ To enable the copying of data between Oracle and non-Oracle databases,
COPY^75^ NUMBER columns are changed to DECIMAL columns in the destination table.
COPY^76^ Hence, if you are copying between Oracle databases, a NUMBER column
COPY^77^ with no precision will be changed to a DECIMAL(38) column.  When
COPY^78^ copying between Oracle databases, you should use SQL commands
COPY^79^ (CREATE TABLE AS and INSERT) or you should ensure that your columns
COPY^80^ have a precision specified.
COPY^81^
COPY^82^ The SQL*Plus SET system_variable LONG clause limits the length of LONG
COPY^83^ columns that are copied.  If any LONG columns have data longer than the
COPY^84^ LONG value, COPY truncates the data.  SQL*Plus performs a commit at the
COPY^85^ end of each successful COPY.  If you set the SQL*Plus SET system_variable
COPY^86^ COPYCOMMIT to a positive value n, SQL*Plus performs a commit after copying
COPY^87^ every n batches of records; the SET system_variable ARRAYSIZE clause
COPY^88^ determines the size of a batch.
COPY^89^
COPY^90^
COPY^91^ Examples: The command below copies the entire EMP table from database HQ
COPY^92^           to a table named WESTEMP in database WEST.  If WESTEMP already
COPY^93^           exists, SQL*Plus replaces its contents.  Columns in WESTEMP have
COPY^94^           the same names as the columns in the source table, EMP:
COPY^95^
COPY^96^               SQL> COPY FROM SCOTT/TIGER@HQ TO JOHN/CHROME@WEST -
COPY^97^               > REPLACE WESTEMP -
COPY^98^               > USING SELECT * FROM EMP
COPY^99^
COPY^100^
COPY^101^           The following command copies selected records from EMP in
COPY^102^           database HQ to the database to which SQL*Plus is connected:
COPY^103^           SQL*Plus creates SALESMEN through the copy.  SQL*Plus copies
COPY^104^           only the columns EMPNO and ENAME and at the destination names
COPY^105^           them EMPNO and SALESMAN.
COPY^106^
COPY^107^               SQL> COPY FROM SCOTT/TIGER@HQ -
COPY^108^               > CREATE SALESMEN (EMPNO,SALESMAN) -
COPY^109^               > USING SELECT EMPNO, ENAME FROM EMP -
COPY^110^               > WHERE JOB='SALES'
COPY^111^
COPY^112^
COPY^113^           SQL*Plus creates SALESMEN through the copy, copies columns EMPNO
COPY^114^           and ENAME, and names them EMPNO and SALESMAN at the destination.
COPY^115^
COPY^116^
COPY^117^ See also: connect, disconnect, describe, edit, set (arraysize, copycommit,
COPY^118^           long), commands.
COPY^119^
DBA^1^
DBA^2^
DBA^3^                                     DBA
DBA^4^
DBA^5^ DBA username SYSTEM owns and has all privileges on PRODUCT_USER_PROFILE.
DBA^6^ Other users should have only SELECT access to this table.  Command file
DBA^7^ PUPBLD, when run, grants SELECT access on PRODUCT_USER_PROFILE to PUBLIC.
DBA^8^
DBA^9^ To disable a SQL or SQL*Plus command for a given user, the DBA inserts a
DBA^10^ row with the username in the USERID column, the command in the ATTRIBUTE
DBA^11^ column, and DISABLED in the CHAR_VALUE column.  The SCOPE, NUMERIC_VALUE,
DBA^12^ and DATE_VALUE columns should contain null.  For example:
DBA^13^
DBA^14^                                             NUMERIC   CHAR      DATE
DBA^15^      PRODUCT    USERID   ATTRIBUTE   SCOPE  VALUE     VALUE     VALUE
DBA^16^      --------   ------   ---------   -----  -------   --------  -----
DBA^17^      SQL*Plus   SCOTT    HOST                         DISABLED
DBA^18^      SQL*Plus   %        INSERT                       DISABLED
DBA^19^      SQL*Plus   %        UPDATE                       DISABLED
DBA^20^      SQL*Plus   %        DELETE                       DISABLED
DBA^21^
DBA^22^
DBA^23^ To re-enable a command, the DBA deletes the row with the restriction.
DBA^24^
DBA^25^ The DBA can use the PRODUCT_USER_PROFILE table to disable the following:
DBA^26^
DBA^27^      SQL*Plus Commands     SQL Commands
DBA^28^      -----------------     -------------------------------------------
DBA^29^      CONNECT    QUIT       ALTER    DELETE    NOAUDIT  SET TRANSACTION
DBA^30^      EDIT       RUN        ANALYZE  DROP      RENAME   TRUNCATE
DBA^31^      EXECUTE    SAVE       AUDIT    GRANT     REVOKE   UPDATE
DBA^32^      EXIT       SET        CONNECT  INSERT    SELECT   VALIDATE
DBA^33^      GET        SPOOL      CREATE   LOCK      SET ROLE
DBA^34^      HOST       START
DBA^35^
DBA^36^      PL/SQL Commands
DBA^37^      ---------------
DBA^38^      BEGIN
DBA^39^      DECLARE
DBA^40^
DBA^41^ Note that ANALYZE, SET ROLE, and TRUNCATE require Oracle7.
DBA^42^ Columns in the PRODUCT_USER_PROFILE table:
DBA^43^
DBA^44^     PRODUCT contains the product name (SQL*Plus in this case).  Wildcards
DBA^45^         and nulls are not permitted.
DBA^46^
DBA^47^     USERID contains the username (in CAPITALS) for whom the command is
DBA^48^         being disabled.  To disable the command for more than one user,
DBA^49^         use the % SQL wildcard or make multiple entries.
DBA^50^
DBA^51^     ATTRIBUTE contains the command (in CAPITALS) being disabled or
DBA^52^         the character string "ROLES".  Wildcards are not permitted.
DBA^53^
DBA^54^     SCOPE is ignored for SQL*Plus.  We recommend a NULL here.
DBA^55^
DBA^56^     NUMERIC_VALUE is ignored for SQL*Plus.  We recommend a NULL here.
DBA^57^
DBA^58^     CHAR_VALUE must contain "DISABLED" or the name of the role being
DBA^59^         disabled.  Wildcards are not permitted.
DBA^60^
DBA^61^     DATE_VALUE is ignored for SQL*Plus.  We recommend a NULL here.
DBA^62^
DBA^63^     LONG_VALUE is ignored for SQL*Plus.  We recommend a NULL here.
DBA^64^
DBA^65^     See also:  commands.
DBA^66^
DEFINE^1^
DEFINE^2^
DEFINE^3^                                   DEFINE
DEFINE^4^
DEFINE^5^ DEF[INE] [variable]|[variable = text]
DEFINE^6^
DEFINE^7^ DEFINE specifies a user variable and assigns it a CHAR value, or lists
DEFINE^8^ the value and variable type of a single variable or all variables.
DEFINE^9^
DEFINE^10^     variable
DEFINE^11^         is the user variable whose value you wish to assign or list.
DEFINE^12^         Enter DEFINE followed by variable to list the value and type of
DEFINE^13^         variable.  Enter DEFINE with no clauses to list the values and
DEFINE^14^         types of all user variables.
DEFINE^15^
DEFINE^16^     variable = text
DEFINE^17^         defines (names) a user variable and assigns it a CHAR value.
DEFINE^18^
DEFINE^19^     text
DEFINE^20^         is the CHAR value you wish to assign to variable.  Enclose text in
DEFINE^21^         'single quotes' if it contains punctuation or blanks.
DEFINE^22^
DEFINE^23^ DEFINEd variables retain their values until you:
DEFINE^24^
DEFINE^25^     -   enter a new DEFINE command referencing the variable, or
DEFINE^26^     -   enter an UNDEFINE command referencing the variable, or
DEFINE^27^     -   enter an ACCEPT command referencing the variable, or
DEFINE^28^     -   reference the variable in the NEW_VALUE or OLD_VALUE clause of
DEFINE^29^           the COLUMN command, and reference the column in a subsequent SQL
DEFINE^30^           SELECT statement, or
DEFINE^31^     -   EXIT SQL*Plus.
DEFINE^32^
DEFINE^33^ When you run a stored query or a command file, SQL*Plus substitutes the
DEFINE^34^ value of variable for each substitution variable referencing &variable or
DEFINE^35^ &&variable.  SQL*Plus will not prompt you for the value of variable in
DEFINE^36^ the session until you UNDEFINE variable.  Note that you can use DEFINE to
DEFINE^37^ define the _EDITOR variable, which establishes the host system editor
DEFINE^38^ invoked by the EDIT command.
DEFINE^39^
DEFINE^40^ If you continue the value of a DEFINEd variable on multiple lines with the
DEFINE^41^ SQL*Plus command continuation character, each continuation character and
DEFINE^42^ carriage return you enter are replaced with a space in the resulting
DEFINE^43^ variable.  For example, SQL*Plus interprets
DEFINE^44^
DEFINE^45^     SQL> DEFINE TEXT = 'ONE-
DEFINE^46^     > TWO-
DEFINE^47^     > THREE'
DEFINE^48^
DEFINE^49^ as:  SQL> DEFINE TEXT = 'ONE TWO THREE'
DEFINE^50^
DEFINE^51^ Examples: To assign the value MANAGER to the variable POS, enter:
DEFINE^52^
DEFINE^53^               SQL> DEFINE POS = MANAGER
DEFINE^54^
DEFINE^55^           If you execute a command with a reference to &POS, SQL*Plus
DEFINE^56^           substitutes the value MANAGER for &POS, and will not prompt you
DEFINE^57^           for a POS value.  To assign the CHAR value 20 to the variable
DEFINE^58^           DEPTNO, enter:
DEFINE^59^
DEFINE^60^               SQL> DEFINE DEPTNO = 20
DEFINE^61^
DEFINE^62^           Even though you enter the number 20, SQL*Plus assigns a CHAR
DEFINE^63^           value to DEPTNO consisting of two characters, 2 and 0.  To see
DEFINE^64^           the definition of DEPTNO, enter:
DEFINE^65^
DEFINE^66^               SQL> DEFINE DEPTNO
DEFINE^67^
DEFINE^68^           Result:
DEFINE^69^
DEFINE^70^               DEFINE DEPTNO = "20" (CHAR)
DEFINE^71^
DEFINE^72^
DEFINE^73^ See also: accept, column, edit, parameters, undefine, commands.
DEFINE^74^
DEL^1^
DEL^2^
DEL^3^                                     DEL
DEL^4^
DEL^5^ DEL [n|n m|n *|n LAST|*|* n|* LAST|LAST]
DEL^6^
DEL^7^
DEL^8^     Clause    Deletes
DEL^9^     -----------------------------------------
DEL^10^     n         line n.
DEL^11^     n m       lines n through m.
DEL^12^     n *       line n through the current line.
DEL^13^     n LAST    line n through the last line.
DEL^14^     *         the current line.
DEL^15^     * n       the current line through line n.
DEL^16^     * LAST    the current line through the last line.
DEL^17^     LAST      the last line.
DEL^18^
DEL^19^ DEL deletes one or more lines of the buffer.  DEL makes the
DEL^20^ following line of the buffer (if any) the current line. You can
DEL^21^ enter DEL several times to delete several consecutive lines.
DEL^22^
DEL^23^
DEL^24^ Examples: The SQL buffer contains the following query:
DEL^25^
DEL^26^               SQL> LIST
DEL^27^                 1  SELECT ENAME, DEPTNO
DEL^28^                 2  FROM EMP
DEL^29^                 3  WHERE JOB = 'SALESMAN'
DEL^30^                 4* ORDER BY DEPTNO
DEL^31^
DEL^32^           To make the line with the WHERE clause the current line, enter:
DEL^33^
DEL^34^               SQL> LIST 3
DEL^35^                 3* WHERE JOB = 'SALESMAN'
DEL^36^
DEL^37^           followed by:
DEL^38^
DEL^39^               SQL> DEL
DEL^40^
DEL^41^           The SQL buffer now contains:
DEL^42^
DEL^43^               SQL> LIST
DEL^44^                 1  SELECT ENAME, DEPTNO
DEL^45^                 2  FROM EMP
DEL^46^                 3* ORDER BY DEPTNO
DEL^47^
DEL^48^           To delete the second line of the buffer, enter:
DEL^49^
DEL^50^               SQL> DEL 2
DEL^51^
DEL^52^           The SQL buffer now contains:
DEL^53^
DEL^54^               SQL> LIST
DEL^55^                 1  SELECT ENAME, DEPTNO
DEL^56^                 2* ORDER BY DEPTNO
DEL^57^
DEL^58^
DEL^59^ See also: append, change, edit, input, list, save, commands.
DEL^60^
DESCRIBE^1^
DESCRIBE^2^
DESCRIBE^3^                                  DESCRIBE
DESCRIBE^4^
DESCRIBE^5^ DESC[RIBE] {[user.]table[@database_link_name] [column]|
DESCRIBE^6^    [user.] object[.subobject]}
DESCRIBE^7^
DESCRIBE^8^ DESCRIBE lists the column definitions for a table, view, or synonym,
DESCRIBE^9^ or the specifications for a function or procedure.
DESCRIBE^10^
DESCRIBE^11^     user
DESCRIBE^12^         is the owner of the object.  Omit user if you own the object.
DESCRIBE^13^
DESCRIBE^14^     table
DESCRIBE^15^         is a table, view, or synonym.
DESCRIBE^16^
DESCRIBE^17^     database_link_name
DESCRIBE^18^         is the node name and database where object exists.  The syntax
DESCRIBE^19^         depends on the SQL*Net your computer uses.  See LINKS for more
DESCRIBE^20^         information on database links.
DESCRIBE^21^
DESCRIBE^22^     column
DESCRIBE^23^         is the column in table you wish to describe.
DESCRIBE^24^
DESCRIBE^25^     object
DESCRIBE^26^         is the function or procedure you wish to describe.  If you want
DESCRIBE^27^         to describe a procedure in a package, object is the name of the
DESCRIBE^28^         package.
DESCRIBE^29^
DESCRIBE^30^     subobject
DESCRIBE^31^         is the function or procedure in a package that you wish
DESCRIBE^32^         to describe.
DESCRIBE^33^
DESCRIBE^34^ For each column, the description lists:
DESCRIBE^35^
DESCRIBE^36^     -   the column's name
DESCRIBE^37^     -   whether null values are allowed (NULL or NOT NULL) for the column
DESCRIBE^38^     -   the column's datatype, for example, NUMBER, CHAR, VARCHAR2
DESCRIBE^39^         (VARCHAR), LONG, DATE, MLSLABEL, RAW MLSLABEL, RAW, LONGRAW,
DESCRIBE^40^         ROWID.
DESCRIBE^41^     -   the column's precision (and scale, if any, for a numeric column)
DESCRIBE^42^
DESCRIBE^43^ For each function or procedure the description lists:
DESCRIBE^44^
DESCRIBE^45^     -   the type of PL/SQL object (function or procedure)
DESCRIBE^46^     -   the name of the function or procedure
DESCRIBE^47^     -   the arguments, their type, input/output, and default values
DESCRIBE^48^
DESCRIBE^49^ Example:  To describe the EMP table, enter:
DESCRIBE^50^
DESCRIBE^51^           SQL> DESCRIBE EMP
DESCRIBE^52^
DESCRIBE^53^       Output:  Name       Null?     Type
DESCRIBE^54^                ---------- --------  -----------
DESCRIBE^55^                EMPNO      NOT NULL  NUMBER(4)
DESCRIBE^56^                ENAME                CHAR(10)
DESCRIBE^57^                JOB                  CHAR(9)
DESCRIBE^58^                MGR                  NUMBER(4)
DESCRIBE^59^                HIREDATE             DATE
DESCRIBE^60^                SAL                  NUMBER(7,2)
DESCRIBE^61^                COMM                 NUMBER(7,2)
DESCRIBE^62^                DEPTNO               NUMBER(2)
DESCRIBE^63^
DESCRIBE^64^ To describe a procedure called CUSTOMER_LOOKUP, enter:
DESCRIBE^65^
DESCRIBE^66^       SQL> DESCRIBE customer_lookup
DESCRIBE^67^
DESCRIBE^68^       PROCEDURE customer_lookup
DESCRIBE^69^       Argument Name Type     In/Out Default?
DESCRIBE^70^       ------------- -------- ------ -------------
DESCRIBE^71^       CUST_ID       NUMBER   IN
DESCRIBE^72^       CUST_NAME     VARCHAR2 OUT
DESCRIBE^73^
DESCRIBE^74^
DESCRIBE^75^ To describe the procedure APROC in the package APACK, enter
DESCRIBE^76^
DESCRIBE^77^       SQL> DESCRIBE apack.aproc
DESCRIBE^78^
DESCRIBE^79^       PROCEDURE apack.aproc
DESCRIBE^80^       Argument Name Type     In/Out Default?
DESCRIBE^81^       ------------- -------- ------ -------------
DESCRIBE^82^       P1            CHAR     IN
DESCRIBE^83^       P2            NUMBER   IN
DESCRIBE^84^
DESCRIBE^85^ See also: links, tables, views (and indexes), commands.
DESCRIBE^86^
DISCONNECT^1^
DISCONNECT^2^
DISCONNECT^3^                                 DISCONNECT
DISCONNECT^4^
DISCONNECT^5^ DISC[ONNECT]
DISCONNECT^6^
DISCONNECT^7^ DISCONNECT commits pending changes to the database and logs the current
DISCONNECT^8^ user out of Oracle, but does not exit SQL*Plus.  Use EXIT or QUIT to log
DISCONNECT^9^ out of Oracle and return control to your host computer's operating system.
DISCONNECT^10^
DISCONNECT^11^
DISCONNECT^12^ Example:  Your command file might begin with a CONNECT command and end
DISCONNECT^13^           with a DISCONNECT:
DISCONNECT^14^
DISCONNECT^15^               SQL> GET MYFILE
DISCONNECT^16^                 1  CONNECT ...
DISCONNECT^17^                    .
DISCONNECT^18^                    .
DISCONNECT^19^                    .
DISCONNECT^20^                15* DISCONNECT
DISCONNECT^21^
DISCONNECT^22^
DISCONNECT^23^ See also: connect, exit, host, quit, SQLPlus, commands.
DISCONNECT^24^
EDIT^1^
EDIT^2^
EDIT^3^                                EDIT
EDIT^4^
EDIT^5^ ED[IT] [file_name[.ext]]
EDIT^6^
EDIT^7^ EDIT invokes a host operating system text editor on the contents of the
EDIT^8^ specified file or on the contents of the buffer.
EDIT^9^
EDIT^10^     file_name[.ext]
EDIT^11^         is the file to edit (typically a command file)
EDIT^12^
EDIT^13^ Enter EDIT with no file_name to edit the SQL buffer's contents with the
EDIT^14^ host operating system editor.
EDIT^15^
EDIT^16^ If you omit the file extension, the default command file extension
EDIT^17^ (normally SQL) is assumed.  See the SET command's SUFFIX variable for
EDIT^18^ information on changing the default extension.
EDIT^19^
EDIT^20^ The user variable _EDITOR contains the name of the text editor invoked by
EDIT^21^ EDIT; to change the text editor, change the _EDITOR name.  See DEFINE for
EDIT^22^ information on changing the value of a user variable.  If _EDITOR is
EDIT^23^ undefined, EDIT tries to use the default host operating system editor.
EDIT^24^
EDIT^25^ EDIT alone places the SQL buffer's contents in a file by default named
EDIT^26^ AFIEDT.BUF in your current working directory, then invokes the text
EDIT^27^ editor on the contents of that file.  You can change the default file
EDIT^28^ name by using the SET EDITFILE command.  See the SET command's EDITFILE
EDIT^29^ variable for information on changing the default filename.
EDIT^30^
EDIT^31^ EDIT returns an error message if you don't specify a filename and the
EDIT^32^ buffer is empty.
EDIT^33^
EDIT^34^ To leave the editing session and return to SQL*Plus, terminate the editing
EDIT^35^ session in the way customary for the text editor.  When you exit your
EDIT^36^ editor, SQL*Plus loads the contents of the file into the buffer.
EDIT^37^
EDIT^38^ Example:  To edit the file REPORT with the extension SQL using your host
EDIT^39^           operating system text editor, enter:
EDIT^40^
EDIT^41^               SQL> EDIT REPORT
EDIT^42^
EDIT^43^
EDIT^44^ See also: append, change, del, define, input, list, save, spool, undefine,
EDIT^45^           commands.
EDIT^46^
EXECUTE^1^
EXECUTE^2^
EXECUTE^3^                                    EXECUTE
EXECUTE^4^
EXECUTE^5^ EXEC[UTE] statement
EXECUTE^6^
EXECUTE^7^ EXECUTE executes a single PL/SQL statement.  The EXECUTE command is
EXECUTE^8^ often useful when you want to execute a PL/SQL statement that
EXECUTE^9^  references a stored procedure.
EXECUTE^10^
EXECUTE^11^     statement
EXECUTE^12^         Represents a PL/SQL statement.
EXECUTE^13^
EXECUTE^14^
EXECUTE^15^ If your EXECUTE command cannot fit on one line because of the
EXECUTE^16^ length of the PL/SQL statement, use the SQL*Plus continuation
EXECUTE^17^ character (a hyphen).
EXECUTE^18^ The length of the command and the PL/SQL statement cannot exceed
EXECUTE^19^ the length defined by LINESIZE.
EXECUTE^20^
EXECUTE^21^ Examples:  The following EXECUTE command assigns a value to a bind
EXECUTE^22^ variable:
EXECUTE^23^
EXECUTE^24^      SQL> EXECUTE :n := 1
EXECUTE^25^
EXECUTE^26^ The following EXECUTE command runs a PL/SQL statement that
EXECUTE^27^ references a stored procedure:
EXECUTE^28^
EXECUTE^29^      SQL> EXECUTE -
EXECUTE^30^      :ID := EMP_MANAGEMENT.HIRE('BLAKE','MANAGER','KING',2990,'SALES')
EXECUTE^31^
EXIT^1^
EXIT^2^
EXIT^3^                                    EXIT
EXIT^4^
EXIT^5^ {EXIT|QUIT} [SUCCESS|FAILURE|WARNING|n|variable] [COMMIT|ROLLBACK]
EXIT^6^
EXIT^7^ EXIT terminates SQL*Plus, and returns control to the operating system.
EXIT^8^
EXIT^9^     {EXIT|QUIT}
EXIT^10^         can be used interchangeably.
EXIT^11^
EXIT^12^     SUCCESS
EXIT^13^         exits normally.
EXIT^14^
EXIT^15^     FAILURE
EXIT^16^         exits with a return code indicating failure.
EXIT^17^
EXIT^18^     WARNING
EXIT^19^         exits with a return code indicating warning.  EXIT with no clauses
EXIT^20^         exits with a value of SUCCESS.
EXIT^21^
EXIT^22^     n
EXIT^23^         is an integer you can specify as the return code.
EXIT^24^
EXIT^25^     variable
EXIT^26^         is a user-defined or system variable (not a bind variable), like
EXIT^27^         SQL.SQLCODE. EXIT variable exits with the value of variable as the
EXIT^28^         return code.
EXIT^29^
EXIT^30^     COMMIT
EXIT^31^         saves pending changes to the database before exiting.
EXIT^32^
EXIT^33^     ROLLBACK
EXIT^34^         executes a ROLLBACK statement and abandons pending changes to the
EXIT^35^         database before exiting.
EXIT^36^
EXIT^37^ EXIT with no clauses commits and exits with a value of SUCCESS.
EXIT^38^
EXIT^39^ EXIT enables you to specify an operating system return code so you can run
EXIT^40^ SQL*Plus command files in batch mode and detect an unexpected event.  The
EXIT^41^ manner of detection is operating-system-specific.  SUCCESS, WARNING, and
EXIT^42^ FAILURE represent operating system dependent values; on some systems,
EXIT^43^ WARNING and FAILURE are not distinguishable.  The range of operating system
EXIT^44^ return codes is also restricted on some operating systems.  This limits the
EXIT^45^ portability of EXIT n and EXIT variable between platforms.  For example, on
EXIT^46^ UNIX there is no meaningful way to return an Oracle error code.  Since
EXIT^47^ there is only one byte of storage for return codes, the range for return
EXIT^48^ codes is limited to zero to 255.
EXIT^49^
EXIT^50^ To exit conditionally, use WHENEVER SQLERROR or WHENEVER OSERROR.
EXIT^51^
EXIT^52^ If you make a syntax error in the EXIT options, or use a non-numeric
EXIT^53^ variable, SQL*Plus performs an EXIT FAILURE COMMIT.
EXIT^54^
EXIT^55^
EXIT^56^ Example:  The following commits all uncommitted transactions and returns
EXIT^57^           the error code of the last executed SQL command or PL/SQL block:
EXIT^58^
EXIT^59^               SQL> EXIT SQL.SQLCODE
EXIT^60^
EXIT^61^           The location of the return code depends on your system.  See
EXIT^62^           TTITLE for more information on SQL.SQLCODE.
EXIT^63^
EXIT^64^
EXIT^65^ See also: connect, disconnect, host, quit, save, spool, SQLPlus,
EXIT^66^           whenever sqlerror, commands.
EXIT^67^
FILES^1^
FILES^2^
FILES^3^                                 Files
FILES^4^
FILES^5^ Files Used by SQL*Plus
FILES^6^
FILES^7^ Through SQL*Plus, you can store commands in a command file.  You can
FILES^8^ also create output files (spool files) to save your query results.
FILES^9^ Command files and spool files are operating system files and follow
FILES^10^ standard naming conventions.  Edit with your system's file commands.
FILES^11^
FILES^12^
FILES^13^ Command Entry and Execution
FILES^14^
FILES^15^     Enter SQL, PL/SQL, and SQL*Plus commands at the command prompt: SQL>.
FILES^16^     SQL*Plus stores the SQL commands and PL/SQL blocks you enter in the
FILES^17^     SQL buffer.
FILES^18^
FILES^19^
FILES^20^ See also: buffer, commands.
FILES^21^
GET^1^
GET^2^
GET^3^                                    GET
GET^4^
GET^5^ GET file_name[.ext] [LIS[T]|NOL[IST]]
GET^6^
GET^7^ GET loads a host operating system file into the SQL buffer.
GET^8^
GET^9^     file_name[.ext]
GET^10^         is the file to load (typically a command file).
GET^11^     LIS[T]
GET^12^         lists the contents of the file.  This is the default.
GET^13^
GET^14^     NOL[IST]
GET^15^         suppresses the listing of the file's contents.
GET^16^
GET^17^ If you omit .ext, SQL*Plus uses the default command-file extension
GET^18^ (normally SQL).
GET^19^
GET^20^ Example:  To load a file called YEARENDRPT with the extension SQL into
GET^21^           the buffer, type:
GET^22^
GET^23^               SQL> GET YEARENDRPT
GET^24^
GET^25^
GET^26^ See also: @, /, accept, input, list, run, save, set, spool,
GET^27^           commands.
GET^28^
HELP^1^
HELP^2^
HELP^3^                                    HELP
HELP^4^
HELP^5^ HELP [topic] | help
HELP^6^
HELP^7^ HELP displays information on the commands and conventions of SQL*Plus,
HELP^8^ SQL, and PL/SQL.  Type "help", a space, all or part of any topic, and
HELP^9^ then press Enter.
HELP^10^
HELP^11^ Typing only part of a topic (for example, HELP SE) will cause all help
HELP^12^ topics that match the string (SE) to be displayed on your screen in
HELP^13^ alphabetical order (for example, HELP SE will retrieve help on the
HELP^14^ SELECT statement, the SET command, and the Set Operators--in that order).
HELP^15^
HELP^16^     ENTER THIS...     TO DISPLAY THIS...
HELP^17^     --------------------------------------------------------------
HELP^18^     help commands     a list of SQL*Plus, SQL, and PL/SQL commands
HELP^19^     help comm         information on commands, comments, and commit
HELP^20^     help help         this screen
HELP^21^
HOST^1^
HOST^2^
HOST^3^                                    HOST
HOST^4^
HOST^5^ HO[ST] [ command ]
HOST^6^
HOST^7^ HOST executes a host operating system command without leaving SQL*Plus.
HOST^8^
HOST^9^     command
HOST^10^         is a host operating system command.  Enter HOST without command to
HOST^11^         display an operating system prompt.  You can then enter multiple
HOST^12^         operating system commands.  To return to SQL*Plus, type LOGOFF,
HOST^13^         EXIT, QUIT, or other command applicable to your operating system.
HOST^14^
HOST^15^ With some operating systems, you can use $ (VMS), ! (UNIX) or another
HOST^16^ character instead of HOST.  You may or may not have access to the HOST
HOST^17^ command, depending on your operating system, and privileges assigned by
HOST^18^ your system administrator.
HOST^19^
HOST^20^ SQL*Plus removes the SQLTERMINATOR (a semicolon by default) before the
HOST^21^ HOST command is issued.  A workaround for this is to add another
HOST^22^ SQLTERMINATOR.  See SET SQLTERMINATOR for more information on the
HOST^23^ SQLTERMINATOR.
HOST^24^
HOST^25^
HOST^26^ Example:  To execute an operating system command, ls *.sql, enter:
HOST^27^
HOST^28^               SQL> HOST ls *.sql
HOST^29^
HOST^30^
HOST^31^ See also: change, del, edit, exit, commands.
HOST^32^
INDEX^1^
INDEX^2^
INDEX^3^                                  Index
INDEX^4^
INDEX^5^
INDEX^6^Enter help, a space and part or all of the help topic you want:
INDEX^7^
INDEX^8^
INDEX^9^%FOUND Attribute           DEFAULT DATE FORMAT      Packaged Cursors
INDEX^10^%ISOPEN Attribute          DEFINE                   Packaged Subprograms
INDEX^11^%NOTFOUND Attribute        DEL                      Packages
INDEX^12^%ROWCOUNT Attribute        DELETE                   Parameter Aliasing
INDEX^13^%ROWTYPE Attribute         Delimiters               Parameter Default Values
INDEX^14^%TYPE Attribute            DESCRIBE                 Parameter Modes
INDEX^15^/                          DISABLE                  PARAMETERS
INDEX^16^@                          DISCONNECT               PAUSE
INDEX^17^@@                         DROP                     PL/SQL
INDEX^18^ABS                        DROP CLUSTER             PL/SQL Blocks
INDEX^19^ACCEPT                     DROP DATABASE LINK       PL/SQL Tables
INDEX^20^Actual vs Formal           DROP FUNCTION            PL/SQL Wrapper
INDEX^21^  Parameters               DROP INDEX               Positional and Named
INDEX^22^ADD_MONTHS                 DROP PACKAGE               Notation
INDEX^23^ALTER CLUSTER              DROP PROCEDURE           POWER
INDEX^24^ALTER DATABASE             DROP PROFILE             PRECEDENCE
INDEX^25^ALTER FUNCTION             DROP ROLE                Predefined Exceptions
INDEX^26^ALTER INDEX                DROP ROLLBACK SEGMENT    PRINT
INDEX^27^ALTER PACKAGE              DROP SEQUENCE            Private vs Public
INDEX^28^ALTER PROCEDURE            DROP SNAPSHOT              Objects
INDEX^29^ALTER PROFILE              DROP SNAPSHOT LOG        Procedures
INDEX^30^ALTER RESOURCE COST        DROP SYNONYM             Product-specific
INDEX^31^ALTER ROLE                 DROP TABLE                 Packages
INDEX^32^ALTER ROLLBACK SEGMENT     DROP TABLESPACE          PROMPT
INDEX^33^ALTER SEQUENCE             DROP TRIGGER             PSEUDOCOLUMNS
INDEX^34^ALTER SESSION              DROP USER                Punctuation and Text
INDEX^35^ALTER SNAPSHOT             DROP VIEW                  in Date Format Models
INDEX^36^ALTER SNAPSHOT LOG         DUMP                     QUIT
INDEX^37^ALTER SYSTEM               EDIT                     RAISE Statement
INDEX^38^ALTER TABLE                ENABLE                   raise_application_error
INDEX^39^ALTER TABLESPACE           Ending Transactions        Procedure
INDEX^40^ALTER TRIGGER              Exception Handlers       RAW AND LONG RAW DATATYPES
INDEX^41^ALTER USER                 Exception Propagation    RAWTOHEX
INDEX^42^ALTER VIEW                 Exceptions               Records
INDEX^43^ANALYZE                    EXCEPTION_INIT Pragma    RECOVER
INDEX^44^AND OPERATOR               EXECUTE                  Recursion
INDEX^45^ANSI, DB2, AND SQL/DS      EXIT                     Recursion vs Iteration
INDEX^46^  DATATYPES                EXIT Statement           Referencing Package
INDEX^47^APPEND                     EXP                        Contents
INDEX^48^ARCHIVE LOG                EXPLAIN PLAN             REMARK
INDEX^49^ARITHMETIC OPERATORS       Expr                     RENAME
INDEX^50^ASCII                      Expressions              REPLACE
INDEX^51^Assignments                FETCH Statement          Reraising an Exception
INDEX^52^AUDIT (Schema Objects)     FILES                    RESERVED WORDS
INDEX^53^AUDIT (SQL Statements)     Filespec                 Reserved Words
INDEX^54^AVG                        FLOOR                    RESERVED WORDS (SQL)
INDEX^55^Block Label                FM                       RETURN Statement
INDEX^56^BNF SYNTAX                 FOR UPDATE Clause        REVOKE (Object Privileges)
INDEX^57^Boolean Expressions        Format Model Modifiers   REVOKE (System
INDEX^58^BREAK                      FORMAT MODELS              Privileges and Roles)
INDEX^59^BTITLE                     Forward Declarations     ROLLBACK
INDEX^60^BUFFER                     Functions                ROUND (DATE)
INDEX^61^Built-in Functions         FX                       ROUND (NUMBER)
INDEX^62^Calling Packaged           GET                      ROUND and TRUNC
INDEX^63^  Subprograms              GLB                      ROWID
INDEX^64^Calling Stored             GOTO Statement           ROWID DATATYPE
INDEX^65^  Functions from SQL       GRANT (Object            ROWIDTOCHAR
INDEX^66^Calling Stored               Privileges)            ROWNUM
INDEX^67^  Subprograms              GRANT (System            RPAD
INDEX^68^Capitalization of            Privileges and Roles)  RR Date Format Element
INDEX^69^  Date Format Elements     GREATEST                 RTRIM
INDEX^70^CEIL                       GREATEST_LB              RUN
INDEX^71^CHANGE                     GROUP FUNCTIONS          RUNFORM
INDEX^72^Changing the Return Format Handling Nulls           SAVE
INDEX^73^CHAR DATATYPE              HELP                     SAVEPOINT
INDEX^74^CHARACTER DATATYPES        HEXTORAW                 Scope and Visibility
INDEX^75^Character Functions        HOST                     SELECT
INDEX^76^Character Functions        Identifiers              SET
INDEX^77^  Returning Character      IF Statement             SET OPERATORS
INDEX^78^  Values                   Implicit Rollbacks       SET ROLE
INDEX^79^Character Functions        INDEX                    SET TRANSACTION
INDEX^80^  Returning Number         INITCAP                  SHOW
INDEX^81^  Values                   INPUT                    SIGN
INDEX^82^CHARACTER OPERATORS        INSERT                   SIN
INDEX^83^Character Set              INSTR                    SINGLE ROW FUNCTIONS
INDEX^84^CHARTOROWID                INSTRB                   SINH
INDEX^85^CHR                        INTEGER                  SOUNDEX
INDEX^86^CLEAR                      INTERSECT OPERATOR       SPOOL
INDEX^87^CLOSE Statement            ISO Standard Date        SQL FUNCTIONS
INDEX^88^COLUMN                       Format Elements        SQL Support
INDEX^89^COMMANDS                   LAST_DAY                 SQL92 Conformance
INDEX^90^COMMENT                    LEAST                    SQLCODE and SQLERRM
INDEX^91^Comments                   LEAST_UB                   Functions
INDEX^92^COMMENTS (SQL)             LENGTH                   SQLPLUS
INDEX^93^COMMIT                     LENGTHB                  SQRT
INDEX^94^COMPARISON OPERATORS       LEVEL                    START
INDEX^95^Comparison Operators       Lexical Units            STDDEV
INDEX^96^COMPUTE                    LIKE OPERATOR            STORAGE
INDEX^97^CONCAT                     LIMITS                   Stored Subprograms
INDEX^98^Concatenation Operator     LIST                     Structure Theorem
INDEX^99^Condition                  LIST OF EXPRESSIONS      Subprograms
INDEX^100^CONNECT                    LITERALS                 SUBSTITUTION
INDEX^101^CONSTRAINT                 Literals                 SUBSTR
INDEX^102^Conversion Functions       LN                       SUBSTRB
INDEX^103^CONVERT                    LOCK TABLE               Subtypes
INDEX^104^COPY                       LOG                      SUM
INDEX^105^COS                        LOGICAL OPERATORS        Supplying the Correct
INDEX^106^COSH                       Logical Operators          Format
INDEX^107^COUNT                      LONG DATATYPE            Syntax Notation
INDEX^108^CREATE CLUSTER             Loop Label               SYSDATE
INDEX^109^CREATE CONTROLFILE         LOOP Statement           TAN
INDEX^110^CREATE DATABASE            LOWER                    TANH
INDEX^111^CREATE DATABASE LINK       LPAD                     TEXT
INDEX^112^CREATE FUNCTION            LTRIM                    TIMING
INDEX^113^CREATE INDEX               LUB                      TOPICS
INDEX^114^CREATE PACKAGE             MAX                      TO_CHAR (date conversion)
INDEX^115^CREATE PACKAGE BODY        MENU                     TO_CHAR (label conversion)
INDEX^116^CREATE PROCEDURE           MIN                      TO_CHAR (number conversion)
INDEX^117^CREATE PROFILE             MINUS OPERATOR           TO_DATE
INDEX^118^CREATE ROLE                MLSLABEL DATATYPE        TO_LABEL
INDEX^119^CREATE ROLLBACK SEGMENT    MOD                      TO_MULTI_BYTE
INDEX^120^CREATE SCHEMA              MONTHS_BETWEEN           TO_NUMBER
INDEX^121^CREATE SEQUENCE            Mutual Recursion         TO_SINGLE_BYTE
INDEX^122^CREATE SNAPSHOT            Naming Conventions       Transaction Processing
INDEX^123^CREATE SNAPSHOT LOG        NEW_TIME                 TRANSLATE
INDEX^124^CREATE SYNONYM             NEXT_DAY                 TRUNC (DATE)
INDEX^125^CREATE TABLE               NLSSORT                  TRUNC (NUMBER)
INDEX^126^CREATE TABLESPACE          NLS_INITCAP              TRUNCATE
INDEX^127^CREATE TRIGGER             NLS_LOWER                TTITLE
INDEX^128^CREATE USER                NLS_UPPER                UID
INDEX^129^CREATE VIEW                NOAUDIT (Schema Objects) UNDEFINE
INDEX^130^CURRVAL AND NEXTVAL        NOAUDIT (SQL Statements) Unhandled Exceptions
INDEX^131^Cursor Attributes          NOT IN OPERATOR          UNION ALL OPERATOR
INDEX^132^Cursor FOR Loop            NOT OPERATOR             UNION OPERATOR
INDEX^133^Cursor Variables           NULL Statement           UPDATE
INDEX^134^Cursors                    NULLS                    UPPER
INDEX^135^DATA CONVERSION            NUMBER                   USER
INDEX^136^DATATYPE COMPARISON        NUMBER DATATYPE          USERENV
INDEX^137^  RULES                    Number Format Elements   Using COMMIT
INDEX^138^Datatype Conversion        Number Format Models     Using LOCK TABLE
INDEX^139^Datatypes                  NUMBER FUNCTIONS         Using ROLLBACK
INDEX^140^DATATYPES (ORACLE)         NVL                      Using SAVEPOINT
INDEX^141^DATE DATATYPE              OLD COMMANDS             Using SET TRANSACTION
INDEX^142^Date Format Element        OPEN Statement           VARCHAR DATATYPE
INDEX^143^  Suffixes                 Operator Precedence      VARCHAR2 DATATYPE
INDEX^144^Date Format Elements       OPERATORS                VARIABLE
INDEX^145^Date Format Elements       OR OPERATOR              VARIABLES
INDEX^146^  and National             Other Functions          Variables and Constants
INDEX^147^  Language Support         OTHER OPERATORS          VARIANCE
INDEX^148^Date Format Models         Overloading              VSIZE
INDEX^149^DATE FUNCTIONS             OVERVIEW                 WHENEVER OSERROR
INDEX^150^DBA                        Package Body             WHENEVER SQLERROR
INDEX^151^DDL and Dynamic SQL        Package Specification
INDEX^152^Decoded Expression         Package STANDARD
INDEX^153^
INPUT^1^
INPUT^2^
INPUT^3^                                  INPUT
INPUT^4^
INPUT^5^ I[NPUT] [ text ]
INPUT^6^
INPUT^7^ INPUT adds one or more lines of text after the current line in the buffer.
INPUT^8^
INPUT^9^     text
INPUT^10^         is the text to add.  To add one line, enter INPUT, a space, and
INPUT^11^         the text. (To begin the line with one or more spaces, enter two
INPUT^12^         or more spaces after INPUT.)  To add several lines, enter INPUT
INPUT^13^         without text; INPUT prompts you for each line.  To leave INPUT,
INPUT^14^         enter an empty line.
INPUT^15^
INPUT^16^ At the command prompt, if you enter a line number larger than the number
INPUT^17^ of lines in the buffer, and follow the number with text, SQL*Plus adds
INPUT^18^ the text in a new line at the end of the buffer.  If you specify zero (0)
INPUT^19^ for the line number and follow the zero with text, SQL*Plus inserts the
INPUT^20^ line at the beginning of the buffer; that line becomes line 1.
INPUT^21^
INPUT^22^ Examples: The SQL buffer contains the following command:
INPUT^23^
INPUT^24^               1  SELECT ENAME, DEPTNO, SAL, COMM
INPUT^25^               2  FROM EMP
INPUT^26^
INPUT^27^           To add an ORDER BY clause to the query, enter:
INPUT^28^
INPUT^29^               SQL> LIST 2
INPUT^30^                 2* FROM EMP
INPUT^31^
INPUT^32^               SQL> INPUT ORDER BY ENAME
INPUT^33^
INPUT^34^           LIST 2 ensures that line 2 is the current line.  INPUT adds a
INPUT^35^           line with the ORDER BY clause after the current line. The SQL
INPUT^36^           buffer now contains:
INPUT^37^
INPUT^38^               1  SELECT ENAME, DEPTNO, SAL, COMM
INPUT^39^               2  FROM EMP
INPUT^40^               3* ORDER BY ENAME
INPUT^41^
INPUT^42^           To add a two-line WHERE clause, enter:
INPUT^43^
INPUT^44^               SQL> LIST 2
INPUT^45^                 2* FROM EMP
INPUT^46^               SQL> INPUT
INPUT^47^                 3  WHERE JOB = 'SALESMAN'
INPUT^48^                 4  AND COMM  500
INPUT^49^                 5
INPUT^50^
INPUT^51^           INPUT continues to prompt you for new lines until you enter an
INPUT^52^           empty line.  The SQL buffer now contains the following lines:
INPUT^53^
INPUT^54^               1  SELECT ENAME, DEPTNO, SAL, COMM
INPUT^55^               2  FROM EMP
INPUT^56^               3  WHERE JOB = 'SALESMAN'
INPUT^57^               4  AND COMM 500
INPUT^58^               5  ORDER BY ENAME
INPUT^59^
INPUT^60^
INPUT^61^ See also: change, del, edit, list, save, spool, get, input,
INPUT^62^           set, prompt, commands.
INPUT^63^
LIMITS^1^
LIMITS^2^
LIMITS^3^                                Limits
LIMITS^4^
LIMITS^5^ Item                               SQL*Plus Limit
LIMITS^6^ --------------------------------------------------------
LIMITS^7^ filename length                    system dependent
LIMITS^8^ username length                    30  characters
LIMITS^9^ user variable name length          30  characters
LIMITS^10^ user variable value length         240 characters
LIMITS^11^ command-line length                2,500 characters
LIMITS^12^ length of LONG value in SQL*Plus   LINESIZE value
LIMITS^13^ LINESIZE                           system dependent
LIMITS^14^ LONGCHUNKSIZE value (Oracle7)      MAXDATA value
LIMITS^15^ MAXDATA value                      system dependent
LIMITS^16^ output line size                   system dependent
LIMITS^17^ characters in COMPUTE label        500 characters
LIMITS^18^ line after variable substitution   3,000 characters (internal only)
LIMITS^19^ number of lines per command        500 (assuming 80 characters per line)
LIMITS^20^ maximum PAGESIZE                   50,000 lines
LIMITS^21^ total row width                    60,000 characters in VMS; else, 32,767
LIMITS^22^ maximum ARRAYSIZE                  5000 rows
LIMITS^23^ maximum nested command files       20 for VMS, CMS, Unix; otherwise, 5
LIMITS^24^ maximum page numbers               99,999 pages
LIMITS^25^ maximum PL/SQL error message size  2K (Oracle7) 512 Bytes (Oracle Version 6)
LIMITS^26^ maximum ACCEPT character string    240 bytes
LIMITS^27^
LIMITS^28^ See also:  commands.
LIMITS^29^
LIST^1^
LIST^2^
LIST^3^                                    LIST
LIST^4^
LIST^5^ L[IST] [n|n m|n  *|n LAST|*|* n|* LAST|LAST]
LIST^6^
LIST^7^
LIST^8^ LIST displays one or more lines of the SQL buffer. Enter LIST by
LIST^9^ itself to list all lines.
LIST^10^
LIST^11^     Clause    Lists
LIST^12^     -----------------------------------------
LIST^13^     n         line n.
LIST^14^     n m       lines n through m.
LIST^15^     n *       line n through the current line.
LIST^16^     n LAST    line n through the last line.
LIST^17^     *         the current line.
LIST^18^     * n       the current line through line n.
LIST^19^     * LAST    the current line through the last line.
LIST^20^     LAST      the last line.
LIST^21^
LIST^22^ The last line listed is the new current line (with an asterisk).
LIST^23^
LIST^24^
LIST^25^ Example:  To list the contents of the buffer, enter:
LIST^26^
LIST^27^               SQL> LIST
LIST^28^
LIST^29^           You will see a listing of all lines in the buffer, like this:
LIST^30^
LIST^31^                 1  SELECT ENAME, DEPTNO, JOB
LIST^32^                 2  FROM EMP
LIST^33^                 3  WHERE JOB = 'CLERK'
LIST^34^                 4* ORDER BY DEPTNO
LIST^35^
LIST^36^           The asterisk shows line 4 to be the current line.  To list the
LIST^37^           second line only, enter:
LIST^38^
LIST^39^               SQL> LIST 2
LIST^40^                 2* FROM EMP
LIST^41^
LIST^42^           To list the current line (now line 2) to the last line, enter:
LIST^43^
LIST^44^               SQL> LIST * LAST
LIST^45^                 2  FROM EMP
LIST^46^                 3  WHERE JOB = 'CLERK'
LIST^47^                 4* ORDER BY DEPTNO
LIST^48^
LIST^49^
LIST^50^ See also: change, del, edit, get, input, save, spool, set,
LIST^51^           commands.
LIST^52^
MENU^1^
MENU^2^
MENU^3^                                     Menu
MENU^4^
MENU^5^ Enter TOPIC or INDEX for a list of help topics.
MENU^6^
OLD COMMANDS^1^
OLD COMMANDS^2^
OLD COMMANDS^3^                                Old Commands
OLD COMMANDS^4^
OLD COMMANDS^5^ These old SQL*Plus commands still work, although SQL*Plus provides newer
OLD COMMANDS^6^ commands with better functionality.
OLD COMMANDS^7^
OLD COMMANDS^8^ BTI[TLE] text
OLD COMMANDS^9^     BTITLE displays a title at the bottom of each report page.  The old
OLD COMMANDS^10^     form of BTITLE offers more limited formatting than the new form, but
OLD COMMANDS^11^     provides compatibility with UFI (a predecessor of SQL*Plus). The old
OLD COMMANDS^12^     form defines the bottom title as an empty line followed by a line with
OLD COMMANDS^13^     centered text.  See OLD TTITLE for details.
OLD COMMANDS^14^
OLD COMMANDS^15^ COL[UMN] {column|expr} DEF[AULT]               Replaced by: COLUMN CLEAR
OLD COMMANDS^16^      COLUMN DEFAULT resets the display attributes for a given column to
OLD COMMANDS^17^      default values.  It has the same effect as COLUMN CLEAR.
OLD COMMANDS^18^
OLD COMMANDS^19^ DOC[UMENT]                                           Replaced by: REMARK
OLD COMMANDS^20^     DOCUMENT begins a block of documentation in a command file.
OLD COMMANDS^21^     When you type DOCUMENT and press RETURN, SQL*Plus displays DOC> in
OLD COMMANDS^22^     place of SQL> until you end the documentation.  Enter # (pound) on a
OLD COMMANDS^23^     line by itself to end the documentation.  If DOCUMENT is OFF, SQL*Plus
OLD COMMANDS^24^     reads further lines of documentation as commands.  See SET DOCUMENT.
OLD COMMANDS^25^
OLD COMMANDS^26^ NEWPAGE [1|n]                         Replaced by: SET command's NEWPAGE
OLD COMMANDS^27^     NEWPAGE advances spooled output n lines beyond the beginning of the
OLD COMMANDS^28^     next page.
OLD COMMANDS^29^
OLD COMMANDS^30^ SET BUF[FER] {buffer|SQL}
OLD COMMANDS^31^     SET BUFFER makes the specified buffer the current buffer.  Initially,
OLD COMMANDS^32^     the SQL buffer is the current buffer.  SQL*Plus doesn't use multiple
OLD COMMANDS^33^     buffers; the SQL buffer should meet your needs.  If the buffer name
OLD COMMANDS^34^     you enter does not already exist, SET BUFFER creates and names the
OLD COMMANDS^35^     buffer.  The buffer is erased when you exit SQL*Plus.
OLD COMMANDS^36^
OLD COMMANDS^37^     Running a query automatically makes the SQL buffer the current one.
OLD COMMANDS^38^     GET and SAVE copy text from one buffer to another.  CLEAR BUFFER
OLD COMMANDS^39^     erases text from the current buffer.  CLEAR SQL erases text from the
OLD COMMANDS^40^     SQL buffer when you're using another one.
OLD COMMANDS^41^
OLD COMMANDS^42^ SET DOC[UMENT] {OFF|ON}
OLD COMMANDS^43^     SET DOCUMENT ON enables the DOCUMENT command, and SET DOCUMENT OFF
OLD COMMANDS^44^     disables it.  If you disable DOCUMENT, SQL*Plus reads any lines after
OLD COMMANDS^45^     a DOCUMENT command as commands.  See DOCUMENT for details.
OLD COMMANDS^46^
OLD COMMANDS^47^ SET SCAN {OFF|ON}                                Replaced by: SET DEFINE
OLD COMMANDS^48^     controls scanning for substitution variables and parameters.
OLD COMMANDS^49^     OFF suppresses their processing; ON allows normal processing.  ON
OLD COMMANDS^50^     functions in the same manner as SET DEFINE ON.
OLD COMMANDS^51^
OLD COMMANDS^52^ SET SPA[CE] {1|n}                                Replaced by: SET COLSEP
OLD COMMANDS^53^     sets the number of spaces between output columns (Maximum = 10).
OLD COMMANDS^54^     This command is obsoleted by SET COLSEP, but you can still use it
OLD COMMANDS^55^     for backward compatibility.
OLD COMMANDS^56^
OLD COMMANDS^57^ SET TRU[NCATE] {OFF|ON}
OLD COMMANDS^58^     SET TRUNCATE controls whether SQL*Plus truncates or wraps a data item
OLD COMMANDS^59^     that is too long for the current line width.  ON and SET WRAP OFF work
OLD COMMANDS^60^     the same way.  You may prefer to use WRAP, because the SHOW command
OLD COMMANDS^61^     recognizes WRAP and does not recognize TRUNCATE.
OLD COMMANDS^62^
OLD COMMANDS^63^ TTI[TLE] text
OLD COMMANDS^64^     TTITLE displays a title at the top of each report page.  The old form
OLD COMMANDS^65^     of TTITLE has more limited formatting than the new form, but is
OLD COMMANDS^66^     compatible with UFI, a SQL*Plus predecessor.  The old form defines the
OLD COMMANDS^67^     top title as a line with the date left-aligned and the page number
OLD COMMANDS^68^     right-aligned, a line with centered text, and then a blank line.  Text
OLD COMMANDS^69^     is the title displayed.
OLD COMMANDS^70^
OLD COMMANDS^71^     SQL*Plus centers text based on the SET LINESIZE setting.  A separator
OLD COMMANDS^72^     character (|) begins a new line; two line separator characters (||)
OLD COMMANDS^73^     insert a blank line.  Use SET HEADSEP to change the line separator
OLD COMMANDS^74^     character.  Control the formatting of page numbers in the old forms of
OLD COMMANDS^75^     TTITLE and BTITLE by defining the variable "_page".  The default _page
OLD COMMANDS^76^     value is the formatting string, "page &P4".  To alter it, DEFINE _page
OLD COMMANDS^77^     with a new string:
OLD COMMANDS^78^
OLD COMMANDS^79^           SQL> SET ESCAPE /SQL> DEFINE _page = 'Page /&P2'
OLD COMMANDS^80^
OLD COMMANDS^81^     The string prints "Page" and formats the page number to a width of 2.
OLD COMMANDS^82^     You can substitute any text for "Page" and any number for the width.
OLD COMMANDS^83^     You must set Escape so SQL*Plus doesn't read the ampersand (&) as a
OLD COMMANDS^84^     substitution variable.  The SET command's ESCAPE variable sets the
OLD COMMANDS^85^     escape character.
OLD COMMANDS^86^
OLD COMMANDS^87^     SQL*Plus interprets TTITLE in the old form if a valid new-form clause
OLD COMMANDS^88^     does not immediately follow the command name.
OLD COMMANDS^89^
OLD COMMANDS^90^     If you want to use CENTER with TTITLE and put more than one word on
OLD COMMANDS^91^     a line, you should use the new form of TTITLE.
OLD COMMANDS^92^
OLD COMMANDS^93^     Example:  To use the old TTITLE to set a top title with a left-aligned
OLD COMMANDS^94^               date and a right-aligned page number on one line, MARKETING
OLD COMMANDS^95^               on the next line, and PERSONNEL REPORT on the third, enter:
OLD COMMANDS^96^
OLD COMMANDS^97^               SQL> TTITLE 'MARKETING | PERSONNEL REPORT'
OLD COMMANDS^98^
OLD COMMANDS^99^
OLD COMMANDS^100^     See also:  commands.
OLD COMMANDS^101^
OVERVIEW^1^
OVERVIEW^2^
OVERVIEW^3^                             Overview (SQL*Plus)
OVERVIEW^4^
OVERVIEW^5^ You can use SQL*Plus with SQL and its procedural extension, PL/SQL.  SQL
OVERVIEW^6^ enables you to store and retrieve data in the Oracle relational database
OVERVIEW^7^ management system.  SQL*Plus enables you to manipulate SQL commands and
OVERVIEW^8^ PL/SQL blocks, and to perform many other tasks.  With SQL*Plus, you can:
OVERVIEW^9^
OVERVIEW^10^  -  enter, edit, store, retrieve, and run SQL commands and PL/SQL blocks
OVERVIEW^11^  -  format, perform calculations on, store, and print query results
OVERVIEW^12^  -  list column definitions for any table
OVERVIEW^13^  -  access and copy data between SQL databases
OVERVIEW^14^  -  send messages to and accept responses from an end user
OVERVIEW^15^
OVERVIEW^16^
OVERVIEW^17^ Basic SQL*Plus Concepts
OVERVIEW^18^
OVERVIEW^19^     Command         An instruction you give SQL*Plus or the Oracle Server.
OVERVIEW^20^
OVERVIEW^21^     Block           A group of SQL and PL/SQL commands related to one
OVERVIEW^22^                     another through procedural logic.
OVERVIEW^23^
OVERVIEW^24^     Table           The basic unit of storage in the Oracle Server.
OVERVIEW^25^
OVERVIEW^26^     Query           A SELECT statement that retrieves information from
OVERVIEW^27^                     one or more tables.
OVERVIEW^28^
OVERVIEW^29^     Query results   The data retrieved by a query.
OVERVIEW^30^
OVERVIEW^31^     Report          Query results formatted by you with SQL*Plus commands.
OVERVIEW^32^
OVERVIEW^33^
OVERVIEW^34^ Entering and Executing Commands
OVERVIEW^35^
OVERVIEW^36^ Your computer's cursor (usually an underline, rectangular block, or slash)
OVERVIEW^37^ appears after the command prompt.  The cursor is where the next character
OVERVIEW^38^ you type appears on the screen.  You can enter commands in uppercase or
OVERVIEW^39^ lowercase in SQL*Plus.  As you type SQL*Plus, SQL, and PL/SQL commands,
OVERVIEW^40^ use at least one space, tab, or RETURN between words.  You can use extra
OVERVIEW^41^ spaces, tabs, and RETURNs between words to make the code easier to read.
OVERVIEW^42^
OVERVIEW^43^ You can enter three kinds of commands at the command prompt:
OVERVIEW^44^
OVERVIEW^45^      -  SQL commands, for working with information in the database
OVERVIEW^46^      -  PL/SQL blocks, also for working with information in the database
OVERVIEW^47^      -  SQL*Plus commands for formatting query results, setting options,
OVERVIEW^48^         and editing and storing SQL and PL/SQL commands
OVERVIEW^49^
OVERVIEW^50^ End a SQL command with a semicolon (;) at the end of a line
OVERVIEW^51^                        a slash (/) on a line by itself
OVERVIEW^52^                        a blank line
OVERVIEW^53^
OVERVIEW^54^ A semicolon (;) tells SQL*Plus to run the command.  Type ; at the end of
OVERVIEW^55^ the last line and press RETURN to execute it.  If you press RETURN without
OVERVIEW^56^ a semicolon, SQL*Plus displays the next line number.  Type ; and press
OVERVIEW^57^ RETURN again to run the command.  A slash (/) on a line by itself also
OVERVIEW^58^ tells SQL*Plus to run the command.  Press RETURN after the last command
OVERVIEW^59^ line.  At the next line number, type / and press RETURN again.
OVERVIEW^60^
OVERVIEW^61^
OVERVIEW^62^ Running PL/SQL Blocks
OVERVIEW^63^
OVERVIEW^64^ PL/SQL blocks begin with DECLARE, BEGIN, or a block name.  SQL*Plus treats
OVERVIEW^65^ PL/SQL blocks the same as SQL commands, except that a semicolon (;) or a
OVERVIEW^66^ blank line does not terminate and execute a block; terminate PL/SQL blocks
OVERVIEW^67^ by entering a period (.) by itself on a new line.  To execute the block
OVERVIEW^68^ currently in the SQL buffer, use the RUN or slash (/) command.
OVERVIEW^69^
OVERVIEW^70^ Example: You might enter and run the following PL/SQL block:
OVERVIEW^71^
OVERVIEW^72^     SQL> DECLARE
OVERVIEW^73^        2     x   NUMBER := 100;
OVERVIEW^74^        3  BEGIN
OVERVIEW^75^        4     FOR i IN 1..10 LOOP
OVERVIEW^76^        5        IF MOD(i, 2) = 0 THEN    --i is even
OVERVIEW^77^        6          INSERT INTO temp VALUES (i, x, 'i is even');
OVERVIEW^78^        7          ELSE
OVERVIEW^79^        8             INSERT INTO temp VALUES (i, x, 'i is odd');
OVERVIEW^80^        9          END IF;
OVERVIEW^81^       10          x := x + 100;
OVERVIEW^82^       11     END LOOP;
OVERVIEW^83^       12  END;
OVERVIEW^84^       13  .
OVERVIEW^85^
OVERVIEW^86^     SQL> PL/SQL procedure successfully completed.
OVERVIEW^87^
OVERVIEW^88^           When you run a block, SQL commands within the block may behave
OVERVIEW^89^           somewhat differently than they would outside of the block.
OVERVIEW^90^
OVERVIEW^91^
OVERVIEW^92^ Running SQL*Plus Commands
OVERVIEW^93^
OVERVIEW^94^ Use SQL*Plus commands to manipulate SQL commands and PL/SQL blocks, and
OVERVIEW^95^ format and print query results.  To speed up command entry, you can
OVERVIEW^96^ abbreviate many SQL*Plus commands to one or a few letters.
OVERVIEW^97^
OVERVIEW^98^
OVERVIEW^99^ Running Host Operating System Commands
OVERVIEW^100^
OVERVIEW^101^ You can execute a host operating system command from the SQL*Plus command
OVERVIEW^102^ prompt, useful when you want to perform a task like listing host operating
OVERVIEW^103^ system files.  To run a host operating system command, enter HOST followed
OVERVIEW^104^ by the host operating system command.  For example, this SQL*Plus command
OVERVIEW^105^ runs a host command, DIRECTORY *.SQL:
OVERVIEW^106^
OVERVIEW^107^               SQL> HOST DIRECTORY *.SQL
OVERVIEW^108^
OVERVIEW^109^ See also:  commands.
OVERVIEW^110^
PARAMETERS^1^
PARAMETERS^2^
PARAMETERS^3^                               Parameters
PARAMETERS^4^
PARAMETERS^5^ A parameter is a substitution variable with & (ampersand) followed by a
PARAMETERS^6^ number (for example, "&1").  Parameters are used only in command files.
PARAMETERS^7^ You pass values to the parameters as arguments to the START command.  If a
PARAMETERS^8^ parameter represents a char or date value, enclose the parameter in
PARAMETERS^9^ apostrophes as if it were a constant:
PARAMETERS^10^
PARAMETERS^11^               SELECT * FROM EMP
PARAMETERS^12^               WHERE JOB='&1'  /* char value */
PARAMETERS^13^               AND SAL=&2;  /* number value */
PARAMETERS^14^
PARAMETERS^15^ Then, when you run the command file, enter parameter values as arguments
PARAMETERS^16^ of the START command.   The first argument after the filename represents
PARAMETERS^17^ the first parameter (&1), the second represents the second parameter (&2),
PARAMETERS^18^ and so on.  In the following command, SQL*Plus substitutes CLERK for &1
PARAMETERS^19^ and 7900 for &2:
PARAMETERS^20^
PARAMETERS^21^               SQL> START MYFILE CLERK 7900
PARAMETERS^22^
PARAMETERS^23^ When you use arguments with the START command, SQL*Plus DEFINEs each
PARAMETERS^24^ parameter in the command file with the value of the appropriate argument.
PARAMETERS^25^
PARAMETERS^26^ See also: substitution, commands.
PARAMETERS^27^
PAUSE^1^
PAUSE^2^
PAUSE^3^                                   PAUSE
PAUSE^4^
PAUSE^5^ PAU[SE] [text]
PAUSE^6^
PAUSE^7^ PAUSE displays an empty line followed by a line with text, then waits for
PAUSE^8^ the user to press RETURN.  Or it displays two empty lines, and waits for
PAUSE^9^ the user's response.
PAUSE^10^
PAUSE^11^     text
PAUSE^12^         is the text you wish to display.  Enter PAUSE with no text to
PAUSE^13^         display two empty lines.
PAUSE^14^
PAUSE^15^
PAUSE^16^ Since PAUSE waits for the user's response, it's wise to include a message
PAUSE^17^ to press RETURN.  PAUSE reads input from the terminal (if available) even
PAUSE^18^ when you specify a file as the source of the input.  The SET command's
PAUSE^19^ PAUSE clause controls pausing between pages of a report.
PAUSE^20^
PAUSE^21^
PAUSE^22^ Example:  To display "Adjust paper and press RETURN to continue." then
PAUSE^23^           wait for the user to press RETURN, include the following PAUSE
PAUSE^24^           command in a command file:
PAUSE^25^
PAUSE^26^                 SET PAUSE ON
PAUSE^27^                 PAUSE Adjust paper and press RETURN to continue.
PAUSE^28^                 SELECT ...
PAUSE^29^
PAUSE^30^
PAUSE^31^ See also: /, @, get, prompt, run, set (pause), start, commands.
PAUSE^32^
PRINT^1^
PRINT^2^
PRINT^3^                                   PRINT
PRINT^4^
PRINT^5^ PRI[NT] variable ...
PRINT^6^
PRINT^7^ PRINT displays the current values of bind variables.
PRINT^8^
PRINT^9^     variable ...
PRINT^10^         Represents the names of the bind variables you wish to
PRINT^11^         display.
PRINT^12^
PRINT^13^
PRINT^14^ To automatically display bind variables, use the AUTOPRINT clause
PRINT^15^ of the SET command.
PRINT^16^
PRINT^17^ Bind variables are created using the VARIABLE command.  You can
PRINT^18^ control the formatting of the PRINT output just as you would
PRINT^19^ query output.
PRINT^20^
PRINT^21^ Example:  The following is an example of a PRINT command:
PRINT^22^
PRINT^23^                     SQL> VARIABLE id NUMBER
PRINT^24^                     SQL> BEGIN
PRINT^25^                        1    :id := 1;
PRINT^26^                       2  END;
PRINT^27^                     SQL> PRINT id
PRINT^28^                                ID
PRINT^29^                      ------------
PRINT^30^                                1
PRINT^31^
PRINT^32^ See also: variable, set.
PRINT^33^
PROMPT^1^
PROMPT^2^
PROMPT^3^                                   PROMPT
PROMPT^4^
PROMPT^5^ PROMPT [text]
PROMPT^6^
PROMPT^7^ PROMPT sends the specified message or a blank line to the user's screen.
PROMPT^8^
PROMPT^9^     text
PROMPT^10^         is the text of the message you wish to display. If you omit text,
PROMPT^11^         PROMPT displays a blank line on the user's screen.
PROMPT^12^
PROMPT^13^ Use this command in command files to give information to the user.
PROMPT^14^
PROMPT^15^ Example:  Here is PROMPT used with ACCEPT in command file ASKFORDEPT:
PROMPT^16^
PROMPT^17^               SQL> GET ASKFORDEPT
PROMPT^18^                 1  PROMPT
PROMPT^19^                 2  PROMPT Please enter a department
PROMPT^20^                 3  PROMPT For example: 10, 20, 30, 40
PROMPT^21^                 4  ACCEPT NEWDEPT NUMBER PROMPT 'DEPT:>'
PROMPT^22^                 5* SELECT DNAME FROM DEPT WHERE DEPTNO = &NEWDEPT
PROMPT^23^
PROMPT^24^           If you run the file using @ASKFORDEPT, SQL*Plus displays:
PROMPT^25^
PROMPT^26^               Please enter a department
PROMPT^27^               For example: 10, 20, 30, 40
PROMPT^28^               DEPT:>
PROMPT^29^
PROMPT^30^           You can enter a department number at the DEPT:> prompt.
PROMPT^31^           By default, SQL*Plus lists the line containing &NEWDEPT before
PROMPT^32^           and after substitution, and then displays the department name
PROMPT^33^           matching the number entered at the DEPT:> prompt.
PROMPT^34^
PROMPT^35^
PROMPT^36^ See also: /, @, accept, get, input, pause, run, start, commands.
PROMPT^37^
QUIT^1^
QUIT^2^
QUIT^3^                                   QUIT
QUIT^4^
QUIT^5^ {QUIT|EXIT} [SUCCESS|FAILURE|WARNING|n|variable] [COMMIT|ROLLBACK]
QUIT^6^
QUIT^7^ QUIT commits all pending database changes, leaves SQL*Plus, and returns
QUIT^8^ control to the operating system.
QUIT^9^
QUIT^10^     {QUIT|EXIT}
QUIT^11^         can be used interchangeably.
QUIT^12^
QUIT^13^     SUCCESS
QUIT^14^         exits normally.
QUIT^15^
QUIT^16^     FAILURE
QUIT^17^         exits with a return code indicating failure.
QUIT^18^
QUIT^19^     WARNING
QUIT^20^         exits with a return code indicating warning.  QUIT with no clauses
QUIT^21^         exits with a value of SUCCESS.
QUIT^22^
QUIT^23^     n
QUIT^24^         is an integer you can specify as the return code.
QUIT^25^
QUIT^26^     variable
QUIT^27^         is a user-defined or system variable, like SQL.SQLCODE.
QUIT^28^         QUIT variable exits with the value of variable as the return code.
QUIT^29^
QUIT^30^     COMMIT
QUIT^31^         saves pending changes to the database before exiting.
QUIT^32^
QUIT^33^     ROLLBACK
QUIT^34^         executes a ROLLBACK statement and abandons pending changes to the
QUIT^35^         database before exiting.
QUIT^36^
QUIT^37^ QUIT enables you to specify an operating system return code so you can run
QUIT^38^ SQL*Plus command files in batch mode and detect an unexpected event.  The
QUIT^39^ manner of detection is operating-system specific.  SUCCESS, WARNING, and
QUIT^40^ FAILURE represent operating system dependent values; on some systems,
QUIT^41^ WARNING and FAILURE are not distinguishable.  The range of operating system
QUIT^42^ return codes is also restricted on some operating systems.  This limits the
QUIT^43^ portability of QUIT n and QUIT variable between platforms.  For example, on
QUIT^44^ UNIX there is no meaningful way to return an Oracle error code.  Since
QUIT^45^ there is only one byte of storage for return codes, the range for return
QUIT^46^ codes is limited to zero to 250.
QUIT^47^
QUIT^48^ To exit conditionally, use WHENEVER SQLERROR or WHENEVER OSERROR.
QUIT^49^
QUIT^50^ If you make a syntax error in the QUIT options, or use a non-numeric
QUIT^51^ variable, SQL*Plus performs a QUIT FAILURE COMMIT.
QUIT^52^
QUIT^53^
QUIT^54^ Example:  The following returns the error code of the last executed SQL
QUIT^55^           command or PL/SQL block:
QUIT^56^
QUIT^57^               SQL> QUIT SQL.SQLCODE
QUIT^58^
QUIT^59^           The location of the return code depends on your system.  See
QUIT^60^           TTITLE for more information on SQL.SQLCODE.
QUIT^61^
QUIT^62^
QUIT^63^ See also: connect, disconnect, host, exit, save, spool, SQLPlus,
QUIT^64^           whenever sqlerror, commands.
QUIT^65^
REMARK^1^
REMARK^2^
REMARK^3^                                   REMARK
REMARK^4^
REMARK^5^ REM[ARK]
REMARK^6^
REMARK^7^ REMARK at the beginning of a line signifies a comment in a command file.
REMARK^8^ The comment ends at the end of the line.  A line cannot contain both a
REMARK^9^ comment and a command.  See /* for information on entering comments in
REMARK^10^ statements.
REMARK^11^
REMARK^12^ Example:  Here are some typical comments in command files:
REMARK^13^
REMARK^14^               REM Uses BREAK ON REPORT to break on end of table.
REMARK^15^               BREAK ON REPORT
REMARK^16^               COMPUTE SUM OF "DEPARTMENT 10" "DEPARTMENT 20" -
REMARK^17^               "DEPARTMENT 30" "TOTAL BY JOB" ON REPORT
REMARK^18^               REM Each column displays the sums of salaries by job
REMARK^19^               REM for one of the departments 10, 20, 30.
REMARK^20^               SELECT JOB,
REMARK^21^                      SUM( DECODE( DEPTNO, 10, SAL, 0)) "DEPARTMENT 10",
REMARK^22^                      SUM( DECODE( DEPTNO, 20, SAL, 0)) "DEPARTMENT 20",
REMARK^23^                      SUM( DECODE( DEPTNO, 30, SAL, 0)) "DEPARTMENT 30",
REMARK^24^                      SUM(SAL) "TOTAL BY JOB"
REMARK^25^               FROM EMP
REMARK^26^               GROUP BY JOB
REMARK^27^
REMARK^28^
REMARK^29^ See also: /, @, comments, edit, get, start, run, whenever sqlerror,
REMARK^30^           commands.
REMARK^31^
RESERVED WORDS^1^
RESERVED WORDS^2^
RESERVED WORDS^3^                            Reserved Words
RESERVED WORDS^4^
RESERVED WORDS^5^ The following words have special meaning in SQL and PL/SQL, and may
RESERVED WORDS^6^ not be used for identifier names (unless enclosed in "quotes"):
RESERVED WORDS^7^
RESERVED WORDS^8^ ABORT      AUDIT           CLUSTERS     DATA_BASE      DISPOSE
RESERVED WORDS^9^ ACCEPT     AUTHORIZATION   COLAUTH      DATE           DISTINCT
RESERVED WORDS^10^ ACCESS     AVG             COLUMN       DBA            DO
RESERVED WORDS^11^ ADD        BEGIN           COMMENT      DEBUGOFF       DROP
RESERVED WORDS^12^ ALL        BETWEEN         COMMIT       DEBUGON        ELSE
RESERVED WORDS^13^ ALTER      BODY            COMPRESS     DECIMAL        ELSIF
RESERVED WORDS^14^ AND        BOOLEAN         CONNECT      DECLARE        END
RESERVED WORDS^15^ ANY        BY              CONSTANT     DEFAULT        ENTRY
RESERVED WORDS^16^ ARRAY      CASE            COUNT        DEFINITION     EXCEPTION
RESERVED WORDS^17^ AS         CHAR            CRASH        DELAY          EXCEPTION_INIT
RESERVED WORDS^18^ ASC        CHAR_BASE       CREATE       DELETE         EXCLUSIVE
RESERVED WORDS^19^ ASSERT     CHECK           CURRENT      DELTA          EXISTS
RESERVED WORDS^20^ ASSIGN     CLOSE           CURSOR       DESC           EXIT
RESERVED WORDS^21^ AT         CLUSTER         DATABASE     DIGITS         FALSE
RESERVED WORDS^22^
RESERVED WORDS^23^ FETCH        IF            LIKE         NOCOMPRESS     OTHERS
RESERVED WORDS^24^ FILE         IMMEDIATE     LIMITED      NOT            OUT
RESERVED WORDS^25^ FLOAT        IN            LOCK         NOWAIT         PACKAGE
RESERVED WORDS^26^ FOR          INCREMENT     LONG         NULL           PARTITION
RESERVED WORDS^27^ FORM         INDEX         LOOP         NUMBER         PCTFREE
RESERVED WORDS^28^ FROM         INDEXES       MAX          NUMBER_BASE    PRAGMA
RESERVED WORDS^29^ FUNCTION     INDICATOR     MAXEXTENTS   OF             PRIOR
RESERVED WORDS^30^ GENERIC      INITIAL       MIN          OFFLINE        PRIVATE
RESERVED WORDS^31^ GOTO         INSERT        MINUS        ON             PRIVILEGES
RESERVED WORDS^32^ GRANT        INTEGER       MOD          ONLINE         PROCEDURE
RESERVED WORDS^33^ GRAPHIC      INTERSECT     MODE         OPEN           PUBLIC
RESERVED WORDS^34^ GROUP        INTO          MODIFY       OPTION         RAISE
RESERVED WORDS^35^ HAVING       IS            NEW          OR             RANGE
RESERVED WORDS^36^ IDENTIFIED   LEVEL         NOAUDIT      ORDER          RAW
RESERVED WORDS^37^
RESERVED WORDS^38^ RECORD       ROWTYPE       SQLERRM      THEN           VARGRAPH
RESERVED WORDS^39^ RELEASE      RUN           START        TO             VARIANCE
RESERVED WORDS^40^ REM          SAVEPOINT     STATEMENT    TRIGGER        VIEW
RESERVED WORDS^41^ REMARK       SCHEMA        STDDEV       TRUE           VIEWS
RESERVED WORDS^42^ RENAME       SELECT        SUBTYPE      TYPE           WHEN
RESERVED WORDS^43^ RESOURCE     SEPARATE      SUCCESSFUL   UID            WHENEVER
RESERVED WORDS^44^ RETURN       SESSION       SUM          UNION          WHERE
RESERVED WORDS^45^ REVERSE      SET           SYNONYM      UNIQUE         WHILE
RESERVED WORDS^46^ REVOKE       SHARE         SYSDATE      UPDATE         WITH
RESERVED WORDS^47^ ROLLBACK     SIZE          TABAUTH      USE            WORK
RESERVED WORDS^48^ ROW          SMALLINT      TABLE        USER           XOR
RESERVED WORDS^49^ ROWID        SPACE         TABLES       VALIDATE
RESERVED WORDS^50^ ROWNUM       SQL           TASK         VALUES
RESERVED WORDS^51^ ROWS         SQLCODE       TERMINATE    VARCHAR
RESERVED WORDS^52^
RESERVED WORDS^53^
RESERVED WORDS^54^
RESERVED WORDS^55^ See also: commands.
RESERVED WORDS^56^
RUN^1^
RUN^2^
RUN^3^                                     RUN
RUN^4^
RUN^5^ R[UN]
RUN^6^
RUN^7^ RUN lists and executes the SQL command or PL/SQL block currently in the
RUN^8^ SQL buffer.  RUN makes the last line of the SQL buffer the current line.
RUN^9^ The slash command (/) works like RUN, but doesn't list the command.
RUN^10^
RUN^11^    Example:  The SQL buffer contains the query:
RUN^12^
RUN^13^               SELECT DEPTNO FROM DEPT
RUN^14^
RUN^15^           To RUN the query, enter:
RUN^16^
RUN^17^               SQL> RUN
RUN^18^
RUN^19^           Output:  1* SELECT DEPTNO FROM DEPT
RUN^20^
RUN^21^                    DEPTNO
RUN^22^                    ------
RUN^23^                        10
RUN^24^                        20
RUN^25^                        30
RUN^26^                        40
RUN^27^
RUN^28^
RUN^29^ See also: /, @, edit, get, list, parameters, save, spool, start,
RUN^30^           SQL in PL/SQL, commands.
RUN^31^
RUNFORM^1^
RUNFORM^2^
RUNFORM^3^                                   RUNFORM
RUNFORM^4^
RUNFORM^5^ RUNFORM [options]  form_name
RUNFORM^6^
RUNFORM^7^ RUNFORM invokes a SQL*Forms application from within SQL*Plus.  Note: You
RUNFORM^8^ have access to this command only if your site chose this option while
RUNFORM^9^ installing SQL*Plus.
RUNFORM^10^
RUNFORM^11^     [options]
RUNFORM^12^         See your SQL*Forms Designer's Reference Manual for details.
RUNFORM^13^
RUNFORM^14^     form_name
RUNFORM^15^         See your SQL*Forms Designer's Reference Manual for details.
RUNFORM^16^
RUNFORM^17^ The RUNFORM syntax is the same in both SQL*Plus and SQL*Forms.  You can
RUNFORM^18^ invoke a form more quickly in SQL*Plus than you can from the system prompt
RUNFORM^19^ because you avoid a separate Oracle logon.
RUNFORM^20^
RUNFORM^21^ When you invoke a form in SQL*Plus (by using RUNFORM), do not specify a
RUNFORM^22^ username/password (you retain your current connection to Oracle).  To use
RUNFORM^23^ another username/password, use the CONNECT command to connect to the
RUNFORM^24^ username before issuing the RUNFORM command.
RUNFORM^25^
RUNFORM^26^
RUNFORM^27^ Example:  To run a form named MYFORM, enter:
RUNFORM^28^
RUNFORM^29^               SQL> RUNFORM MYFORM
RUNFORM^30^
RUNFORM^31^
RUNFORM^32^ See also:  commands.
RUNFORM^33^
SAVE^1^
SAVE^2^
SAVE^3^                                         SAVE
SAVE^4^
SAVE^5^ SAV[E] file_name[.ext] [CRE[ATE]|REP[LACE]|APP[END]]
SAVE^6^
SAVE^7^ SAVE stores the SQL buffer's contents in a host operating system command
SAVE^8^ file.
SAVE^9^
SAVE^10^     file_name[.ext ]
SAVE^11^         specifies the command file in which to save the buffer's
SAVE^12^         contents.
SAVE^13^
SAVE^14^     CRE[ATE]
SAVE^15^         creates the file if the file does not exist.
SAVE^16^
SAVE^17^     REP[LACE]
SAVE^18^         replaces the contents of an existing file.  If the file does not
SAVE^19^         exist, REPLACE creates the file.
SAVE^20^
SAVE^21^     APP[END]
SAVE^22^         adds the contents of the buffer to the end of the specified file.
SAVE^23^
SAVE^24^
SAVE^25^ When you SAVE the contents of the SQL buffer, SAVE adds a line containing
SAVE^26^ a slash (/) to the end of the file.  If you don't specify an extension,
SAVE^27^ SQL*Plus assumes the default extension (normally SQL).
SAVE^28^
SAVE^29^ To SAVE a file under a name identical to a SAVE command clause (CREATE,
SAVE^30^ REPLACE, or APPEND), you must specify a file extension.
SAVE^31^
SAVE^32^
SAVE^33^ Example:  To save the buffer's contents in file DEPTSALRPT.SQL, enter:
SAVE^34^
SAVE^35^               SQL> SAVE DEPTSALRPT
SAVE^36^
SAVE^37^
SAVE^38^           To save the buffer's contents in file DEPTSALRPT.OLD, enter:
SAVE^39^
SAVE^40^               SQL> SAVE DEPTSALRPT.OLD
SAVE^41^
SAVE^42^ See also:  commands.
SAVE^43^
SET^1^
SET^2^
SET^3^                                     SET
SET^4^
SET^5^ SET system_variable value
SET^6^
SET^7^   ARRAY[SIZE] {20|n}                       NEWP[AGE] {1|n}
SET^8^   AUTO[COMMIT] {OFF|ON|IMM[EDIATE|n]}      NULL text
SET^9^   AUTOP[RINT] {OFF|ON}                     NUMF[ORMAT] format
SET^10^   BLO[CKTERMINATOR] {.|c}                  NUM[WIDTH] {10|n}
SET^11^   CLOSECUR[SOR] {OFF|ON}                   PAGES[IZE] {24|n}
SET^12^   CMDS[EP] {;|c|OFF|ON}                    PAU[SE] {OFF|ON|text}
SET^13^   COLSEP { |text}                          RECSEP {WR[APPED]|EA[CH]|OFF}
SET^14^   COM[PATIBILITY] {V6|V7|NATIVE}           RECSEPCHAR { |c}
SET^15^   CON[CAT] {.|c|OFF|ON}                    SERVEROUT[PUT] {OFF|ON} [SIZE n]
SET^16^   COPYC[OMMIT] {0|n}                       SHOW[MODE] {OFF|ON}
SET^17^   COPYTYPECHECK {OFF|ON}                   SQLC[ASE] {MIX[ED]|LO[WER]|UP[PER]}
SET^18^   CRT crt                                  SQLCO[NTINUE] {> | text}
SET^19^   DEF[INE] {&|c|OFF|ON}                    SQLN[UMBER] {OFF|ON}
SET^20^   ECHO {OFF|ON}                            SQLPRE[FIX] {#|c}
SET^21^   EDITF[ILE] file_name[.ext]               SQLP[ROMPT] {SQL>|text}
SET^22^   EMBEDDED {OFF|ON}                        SQLT[ERMINATOR] {;|c|OFF|ON}
SET^23^   ESC[APE] {\|c|OFF|ON}                    SUF[FIX] {SQL|text}
SET^24^   FEED[BACK] {6|n|OFF|ON}                  TAB {OFF|ON}
SET^25^   FLAGGER {OFF|ENTRY|INTERMED[IATE]|FULL}  TERM[OUT] {OFF|ON}
SET^26^   FLU[SH] {OFF|ON}                         TI[ME] {OFF|ON}
SET^27^   HEA[DING] {OFF|ON}                       TIMI[NG] {OFF|ON}
SET^28^   HEADS[EP] {||c|OFF|ON}                   TRIM[OUT] {OFF|ON}
SET^29^   LIN[ESIZE] {80|n}                        TRIMS[POOL] {ON|OFF}
SET^30^   LONG {80|n}                              UND[ERLINE] {-|c|ON|OFF}
SET^31^   LONGC[HUNKSIZE] {80|n}                   VER[IFY] {OFF|ON}
SET^32^   MAXD[ATA] n                              WRA[P] {OFF|ON}
SET^33^
SET^34^
SET^35^ Use SET to control SQL*Plus environment settings for the current session;
SET^36^ for example:
SET^37^                -   the display width for NUMBER data
SET^38^                -   the display width for LONG data
SET^39^                -   enabling or disabling the printing of column headings
SET^40^                -   the number of lines per page
SET^41^
SET^42^     ARRAY[SIZE] {20|n}
SET^43^         sets the number of rows called a batch that SQL*Plus will fetch from
SET^44^         the database at one time (Range: 1 - 5000). A large value increases
SET^45^         the efficiency of queries and subqueries that fetch many rows, but
SET^46^         requires more memory; values over 100 or so provide little added
SET^47^         performance.  ARRAYSIZE only improves the efficiency of SQL*Plus
SET^48^         operations; it has no other effect.
SET^49^
SET^50^     AUTO[COMMIT] {OFF|ON|IMM[EDIATE]|n}
SET^51^         controls when Oracle commits pending changes to the database.  ON
SET^52^         commits pending changes to the database after Oracle executes each
SET^53^         SQL command or PL/SQL block.  OFF suppresses automatic committing,
SET^54^         so changes must be committed manually (with COMMIT, for example).
SET^55^         IMMEDIATE works just like ON.  n commits pending changes to the
SET^56^         database after Oracle executes n INSERT, UPDATE or DELETE commands
SET^57^         or PL/SQL blocks.  The statement counter is reset to zero after
SET^58^         successful completion of:  n INSERT, UPDATE or DELETE commands or
SET^59^         PL/SQL blocks; a commit; a rollback; or a SET AUTOCOMMIT command.
SET^60^         A PL/SQL block is regarded as one transaction, regardless of the
SET^61^         number of SQL commands in it.
SET^62^
SET^63^     AUTOP[RINT] {OFF|ON}
SET^64^         sets the automatic PRINTing of bind variables.  ON or OFF controls
SET^65^         whether SQL*Plus automatically displays bind variables (referenced
SET^66^         in a successful PL/SQL block, or used in an EXECUTE command).  See
SET^67^         the PRINT command for more information about displaying bind
SET^68^         variables.
SET^69^
SET^70^     BLO[CKTERMINATOR] {.|c}
SET^71^         sets the non-alphanumeric character that ends PL/SQL blocks to c.
SET^72^         To execute the block, issue a RUN or slash (/) command.
SET^73^
SET^74^     CLOSECUR[SOR] {OFF|ON}
SET^75^         sets the cursor usage behavior.  ON or OFF sets whether or not
SET^76^         the cursor will close and reopen after each SQL statement.
SET^77^         This feature may be useful in some environments to release
SET^78^         resources in the database server.
SET^79^
SET^80^     CMDS[EP] {;|c|ON|OFF}
SET^81^         sets the non-alphanumeric character used between multiple SQL*Plus
SET^82^         commands entered on one line to c.  ON or OFF sets whether or not
SET^83^         multiple commands can be entered on a line; ON automatically makes
SET^84^         ; (a semicolon) the command separator character.
SET^85^
SET^86^     COLSEP { |text}
SET^87^         sets the text to be printed between SELECTed columns. If the
SET^88^         COLSEP variable contains blanks or punctuation characters, you
SET^89^         must enclose it with single quotes. The default is a space.
SET^90^         In multi-line rows, the column separator does not print between
SET^91^         columns that begin on different lines.  The column separator
SET^92^         does not appear on blank lines produced by BREAK ... SKIP n and
SET^93^         does not overwrite the record separator.
SET^94^
SET^95^     COM[PATIBILITY] {V6|V7|NATIVE}
SET^96^         specifies the version of Oracle to which you are connected.
SET^97^         Set COMPATIBILITY to V6 for Version 6 or V7 for Oracle7. Set
SET^98^         COMPATABILITY to NATIVE if you wish the database to determine the
SET^99^         setting (for example, if connected to Oracle7, COMPATIBILITY would
SET^100^         default to V7).  Note that you can set COMPATIBILITY to V6 when
SET^101^         connected to Oracle7.  This enables you to run Version 6 SQL
SET^102^         against Oracle7.
SET^103^
SET^104^         Setting COMPATIBILITY to V6 causes SQL*Plus to treat CHAR
SET^105^         column values as variable length character strings.
SET^106^         Setting COMPATIBILITY to V7 causes SQL*Plus to treat CHAR
SET^107^         COLUMN VALUES as fixed length character strings and
SET^108^         VARCHAR2 (VARCHAR) column values as variable length
SET^109^         character strings.
SET^110^
SET^111^         See the Oracle7 Server documentation for a list of changes
SET^112^         from Version 6 to Oracle7.
SET^113^
SET^114^     CON[CAT] {.|c|OFF|ON}
SET^115^         sets the character you can use to end a substitution variable name
SET^116^         when you want to use a character after the variable that SQL*Plus
SET^117^         would otherwise see as a part of the variable's name.  SQL*Plus
SET^118^         resets the value of CONCAT to a period when you switch CONCAT on.
SET^119^
SET^120^     COPYC[OMMIT] {0|n}
SET^121^         controls the number of batches processed before the COPY command
SET^122^         commits database changes (Range: 0 - 5000).  Set the size of a
SET^123^         batch with the ARRAYSIZE variable.  If you set COPYCOMMIT to zero,
SET^124^         COPY commits changes only at the end of a copy operation.
SET^125^
SET^126^     COPYTYPECHECK {OFF|ON}
SET^127^         sets the suppression of the comparison of datatypes whilst
SET^128^         inserting or appending to tables with the COPY command.  This is
SET^129^         to facilitate copying to DB2 which requires that a CHAR be copied
SET^130^         to a DB2 DATE.
SET^131^
SET^132^     CRT crt
SET^133^         changes the default CRT file used in the SQL*Plus RUNFORM command.
SET^134^         To return to the original default (before CRT was set), set CRT to
SET^135^         nothing by entering two double quotes ("") for crt.
SET^136^
SET^137^         To use NEW.CRT during a form invocation on a system where the
SET^138^         default CRT is OLD.CRT, invoke the form with either:
SET^139^
SET^140^               SQL> RUNFORM -c NEW form_name
SET^141^         or    SQL> SET CRT NEWSQL> RUNFORM form_name
SET^142^
SET^143^         The second method stores the CRT option; you don't have to
SET^144^         re-specify it for additional RUNFORM commands during the same
SET^145^         SQL*Plus session.
SET^146^
SET^147^     DEF[INE] {&|c|OFF|ON}
SET^148^         sets c to be the character in front of substitution variables.
SET^149^         ON or OFF sets whether or not SQL*Plus will scan commands for
SET^150^         substitution variables and replace them with their values.
SET^151^         ON changes the value of c back to the default '&' and not
SET^152^         the most recently used character.
SET^153^
SET^154^     ECHO {OFF|ON}
SET^155^         sets whether START lists each command in a command file as the
SET^156^         command is executed.  ON lists the commands; OFF does not.
SET^157^
SET^158^     EDITF[ILE] file_name[.ext]
SET^159^         sets the default filename for the EDIT command.  You can include
SET^160^         a path and/or extension.
SET^161^
SET^162^     EMBEDDED {OFF|ON}
SET^163^         controls each report begins on a page.  OFF starts each report at
SET^164^         the top of a new page; ON allows a report to begin anywhere.  Set
SET^165^         EMBEDDED to ON to start printing a report immediately after the
SET^166^         previous one.
SET^167^
SET^168^         Note:  When you use SET EMBEDDED ON and change the pagesize with
SET^169^         SET PAGESIZE n, SQL*Plus finishes the current page using the
SET^170^         existing pagesize setting and, if required, begins a new page
SET^171^         with the new pagesize setting.
SET^172^
SET^173^         Note:  When using a BTITLE with SET EMBEDDED ON, the second and
SET^174^         subsequent SELECTs will always begin on a new page.  This is
SET^175^         because SQL*Plus has no input read ahead.  Since SQL*Plus cannot
SET^176^         tell whether you will enter another SELECT, or, for example,
SET^177^         EXIT, SQL*Plus has to complete processing all output from the
SET^178^         first SELECT before it reads the next command.  This
SET^179^         processing includes printing the BTITLE.  Hence, given two
SET^180^         SELECTs, SQL*Plus prints the final BTITLE of the first SELECT
SET^181^         before it processes the second.  The second SELECT will then
SET^182^         begin at the top of a new page.
SET^183^
SET^184^     ESC[APE] {\|c|OFF|ON}
SET^185^         defines the character you enter as the escape character.  OFF
SET^186^         undefines the escape character.  ON enables the escape character.
SET^187^         ON changes the value of c back to the default "\".
SET^188^
SET^189^         Use the escape character before the substitution character (set
SET^190^         with SET DEFINE) to have SQL*Plus treat the substitution character
SET^191^         as an ordinary character, not a request for variable substitution.
SET^192^
SET^193^     FEED[BACK] {6|n|OFF|ON}
SET^194^         shows the number of records returned by a query when at n or more
SET^195^         records are selected.  ON sets n to 1.  Zero is the same as OFF.
SET^196^
SET^197^     FLAGGER {OFF|ENTRY|INTERMED[IATE]|FULL}
SET^198^         checks to make sure that SQL statements conform to the ANSI/ISO
SET^199^         SQL92 standard.  If any non-standard constructs are found, the
SET^200^         Oracle server flags them as errors and displays the violating
SET^201^         syntax.  This is the equivalent of the SQL language ALTER SESSION
SET^202^         SET FLAGGER command.  However, you may execute SET FLAGGER even if
SET^203^         you are not connected to a database. FIPS flagging will remain in
SET^204^         effect across SQL*Plus sessions until a SET FLAGGER OFF (or ALTER
SET^205^         SESSION SET FLAGGER = OFF) command is successful or you exit
SET^206^         SQL*Plus.
SET^207^
SET^208^         When FIPS flagging is enabled, SQL*Plus will display a warning for
SET^209^         the following three commands, even if they are successful:
SET^210^
SET^211^               CONNECT
SET^212^               DISCONNECT
SET^213^               ALTER SESSION SET FLAGGER
SET^214^
SET^215^     FLU[SH] {OFF|ON}
SET^216^         controls when output goes to the display device.  OFF allows the
SET^217^         host operating system to buffer output.  ON disables buffering.
SET^218^
SET^219^         Use FLUSH OFF only when running a command file non-interactively
SET^220^         to suppress output and prompts until the run is over.  FLUSH OFF
SET^221^         may improve performance by reducing the amount of program I/O.
SET^222^
SET^223^     HEA[DING] {OFF|ON}
SET^224^         controls printing of column headings in reports.  ON prints column
SET^225^         headings in reports; OFF suppresses column headings.
SET^226^
SET^227^     HEADS[EP] {||c|OFF|ON}
SET^228^         sets the character you enter as the heading separator character.
SET^229^         The heading separator character cannot be alphanumeric or white
SET^230^         space.  You can use the heading separator character in the COLUMN
SET^231^         command and in the old forms of BTITLE and TTITLE to divide a
SET^232^         column heading or title onto more than one line.  Set HEADSEP OFF
SET^233^         to print a heading separator character like any other character.
SET^234^         ON changes the value of c back to the default "\".
SET^235^
SET^236^     LIN[ESIZE] {80|n}
SET^237^         sets the total number of characters displayed on a line before
SET^238^         starting a new line, and controls the position of centered and
SET^239^         right-aligned text in TTITLE and BTITLE.  The range is 1 to
SET^240^         a system dependent maximum.
SET^241^
SET^242^     LONG {80|n}
SET^243^         sets the maximum width for displaying and copying LONG values; the
SET^244^         maximum value of n is two gigabytes.
SET^245^
SET^246^     LONGC[HUNKSIZE] {80|n}
SET^247^         sets the size, in characters, of the increments in which SQL*Plus
SET^248^         retrieves a LONG value.  When retrieving a LONG value you may
SET^249^         want to retrieve it in increments rather than all at once
SET^250^         because of memory restrictions.  Valid values are 1 to whatever
SET^251^         has been set with MAXDATA.  Note that the value may not
SET^252^         exceed the value set with LONG.  Applies only to Oracle7.
SET^253^
SET^254^     MAXD[ATA] n
SET^255^         sets the maximum size, in bytes, of all ARRAYSIZE rows.  The
SET^256^         default and maximum values of n are system dependent.
SET^257^
SET^258^     NEWP[AGE] {1|n}
SET^259^         sets the number of blank lines printed between the beginning of
SET^260^         each page and the top title.  A value of zero sends a formfeed
SET^261^         between pages and clears the screen on most terminals.
SET^262^
SET^263^     NULL text
SET^264^         sets the text to represent a null value in the result of a SELECT
SET^265^         statement.  Use the NULL clause of the COLUMN command to override
SET^266^         the setting of the NULL variable for a given column.
SET^267^
SET^268^     NUMF[ORMAT] format
SET^269^         sets the default format for displaying numbers.  Enter a number
SET^270^         format for format.  See FORMAT NUMBERS for format descriptions.
SET^271^
SET^272^     NUM[WIDTH] {10|n}
SET^273^         sets the default width for displaying numbers.
SET^274^
SET^275^     PAGES[IZE] {24|n}
SET^276^         sets the number of lines in each page.  Set PAGESIZE to zero to
SET^277^         suppress headings, page breaks, titles, the initial blank line,
SET^278^         and other formatting information.
SET^279^
SET^280^     PAU[SE] {OFF|ON|text}
SET^281^         controls scrolling on the terminal when running reports.  ON
SET^282^         pauses at the beginning of each page of report output.  Press
SET^283^         RETURN or [Clear] after each pause.  text specifies the text
SET^284^         displayed whenever SQL*Plus pauses.  To enter multiple words,
SET^285^         enclose text in single quotes.
SET^286^
SET^287^         You can embed terminal-dependent escape sequences in PAUSE to
SET^288^         create inverse video messages and other effects, where supported.
SET^289^
SET^290^     RECSEP {WR[APPED]|EA[CH]|OFF}
SET^291^     RECSEPCHAR { |c}
SET^292^         displays or prints record separators.  A record separator is the
SET^293^         RECSEPCHAR (character) repeated LINESIZE times on a single line.
SET^294^
SET^295^         RECSEPCHAR is the record separating character.  Default = space.
SET^296^
SET^297^         RECSEP sets where the record separation occurs.  WRAPPED prints a
SET^298^         record separator only after wrapped lines.  EACH prints a record
SET^299^         separator after every row.  OFF does not print a record separator.
SET^300^
SET^301^     SERVEROUT[PUT] {OFF|ON} [SIZE n]
SET^302^         controls whether to display  the output (DBMS_OUTPUT.PUT_LINE)
SET^303^         of stored procedures or PL/SQL blocks in SQL*Plus.  OFF suppresses
SET^304^         the output of DBMS_OUTPUT.PUT_LINE; ON displays the output.
SET^305^
SET^306^         Output is always formatted in the same way as using WORD_WRAPPED
SET^307^         on a column.  See the COLUMN command for more information on
SET^308^         WORD_WRAPPED.
SET^309^
SET^310^         SIZE sets the number of bytes of the output that can be
SET^311^         buffered within the Oracle7 Server.  The default for n is 2000.
SET^312^         n cannot be less than 2000 or greater than 1,000,000.
SET^313^
SET^314^         Note:  The output is displayed synchronously after the
SET^315^         stored procedure or PL/SQL block has been executed by the Oracle7
SET^316^         Server.
SET^317^
SET^318^     SHOW[MODE] {OFF|ON}
SET^319^         controls whether or not SQL*Plus lists the old and new settings of
SET^320^         a SQL*Plus system variable when you change the setting with SET.
SET^321^         ON lists the settings; OFF does not.  SHOWMODE ON has the same
SET^322^         behavior as the obsolete SHOWMODE BOTH.
SET^323^
SET^324^     SQLC[ASE] {MIX[ED]|LO[WER]|UP[PER]}
SET^325^         changes the case of SQL commands and PL/SQL blocks just prior to
SET^326^         execution.  SQL*Plus converts all text in the command, including
SET^327^         quoted literals and identifiers, as follows:
SET^328^
SET^329^               uppercase if SQLCASE equals UPPER
SET^330^               lowercase if SQLCASE equals LOWER
SET^331^               unchanged if SQLCASE equals MIXED
SET^332^
SET^333^     SQLCASE does not change the SQL buffer itself.
SET^334^
SET^335^     SQLCO[NTINUE] {>|text}
SET^336^         sets the character sequence SQL*Plus displays as a prompt after
SET^337^         you use - (hyphen) to continue a SQL*Plus command on a new line.
SET^338^
SET^339^     SQLN[UMBER] {OFF|ON}
SET^340^         sets the prompt for the second and subsequent lines of a SQL
SET^341^         command or PL/SQL block.  ON sets the prompt to be the line
SET^342^         number.  OFF sets the prompt to the value of SQLPROMPT.
SET^343^
SET^344^     SQLPRE[FIX] {#|c}
SET^345^         sets the SQL*Plus prefix character.  While entering a SQL command
SET^346^         or PL/SQL block, you can enter a SQL*Plus command on a separate
SET^347^         line, prefixed by the SQL*Plus prefix character, to execute the
SET^348^         command immediately without affecting the SQL command or PL/SQL
SET^349^         block. The prefix character must be non-alphanumeric.
SET^350^
SET^351^     SQLP[ROMPT] {SQL>|text}
SET^352^         sets the SQL*Plus command prompt.
SET^353^
SET^354^     SQLT[ERMINATOR] {;|c|OFF|ON}
SET^355^         sets to c the character used to end and execute SQL command.  OFF
SET^356^         recognizes no command terminator; you terminate a SQL command by
SET^357^         entering an empty line. ON resets the terminator to ; (semicolon).
SET^358^
SET^359^     SUF[FIX] {SQL|text}
SET^360^         sets the default file extension that SQL*Plus uses in commands
SET^361^         that refer to command files.  SUFFIX does not control extensions
SET^362^         for spool files.
SET^363^
SET^364^     TAB {OFF|ON}
SET^365^         controls how SQL*Plus formats white space in the output.  OFF uses
SET^366^         spaces to add white space in the output.  ON uses TAB characters.
SET^367^         TAB settings are every eight characters.  The default value is
SET^368^         system dependent.
SET^369^
SET^370^     TERM[OUT] {OFF|ON}
SET^371^         controls the display of output generated by commands executed from
SET^372^         a command file.  OFF suppresses the display so you can spool output
SET^373^         from a command file without displaying the output.  ON shows the
SET^374^         output.  TERMOUT OFF doesn't affect interactively-entered command
SET^375^         output.
SET^376^
SET^377^     TI[ME] {OFF|ON}
SET^378^         controls the display of the current time.  ON displays the current
SET^379^         time before each command prompt.  OFF suppresses the time display.
SET^380^
SET^381^     TIMI[NG] {OFF|ON}
SET^382^         sets the display of timing statistics.  ON shows timing statistics
SET^383^         for each SQL command or PL/SQL block run.  OFF suppresses timing.
SET^384^         Use the TIMING command to control the timing of multiple commands.
SET^385^
SET^386^     TRIM[OUT] {OFF|ON}
SET^387^         determines whether SQL*Plus allows trailing blanks at the end of
SET^388^         each displayed line.  ON removes blanks at the end of each line,
SET^389^         improving performance especially when using a slow communications
SET^390^         device.  OFF displays trailing blanks.  TRIMOUT ON does not affect
SET^391^         spooled output.
SET^392^
SET^393^     TRIMS[POOL] {ON|OFF}
SET^394^         determines whether SQL*Plus allows trailing blanks at the end of
SET^395^         each spooled line.  ON removes blanks at the end of each line.
SET^396^         OFF allows SQL*Plus to include trailing blanks.  TRIMSPOOL ON
SET^397^         does not affect terminal output.
SET^398^
SET^399^     UND[ERLINE] {-|c|ON|OFF}
SET^400^         sets the character used to underline column headings in SQL*Plus
SET^401^         reports to c.  ON or OFF turns underlining on or off.  ON changes
SET^402^         the value of c back to the default "-".
SET^403^
SET^404^     VER[IFY] {OFF|ON}
SET^405^         controls whether SQL*Plus lists the text of a SQL statement or
SET^406^         PL/SQL command before and after SQL*Plus replaces substitution
SET^407^         variables with values.  ON lists the text; OFF suppresses the
SET^408^         listing.
SET^409^
SET^410^     WRA[P] {OFF|ON}
SET^411^         controls whether SQL*Plus truncates the display of a SELECTed row
SET^412^         if it is longer than the current line width.  OFF truncates it; ON
SET^413^         allows it to wrap to the next line.  The COLUMN command's WRAPPED
SET^414^         and TRUNCATED override the WRAP setting for specific columns.
SET^415^
SET^416^
SET^417^ SQL*Plus maintains system variables (SET command variables) so you can
SET^418^ tailor the environment for a SQL*Plus session.  You change these system
SET^419^ variables with the SET command and list them with the SHOW command.
SET^420^
SET^421^ SET ROLE and SET TRANSACTION are SQL commands.
SET^422^
SET^423^ Examples: Here are some uses of SET command variables:
SET^424^
SET^425^           CMDSEP - To specify a TTITLE and format a column on the same
SET^426^           line:
SET^427^
SET^428^               SQL> SET CMDSEP +
SET^429^               SQL> TTITLE LEFT 'SALARIES' + COLUMN SAL FORMAT $9,999
SET^430^               SQL> SELECT ENAME, SAL FROM EMP
SET^431^                 2  WHERE JOB = 'CLERK';
SET^432^
SET^433^           The following output results:
SET^434^
SET^435^               SALARIES
SET^436^               ENAME          SAL
SET^437^               ---------- -------
SET^438^               SMITH         $800
SET^439^               ADAMS       $1,100
SET^440^               JAMES         $950
SET^441^               MILLER      $1,300
SET^442^
SET^443^           COLUMN SEPARATOR - To set the column separator to "|":
SET^444^
SET^445^               SQL> SET COLSEP '|'
SET^446^               SQL> SELECT ENAME, JOB, DEPTNO
SET^447^                 2  FROM EMP
SET^448^                 3  WHERE DEPTNO = 20;
SET^449^
SET^450^           The following output results:
SET^451^
SET^452^               ENAME      |JOB      |   DEPTNO
SET^453^               -------------------------------
SET^454^               SMITH      |CLERK    |       20
SET^455^               JONES      |MANAGER  |       20
SET^456^               SCOTT      |ANALYST  |       20
SET^457^               ADAMS      |CLERK    |       20
SET^458^               FORD       |ANALYST  |       20
SET^459^
SET^460^           COMPATIBILITY - To run command file SALARY.SQL, created with
SET^461^           Version 6 of Oracle, enter:
SET^462^
SET^463^               SQL> SET COMPATIBILITY V6
SET^464^               SQL> START SALARY
SET^465^
SET^466^           After running the file, reset compatibility to V7:
SET^467^
SET^468^               SQL> SET COMPATIBILITY V7
SET^469^
SET^470^           Or you could add SET COMPATIBILITY V6 to the beginning of the
SET^471^           command file, and reset COMPATIBILITY to V7 at its end.
SET^472^
SET^473^           ESCAPE - If you define the escape character as !, then:
SET^474^
SET^475^                SQL> SET ESCAPE !
SET^476^                SQL> ACCEPT v1 PROMPT 'Enter !&1:'
SET^477^
SET^478^           displays the prompt:  Enter &1:
SET^479^
SET^480^           HEADING - The next example suppresses the display of column
SET^481^           headings in a report, then runs a SELECT statement:
SET^482^
SET^483^               SQL> SET HEADING OFF
SET^484^               SQL> SELECT ENAME, SAL FROM EMP
SET^485^                 2  WHERE JOB = 'CLERK';
SET^486^
SET^487^           Output:  ADAMS        1100
SET^488^                    JAMES         950
SET^489^                    MILLER       1300
SET^490^
SET^491^           LONG - To set the maximum width for displaying and copying LONG
SET^492^           values to 500, enter:
SET^493^
SET^494^               SQL> SET LONG 500
SET^495^
SET^496^           The LONG data will wrap on your screen; SQL*Plus truncates at
SET^497^           the 501st character.
SET^498^
SET^499^           LONGCHUNKSIZE - To set the size of the increments in which
SET^500^           SQL*Plus retrieves LONG values to 100 characters enter:
SET^501^
SET^502^               SQL> SET LONGCHUNKSIZE 100
SET^503^
SET^504^           The LONG data will be retrieved in increments of 100 characters
SET^505^           until the entire value is retrieved, or the value of SET LONG
SET^506^           is reached.
SET^507^
SET^508^           SERVEROUTPUT - To enable the display of DBMS_OUTPUT.PUT_LINE,
SET^509^           enter:
SET^510^
SET^511^               SQL> SET SERVEROUTPUT ON
SET^512^
SET^513^           The following example shows what happens when you execute an
SET^514^           anonymous procedure with SET SERVER OUTPUT ON:
SET^515^
SET^516^               SQL> BEGIN
SET^517^                 2  DBMS_OUTPUT.PUT_LINE('Task is complete');
SET^518^                 3  END;
SET^519^                 4  /
SET^520^               Task is complete.
SET^521^               PL/SQL procedure successfully completed.
SET^522^
SET^523^           The following example shows what happens when you create a
SET^524^           trigger with SET SERVEROUTPUT ON:
SET^525^
SET^526^               SQL> CREATE TRIGGER SERVER_TRIG BEFORE INSERT
SET^527^                 2  OR UPDATE OR DELETE ON SERVER_TAB
SET^528^                 3  BEGIN
SET^529^                 4  DBMS_OUTPUT.PUT_LINE('Task is complete.');
SET^530^                 5  END;
SET^531^                 6  /
SET^532^               Trigger created.
SET^533^               SQL> INSERT INTO SERVER_TAB VALUES ('TEXT');
SET^534^               Task is complete.
SET^535^               1 row created.
SET^536^
SET^537^           SQLCONTINUE - To set the SQL*Plus command continuation prompt to
SET^538^           an exclamation point followed by a space, enter:
SET^539^
SET^540^               SQL> SET SQLCONTINUE '! '
SET^541^
SET^542^           SQL*Plus prompts for continuation as follows:
SET^543^
SET^544^               SQL> TTITLE 'YEARLY INCOME' -
SET^545^               ! RIGHT SQL.PNO SKIP 2 -
SET^546^               ! CENTER 'PC DIVISION'
SET^547^               SQL>
SET^548^
SET^549^           SUFFIX - To set the default command file extension to UFI:
SET^550^
SET^551^               SQL> SET SUFFIX UFI
SET^552^
SET^553^           If you then enter:
SET^554^
SET^555^               SQL> GET EXAMPLE
SET^556^
SET^557^           SQL*Plus looks for file EXAMPLE.UFI instead of file EXAMPLE.SQL.
SET^558^
SET^559^ See also:  commands.
SET^560^
SHOW^1^
SHOW^2^
SHOW^3^                                    SHOW
SHOW^4^
SHOW^5^ SHO[W] option
SHOW^6^
SHOW^7^     where option can be:
SHOW^8^
SHOW^9^     system_variable
SHOW^10^     ALL
SHOW^11^     BTI[TLE]
SHOW^12^     ERR[ORS] [{FUNCTION|PROCEDURE|PACKAGE|PACKAGE BODY|TRIGGER|
SHOW^13^        VIEW} name]
SHOW^14^     LABEL
SHOW^15^     LNO
SHOW^16^     PNO
SHOW^17^     REL[EASE]
SHOW^18^     SPOO[L]
SHOW^19^     SQLCODE
SHOW^20^     TT[ITLE]
SHOW^21^     USER
SHOW^22^
SHOW^23^ Use SHOW to show the value of a SQL*Plus system variable, or the
SHOW^24^ current SQL*Plus environment.
SHOW^25^
SHOW^26^     system_variable
SHOW^27^         is any system variable set by the SET command.
SHOW^28^
SHOW^29^     ALL
SHOW^30^         lists the settings of all SHOW options, except ERRORS and
SHOW^31^         LABEL, in alphabetical order.
SHOW^32^
SHOW^33^     BTI[TLE]
SHOW^34^         shows the current BTITLE definition.
SHOW^35^
SHOW^36^     ERR[ORS] {FUNCTION|PROCEDURE|PACKAGE|PACKAGE BODY|
SHOW^37^        TRIGGER|VIEW} name
SHOW^38^         shows the compilation errors of a stored procedure
SHOW^39^         (includes stored functions, procedures, and packages).
SHOW^40^         When you use the CREATE command to create a stored
SHOW^41^         procedure, a message is displayed if there are any
SHOW^42^         compilation errors.  To see the errors, you use SHOW
SHOW^43^         ERRORS.  When you specify SHOW ERRORS with no
SHOW^44^         arguments, compilation errors for the most recently
SHOW^45^         created or altered stored procedure are displayed.
SHOW^46^         When you specify the type (function, procedure, package,
SHOW^47^         package body, trigger, or view) and the name of the
SHOW^48^         PL/SQL stored procedure, SQL*Plus shows errors for that
SHOW^49^         stored procedure.
SHOW^50^
SHOW^51^         SHOW ERRORS output displays the line and column
SHOW^52^         number of the error (LINE/COL) as well as the error
SHOW^53^         itself (ERROR).  LINE/COL and ERROR have default widths
SHOW^54^         of 8 and 65, respectively.  You can alter these widths
SHOW^55^         using the COLUMN command.
SHOW^56^
SHOW^57^     LABEL
SHOW^58^         shows the security level for the current session.
SHOW^59^
SHOW^60^     LNO shows the current line number--the position in the current page
SHOW^61^         of the display and/or spooled output.
SHOW^62^
SHOW^63^     PNO shows the current page number.
SHOW^64^
SHOW^65^     REL[EASE]
SHOW^66^         shows the release number of Oracle Server SQL*Plus is accessing.
SHOW^67^
SHOW^68^     SPOO[L]
SHOW^69^         shows whether or not output is being spooled.
SHOW^70^
SHOW^71^     SQLCODE
SHOW^72^         shows the value of SQL.SQLCODE; the SQL return code of the most
SHOW^73^         recent operation.
SHOW^74^
SHOW^75^     TTI[TLE]
SHOW^76^         shows the current TTITLE definition.
SHOW^77^
SHOW^78^     USER
SHOW^79^         shows the username currently accessing SQL*Plus.
SHOW^80^
SHOW^81^
SHOW^82^ Example:  To list the current LINESIZE, enter:
SHOW^83^
SHOW^84^               SQL> SHOW LINESIZE
SHOW^85^
SHOW^86^           If the current linesize is 80 characters, SQL*Plus responds:
SHOW^87^
SHOW^88^               linesize 80
SHOW^89^
SHOW^90^           Following is an example of how to show the compilation
SHOW^91^           errors of a PL/SQL procedure:
SHOW^92^
SHOW^93^               SQL> CREATE PROCEDURE ASSIGNVL AS
SHOW^94^                 2     BEGIN ZZZZZZZ; END;
SHOW^95^                 3  /
SHOW^96^               Warning:  Procedure created with compilation errors.
SHOW^97^               SQL> SHOW ERRORS PROCEDURE ASSIGNVL
SHOW^98^               LINE/COL   ERROR
SHOW^99^               --------   -----------------------------------------
SHOW^100^               1/30       PLS-00313: 'ZZZZZZZ' not declared in this scope
SHOW^101^               1/30       PL/SQL:  Statement ignored.
SHOW^102^
SHOW^103^
SHOW^104^ See also:  commands.
SHOW^105^
/^1^
/^2^
/^3^                                / (slash)
/^4^
/^5^ /
/^6^
/^7^ Enter a slash (/) at the command prompt or at a line number prompt to
/^8^ execute a SQL command or PL/SQL block in the SQL buffer.  The slash
/^9^ command works like RUN, but does not list the command on your screen
/^10^ buffer.
/^11^
/^12^ Executing a SQL command or PL/SQL block with the slash does not change the
/^13^ current line number in the SQL buffer unless the command in the buffer has
/^14^ an error.  If so, SQL*Plus makes the line with the error the current line.
/^15^
/^16^ Examples: Type LIST to see the contents of the buffer:
/^17^
/^18^               SQL> LIST
/^19^                 1* SELECT ENAME, JOB FROM EMP WHERE ENAME = 'JAMES'
/^20^
/^21^           Enter slash (/) to execute the command in the buffer:
/^22^
/^23^               SQL> /         Output:  ENAME   JOB
/^24^                                       ------  -----
/^25^                                       JAMES   CLERK
/^26^
/^27^ See also: @, buffer, edit, get, list, run, save, parameters,
/^28^           spool, start, commands.
/^29^
SPOOL^1^
SPOOL^2^
SPOOL^3^                                   SPOOL
SPOOL^4^
SPOOL^5^ SPO[OL] [file_name[.ext]|OFF|OUT]
SPOOL^6^
SPOOL^7^ Use SPOOL to store query results in an operating system file, or send the
SPOOL^8^ file to a printer.
SPOOL^9^
SPOOL^10^     file_name[.ext]
SPOOL^11^         is the name of the file to receive the spool.  SPOOL file_name
SPOOL^12^         begins spooling displayed output to the named file.  If you omit
SPOOL^13^         an extension, SPOOL uses a default extension (usually LST or LIS).
SPOOL^14^
SPOOL^15^     OFF stops spooling.
SPOOL^16^
SPOOL^17^     OUT stops spooling and sends the file to your host computer's default
SPOOL^18^         printer.  for the current spooling status.
SPOOL^19^
SPOOL^20^
SPOOL^21^ To spool output generated by commands in a command file without displaying
SPOOL^22^ the output on the screen, use SET TERMOUT OFF.  SET TERMOUT OFF does not
SPOOL^23^ affect output from commands run interactively.
SPOOL^24^
SPOOL^25^
SPOOL^26^ Examples: To record your displayed output in a file named DIARY using the
SPOOL^27^           default file extension, enter:
SPOOL^28^
SPOOL^29^               SQL> SPOOL DIARY
SPOOL^30^
SPOOL^31^           To stop spooling and print the file on your default printer:
SPOOL^32^
SPOOL^33^               SQL> SPOOL OUT
SPOOL^34^
SPOOL^35^ See also:  commands.
SPOOL^36^
SQLPLUS^1^
SQLPLUS^2^
SQLPLUS^3^                                    SQLPLUS
SQLPLUS^4^
SQLPLUS^5^ SQLPLUS [[-S[ILENT]] [logon] [start]]|-?
SQLPLUS^6^
SQLPLUS^7^     logon:  username[/password][@database_specification]|/|/NOLOG
SQLPLUS^8^     start:  @file_name[.ext ] [arg ...]
SQLPLUS^9^
SQLPLUS^10^
SQLPLUS^11^ SQLPLUS starts SQL*Plus from the operating system prompt.  Start enables
SQLPLUS^12^ you to enter a command filename and arguments.  SQL*Plus passes the
SQLPLUS^13^ arguments to the command file as though you executed the file with the
SQLPLUS^14^ SQL*Plus START command.
SQLPLUS^15^
SQLPLUS^16^ If you omit logon and specify start, SQL*Plus assumes that the first line
SQLPLUS^17^ of the command file contains a valid logon.  If both start and logon are
SQLPLUS^18^ omitted, SQL*Plus prompts for logon information.
SQLPLUS^19^
SQLPLUS^20^     username[/password]
SQLPLUS^21^         are the username and password with which to start SQL*Plus and
SQLPLUS^22^         connect to Oracle.  If omitted, SQL*Plus prompts for them.  If
SQLPLUS^23^         you enter a slash (/) or enter RETURN to the prompt for username,
SQLPLUS^24^         SQL*Plus logs you in with a default logon (see "/" below).
SQLPLUS^25^
SQLPLUS^26^     /   is a default logon using operating system authentication.  In
SQLPLUS^27^         a default logon, SQL*Plus tries to log in with the username
SQLPLUS^28^         OPS$name, where name is your operating system username.  You
SQLPLUS^29^         cannot enter a database_specification with a default logon.
SQLPLUS^30^
SQLPLUS^31^     /NOLOG
SQLPLUS^32^         establishes no initial connection to Oracle.  Before issuing any
SQLPLUS^33^         SQL commands, you must issue a CONNECT command to establish a
SQLPLUS^34^         valid logon.  Use /NOLOG to have a SQL*Plus command file prompt
SQLPLUS^35^         for the username, password or database specification. The first
SQLPLUS^36^         line of this command file is not assumed to contain a logon.
SQLPLUS^37^
SQLPLUS^38^     @database_specification
SQLPLUS^39^         consists of a SQL*Net connection string; the syntax depends on the
SQLPLUS^40^         SQL*Net communications protocol your Oracle installation uses.
SQLPLUS^41^
SQLPLUS^42^     -S[ILENT]
SQLPLUS^43^         suppresses all SQL*Plus information and prompt messages, including
SQLPLUS^44^         the command prompt and the banner usually displayed when SQL*Plus
SQLPLUS^45^         is started.  Use SILENT to make the use of SQL*Plus invisible to
SQLPLUS^46^         the user when invoking SQL*Plus within another program.
SQLPLUS^47^
SQLPLUS^48^     -?  makes SQLPLUS display its current version and level number, then
SQLPLUS^49^         returns control to the operating system.  The ? (question mark)
SQLPLUS^50^         must come right after the - (hyphen); a space is not permitted.
SQLPLUS^51^
SQLPLUS^52^
SQLPLUS^53^ The SQLPLUS command may be known by a different name under some
SQLPLUS^54^ operating systems, for example, plus32.
SQLPLUS^55^
SQLPLUS^56^ SQL*Plus supports a Site Profile, a SQL*Plus command file created by the
SQLPLUS^57^ database administrator.  This file is generally named GLOGIN.SQL.  This
SQLPLUS^58^ file is executed whenever a user starts SQL*Plus and SQL*Plus establishes
SQLPLUS^59^ the Oracle connection.  The Site Profile enables the DBA to set up
SQLPLUS^60^ SQL*Plus environment defaults for all users at a particular site.
SQLPLUS^61^ Users cannot directly access the Site Profile.  The default name
SQLPLUS^62^ and location of the Site Profile depend on your system.
SQLPLUS^63^
SQLPLUS^64^ SQL*Plus also supports a User Profile, executed after the Site Profile.
SQLPLUS^65^ SQL*Plus searches for file LOGIN.SQL in your current directory.  If it's
SQLPLUS^66^ not there, SQL*Plus searches a system dependent path to find the file;
SQLPLUS^67^ some operating systems may not support this path-search.
SQLPLUS^68^
SQLPLUS^69^ If you fail to log in successfully to SQL*Plus because your username or
SQLPLUS^70^ password is invalid, or some other error, SQL*Plus will return an error
SQLPLUS^71^ status equivalent to an EXIT FAILURE command.  See the EXIT command for
SQLPLUS^72^ further information on EXIT FAILURE.
SQLPLUS^73^
SQLPLUS^74^
SQLPLUS^75^ Examples: To start SQL*Plus with username SCOTT and password TIGER, enter:
SQLPLUS^76^
SQLPLUS^77^               SQLPLUS SCOTT/TIGER
SQLPLUS^78^
SQLPLUS^79^           To start SQL*Plus, as above, and to make POLICY (where POLICY is
SQLPLUS^80^           a valid SQL*Net database connection string) the default database,
SQLPLUS^81^           enter:
SQLPLUS^82^
SQLPLUS^83^               SQLPLUS SCOTT/TIGER@POLICY
SQLPLUS^84^
SQLPLUS^85^           To start SQL*Plus with username SCOTT and password TIGER and run
SQLPLUS^86^           a command file named STARTUP with the extension SQL, enter:
SQLPLUS^87^
SQLPLUS^88^               SQLPLUS SCOTT/TIGER @STARTUP
SQLPLUS^89^
SQLPLUS^90^           Note the space between TIGER and @STARTUP.
SQLPLUS^91^
SQLPLUS^92^ See also:  remote databases, commands, exit.
SQLPLUS^93^
START^1^
START^2^
START^3^                                  START
START^4^
START^5^ STA[RT] file_name[.ext] [arg ...]
START^6^
START^7^ START executes the contents of a command file.  The @ ("at" sign) and @@
START^8^ (double "at" sign) commands work similarly to the START command, but do
START^9^ not enable the passing of values to parameters.
START^10^
START^11^     file_name[.ext]
START^12^         is the command file to execute. If you omit an extension, SQL*Plus
START^13^         assumes the default command-file extension (normally SQL).
START^14^
START^15^         When you enter START file_name.ext, SQL*Plus searches for a file
START^16^         with the specified name and extension in the current default
START^17^         directory.  If SQL*Plus doesn't find the file, it searches a
START^18^         system dependent path for the FROM file.  Some operating systems
START^19^         don't support this path-search.
START^20^
START^21^     arg ...
START^22^         are data items to be passed to parameters in the command file.
START^23^         If you enter one or more arguments, SQL*Plus substitutes the
START^24^         values into the parameters (&1, &2, and so forth) in the command
START^25^         file.  The first argument replaces each occurrence of &1, the
START^26^         second replaces each occurrence of &2, and so forth.
START^27^
START^28^ The START command DEFINEs the parameters with the values of the arguments;
START^29^ if you START the file again in this session, you can enter new arguments
START^30^ or omit the arguments to use the old values.
START^31^
START^32^ The EXIT or QUIT commands in a command file terminate SQL*Plus.
START^33^
START^34^ Disabling the START command in the Product User Profile also disables the
START^35^ @ and @@ commands.
START^36^
START^37^
START^38^
START^39^ Example:  File PROMOTE.SQL, used to promote employees, contains:
START^40^
START^41^               SELECT * FROM EMP WHERE MGR=&1 AND JOB='&2' AND SAL>&3;
START^42^
START^43^           To run this command file, enter:
START^44^
START^45^               SQL> START PROMOTE 7280 CLERK 950
START^46^
START^47^           SQL*Plus then executes the following command:
START^48^
START^49^               SELECT * FROM EMP
START^50^               WHERE MGR = 7280 AND JOB = 'CLERK' AND SAL > 950;
START^51^
START^52^ See also:  @, @@, define, commands.
START^53^
SUBSTITUTION^1^
SUBSTITUTION^2^
SUBSTITUTION^3^                                Substitution
SUBSTITUTION^4^
SUBSTITUTION^5^ A substitution variable is a user variable name preceded by one or two
SUBSTITUTION^6^ ampersands (&).  When a substitution variable is in a command, SQL*Plus
SUBSTITUTION^7^ executes the command as though it contained the value of the substitution
SUBSTITUTION^8^ variable, rather than the reference to the variable.
SUBSTITUTION^9^
SUBSTITUTION^10^ Example:  If the variable SORTCOL is "JOB", and the variable MYTABLE is
SUBSTITUTION^11^           "EMP", SQL*Plus executes the commands:
SUBSTITUTION^12^
SUBSTITUTION^13^               SQL> BREAK ON &SORTCOL SQL> SELECT &SORTCOL, SAL
SUBSTITUTION^14^                 2  FROM &MYTABLE
SUBSTITUTION^15^                 3  ORDER BY &SORTCOL;
SUBSTITUTION^16^
SUBSTITUTION^17^           as if they were:  SQL> BREAK ON JOB
SUBSTITUTION^18^                             SQL> SELECT JOB, SAL
SUBSTITUTION^19^                               2  FROM EMP
SUBSTITUTION^20^                               3  ORDER BY JOB;
SUBSTITUTION^21^
SUBSTITUTION^22^
SUBSTITUTION^23^ You can use substitution variables anywhere in SQL and SQL*Plus commands,
SUBSTITUTION^24^ except as the first word entered at the prompt.  If SQL*Plus finds an
SUBSTITUTION^25^ undefined substitution variable in a command, you are asked for its value.
SUBSTITUTION^26^
SUBSTITUTION^27^ Example:  If the variable GIVENNAME is undefined and you enter:
SUBSTITUTION^28^
SUBSTITUTION^29^               SQL> SELECT * FROM EMP WHERE ENAME = '&GIVENNAME';
SUBSTITUTION^30^
SUBSTITUTION^31^           SQL*Plus displays the prompt:
SUBSTITUTION^32^
SUBSTITUTION^33^               Enter value for givenname:
SUBSTITUTION^34^
SUBSTITUTION^35^
SUBSTITUTION^36^ You can enter any string at the prompt, even with blanks and punctuation.
SUBSTITUTION^37^ Quote marks are not needed if they surround the substitution variable in
SUBSTITUTION^38^ the command.  SQL*Plus reads your response from the keyboard, even if you
SUBSTITUTION^39^ have redirected terminal input or output to a file.  If a terminal is not
SUBSTITUTION^40^ available (running the file in batch mode, for example), SQL*Plus uses the
SUBSTITUTION^41^ redirected file.  To append characters immediately after a substitution
SUBSTITUTION^42^ variable, use a period to separate the variable from the characters:
SUBSTITUTION^43^
SUBSTITUTION^44^               SQL> SELECT * FROM EMP WHERE EMPNO='&E.01';
SUBSTITUTION^45^               Enter value for E:  123
SUBSTITUTION^46^
SUBSTITUTION^47^     is interpreted as:   SQL> SELECT * FROM EMP WHERE EMPNO='12301';
SUBSTITUTION^48^
SUBSTITUTION^49^
SUBSTITUTION^50^ & and &&
SUBSTITUTION^51^
SUBSTITUTION^52^ If you use a substitution variable with one ampersand, SQL*Plus does not
SUBSTITUTION^53^ implicitly DEFINE the variable when you input a value.  Thus, if SQL*Plus
SUBSTITUTION^54^ later executes the same command (or another one with the same substitution
SUBSTITUTION^55^ variable), SQL*Plus will prompt you again for the value of the variable.
SUBSTITUTION^56^ If you use a substitution variable with two ampersands, the variable is
SUBSTITUTION^57^ automatically defined when you input a value.  Thus, if the same command
SUBSTITUTION^58^ is executed later in that session, SQL*Plus will not prompt you again for
SUBSTITUTION^59^ the value of the variable.
SUBSTITUTION^60^
SUBSTITUTION^61^ Example:  A command file named STATS (for calculating subgroup statistics
SUBSTITUTION^62^           on a numeric column) contains:
SUBSTITUTION^63^
SUBSTITUTION^64^               SELECT &&GROUP_COL, MAX(&&NUMBER_COL)  MAXIMUM,
SUBSTITUTION^65^                   MIN(&&NUMBER_COL) MINIMUM,
SUBSTITUTION^66^                   SUM(&&NUMBER_COL) TOTAL,
SUBSTITUTION^67^                   AVG(&&NUMBER_COL) AVERAGE
SUBSTITUTION^68^               FROM &TABLE
SUBSTITUTION^69^               GROUP BY &&GROUP_COL;
SUBSTITUTION^70^
SUBSTITUTION^71^           When you run this file, SQL*Plus prompts you for the values, by
SUBSTITUTION^72^           name, before running the file:
SUBSTITUTION^73^
SUBSTITUTION^74^               Enter value for group_col: PROJNO
SUBSTITUTION^75^               Enter value for number_col: SAL
SUBSTITUTION^76^               Enter value for table: EMP
SUBSTITUTION^77^
SUBSTITUTION^78^           SQL*Plus runs the following query:
SUBSTITUTION^79^
SUBSTITUTION^80^               SELECT PROJNO, MAX(SAL)  MAXIMUM,
SUBSTITUTION^81^                   MIN(SAL) MINIMUM,
SUBSTITUTION^82^                   SUM(SAL) TOTAL,
SUBSTITUTION^83^                   AVG(SAL) AVERAGE
SUBSTITUTION^84^               FROM EMP
SUBSTITUTION^85^               GROUP BY PROJNO;
SUBSTITUTION^86^
SUBSTITUTION^87^           If you run the query again during the same session, you will be
SUBSTITUTION^88^           prompted for TABLE (its name has a single ampersand) but not for
SUBSTITUTION^89^           GROUP_COL or NUMBER_COL (their names have double ampersands).
SUBSTITUTION^90^
SUBSTITUTION^91^
SUBSTITUTION^92^ Restrictions on Substitution
SUBSTITUTION^93^
SUBSTITUTION^94^ You can't use substitution variables or parameters in the editing commands
SUBSTITUTION^95^ APPEND, CHANGE, DEL, and INPUT, nor in other commands where substitution
SUBSTITUTION^96^ would be meaningless, like HELP, REMARK, and TIMING.  APPEND, CHANGE, and
SUBSTITUTION^97^ INPUT treat text beginning with & or && like any other text string.
SUBSTITUTION^98^
SUBSTITUTION^99^ These SET variables affect substitution variables and parameters:
SUBSTITUTION^100^
SUBSTITUTION^101^ SET DEFINE    turns substitution on and off and defines the substitution
SUBSTITUTION^102^               character.  & is the default.
SUBSTITUTION^103^
SUBSTITUTION^104^ SET ESCAPE    defines an escape character to use before the substitution
SUBSTITUTION^105^               character.  The escape character instructs SQL*Plus to treat
SUBSTITUTION^106^               the substitution character as an ordinary character, not a
SUBSTITUTION^107^               variable substitution request.  \ is the default character.
SUBSTITUTION^108^
SUBSTITUTION^109^ SET VERIFY ON shows each line of the file before and after substitution.
SUBSTITUTION^110^
SUBSTITUTION^111^ SET CONCAT    defines the character between the name of a substitution
SUBSTITUTION^112^               variable or parameter and characters immediately after the
SUBSTITUTION^113^               variable or parameter (. is the default).  See SET.
SUBSTITUTION^114^
SUBSTITUTION^115^ See also: commands.
SUBSTITUTION^116^
TIMING^1^
TIMING^2^
TIMING^3^                                    TIMING
TIMING^4^
TIMING^5^ TIMI[NG] [START text|SHOW|STOP]
TIMING^6^
TIMING^7^ TIMING records timing data for an elapsed time period, lists the current
TIMING^8^ timer's name and timing data, or lists the number of active timers.
TIMING^9^
TIMING^10^     START text
TIMING^11^         sets up a timer and makes text its name.  To have more than
TIMING^12^         one active timer, START additional timers before STOPping the
TIMING^13^         first; SQL*Plus nests each new timer within the preceding one.  The
TIMING^14^         timer most recently STARTed is the current timer.
TIMING^15^
TIMING^16^     SHOW
TIMING^17^         shows the current timer's name and timing data.
TIMING^18^
TIMING^19^     STOP
TIMING^20^         shows the current timer's title and timing data, then erases
TIMING^21^         the timer.  If other timers are active, the next most
TIMING^22^         recently STARTed timer becomes the current timer.  Use the
TIMING^23^         CLEAR command's TIMING clause to delete all timers.  Enter
TIMING^24^         TIMING with no clauses to list the number of active timers.
TIMING^25^
TIMING^26^
TIMING^27^ You can use this data to do a performance analysis on commands or blocks
TIMING^28^ run during the period.  SET TIMING ON automatically displays timing data
TIMING^29^ after each SQL command or PL/SQL block you run.
TIMING^30^
TIMING^31^ To delete all timers, use the CLEAR TIMING command.
TIMING^32^
TIMING^33^ Examples: To create a timer named SQL_TIMER, enter:
TIMING^34^
TIMING^35^               SQL> TIMING START SQL_TIMER
TIMING^36^
TIMING^37^           To list the current timer's title and accumulated time:
TIMING^38^
TIMING^39^               SQL> TIMING SHOW
TIMING^40^
TIMING^41^           To list the current timer's title and accumulated time,
TIMING^42^           and remove the timer, enter:
TIMING^43^
TIMING^44^               SQL> TIMING STOP
TIMING^45^
TIMING^46^ See also:  clear, show, set, start, commands.
TIMING^47^
TTITLE^1^
TTITLE^2^
TTITLE^3^                                   TTITLE
TTITLE^4^
TTITLE^5^ TTI[TLE] [printspec [text|variable] ...] | [OFF|ON]
TTITLE^6^
TTITLE^7^ where printspec is one or more of the clauses:
TTITLE^8^
TTITLE^9^         COL n          LE[FT]        BOLD
TTITLE^10^         S[KIP] [n]     CE[NTER]      FORMAT text
TTITLE^11^         TAB n          R[IGHT]
TTITLE^12^
TTITLE^13^ TTITLE places and formats a title at the top of each report page.  Enter
TTITLE^14^ TTITLE with no clause to list its current definition.  The old form of
TTITLE^15^ TTITLE is used if only a single word or string in quotes follows the
TTITLE^16^ TTITLE command.
TTITLE^17^
TTITLE^18^ See OLD COMMANDS for a description of the old form of TTITLE.
TTITLE^19^
TTITLE^20^     text
TTITLE^21^         is the title text.  Enter text in single quotes if you wish to
TTITLE^22^         place more than one word on a single line.
TTITLE^23^
TTITLE^24^     variable
TTITLE^25^         is a user variable or any of these system maintained values:
TTITLE^26^
TTITLE^27^              SQL.LNO       current line number
TTITLE^28^              SQL.PNO       current page number
TTITLE^29^              SQL.RELEASE   current Oracle release number
TTITLE^30^              SQL.SQLCODE   current error code
TTITLE^31^              SQL.USER      current username
TTITLE^32^
TTITLE^33^         To print one of these values, reference the appropriate variable
TTITLE^34^         in the title.  You can format variable with the FORMAT clause.
TTITLE^35^
TTITLE^36^     OFF turns the title off (suppresses its display) without affecting
TTITLE^37^         its definition.
TTITLE^38^
TTITLE^39^     ON  turns the title on (restores its display).  When you define a
TTITLE^40^         top title, SQL*Plus automatically sets TTITLE to ON.
TTITLE^41^
TTITLE^42^     COL n
TTITLE^43^         indents to column n of the current line (backward if column n has
TTITLE^44^         been passed).  "Column" here is print position, not table column.
TTITLE^45^
TTITLE^46^     S[KIP] [n]
TTITLE^47^         skips to the start of a new line n times; if n omitted, one time.
TTITLE^48^         If n = 0, skips backward to the start of the current line.
TTITLE^49^
TTITLE^50^     TAB n
TTITLE^51^         skips forward n columns (backward if you enter a negative value
TTITLE^52^         for n).  "Column" here is print position, not table column.
TTITLE^53^
TTITLE^54^     LE[FT], CE[NTER], and R[IGHT]
TTITLE^55^         aligns data left, center, or right on the current line.  SQL*Plus
TTITLE^56^         aligns the following data items as a group, up to the end of the
TTITLE^57^         printspec or the next LEFT, CENTER, RIGHT, or COL command.  CENTER
TTITLE^58^         and RIGHT use the SET LINESIZE value to calculate the position of
TTITLE^59^         the data item that follows.
TTITLE^60^
TTITLE^61^     BOLD
TTITLE^62^         prints data in bold print.  SQL*Plus represents bold print on your
TTITLE^63^         terminal by repeating the data on three consecutive lines.  On
TTITLE^64^         some operating systems, SQL*Plus may instruct your printer to
TTITLE^65^         print bolded text on three consecutive lines, instead of bold.
TTITLE^66^
TTITLE^67^     FORMAT text
TTITLE^68^         specifies a format model that determines the format data items to
TTITLE^69^         the next FORMAT clause or the end of the command.  The format
TTITLE^70^         model must be a text constant like A10 or $999.  See COLUMN
TTITLE^71^         FORMAT for more information on formatting.
TTITLE^72^
TTITLE^73^         If the datatype of the format model does not match the datatype of
TTITLE^74^         a given data item, the FORMAT clause has no effect on that item.
TTITLE^75^
TTITLE^76^         If no FORMAT model precedes a given data item, SQL*Plus prints
TTITLE^77^         NUMBER values in the format specified by SET NUMFORMAT or, if you
TTITLE^78^         have not used SET NUMFORMAT, the default format.  SQL*Plus prints
TTITLE^79^         DATE values in the default format.
TTITLE^80^
TTITLE^81^
TTITLE^82^ If you don't enter a printspec clause before the first occurrence of text,
TTITLE^83^ TTITLE left justifies the text.  SQL*Plus interprets TTITLE in the new
TTITLE^84^ form if a valid printspec clause (LEFT, SKIP, COL, and so on) immediately
TTITLE^85^ follows the command name.  TTITLE's terms and clauses also apply to
TTITLE^86^ the BTITLE command.
TTITLE^87^
TTITLE^88^ See COLUMN NEW_VALUE for information on printing column and DATE values
TTITLE^89^ in the top title.  You can use any number of constants and variables in
TTITLE^90^ a printspec.  SQL*Plus displays the constants and variables in the order
TTITLE^91^ specified, positioning and formatting each constant or variable by the
TTITLE^92^ printspec clause that precedes it.
TTITLE^93^
TTITLE^94^ Examples: To define "Monthly Analysis" as the top title and left-align it,
TTITLE^95^           to center the date, to right-align the page number with a three
TTITLE^96^           digit format, and to display "Date in Thousands" in the
TTITLE^97^           center of the next line, enter:
TTITLE^98^
TTITLE^99^               SQL> TTITLE LEFT 'Monthly Analysis' CENTER '11 Mar 88' -
TTITLE^100^                  > RIGHT 'Page:' FORMAT 999 SQL.PNO SKIP CENTER -
TTITLE^101^                  > 'Data in Thousands'
TTITLE^102^
TTITLE^103^           The following title results:
TTITLE^104^
TTITLE^105^               Monthly Analysis            11 Mar 88             Page: 1
TTITLE^106^                                       Data in Thousands
TTITLE^107^
TTITLE^108^           To suppress the top title display without changing its
TTITLE^109^           definition, enter:
TTITLE^110^
TTITLE^111^               SQL> TTITLE OFF
TTITLE^112^
TTITLE^113^ See also:  old commands, btitle, set, commands.
TTITLE^114^
UNDEFINE^1^
UNDEFINE^2^
UNDEFINE^3^                               UNDEFINE
UNDEFINE^4^
UNDEFINE^5^ UNDEF[INE] variable ...
UNDEFINE^6^
UNDEFINE^7^ UNDEFINE deletes one or more user variables that you defined either
UNDEFINE^8^ explicitly (with the DEFINE command), or implicitly (with a START
UNDEFINE^9^ command argument).
UNDEFINE^10^
UNDEFINE^11^     variable
UNDEFINE^12^         is the name of the user variable you wish to delete. One or more
UNDEFINE^13^         user variables may be deleted in the same command.
UNDEFINE^14^
UNDEFINE^15^
UNDEFINE^16^ Example:  To undefine a user variable named POS, enter:
UNDEFINE^17^
UNDEFINE^18^               SQL> UNDEFINE POS
UNDEFINE^19^
UNDEFINE^20^           To undefine two user variables named MYVAR1 and MYVAR2, enter:
UNDEFINE^21^
UNDEFINE^22^               SQL: UNDEFINE MYVAR1 MYVAR2
UNDEFINE^23^
UNDEFINE^24^ See also:  define, start, @, commands.
UNDEFINE^25^
VARIABLE^1^
VARIABLE^2^
VARIABLE^3^                             VARIABLE
VARIABLE^4^
VARIABLE^5^ VAR[IABLE] [variable [NUMBER|CHAR|CHAR (n)|VARCHAR2 (n)|REFCURSOR]]
VARIABLE^6^
VARIABLE^7^ VARIABLE declares a bind variable that can then be referenced in
VARIABLE^8^ PL/SQL.  VARIABLE with no arguments displays a list of all the
VARIABLE^9^ variables declared in the session.  VARIABLE followed by a name
VARIABLE^10^ lists that variable.
VARIABLE^11^
VARIABLE^12^     variable
VARIABLE^13^         represents the name of the bind variable you wish to create.
VARIABLE^14^
VARIABLE^15^     NUMBER
VARIABLE^16^         creates a variable of type NUMBER with a fixed length.
VARIABLE^17^
VARIABLE^18^     CHAR
VARIABLE^19^         creates a variable of type CHAR with a length of one.
VARIABLE^20^
VARIABLE^21^     CHAR (n)
VARIABLE^22^         creates a variable of type CHAR with a maximum length
VARIABLE^23^         of n, up to 255.
VARIABLE^24^
VARIABLE^25^     VARCHAR2 (n)
VARIABLE^26^         creates a variable of type VARCHAR2 with a maximum length
VARIABLE^27^         of n, up to 2000.
VARIABLE^28^
VARIABLE^29^     REFCURSOR
VARIABLE^30^         creates a variable of type REFCURSOR.
VARIABLE^31^
VARIABLE^32^ Bind variables may be used as parameters to stored procedures,
VARIABLE^33^ or may be directly referenced in anonymous PL/SQL blocks.
VARIABLE^34^
VARIABLE^35^ To display the value of a bind variable created with VARIABLE,
VARIABLE^36^ use the PRINT command.
VARIABLE^37^
VARIABLE^38^ To automatically display the value of a bind variable created
VARIABLE^39^ with VARIABLE, use the SET AUTOPRINT command.
VARIABLE^40^
VARIABLE^41^ Bind variables cannot be used in the COPY command or SQL
VARIABLE^42^ statements, except in PL/SQL blocks.  Instead, use substitution
VARIABLE^43^ variables.
VARIABLE^44^
VARIABLE^45^ SQL*Plus REFCURSOR bind variables may be used to reference
VARIABLE^46^ PL/SQL 2.2 Cursor Variables, allowing PL/SQL output to be
VARIABLE^47^ formatted by SQL*Plus.
VARIABLE^48^
VARIABLE^49^ When you execute a VARIABLE command, SQL*Plus opens a cursor
VARIABLE^50^ for each REFCURSOR bind variable.  SQL*Plus closes the cursor
VARIABLE^51^ after completing a PRINT statement for that bind variable, or
VARIABLE^52^ on exit.  Subsequent PL/SQL blocks referencing the REFCURSOR
VARIABLE^53^ bind variable in an OPEN ... FOR statement will automatically
VARIABLE^54^ open the cursor.
VARIABLE^55^
VARIABLE^56^ SQL*Plus formatting commands such as BREAK, COLUMN, COMPUTE and
VARIABLE^57^ SET may be used to format the output from PRINTing a REFCURSOR.
VARIABLE^58^
VARIABLE^59^ A REFCURSOR bind variable may not be PRINTed more than once
VARIABLE^60^ without re-executing the PL/SQL OPEN ... FOR statement.
VARIABLE^61^
VARIABLE^62^
VARIABLE^63^ Example:  The following example illustrates creating a bind variable
VARIABLE^64^ and then setting it to a value returned by a function:
VARIABLE^65^
VARIABLE^66^              SQL> VARIABLE id NUMBER
VARIABLE^67^              SQL> BEGIN
VARIABLE^68^                2    :id := emp_management.hire
VARIABLE^69^                3      ('BLAKE','MANAGER','KING',2990,'SALES');
VARIABLE^70^                4  END;
VARIABLE^71^
VARIABLE^72^ The following example automatically displays a bind variable:
VARIABLE^73^
VARIABLE^74^              SQL> SET AUTOPRINT ON
VARIABLE^75^              SQL> VARIABLE a REFCURSOR
VARIABLE^76^              SQL> BEGIN
VARIABLE^77^                2  OPEN :a FOR SELECT * FROM DEPT ORDER BY DEPTNO;
VARIABLE^78^                3  END;
VARIABLE^79^                4  /
VARIABLE^80^
VARIABLE^81^              PL/SQL procedure successfully completed.
VARIABLE^82^
VARIABLE^83^              DEPTNO   DNAME         LOC
VARIABLE^84^              -------- ------------- -------------
VARIABLE^85^                    10 ACCOUNTING    NEW YORK
VARIABLE^86^                    20 RESEARCH      DALLAS
VARIABLE^87^                    30 SALES         CHICAGO
VARIABLE^88^                    40 OPERATIONS    BOSTON
VARIABLE^89^
VARIABLE^90^ The following example creates some variables and lists them:
VARIABLE^91^
VARIABLE^92^              SQL> VARIABLE id NUMBER
VARIABLE^93^              SQL> VARIABLE txt CHAR (20)
VARIABLE^94^              SQL> VARIABLE myvar REFCURSOR
VARIABLE^95^              SQL> VARIABLE
VARIABLE^96^              variable id
VARIABLE^97^              datatype number
VARIABLE^98^
VARIABLE^99^              variable txt
VARIABLE^100^              datatype CHAR(20)
VARIABLE^101^
VARIABLE^102^              variable myvar
VARIABLE^103^              datatype REFCURSOR
VARIABLE^104^
VARIABLE^105^ The following example lists a single variable:
VARIABLE^106^
VARIABLE^107^              SQL> VARIABLE txt
VARIABLE^108^              variable txt
VARIABLE^109^              datatype CHAR(20)
VARIABLE^110^
VARIABLE^111^ The following example illustrates producing a report listing
VARIABLE^112^ individual salaries and computing the departmental and total
VARIABLE^113^ salary cost:
VARIABLE^114^
VARIABLE^115^              SQL> VARIABLE RC REFCURSOR
VARIABLE^116^              SQL> DECLARE
VARIABLE^117^                2  TYPE EMPSALTYPE IS RECORD (DNAME VARCHAR2(14),
VARIABLE^118^                3        ENAME VARCHAR2(10),
VARIABLE^119^                4        SAL NUMBER(7));
VARIABLE^120^                5        TYPE RCT IS REF CURSOR RETURN EMPSALTYPE;
VARIABLE^121^                6  LOC_RC RCT;
VARIABLE^122^                7  BEGIN
VARIABLE^123^                8  LOC_RC := :RC;
VARIABLE^124^                9  OPEN LOC_RC FOR SELECT DNAME, ENAME, SAL
VARIABLE^125^               10        FROM EMP, DEPT
VARIABLE^126^               11        WHERE EMP.DEPTNO = DEPT.DEPTNO
VARIABLE^127^               12        ORDER BY EMP.DEPTNO, ENAME;
VARIABLE^128^               13  END;
VARIABLE^129^               14  /
VARIABLE^130^
VARIABLE^131^              PL/SQL procedure successfully completed.
VARIABLE^132^
VARIABLE^133^              SQL> SET PAGESIZE 100 FEEDBACK OFF
VARIABLE^134^              SQL> TTITLE LEFT '*** Departmental Salary Bill *** ' SKIP 2
VARIABLE^135^              SQL> COLUMN SAL FORMAT $999,990.99 HEADING 'Salary'
VARIABLE^136^              SQL> COLUMN DNAME HEADING 'Department'
VARIABLE^137^              SQL> COLUMN ENAME HEADING 'Employee'
VARIABLE^138^              SQL> COMPUTE SUM LABEL 'Subtotal:' OF SAL ON DNAME
VARIABLE^139^              SQL> COMPUTE SUM LABEL 'Total:' OF SAL ON REPORT
VARIABLE^140^              SQL> BREAK ON DNAME SKIP 1 ON REPORT SKIP 1
VARIABLE^141^              SQL> PRINT RC
VARIABLE^142^
VARIABLE^143^              *** Departmental Salary Bill ***
VARIABLE^144^
VARIABLE^145^
VARIABLE^146^              Department     Employee         Salary
VARIABLE^147^              -------------- ---------- ------------
VARIABLE^148^              ACCOUNTING     CLARK         $2,450.00
VARIABLE^149^                             KING          $5,000.00
VARIABLE^150^                             MILLER        $1,300.00
VARIABLE^151^              **************            ------------
VARIABLE^152^              Subtotal:                    $8,750.00
VARIABLE^153^
VARIABLE^154^              RESEARCH       ADAMS         $1,100.00
VARIABLE^155^                             FORD          $3,000.00
VARIABLE^156^                             JONES         $2,975.00
VARIABLE^157^                             SCOTT         $3,000.00
VARIABLE^158^                             SMITH           $800.00
VARIABLE^159^              **************            ------------
VARIABLE^160^              Subtotal:                   $10,875.00
VARIABLE^161^
VARIABLE^162^              SALES          ALLEN         $1,600.00
VARIABLE^163^                             BLAKE         $2,850.00
VARIABLE^164^                             JAMES           $950.00
VARIABLE^165^                             MARTIN        $1,250.00
VARIABLE^166^                             TURNER        $1,500.00
VARIABLE^167^                             WARD          $1,250.00
VARIABLE^168^              **************            ------------
VARIABLE^169^              Subtotal:                    $9,400.00
VARIABLE^170^
VARIABLE^171^                                        ------------
VARIABLE^172^              Total:                      $29,025.00
VARIABLE^173^
VARIABLE^174^ See also:  print, set autoprint, set serveroutput.
VARIABLE^175^
VARIABLES^1^
VARIABLES^2^
VARIABLES^3^                              Variables
VARIABLES^4^
VARIABLES^5^ Use variables to store the results of a query, or to calculate
VARIABLES^6^ values to insert into tables. You can declare a variable to be
VARIABLES^7^ of any SQL or PL/SQL datatype: NUMBER, CHAR, VARCHAR2, DATE, or BOOLEAN.
VARIABLES^8^ Examples: balance NUMBER(5,2);  wkphone CHAR(12);  sex BOOLEAN
VARIABLES^9^
VARIABLES^10^ You can also create bind variables in SQL*Plus with the VARIABLE
VARIABLES^11^ command.  Bind variables can be referenced in PL/SQL and displayed
VARIABLES^12^ in SQL*Plus (using the PRINT command).  Bind variables can be of type
VARIABLES^13^ NUMBER, CHAR, CHAR (n), or VARCHAR2 (n).  Bind variables are
VARIABLES^14^ useful for storing return codes and debugging your PL/SQL because you
VARIABLES^15^ can display their values in SQL*Plus.
VARIABLES^16^
VARIABLES^17^ There are two ways you can assign values to a variable:
VARIABLES^18^   1 - use := (assignment operator)    discount := price * 0.15
VARIABLES^19^
VARIABLES^20^   2 - SELECT or FETCH table values INTO a variable:
VARIABLES^21^               SELECT price * 0.15 INTO discount FROM pricelist
VARIABLES^22^               WHERE stockdate <= SYSDATE - 60
VARIABLES^23^
VARIABLES^24^ To declare a constant, put CONSTANT  after the name and assign
VARIABLES^25^ its value immediately: discount  CONSTANT NUMBER(2,2) := 0.15;
VARIABLES^26^
VARIABLES^27^ See also: declare, number, char, varchar2, date, boolean, select into,
VARIABLES^28^           fetch, variable, print
VARIABLES^29^
WHENEVER OSERROR^1^
WHENEVER OSERROR^2^
WHENEVER OSERROR^3^                             WHENEVER OSERROR
WHENEVER OSERROR^4^
WHENEVER OSERROR^5^ WHENEVER OSERROR {EXIT [SUCCESS|FAILURE|n|variable]
WHENEVER OSERROR^6^    [COMMIT|ROLLBACK]|CONTINUE [COMMIT|ROLLBACK|NONE]}
WHENEVER OSERROR^7^
WHENEVER OSERROR^8^ WHENEVER OSERROR exits SQL*Plus if an operating system error occurs,
WHENEVER OSERROR^9^ (such as a file I/O error).
WHENEVER OSERROR^10^
WHENEVER OSERROR^11^     EXIT [SUCCESS|FAILURE|n|variable]
WHENEVER OSERROR^12^         directs SQL*Plus to exit as soon as an operating system error
WHENEVER OSERROR^13^         is detected.  You can also specify whether SQL*Plus should
WHENEVER OSERROR^14^         return a success or failure code, the operating system failure
WHENEVER OSERROR^15^         code, or a number or variable of your choice.
WHENEVER OSERROR^16^
WHENEVER OSERROR^17^     CONTINUE
WHENEVER OSERROR^18^         turns off the EXIT option.
WHENEVER OSERROR^19^
WHENEVER OSERROR^20^     COMMIT
WHENEVER OSERROR^21^         directs SQL*Plus to execute a COMMIT before exiting or
WHENEVER OSERROR^22^         continuing and save pending changes to the database.
WHENEVER OSERROR^23^
WHENEVER OSERROR^24^     ROLLBACK
WHENEVER OSERROR^25^         directs SQL*Plus to execute a ROLLBACK before exiting or
WHENEVER OSERROR^26^         continuing and abandon pending changes to the database.
WHENEVER OSERROR^27^
WHENEVER OSERROR^28^     NONE
WHENEVER OSERROR^29^         directs SQL*Plus to take no action before continuing.
WHENEVER OSERROR^30^         NONE is only valid with CONTINUE.
WHENEVER OSERROR^31^
WHENEVER OSERROR^32^ If you do not enter the WHENEVER OSERROR command, the default
WHENEVER OSERROR^33^ behavior of SQL*Plus is to continue and take no action when an
WHENEVER OSERROR^34^ operating system error occurs.
WHENEVER OSERROR^35^
WHENEVER OSERROR^36^ Examples:  The commands in the following command file cause
WHENEVER OSERROR^37^            SQL*Plus to exit and COMMIT any pending changes if an
WHENEVER OSERROR^38^            error occurs when writing to the output file:
WHENEVER OSERROR^39^
WHENEVER OSERROR^40^                 WHENEVER OSERROR EXIT SQL.OSCODE COMMIT
WHENEVER OSERROR^41^                 SPOOL MYLOG
WHENEVER OSERROR^42^                 UPDATE EMP SET SAL = SAL*1.1
WHENEVER OSERROR^43^                 COPY TO SCOTT/TIGER@HQDB -
WHENEVER OSERROR^44^                 REPLACE EMP -
WHENEVER OSERROR^45^                 USING SELECT * FROM EMP
WHENEVER OSERROR^46^                 SPOOL OUT
WHENEVER OSERROR^47^                 SELECT SAL FROM EMP
WHENEVER OSERROR^48^
WHENEVER OSERROR^49^ See also:  whenever sqlerror, exit.
WHENEVER OSERROR^50^
WHENEVER SQLERROR^1^
WHENEVER SQLERROR^2^
WHENEVER SQLERROR^3^                             WHENEVER SQLERROR
WHENEVER SQLERROR^4^
WHENEVER SQLERROR^5^ WHENEVER SQLERROR {EXIT [SUCCESS|FAILURE|WARNING|n|variable]
WHENEVER SQLERROR^6^    [COMMIT|ROLLBACK]|CONTINUE [COMMIT|ROLLBACK|NONE]}
WHENEVER SQLERROR^7^
WHENEVER SQLERROR^8^ Exits SQL*Plus if a SQL command or PL/SQL block generates an error.
WHENEVER SQLERROR^9^
WHENEVER SQLERROR^10^     EXIT [SUCCESS|FAILURE|WARNING|n|variable]
WHENEVER SQLERROR^11^         directs SQL*Plus to exit as soon as it detects any SQL
WHENEVER SQLERROR^12^         command or PL/SQL block error (but after printing the
WHENEVER SQLERROR^13^         error message).
WHENEVER SQLERROR^14^
WHENEVER SQLERROR^15^     CONTINUE
WHENEVER SQLERROR^16^         turns off the EXIT option.
WHENEVER SQLERROR^17^
WHENEVER SQLERROR^18^     COMMIT
WHENEVER SQLERROR^19^         directs SQL*Plus to execute a COMMIT before exiting or
WHENEVER SQLERROR^20^         continuing and save pending changes to the database.
WHENEVER SQLERROR^21^
WHENEVER SQLERROR^22^     ROLLBACK
WHENEVER SQLERROR^23^         directs SQL*Plus to execute a ROLLBACK before exiting or
WHENEVER SQLERROR^24^         continuing and abandon pending changes to the database.
WHENEVER SQLERROR^25^
WHENEVER SQLERROR^26^     NONE
WHENEVER SQLERROR^27^         directs SQL*Plus to take no action before continuing.
WHENEVER SQLERROR^28^
WHENEVER SQLERROR^29^ The WHENEVER SQLERROR command is triggered by SQL command or PL/SQL
WHENEVER SQLERROR^30^ block errors, and not by SQL*Plus command errors.
WHENEVER SQLERROR^31^
WHENEVER SQLERROR^32^ If you do not enter the WHENEVER SQLERROR command, the default
WHENEVER SQLERROR^33^ behavior of SQL*Plus is to continue and take no action when a
WHENEVER SQLERROR^34^ SQL error occurs.
WHENEVER SQLERROR^35^
WHENEVER SQLERROR^36^ Examples:  The commands in the following command file cause
WHENEVER SQLERROR^37^            SQL*Plus to exit before the COPY command and return
WHENEVER SQLERROR^38^            the SQL error code if the SQL UPDATE command fails:
WHENEVER SQLERROR^39^
WHENEVER SQLERROR^40^                 WHENEVER SQLERROR EXIT SQL.SQLCODE
WHENEVER SQLERROR^41^                 UPDATE EMP SET SAL = SAL*1.1
WHENEVER SQLERROR^42^                 COPY TO SCOTT/TIGER@D:BETHESDA -
WHENEVER SQLERROR^43^                 REPLACE EMP -
WHENEVER SQLERROR^44^                 USING SELECT * FROM EMP
WHENEVER SQLERROR^45^                 WHENEVER SQLERROR CONTINUE
WHENEVER SQLERROR^46^
WHENEVER SQLERROR^47^ See also:  whenever oserror, exit.
WHENEVER SQLERROR^48^
WHENEVER SQLERROR^49^
WHENEVER SQLERROR^50^
