/* LiveWire 3.2 text mode installation program */

/* Install REXX system functions */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/* Determine the path to LiveWire */
parse source . . argv0 .
temp = reverse(argv0)
temp = substr(temp, pos('\', temp))
if length(temp) > 3 then temp = substr(temp, 2)
CurrentPath = reverse(temp)

/* Begin installation */
ECHO OFF
call SysCls
Say "LiveWire 3.2 Text Mode Install Program"
Say "Copyright 1996 Les Novell"
Say ""
Say "THIS INSTALLATION ASSUMES THAT IT IS RUNNING FROM THE DIRECTORY"
Say "ON YOUR HARD DRIVE WHERE YOU WANT LiveWire 3.2 TEXT MODE"
Say ""
Say "IF YOU ARE INSTALLING FROM A FLOPPY, COPY THE CONTENTS OF THE DISK"
Say "TO A NEW DIRECTORY ON YOUR HARD DRIVE FIRST!"
Say ""
Say "-> If you're installing LiveWire 3.2 on a system with LiveWire 2.2"
Say "   or later, simply copy these files to the old LiveWire text"
Say "   mode directory."
Say ""
Say "Press [ENTER] to perform installation, or [CTRL-BREAK] to halt"
Pull A

call SysCls
Say "Beginning installation..."
Say ""
Say "Creating directory PROTOCOL..."
Say "  LiveWire will search this directory for installable file transfer"
Say "  protocols, including the path."
"MKDIR PROTOCOL 2>NUL"
Say ""
Say "Creating a desktop folder for LiveWire"
Say "  The desktop folder will contain the program and related"
Say "  documentation. It will be located in the upper left-hand"
Say "  corner of your desktop. Move it wherever you like."
Say ""

/* Create the LiveWire folder */
setting="OBJECTID=<LIVEWIRE_TM_FOLDER>;";
ret = SysCreateObject("WPFolder", "LiveWire Communications", "<WP_DESKTOP>", setting, "U")

/* Create Registration object */
setting="OBJECTID=<LIVEWIRE_TM_REG>;"||,
	 "EXENAME="||CurrentPath||"\LW30.EXE;"||,
         "ICONFILE="||CurrentPath||"\LWREG.ICO;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PARAMETERS=REGISTER;"||,
	 "PROGTYPE=WINDOWABLEVIO;"
ret = SysCreateObject("WPProgram", "Register LiveWire", "<LIVEWIRE_TM_FOLDER>", setting, "R")

/* Create DOCUMENTATION object */
setting="OBJECTID=<LIVEWIRE_TM_DOCS>;"||,
	 "EXENAME=VIEW.EXE;"||,
	 "PARAMETERS=LW30.INF;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "LiveWire 3.2 Text Mode Manual", "<LIVEWIRE_TM_FOLDER>", setting, "R")

/* Create DOCUMENTATION object */
setting="OBJECTID=<LIVEWIRE_TM_DOC_SCRIPT>;"||,
	 "EXENAME=VIEW.EXE;"||,
	 "PARAMETERS=LWSCR.INF;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "LiveWire 3.2 Script Manual", "<LIVEWIRE_TM_FOLDER>", setting, "R")

/* Create FAQ object */
setting="OBJECTID=<LIVEWIRE_TM_FAQ>;"||,
	 "EXENAME=VIEW.EXE;"||,
	 "PARAMETERS=LWFAQ.INF;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "Frequently Asked Questions", "<LIVEWIRE_TM_FOLDER>", setting, "R")

/* Create ORDER.FRM object */
setting="SHADOWID="||CurrentPath||"\ORDER.FRM;"
ret = SysCreateObject("WPShadow", "How to order LiveWire 3.2", "<LIVEWIRE_TM_FOLDER>", setting, "R")

/* Create Program object */
setting="OBJECTID=<LW_EXE>;"||,
	 "EXENAME="||CurrentPath||"\LW30.EXE;"||,
         "ICONFILE="||CurrentPath||"\LWPRG.ICO;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=WINDOWABLEVIO;"
ret = SysCreateObject("WPProgram", "LiveWire 3.2 Program", "<LIVEWIRE_TM_FOLDER>", setting, "R")

/* Create Host Mode object */
setting="OBJECTID=<LIVEWIRE_TM_HOST>;"||,
	 "EXENAME="||CurrentPath||"\LW30.EXE;"||,
	 "PARAMETERS=/Shost.cmd;"||,
         "ICONFILE="||CurrentPath||"\LWHST.ICO;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=WINDOWABLEVIO;"
ret = SysCreateObject("WPProgram", "LiveWire 3.2 Host Mode", "<LIVEWIRE_TM_FOLDER>", setting, "R")

/* Create PM File Transfer Monitor object */
setting="OBJECTID=<LIVEWIRE_TM_XFERMONITOR>;"||,
	 "EXENAME="||CurrentPath||"\LWXFER.EXE;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "File Transfer Monitor", "<LIVEWIRE_TM_FOLDER>", setting, "R")

Say "Installation complete."
Say "To configure LiveWire, double click on the LiveWire icon."
Say ""
