/************************************************************************/
/* Hilfsscript um Fonts zu generieren 							*/
/*   Das Skript GENFONT dient zur Erstellung neuer Schriftarten fr BIGFONT		*/  
/*   Eine Beschreibung des Aufbaus der Schriftartdateien finden Sie im Skript BIGFONT  */
/*  												*/
/*   von Thomas Jachmann  (2:2490/1135.17)   -   Version 1.0  -   22.10.94 		*/	
/************************************************************************/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Call SysCls

SAY 'Hilfsscript zur Generierung von Spezialfonts'
SAY ''

CALL CHAROUT 'STDOUT', 'Fontname (ohne Endung) : '
PULL fontdatei

fontdatei = fontdatei || '.FFT'

hoehe = 5
breite = 7

DO FOREVER
  fuerzeichen = ''
  DO WHILE LENGTH(fuerzeichen) \= 1
    CALL SysCls
    CALL CHAROUT 'STDOUT', 'Welches Zeichen soll definiert werden ? (''QUIT'' um zu Beenden) : '
    PARSE PULL fuerzeichen

    IF (fuerzeichen = 'QUIT') | (fuerzeichen = 'quit') THEN
      DO
      erg = STREAM(fontdatei, 'close')
      SAY ''
      SAY 'Nicht vergessen: Der Kopf der Datei mu noch ergnzt werden !'
      EXIT
      END
  END

  SAY ''

  CALL CHAROUT 'STDOUT', 'Hoehe  (ENTER fr ' || hoehe || '): '
  PULL temphoehe

  IF (DATATYPE(temphoehe) = 'NUM')  THEN
    hoehe = temphoehe

  CALL CHAROUT 'STDOUT', 'Breite (ENTER fr ' || breite || '): '
  PULL tempbreite

  IF (DATATYPE(tempbreite) = 'NUM')  THEN
    breite = tempbreite

  gesamtausgabe = ''
  compressedausgabe = ''

  CALL SysCls
  SAY' Font: ' || fontdatei || '    -     Zeichen ''' || fuerzeichen || ''' (Hhe ' || hoehe || ', Breite ' || breite || ')'
  SAY'------------------------------------------------------------------------------'
  SAY ''
  SAY ' Geben Sie jetzt das Fontmuster ein, zusammengesetzt aus ''#'' und Leerzeichen'
  SAY ' Endende Leerzeichen mssen nicht (knnen aber) mit eingegeben werden'
  SAY ''
  DO j = 1 TO hoehe
    CALL CHAROUT 'STDOUT', '     Zeile ' || j || ': '
    PULL kette

    ausgabe = ''
    DO i = 0 TO breite-1
      zeichen = SUBSTR(kette,breite-i,1)

      IF zeichen = '#' THEN
        ausgabe =  ausgabe || '1'
      ELSE
        ausgabe =  ausgabe || '0'
  
      hexwert = B2X(ausgabe)

      IF LENGTH(hexwert) = 1 THEN
        hexwert = '0' || hexwert
    END

  gesamtausgabe = gesamtausgabe || ' ' || hexwert
  compressedausgabe = compressedausgabe || hexwert
  END

  SAY ''
  SAY 'Das wre dann : ' || gesamtausgabe 

  CALL CHAROUT 'STDOUT', 'Speichern in ' || fontdatei || '?  (J/N): '
  PULL antwort
  antwort = SUBSTR(antwort, 1, 1)

  IF antwort = 'J' THEN
    DO
    zeile = fuerzeichen || ' ' || hoehe || ' ' || breite || ' ' || compressedausgabe
    CALL LINEOUT fontdatei, zeile
    END
END
