/****************************************************************************\
* SBCdev Language Compare Utility (C) 1996 Matt Davis (205:310/120.0@ekonet) *
*-----------------------------------------------------(1:3666/107.0@fidonet)-*
\****************************************************************************/

   Arg File1 File2
   Signal On Halt

   Say '[0m[2JSBCdev''s LangDiff Utility v'GetVersion()
   Say '------------------------------------------------------------------------------'
   If File2='' Then Do
      Say 'USAGE: LangDiff.Cmd [File] [FileToCompareTo]'
      Say ''
      Say 'LangDiff only works on AdeptXBBS Language files!!'
      Say '------------------------------------------------------------------------------'
      Exit
   End
   Say '  Reading ['File1']'
   Say '   (Read [s0 lines)'
   i='0'
   Do While Lines(File1)>'0'
      i=i+1
      Say '[u'i' lines)'
      Parse Value Strip(LineIn(File1)) With File1.i
   End
   File1.0=i
   Call Stream File1,'c','Close'
   /*----------------------------------------------------------------------*/
   Say '  Reading ['File2']'
   Say '   (Read [s0 lines)'
   i='0'
   Do While Lines(File2)>'0'
      i=i+1
      Say '[u'i' lines)'
      Parse Value Strip(LineIn(File2)) With File2.i
   End
   File2.0=i
   Call Stream File2,'c','Close'
   /*----------------------------------------------------------------------*\
   \*----------------------------------------------------------------------*/
   Say '  Dithering ['File1']'
   Say '   (Dithered [s0 lines)'
   Location.1.0.0='0'
   Do i=1 to File1.0
      Say '[u'i' lines) (Location 'Location.1.0.0')'
      If TestPrompt(File1.i)='1' Then Do
         Tmp             =Location.1.0.0
         Tmp             =Tmp+1
         Location.1.0.0  =Tmp
         Location.1.0.Tmp='0'
         Text1.Tmp       =File1.i
      End
      Else Do
         Tmp1                =Location.1.0.0
         Tmp2                =Location.1.0.Tmp1
         Tmp2                =Tmp2+1
         Location.1.0.Tmp1   =Tmp2
         Location.1.Tmp2.Tmp1=File1.i
      End
   End
   /*----------------------------------------------------------------------*/
   Say '  Dithering ['File2']'
   Say '   (Dithered [s0 lines)'
   Location.2.0.0='0'
   Do i=1 to File2.0
      Say '[u'i' lines) (Location 'Location.2.0.0')'
      If TestPrompt(File2.i)='1' Then Do
         Tmp             =Location.2.0.0
         Tmp             =Tmp+1
         Location.2.0.0  =Tmp
         Location.2.0.Tmp='0'
         Text2.Tmp       =File2.i
      End
      Else Do
         Tmp1                =Location.2.0.0
         Tmp2                =Location.2.0.Tmp1
         Tmp2                =Tmp2+1
         Location.2.0.Tmp1   =Tmp2
         Location.2.Tmp2.Tmp1=File2.i
      End
   End
   /*----------------------------------------------------------------------*\
   \*----------------------------------------------------------------------*/
   Say '  Comparing Files'
   Say '   (Compared [s0 Locations)'
   DiffStem.0='0'
   Do i=1 to Location.1.0.0
      Say '[u'i' Locations)'
      Diff='0'
      If Location.1.0.i <> Location.2.0.i Then Diff='1'
      Do c=1 to Location.1.0.i
         If Location.1.c.i <> Location.2.c.i Then Diff='1'
      End
      If Diff='1' Then Do
         Tmp         =DiffStem.0
         Tmp         =Tmp+1
         DiffStem.0  =Tmp
         DiffStem.Tmp=i
      End
   End
   /*----------------------------------------------------------------------*\
   \*----------------------------------------------------------------------*/
   Say '-----------------------------------------------------------------------------'
   Do
      Tmp='0'
      Say ' ! Counting ['File1']'
      Do i=1 to Location.1.0.0
         Do c=1 to Location.1.0.i
            Tmp=Tmp+1
         End
      End
      Say '[A[K  ['File1'] has 'Tmp' entries ('Location.1.0.0' Locations)'

      Tmp='0'
      Say ' ! Counting ['File2']'
      Do i=1 to Location.2.0.0
         Do c=1 to Location.2.0.i
            Tmp=Tmp+'1'
         End
      End
      Say '[A[K  ['File2'] has 'Tmp' entries ('Location.2.0.0' Locations)'
   End
   Say '  Found 'DiffStem.0' differences!'
   If DiffStem.0>'0' Then Do
      Say '  Exporting a list of locations to "LangDiff.Dif"'
      Address CMD "@Del LangDiff.Dif"
      Do i=1 to DiffStem.0
         Tmp=DiffStem.i
         Call LineOut 'LangDiff.Dif','['Right(i,3,'0')'] Location 'DiffStem.i':'
         Call LineOut 'LangDiff.Dif','       'File1': "'Text1.Tmp'"'
         Call LineOut 'LangDiff.Dif','       'File2': "'Text2.Tmp'"'
      End
   End
   Say '  Terminated Normally'
   Exit
/****************************************************************************\
* FUNCTIONS                                                                  *
\****************************************************************************/
GetVersion: Procedure
   Return '1.00'
/****************************************************************************/
TestPrompt: Procedure
   Arg Prompt
   Select
      When Left(Prompt,1)<>'#' Then Return '0'
      When DataType(Substr(Prompt,2,1,'x'),'N') Then Return '1'
      Otherwise Return '0'
   End
   Return '0'
/****************************************************************************\
* ERROR HANDLERS                                                             *
\****************************************************************************/
Halt:
   Say '-[[1;31mBreak Encountered![0m]---------------------------------------------------------'
   Say '  Terminated Normally'
   Say '------------------------------------------------------------------------------'
   Exit
/****************************************************************************/
