/* ScummC
 * Copyright (C) 2004-2006  Alban Bedel
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

/**
 * @file scc_param.h
 * @ingroup utils
 * @brief Command line parser
 */

#define SCC_PARAM_FLAG 1
#define SCC_PARAM_INT  2
#define SCC_PARAM_STR  3
#define SCC_PARAM_DBL  4
#define SCC_PARAM_STR_LIST 5
#define SCC_PARAM_INT_LIST 6
#define SCC_PARAM_HELP     7

#define SCC_PARAM_TYPE_NO_ARG 1

#define SCC_PARAM_UNKNOWN      -1
#define SCC_PARAM_NEED_ARG     -2
#define SCC_PARAM_INVALID      -3
#define SCC_PARAM_OUT_OF_RANGE -4
#define SCC_PARAM_INVALID_TYPE -5

typedef struct scc_param_st {
  char* name;
  int type;
  int min,max;
  void* ptr;
} scc_param_t;

typedef struct scc_cl_arg_st scc_cl_arg_t;
struct scc_cl_arg_st {
  scc_cl_arg_t* next;
  char* val;
};

int scc_param_parse(scc_param_t* params,char* k,char* v);

scc_cl_arg_t* scc_param_parse_argv(scc_param_t* params,int argc,char** argv);

typedef struct scc_param_help_st scc_param_help_t;
struct scc_param_help_st {
  char* name;
  char* arg;
  char* dfault;
  char* desc;
  scc_param_help_t* group;
};

typedef struct scc_help_st {
  char* name;
  char* usage;
  scc_param_help_t* param_help;
} scc_help_t;

void scc_print_help(scc_help_t* help,int exit_code);
