# completely replaces dct64() in dct64_i386.c and
# can also use 16 bit integers as part of dct64_MMX() used by
# decode_MMX.asm

BITS 32

segment .data class=DATA use32 FLAT
        align 32
costab:
        dd 1056974725
        dd 1057056395
        dd 1057223771
        dd 1057485416
        dd 1057855544
        dd 1058356026
        dd 1059019886
        dd 1059897405
        dd 1061067246
        dd 1062657950
        dd 1064892987
        dd 1066774581
        dd 1069414683
        dd 1073984175
        dd 1079645762
        dd 1092815430
        dd 1057005197
        dd 1057342072
        dd 1058087743
        dd 1059427869
        dd 1061799040
        dd 1065862217
        dd 1071413542
        dd 1084439708
        dd 1057128951
        dd 1058664893
        dd 1063675095
        dd 1076102863
        dd 1057655764
        dd 1067924853
        dd 1060439283

segment .text class=CODE use32 FLAT

        align 32

global dct64
dct64:
        push    ebx
        push    edi
        push    esi
        push    ebp
        sub     esp,256

        xor     ebp, ebp

        jmp     after_init
global dct64_MMX
dct64_MMX:
        push    ebx
        push    edi
        push    esi
        push    ebp
        sub     esp,256

        mov     ebp, 1

after_init:

        mov     esi, eax        ; out0
        mov     edi, edx        ; out1
        mov     eax, ecx        ; samples
        lea     edx, [esp+128]
        fld     DWORD [eax]     ; samples
        fadd    DWORD [eax+124]
        fstp    DWORD [edx]
        fld     DWORD [eax+4]

        mov     ebx, costab
        fadd    DWORD [120+eax]
        or      ebp, ebp
        fstp    DWORD [4+edx]
        fld     DWORD [eax]
        mov     ecx, esp
        fsub    DWORD [124+eax]
        fmul    DWORD [ebx]
        fstp    DWORD [124+edx]
        fld     DWORD [4+eax]
        fsub    DWORD [120+eax]
        fmul    DWORD [4+ebx]
        fstp    DWORD [120+edx]
        fld     DWORD [8+eax]
        fadd    DWORD [116+eax]
        fstp    DWORD [8+edx]
        fld     DWORD [12+eax]
        fadd    DWORD [112+eax]
        fstp    DWORD [12+edx]
        fld     DWORD [8+eax]
        fsub    DWORD [116+eax]
        fmul    DWORD [8+ebx]
        fstp    DWORD [116+edx]
        fld     DWORD [12+eax]
        fsub    DWORD [112+eax]
        fmul    DWORD [12+ebx]
        fstp    DWORD [112+edx]
        fld     DWORD [16+eax]
        fadd    DWORD [108+eax]
        fstp    DWORD [16+edx]
        fld     DWORD [20+eax]
        fadd    DWORD [104+eax]
        fstp    DWORD [20+edx]
        fld     DWORD [16+eax]
        fsub    DWORD [108+eax]
        fmul    DWORD [16+ebx]
        fstp    DWORD [108+edx]
        fld     DWORD [20+eax]
        fsub    DWORD [104+eax]
        fmul    DWORD [20+ebx]
        fstp    DWORD [104+edx]
        fld     DWORD [24+eax]
        fadd    DWORD [100+eax]
        fstp    DWORD [24+edx]
        fld     DWORD [28+eax]
        fadd    DWORD [96+eax]
        fstp    DWORD [28+edx]
        fld     DWORD [24+eax]
        fsub    DWORD [100+eax]
        fmul    DWORD [24+ebx]
        fstp    DWORD [100+edx]
        fld     DWORD [28+eax]
        fsub    DWORD [96+eax]
        fmul    DWORD [28+ebx]
        fstp    DWORD [96+edx]
        fld     DWORD [32+eax]
        fadd    DWORD [92+eax]
        fstp    DWORD [32+edx]
        fld     DWORD [36+eax]
        fadd    DWORD [88+eax]
        fstp    DWORD [36+edx]
        fld     DWORD [32+eax]
        fsub    DWORD [92+eax]
        fmul    DWORD [32+ebx]
        fstp    DWORD [92+edx]
        fld     DWORD [36+eax]
        fsub    DWORD [88+eax]
        fmul    DWORD [36+ebx]
        fstp    DWORD [88+edx]
        fld     DWORD [40+eax]
        fadd    DWORD [84+eax]
        fstp    DWORD [40+edx]
        fld     DWORD [44+eax]
        fadd    DWORD [80+eax]
        fstp    DWORD [44+edx]
        fld     DWORD [40+eax]
        fsub    DWORD [84+eax]
        fmul    DWORD [40+ebx]
        fstp    DWORD [84+edx]
        fld     DWORD [44+eax]
        fsub    DWORD [80+eax]
        fmul    DWORD [44+ebx]
        fstp    DWORD [80+edx]
        fld     DWORD [48+eax]
        fadd    DWORD [76+eax]
        fstp    DWORD [48+edx]
        fld     DWORD [52+eax]
        fadd    DWORD [72+eax]
        fstp    DWORD [52+edx]
        fld     DWORD [48+eax]
        fsub    DWORD [76+eax]
        fmul    DWORD [48+ebx]
        fstp    DWORD [76+edx]
        fld     DWORD [52+eax]
        fsub    DWORD [72+eax]
        fmul    DWORD [52+ebx]
        fstp    DWORD [72+edx]
        fld     DWORD [56+eax]
        fadd    DWORD [68+eax]
        fstp    DWORD [56+edx]
        fld     DWORD [60+eax]
        fadd    DWORD [64+eax]
        fstp    DWORD [60+edx]
        fld     DWORD [56+eax]
        fsub    DWORD [68+eax]
        fmul    DWORD [56+ebx]
        fstp    DWORD [68+edx]
        fld     DWORD [60+eax]
        fsub    DWORD [64+eax]
        fmul    DWORD [60+ebx]
        fstp    DWORD [64+edx]

        fld     DWORD [edx]
        fadd    DWORD [60+edx]
        fstp    DWORD [ecx]
        fld     DWORD [4+edx]
        fadd    DWORD [56+edx]
        fstp    DWORD [4+ecx]
        fld     DWORD [edx]
        fsub    DWORD [60+edx]
        fmul    DWORD [64+ebx]
        fstp    DWORD [60+ecx]
        fld     DWORD [4+edx]
        fsub    DWORD [56+edx]
        fmul    DWORD [68+ebx]
        fstp    DWORD [56+ecx]
        fld     DWORD [8+edx]
        fadd    DWORD [52+edx]
        fstp    DWORD [8+ecx]
        fld     DWORD [12+edx]
        fadd    DWORD [48+edx]
        fstp    DWORD [12+ecx]
        fld     DWORD [8+edx]
        fsub    DWORD [52+edx]
        fmul    DWORD [72+ebx]
        fstp    DWORD [52+ecx]
        fld     DWORD [12+edx]
        fsub    DWORD [48+edx]
        fmul    DWORD [76+ebx]
        fstp    DWORD [48+ecx]
        fld     DWORD [16+edx]
        fadd    DWORD [44+edx]
        fstp    DWORD [16+ecx]
        fld     DWORD [20+edx]
        fadd    DWORD [40+edx]
        fstp    DWORD [20+ecx]
        fld     DWORD [16+edx]
        fsub    DWORD [44+edx]
        fmul    DWORD [80+ebx]
        fstp    DWORD [44+ecx]
        fld     DWORD [20+edx]
        fsub    DWORD [40+edx]
        fmul    DWORD [84+ebx]
        fstp    DWORD [40+ecx]
        fld     DWORD [24+edx]
        fadd    DWORD [36+edx]
        fstp    DWORD [24+ecx]
        fld     DWORD [28+edx]
        fadd    DWORD [32+edx]
        fstp    DWORD [28+ecx]
        fld     DWORD [24+edx]
        fsub    DWORD [36+edx]
        fmul    DWORD [88+ebx]
        fstp    DWORD [36+ecx]
        fld     DWORD [28+edx]
        fsub    DWORD [32+edx]
        fmul    DWORD [92+ebx]
        fstp    DWORD [32+ecx]

        fld     DWORD [64+edx]
        fadd    DWORD [124+edx]
        fstp    DWORD [64+ecx]
        fld     DWORD [68+edx]
        fadd    DWORD [120+edx]
        fstp    DWORD [68+ecx]
        fld     DWORD [124+edx]
        fsub    DWORD [64+edx]
        fmul    DWORD [64+ebx]
        fstp    DWORD [124+ecx]
        fld     DWORD [120+edx]
        fsub    DWORD [68+edx]
        fmul    DWORD [68+ebx]
        fstp    DWORD [120+ecx]
        fld     DWORD [72+edx]
        fadd    DWORD [116+edx]
        fstp    DWORD [72+ecx]
        fld     DWORD [76+edx]
        fadd    DWORD [112+edx]
        fstp    DWORD [76+ecx]
        fld     DWORD [116+edx]
        fsub    DWORD [72+edx]
        fmul    DWORD [72+ebx]
        fstp    DWORD [116+ecx]
        fld     DWORD [112+edx]
        fsub    DWORD [76+edx]
        fmul    DWORD [76+ebx]
        fstp    DWORD [112+ecx]
        fld     DWORD [80+edx]
        fadd    DWORD [108+edx]
        fstp    DWORD [80+ecx]
        fld     DWORD [84+edx]
        fadd    DWORD [104+edx]
        fstp    DWORD [84+ecx]
        fld     DWORD [108+edx]
        fsub    DWORD [80+edx]
        fmul    DWORD [80+ebx]
        fstp    DWORD [108+ecx]
        fld     DWORD [104+edx]
        fsub    DWORD [84+edx]
        fmul    DWORD [84+ebx]
        fstp    DWORD [104+ecx]
        fld     DWORD [88+edx]
        fadd    DWORD [100+edx]
        fstp    DWORD [88+ecx]
        fld     DWORD [92+edx]
        fadd    DWORD [96+edx]
        fstp    DWORD [92+ecx]
        fld     DWORD [100+edx]
        fsub    DWORD [88+edx]
        fmul    DWORD [88+ebx]
        fstp    DWORD [100+ecx]
        fld     DWORD [96+edx]
        fsub    DWORD [92+edx]
        fmul    DWORD [92+ebx]
        fstp    DWORD [96+ecx]

        fld     DWORD [ecx]
        fadd    DWORD [28+ecx]
        fstp    DWORD [edx]
        fld     DWORD [ecx]
        fsub    DWORD [28+ecx]
        fmul    DWORD [96+ebx]
        fstp    DWORD [28+edx]
        fld     DWORD [4+ecx]
        fadd    DWORD [24+ecx]
        fstp    DWORD [4+edx]
        fld     DWORD [4+ecx]
        fsub    DWORD [24+ecx]
        fmul    DWORD [100+ebx]
        fstp    DWORD [24+edx]
        fld     DWORD [8+ecx]
        fadd    DWORD [20+ecx]
        fstp    DWORD [8+edx]
        fld     DWORD [8+ecx]
        fsub    DWORD [20+ecx]
        fmul    DWORD [104+ebx]
        fstp    DWORD [20+edx]
        fld     DWORD [12+ecx]
        fadd    DWORD [16+ecx]
        fstp    DWORD [12+edx]
        fld     DWORD [12+ecx]
        fsub    DWORD [16+ecx]
        fmul    DWORD [108+ebx]
        fstp    DWORD [16+edx]
        fld     DWORD [32+ecx]
        fadd    DWORD [60+ecx]
        fstp    DWORD [32+edx]
        fld     DWORD [60+ecx]
        fsub    DWORD [32+ecx]
        fmul    DWORD [96+ebx]
        fstp    DWORD [60+edx]
        fld     DWORD [36+ecx]
        fadd    DWORD [56+ecx]
        fstp    DWORD [36+edx]
        fld     DWORD [56+ecx]
        fsub    DWORD [36+ecx]
        fmul    DWORD [100+ebx]
        fstp    DWORD [56+edx]
        fld     DWORD [40+ecx]
        fadd    DWORD [52+ecx]
        fstp    DWORD [40+edx]
        fld     DWORD [52+ecx]
        fsub    DWORD [40+ecx]
        fmul    DWORD [104+ebx]
        fstp    DWORD [52+edx]
        fld     DWORD [44+ecx]
        fadd    DWORD [48+ecx]
        fstp    DWORD [44+edx]
        fld     DWORD [48+ecx]
        fsub    DWORD [44+ecx]
        fmul    DWORD [108+ebx]
        fstp    DWORD [48+edx]
        fld     DWORD [64+ecx]
        fadd    DWORD [92+ecx]
        fstp    DWORD [64+edx]
        fld     DWORD [64+ecx]
        fsub    DWORD [92+ecx]
        fmul    DWORD [96+ebx]
        fstp    DWORD [92+edx]
        fld     DWORD [68+ecx]
        fadd    DWORD [88+ecx]
        fstp    DWORD [68+edx]
        fld     DWORD [68+ecx]
        fsub    DWORD [88+ecx]
        fmul    DWORD [100+ebx]
        fstp    DWORD [88+edx]
        fld     DWORD [72+ecx]
        fadd    DWORD [84+ecx]
        fstp    DWORD [72+edx]
        fld     DWORD [72+ecx]
        fsub    DWORD [84+ecx]
        fmul    DWORD [104+ebx]
        fstp    DWORD [84+edx]
        fld     DWORD [76+ecx]
        fadd    DWORD [80+ecx]
        fstp    DWORD [76+edx]
        fld     DWORD [76+ecx]
        fsub    DWORD [80+ecx]
        fmul    DWORD [108+ebx]
        fstp    DWORD [80+edx]
        fld     DWORD [96+ecx]
        fadd    DWORD [124+ecx]
        fstp    DWORD [96+edx]
        fld     DWORD [124+ecx]
        fsub    DWORD [96+ecx]
        fmul    DWORD [96+ebx]
        fstp    DWORD [124+edx]
        fld     DWORD [100+ecx]
        fadd    DWORD [120+ecx]
        fstp    DWORD [100+edx]
        fld     DWORD [120+ecx]
        fsub    DWORD [100+ecx]
        fmul    DWORD [100+ebx]
        fstp    DWORD [120+edx]
        fld     DWORD [104+ecx]
        fadd    DWORD [116+ecx]
        fstp    DWORD [104+edx]
        fld     DWORD [116+ecx]
        fsub    DWORD [104+ecx]
        fmul    DWORD [104+ebx]
        fstp    DWORD [116+edx]
        fld     DWORD [108+ecx]
        fadd    DWORD [112+ecx]
        fstp    DWORD [108+edx]
        fld     DWORD [112+ecx]
        fsub    DWORD [108+ecx]
        fmul    DWORD [108+ebx]
        fstp    DWORD [112+edx]
        fld     DWORD [edx]
        fadd    DWORD [12+edx]
        fstp    DWORD [ecx]
        fld     DWORD [edx]
        fsub    DWORD [12+edx]
        fmul    DWORD [112+ebx]
        fstp    DWORD [12+ecx]
        fld     DWORD [4+edx]
        fadd    DWORD [8+edx]
        fstp    DWORD [4+ecx]
        fld     DWORD [4+edx]
        fsub    DWORD [8+edx]
        fmul    DWORD [116+ebx]
        fstp    DWORD [8+ecx]
        fld     DWORD [16+edx]
        fadd    DWORD [28+edx]
        fstp    DWORD [16+ecx]
        fld     DWORD [28+edx]
        fsub    DWORD [16+edx]
        fmul    DWORD [112+ebx]
        fstp    DWORD [28+ecx]
        fld     DWORD [20+edx]
        fadd    DWORD [24+edx]
        fstp    DWORD [20+ecx]
        fld     DWORD [24+edx]
        fsub    DWORD [20+edx]
        fmul    DWORD [116+ebx]
        fstp    DWORD [24+ecx]
        fld     DWORD [32+edx]
        fadd    DWORD [44+edx]
        fstp    DWORD [32+ecx]
        fld     DWORD [32+edx]
        fsub    DWORD [44+edx]
        fmul    DWORD [112+ebx]
        fstp    DWORD [44+ecx]
        fld     DWORD [36+edx]
        fadd    DWORD [40+edx]
        fstp    DWORD [36+ecx]
        fld     DWORD [36+edx]
        fsub    DWORD [40+edx]
        fmul    DWORD [116+ebx]
        fstp    DWORD [40+ecx]
        fld     DWORD [48+edx]
        fadd    DWORD [60+edx]
        fstp    DWORD [48+ecx]
        fld     DWORD [60+edx]
        fsub    DWORD [48+edx]
        fmul    DWORD [112+ebx]
        fstp    DWORD [60+ecx]
        fld     DWORD [52+edx]
        fadd    DWORD [56+edx]
        fstp    DWORD [52+ecx]
        fld     DWORD [56+edx]
        fsub    DWORD [52+edx]
        fmul    DWORD [116+ebx]
        fstp    DWORD [56+ecx]
        fld     DWORD [64+edx]
        fadd    DWORD [76+edx]
        fstp    DWORD [64+ecx]
        fld     DWORD [64+edx]
        fsub    DWORD [76+edx]
        fmul    DWORD [112+ebx]
        fstp    DWORD [76+ecx]
        fld     DWORD [68+edx]
        fadd    DWORD [72+edx]
        fstp    DWORD [68+ecx]
        fld     DWORD [68+edx]
        fsub    DWORD [72+edx]
        fmul    DWORD [116+ebx]
        fstp    DWORD [72+ecx]
        fld     DWORD [80+edx]
        fadd    DWORD [92+edx]
        fstp    DWORD [80+ecx]
        fld     DWORD [92+edx]
        fsub    DWORD [80+edx]
        fmul    DWORD [112+ebx]
        fstp    DWORD [92+ecx]
        fld     DWORD [84+edx]
        fadd    DWORD [88+edx]
        fstp    DWORD [84+ecx]
        fld     DWORD [88+edx]
        fsub    DWORD [84+edx]
        fmul    DWORD [116+ebx]
        fstp    DWORD [88+ecx]
        fld     DWORD [96+edx]
        fadd    DWORD [108+edx]
        fstp    DWORD [96+ecx]
        fld     DWORD [96+edx]
        fsub    DWORD [108+edx]
        fmul    DWORD [112+ebx]
        fstp    DWORD [108+ecx]
        fld     DWORD [100+edx]
        fadd    DWORD [104+edx]
        fstp    DWORD [100+ecx]
        fld     DWORD [100+edx]
        fsub    DWORD [104+edx]
        fmul    DWORD [116+ebx]
        fstp    DWORD [104+ecx]
        fld     DWORD [112+edx]
        fadd    DWORD [124+edx]
        fstp    DWORD [112+ecx]
        fld     DWORD [124+edx]
        fsub    DWORD [112+edx]
        fmul    DWORD [112+ebx]
        fstp    DWORD [124+ecx]
        fld     DWORD [116+edx]
        fadd    DWORD [120+edx]
        fstp    DWORD [116+ecx]
        fld     DWORD [120+edx]
        fsub    DWORD [116+edx]
        fmul    DWORD [116+ebx]
        fstp    DWORD [120+ecx]

        fld     DWORD [32+ecx]
        fadd    DWORD [36+ecx]
        fstp    DWORD [32+edx]
        fld     DWORD [32+ecx]
        fsub    DWORD [36+ecx]
        fmul    DWORD [120+ebx]
        fstp    DWORD [36+edx]
        fld     DWORD [44+ecx]
        fsub    DWORD [40+ecx]
        fmul    DWORD [120+ebx]
        fst     DWORD [44+edx]
        fadd    DWORD [40+ecx]
        fadd    DWORD [44+ecx]
        fstp    DWORD [40+edx]
        fld     DWORD [48+ecx]
        fsub    DWORD [52+ecx]
        fmul    DWORD [120+ebx]
        fld     DWORD [60+ecx]
        fsub    DWORD [56+ecx]
        fmul    DWORD [120+ebx]
        fld      st0
        fadd    DWORD [56+ecx]
        fadd    DWORD [60+ecx]
        fld      st0
        fadd    DWORD [48+ecx]
        fadd    DWORD [52+ecx]
        fstp    DWORD [48+edx]
        fadd     st2
        fstp    DWORD [56+edx]
        fst     DWORD [60+edx]
        faddp    st1
        fstp    DWORD [52+edx]
        fld     DWORD [64+ecx]
        fadd    DWORD [68+ecx]
        fstp    DWORD [64+edx]
        fld     DWORD [64+ecx]
        fsub    DWORD [68+ecx]
        fmul    DWORD [120+ebx]
        fstp    DWORD [68+edx]
        fld     DWORD [76+ecx]
        fsub    DWORD [72+ecx]
        fmul    DWORD [120+ebx]
        fst     DWORD [76+edx]
        fadd    DWORD [72+ecx]
        fadd    DWORD [76+ecx]
        fstp    DWORD [72+edx]
        fld     DWORD [92+ecx]
        fsub    DWORD [88+ecx]
        fmul    DWORD [120+ebx]
        fst     DWORD [92+edx]
        fadd    DWORD [92+ecx]
        fadd    DWORD [88+ecx]
        fld      st0
        fadd    DWORD [80+ecx]
        fadd    DWORD [84+ecx]
        fstp    DWORD [80+edx]
        fld     DWORD [80+ecx]
        fsub    DWORD [84+ecx]
        fmul    DWORD [120+ebx]
        fadd     st1, st0
        fadd    DWORD [92+edx]
        fstp    DWORD [84+edx]
        fstp    DWORD [88+edx]
        fld     DWORD [96+ecx]
        fadd    DWORD [100+ecx]
        fstp    DWORD [96+edx]
        fld     DWORD [96+ecx]
        fsub    DWORD [100+ecx]
        fmul    DWORD [120+ebx]
        fstp    DWORD [100+edx]
        fld     DWORD [108+ecx]
        fsub    DWORD [104+ecx]
        fmul    DWORD [120+ebx]
        fst     DWORD [108+edx]
        fadd    DWORD [104+ecx]
        fadd    DWORD [108+ecx]
        fstp    DWORD [104+edx]
        fld     DWORD [124+ecx]
        fsub    DWORD [120+ecx]
        fmul    DWORD [120+ebx]
        fst     DWORD [124+edx]
        fadd    DWORD [120+ecx]
        fadd    DWORD [124+ecx]
        fld      st0
        fadd    DWORD [112+ecx]
        fadd    DWORD [116+ecx]
        fstp    DWORD [112+edx]
        fld     DWORD [112+ecx]
        fsub    DWORD [116+ecx]
        fmul    DWORD [120+ebx]
        fadd     st1, st0
        fadd    DWORD [124+edx]
        fstp    DWORD [116+edx]
        fstp    DWORD [120+edx]
        jnz     near _L01

        fld     DWORD [ecx]
        fadd    DWORD [4+ecx]
        fstp    DWORD [1024+esi]
        fld     DWORD [ecx]
        fsub    DWORD [4+ecx]
        fmul    DWORD [120+ebx]
        fst     DWORD [esi]
        fstp    DWORD [edi]
        fld     DWORD [12+ecx]
        fsub    DWORD [8+ecx]
        fmul    DWORD [120+ebx]
        fst     DWORD [512+edi]
        fadd    DWORD [12+ecx]
        fadd    DWORD [8+ecx]
        fstp    DWORD [512+esi]
        fld     DWORD [16+ecx]
        fsub    DWORD [20+ecx]
        fmul    DWORD [120+ebx]
        fld     DWORD [28+ecx]
        fsub    DWORD [24+ecx]
        fmul    DWORD [120+ebx]
        fst     DWORD [768+edi]
        fld      st0
        fadd    DWORD [24+ecx]
        fadd    DWORD [28+ecx]
        fld      st0
        fadd    DWORD [16+ecx]
        fadd    DWORD [20+ecx]
        fstp    DWORD [768+esi]
        fadd     st2
        fstp    DWORD [256+esi]
        faddp    st1
        fstp    DWORD [256+edi]

        fld     DWORD [32+edx]
        fadd    DWORD [48+edx]
        fstp    DWORD [896+esi]
        fld     DWORD [48+edx]
        fadd    DWORD [40+edx]
        fstp    DWORD [640+esi]
        fld     DWORD [40+edx]
        fadd    DWORD [56+edx]
        fstp    DWORD [384+esi]
        fld     DWORD [56+edx]
        fadd    DWORD [36+edx]
        fstp    DWORD [128+esi]
        fld     DWORD [36+edx]
        fadd    DWORD [52+edx]
        fstp    DWORD [128+edi]
        fld     DWORD [52+edx]
        fadd    DWORD [44+edx]
        fstp    DWORD [384+edi]
        fld     DWORD [60+edx]
        fst     DWORD [896+edi]
        fadd    DWORD [44+edx]
        fstp    DWORD [640+edi]
        fld     DWORD [96+edx]
        fadd    DWORD [112+edx]
        fld      st0
        fadd    DWORD [64+edx]
        fstp    DWORD [960+esi]
        fadd    DWORD [80+edx]
        fstp    DWORD [832+esi]
        fld     DWORD [112+edx]
        fadd    DWORD [104+edx]
        fld      st0
        fadd    DWORD [80+edx]
        fstp    DWORD [704+esi]
        fadd    DWORD [72+edx]
        fstp    DWORD [576+esi]
        fld     DWORD [104+edx]
        fadd    DWORD [120+edx]
        fld      st0
        fadd    DWORD [72+edx]
        fstp    DWORD [448+esi]
        fadd    DWORD [88+edx]
        fstp    DWORD [320+esi]
        fld     DWORD [120+edx]
        fadd    DWORD [100+edx]
        fld      st0
        fadd    DWORD [88+edx]
        fstp    DWORD [192+esi]
        fadd    DWORD [68+edx]
        fstp    DWORD [64+esi]
        fld     DWORD [100+edx]
        fadd    DWORD [116+edx]
        fld      st0
        fadd    DWORD [68+edx]
        fstp    DWORD [64+edi]
        fadd    DWORD [84+edx]
        fstp    DWORD [192+edi]
        fld     DWORD [116+edx]
        fadd    DWORD [108+edx]
        fld      st0
        fadd    DWORD [84+edx]
        fstp    DWORD [320+edi]
        fadd    DWORD [76+edx]
        fstp    DWORD [448+edi]
        fld     DWORD [108+edx]
        fadd    DWORD [124+edx]
        fld      st0
        fadd    DWORD [76+edx]
        fstp    DWORD [576+edi]
        fadd    DWORD [92+edx]
        fstp    DWORD [704+edi]
        fld     DWORD [124+edx]
        fst     DWORD [960+edi]
        fadd    DWORD [92+edx]
        fstp    DWORD [832+edi]

        add     esp,256
        pop     ebp
        pop     esi
        pop     edi
        pop     ebx
        ret

_L01:

        fld     DWORD [ecx]
        fadd    DWORD [4+ecx]
        fistp   WORD [512+esi]
        fld     DWORD [ecx]
        fsub    DWORD [4+ecx]
        fmul    DWORD [120+ebx]

        fistp   WORD [esi]

        fld     DWORD [12+ecx]
        fsub    DWORD [8+ecx]
        fmul    DWORD [120+ebx]
        fist    WORD [256+edi]
        fadd    DWORD [12+ecx]
        fadd    DWORD [8+ecx]
        fistp   WORD [256+esi]
        fld     DWORD [16+ecx]
        fsub    DWORD [20+ecx]
        fmul    DWORD [120+ebx]
        fld     DWORD [28+ecx]
        fsub    DWORD [24+ecx]
        fmul    DWORD [120+ebx]
        fist    WORD [384+edi]
        fld      st0
        fadd    DWORD [24+ecx]
        fadd    DWORD [28+ecx]
        fld      st0
        fadd    DWORD [16+ecx]
        fadd    DWORD [20+ecx]
        fistp   WORD [384+esi]
        fadd     st2
        fistp   WORD [128+esi]
        faddp    st1
        fistp   WORD [128+edi]

        fld     DWORD [32+edx]
        fadd    DWORD [48+edx]
        fistp   WORD [448+esi]
        fld     DWORD [48+edx]
        fadd    DWORD [40+edx]
        fistp   WORD [320+esi]
        fld     DWORD [40+edx]
        fadd    DWORD [56+edx]
        fistp   WORD [192+esi]
        fld     DWORD [56+edx]
        fadd    DWORD [36+edx]
        fistp   WORD [64+esi]
        fld     DWORD [36+edx]
        fadd    DWORD [52+edx]
        fistp   WORD [64+edi]
        fld     DWORD [52+edx]
        fadd    DWORD [44+edx]
        fistp   WORD [192+edi]
        fld     DWORD [60+edx]
        fist    WORD [448+edi]
        fadd    DWORD [44+edx]
        fistp   WORD [320+edi]
        fld     DWORD [96+edx]
        fadd    DWORD [112+edx]
        fld      st0
        fadd    DWORD [64+edx]
        fistp   WORD [480+esi]
        fadd    DWORD [80+edx]
        fistp   WORD [416+esi]
        fld     DWORD [112+edx]
        fadd    DWORD [104+edx]
        fld      st0
        fadd    DWORD [80+edx]
        fistp   WORD [352+esi]
        fadd    DWORD [72+edx]
        fistp   WORD [288+esi]
        fld     DWORD [104+edx]
        fadd    DWORD [120+edx]
        fld      st0
        fadd    DWORD [72+edx]
        fistp   WORD [224+esi]
        fadd    DWORD [88+edx]
        fistp   WORD [160+esi]
        fld     DWORD [120+edx]
        fadd    DWORD [100+edx]
        fld      st0
        fadd    DWORD [88+edx]
        fistp   WORD [96+esi]
        fadd    DWORD [68+edx]
        fistp   WORD [32+esi]
        fld     DWORD [100+edx]
        fadd    DWORD [116+edx]
        fld      st0
        fadd    DWORD [68+edx]
        fistp   WORD [32+edi]
        fadd    DWORD [84+edx]
        fistp   WORD [96+edi]
        fld     DWORD [116+edx]
        fadd    DWORD [108+edx]
        fld      st0
        fadd    DWORD [84+edx]
        fistp   WORD [160+edi]
        fadd    DWORD [76+edx]
        fistp   WORD [224+edi]
        fld     DWORD [108+edx]
        fadd    DWORD [124+edx]
        fld      st0
        fadd    DWORD [76+edx]
        fistp   WORD [288+edi]
        fadd    DWORD [92+edx]
        fistp   WORD [352+edi]
        fld     DWORD [124+edx]
        fist    WORD [480+edi]
        fadd    DWORD [92+edx]
        fistp   WORD [416+edi]
        movsw

        add     esp,256
        pop     ebp
        pop     esi
        pop     edi
        pop     ebx
        ret
