@echo off
rem                Sample script to create/restore PARTition images
rem                instead of VOLume images like DFSIMAGE does.
rem
rem 24-06-2002 JvW Initial version, derived from DFSIMAGE
rem 11-07-2002 JvW Updated to use V5 DFSDOS
rem 20-07-2002 JvW Removed confusing 'spacebar' hint for non-registred users
rem 05-11-2002 JvW Updated for executable naming DFSOS2, DFSWIN and DFSDOS
echo.

if "%0"=="IPARTEST"     echo on
if "%0"=="ipartest"     echo on

if "%OS2_SHELL%"=="" goto notos2
set dfsexe=dfsos2.exe
set cmdext=CMD
goto dfsee
:notos2
if "%OS%"==""        goto notnt
if "%OS%"=="DOS"     goto notnt
if "%OS%"=="MSDOS"   goto notnt
if "%OS%"=="DRDOS"   goto notnt
if "%OS%"=="IBMDOS"  goto notnt
if "%OS%"=="OPENDOS" goto notnt
set dfsexe=dfswin.exe
set cmdext=BAT
goto dfsee
:notnt
set dfsexe=dfsdos.exe
set cmdext=BAT
:dfsee

if "%1" == "?"   goto usage
if "%1" == "/?"  goto usage
if "%1" == "-?"  goto usage
if "%2" == ""    goto usage

%dfsexe% -b -q query RValid
if not errorlevel 1 goto work
echo.
echo NOTE: Your DFSee version is not properly registred, this will cause
echo       some extra delays and reminder messages to be displayed  ...
echo.

:work
set partid=%2
:auto
set imgcmd=wrim
set imfile=%1
if exist %1      goto checkpart
if exist %1.img  goto checkpart
if exist %1.imz  goto checkpart

:trysim
set partid=%1
set imfile=%2
set imgcmd=sim

:checkpart
%dfsexe% -b -q query PValid %partid%
if not errorlevel 1 goto validpart
echo.

if %imgcmd% == sim goto invalid
goto trysim

:invalid
echo The specified parameter "%partid%" is NOT a valid partition id. Use 1 .. nn
goto end

:validpart
echo.
if %imgcmd% == wrim goto wrimcmd

echo Create an image of partid %partid% to compressed imagefile %imfile%
echo.
%dfsexe% %3 %4 %5 %6 %7 %8 %9 part -q %partid%#sim -zip %imfile%#q
goto end

:wrimcmd
echo Restore imagefile %imfile% to partid %partid%
echo.
%dfsexe% %3 %4 %5 %6 %7 %8 %9 part -q %partid%#wrim %imfile%#q
goto end

:usage
echo Create a compressed imagefile from a hard-disk partition, or
echo uncompress and write an imagefile back to a partition
echo.
echo Usage:  %0  imagefile  nn  /  nn  imagefile  [ switches ]
echo.
echo         imagefile =  Name of the imagefile, default extention is .IMZ
echo.
echo.                     When only an imagefile is specified (no 2nd param)
echo.                     and the file exists, it will be restored to the
echo                      diskette in the A: drive, otherwise the imagefile
echo                      will be created as an image of the diskette in A:
echo.
echo         nn        =  Partition-id of the partition to use (DFSee PID)
echo.
echo         switches  =  Any valid DFSee switch  (as shown by DFSxx.exe -?)
echo.
echo                      Useful switches for imaging are:
echo                      -l:logfile  = create a logfile
echo                      -b          = batch option, no confirmations
echo                      -w          = use windowed user interface
echo Examples:
echo  %0 02 os2boot     Create imagefile 'os2boot.imz' from partition 02
echo  %0 02 os2boot     Create 'os2boot.imz' from partition 02, no confirmations
echo  %0 os2boot 02     Restore imagefile 'os2boot.imz' to partition 02
:end
