/**********************************************************/
/**********************************************************/
/***                                                    ***/
/***  Program name: PIPEDOS.C                           ***/
/***                                                    ***/
/***  Created     : 4th July 1995                       ***/
/***                                                    ***/
/***  Author      : Scott Maxwell                       ***/
/***                                                    ***/
/***  Purpose     : Use OS/2 named pipes to redirect    ***/
/***                STDIN, STDOUT and STDERR from a     ***/
/***                DOS session to an OS/2 window.      ***/
/***                                                    ***/
/***  Compile     : icc /O+ pd.c                        ***/
/***                                                    ***/
/***  (C) 1995 Scott Maxwell                            ***/
/***                                                    ***/
/**********************************************************/

#define DO_STDIN

/**********************************************************/
/***  DEFINES                                           ***/
/**********************************************************/
#define INCL_DOSNMPIPES
#define INCL_DOSSESMGR      /* Session Manager values */
#define INCL_DOSQUEUES
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_DOSDATETIME
#define INCL_DOSFILEMGR
#define INCL_DOSSEMAPHORES

/**********************************************************/
/***  INCLUDES and VARIABLES                            ***/
/**********************************************************/
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

void _Optlink OutThread(void *threadArg);
void _Optlink InThread(void *threadArg);

#define QUEUENAME "\\QUEUES\\PIPEDOS.QUE"
#define PIPENAME  "/pipe/pipedos."

#define BUFLEN 0x201

unsigned long eventSem[3];
HMTX ioSync;

/**********************************************************/
/***  MAIN PROGRAM                                      ***/
/**********************************************************/
int main(int argc, char *argv[])
{
  BOOL fEnd_Correct=FALSE;

  STARTDATA   StartData;    /* Start session data structure */
  ULONG       SessID;       /* Session ID (returned) */
  PID         sessionPid;   /* Process ID (returned) */
  UCHAR       ObjBuf[100];  /* Object buffer */
  APIRET      rc;           /* Return code */
  HQUEUE      QueueHandle;
  REQUESTDATA Request;       /* Request-identification data */
  ULONG       DataLength;    /* Length of element received */
  PVOID       DataAddress;   /* Address of element received */
  BYTE        ElemPriority;  /* Priority of element received */
  unsigned short *shrt;
  char	      buffer[BUFLEN], *bptr;


  DosCreateMutexSem(0,&ioSync,0,0);
  
  DosCreateEventSem(NULL,&eventSem[0],0,0);
  rc = _beginthread(InThread, 0, 0x8000, (void*)0); /*stdin*/
  if (rc == -1) {
    printf("_beginthread error\n");
    exit (1);
  } /*end-if*/
  rc = DosWaitEventSem(eventSem[0],2000);
  if (rc) {
    printf("Timeout\n");
    exit (1);
  } /*end-if*/
  DosCreateEventSem(NULL,&eventSem[1],0,0);
  rc = _beginthread(OutThread, 0, 0x8000, (void*)1); /*stdout*/
  if (rc == -1) {
    printf("_beginthread error\n");
    exit (1);
  } /*end-if*/
  rc = DosWaitEventSem(eventSem[1],2000);
  if (rc) {
    printf("Timeout\n");
    exit (1);
  } /*end-if*/
  DosCreateEventSem(NULL,&eventSem[2],0,0);
  rc = _beginthread(OutThread, 0, 0x8000, (void*)2); /*stderr*/
  if (rc == -1) {
    printf("_beginthread error\n");
    exit (1);
  } /*end-if*/
  rc = DosWaitEventSem(eventSem[2],2000);
  if (rc) {
    printf("Timeout\n");
    exit (1);
  } /*end-if*/
  
  
  if (argc < 2) {
    printf("PipeDOS is a DOS executor to allow seamless running of\n");
    printf("DOS command line utilities in an OS/2 window.\n");
    printf("(C) 1995 Scott Maxwell\n\n");
    printf("USAGE: %s dos_command dos_parameters\n",argv[0]);
    return 1;
  }
  
  rc = DosCreateQueue(&QueueHandle,             /* Queue handle */
		      QUE_FIFO |                /* Ordering for elements */
		      QUE_CONVERT_ADDRESS,      /* 16-bit address conversion */
		      QUEUENAME);	/* Queue name string  */

  StartData.Length = sizeof(STARTDATA);
  StartData.Related = SSF_RELATED_CHILD;
  StartData.FgBg = SSF_FGBG_BACK;
  StartData.TraceOpt = SSF_TRACEOPT_NONE;
  StartData.PgmTitle = "PipeDOS Child";
  StartData.PgmName = 0;	/* DOS session */

  strcpy(buffer,"/c _pd");
  bptr = buffer+strlen(buffer);
  while(*++argv) {
    *bptr = ' ';
    bptr++;
    strcpy(bptr,*argv);
    bptr+=strlen(*argv);
  }
  StartData.PgmInputs = buffer;
  StartData.TermQ = QUEUENAME;
  StartData.Environment = "DPMI_MEMORY_LIMIT=32\0EMS_MEMORY_LIMIT=8192\0XMS_MEMORY_LIMIT=8192\0E:\DOS_AUTOEXEC=E:\AutoPD.EXE\0";
  StartData.InheritOpt = SSF_INHERTOPT_PARENT;
  StartData.SessionType = SSF_TYPE_VDM;
  StartData.IconFile = 0;
  StartData.PgmHandle = 0;
  StartData.PgmControl = SSF_CONTROL_INVISIBLE;
  StartData.Reserved = 0;
  StartData.ObjectBuffer = ObjBuf;
  StartData.ObjectBuffLen = 100;
  rc = DosStartSession(&StartData, &SessID, &sessionPid);
 
  if (rc != 0) {
    printf("DosStartSession error: return code = %ld", rc);
    return rc;
  }


  /****************************************************************/
  /* now we wait for our DOS session to connect to us             */
  /****************************************************************/

  rc = DosReadQueue(QueueHandle, &Request, &DataLength,
						  &DataAddress, 0, 0,
						  &ElemPriority, 0L);
 
  if (rc != 0) {
    printf("DosReadQueue error: return code = %ld", rc);
    return rc;
  }
 
  rc = DosCloseQueue(QueueHandle);         /* Close the queue */
  if (rc!= NO_ERROR) {
    printf ("DosCloseQueue error: return code = %u\n", rc);
    return 1;
  }

  rc = DosWaitEventSem(eventSem[1],1000);
  rc = DosWaitEventSem(eventSem[2],1000);

  DosCloseEventSem(eventSem[0]);
  DosCloseEventSem(eventSem[1]);
  DosCloseEventSem(eventSem[2]);
  DosCloseMutexSem(ioSync);
  shrt = DataAddress;
  return shrt[1];
}



/****************************************************************/
/* This is our thread process which creates N named pipes then  */
/* waits for the DOS sessions to connect to them.               */
/****************************************************************/
#define LINELEN 0x100

void _Optlink OutThread(void *vthreadArg)
{
  APIRET rc;
  char	      buffer[LINELEN+1];
  char *pipename;
  unsigned long cnt;
  FILE *f;
  int threadArg = (int)vthreadArg;
  HPIPE PipeHandle;

  switch (threadArg) {
  case 1:
    pipename = PIPENAME"1";
    f = stdout;
    break;
  case 2:
    pipename = PIPENAME"2";
    f = stderr;
    break;
  default:
    fprintf(stderr,"Unknown stream\n");
    exit(1);
  }
  rc = DosCreateNPipe(pipename,	/* create pipe    */
                      &PipeHandle,
                      NP_NOINHERIT|NP_ACCESS_DUPLEX,
                      NP_WAIT | NP_READMODE_BYTE | NP_TYPE_BYTE | NP_UNLIMITED_INSTANCES,
                      2048,	/* outbuffer */
                      4096,	/* inbuffer */
                      0L);	/* timeout */
  if (rc != 0) {
    printf("Couldn't create pipe\n");
    exit(1);
  }

  if (threadArg == 1)
    DosRequestMutexSem( ioSync, -1);
  DosPostEventSem(eventSem[threadArg]);
  DosResetEventSem(eventSem[threadArg],&cnt);

  /****************************************************************/
  /* now we wait for our DOS session to connect to us             */
  /****************************************************************/

  rc = DosConnectNPipe(PipeHandle);
  if (rc != 0) {
    DosBeep(100,200);
    exit(1);
  }

  if (threadArg == 2)
    DosRequestMutexSem( ioSync, -1);
  do {
    DosSleep(100);
    rc=DosRead(PipeHandle,buffer,LINELEN,&cnt);
    if (rc != 0) {
      printf("DosRead: rc=%hu\n",rc);
      exit(1);
    }
    if (cnt) {
      int a, from;
      static int last=-1;
      for (a=0, from=0; a<cnt; a++) {
	if (buffer[a] == 0xa) {
	  if (a>from && buffer[a-1] == 0xd)
	    buffer[a-1] = 0;
	  else
	    buffer[a] = 0;
	  fputs(&buffer[from],f);
	  fputc(10,f);
	  from = a+1;
	}
      }
      if (from < a) {
	buffer[a]=0;
	if (buffer[a-1] == 0xd)
	  buffer[a-1] = 0;
	fputs(&buffer[from],f);
      }
      fflush(0);
    }
  } while (cnt);
  DosReleaseMutexSem(ioSync);
  DosClose(PipeHandle);
  DosPostEventSem(eventSem[threadArg]);
}




void _Optlink InThread(void *vthreadArg)
{
  APIRET rc;
  char *pipename;
  unsigned long cnt=1;
  char c;
  FILE *f;
  int threadArg = (int)vthreadArg;
  HPIPE PipeHandle;

  rc = DosCreateNPipe(PIPENAME"0",	/* create pipe    */
                      &PipeHandle,
                      NP_NOINHERIT|NP_ACCESS_DUPLEX,
                      NP_WAIT | NP_READMODE_BYTE | NP_TYPE_BYTE | NP_UNLIMITED_INSTANCES,
                      4096,	/* outbuffer */
                      4096,	/* inbuffer */
                      0L);	/* timeout */
  if (rc != 0) {
    printf("Couldn't create pipe\n");
    exit(1);
  }
  DosPostEventSem(eventSem[0]);


  /****************************************************************/
  /* now we wait for our DOS session to connect to us             */
  /****************************************************************/

  rc = DosConnectNPipe(PipeHandle);
  if (rc != 0) {
    DosBeep(100,200);
    exit(1);
  }

  while(1) {
	 DosSleep(100);
	 while (_kbhit()) {
      c = _getch();
		rc=DosWrite(PipeHandle,&c,1,&cnt);
		rc=DosWrite(PipeHandle,&c,1,&cnt);
		if (rc != 0) {
		  printf("DosWrite: rc=%hu\n",rc);
		  exit(1);
		}
    }
  }
}
