/****************************************************************************
 *
 *   MIDI Router - allow internal re-routing of MIDI events in Windows 3.1
 *
 *   Written by Zoltan Janosy <janosy@tsys.hit.bme.hu>
 *   Version: 14.11.94
 *   This code is loosely based on the Soundblaster MIDI driver example
 *   of the Windows 3.1 Device Development Kit.
 *
 ***************************************************************************/

// some gizmos from MMDDK.H

/* flags for wFlags parameter of DriverCallback() */
#define DCB_WINDOW     0x0001           /* dwCallback is a HWND */
#define DCB_TASK       0x0002           /* dwCallback is a HTASK */
#define DCB_FUNCTION   0x0003           /* dwCallback is a FARPROC */

BOOL WINAPI DriverCallback(DWORD dwCallback, UINT uFlags,
    HANDLE hDevice, UINT uMessage, DWORD dwUser, DWORD dwParam1, DWORD dwParam2);

/* MIDI input and output device open information structure */
typedef struct midiopendesc_tag {
    HMIDI          hMidi;             /* handle */
    DWORD          dwCallback;        /* callback */
    DWORD          dwInstance;        /* app's private instance information */
} MIDIOPENDESC;
typedef MIDIOPENDESC FAR *LPMIDIOPENDESC;

#define DRVM_INIT             100
#define MODM_INIT             DRVM_INIT
#define MIDM_INIT             DRVM_INIT

/* messages sent to modMessage() entry-point function */
#define MODM_GETNUMDEVS     1
#define MODM_GETDEVCAPS     2
#define MODM_OPEN           3
#define MODM_CLOSE          4
#define MODM_PREPARE        5
#define MODM_UNPREPARE      6
#define MODM_DATA           7
#define MODM_LONGDATA       8
#define MODM_RESET          9
#define MODM_GETVOLUME      10
#define MODM_SETVOLUME      11
#define MODM_CACHEPATCHES       12      
#define MODM_CACHEDRUMPATCHES   13     

/* messages sent to midMessage() entry-point function */
#define MIDM_GETNUMDEVS  53
#define MIDM_GETDEVCAPS  54
#define MIDM_OPEN        55
#define MIDM_CLOSE       56
#define MIDM_PREPARE     57
#define MIDM_UNPREPARE   58
#define MIDM_ADDBUFFER   59
#define MIDM_START       60
#define MIDM_STOP        61
#define MIDM_RESET       62

// End of MMDDK.H

// My own defines

#define DRIVER_VERSION          0x0101
//		 typedefs

/* per allocation structure for midi */
typedef struct portalloc_tag {
    DWORD               dwCallback;     /* client's callback */
    DWORD               dwInstance;     /* client's instance data */
    HMIDIOUT            hMidi;          /* handle for stream */
	 DWORD               dwFlags;        /* allocation flags */
}PORTALLOC, NEAR *NPPORTALLOC;

typedef char huge *HPSTR;


/*  Product description strings - for this driver, they are all the */
/*  same text, so make all ID's equal */
#define IDS_MROUTERPRODUCT      32
#define IDS_MROUTERMIDIIN       IDS_MROUTERPRODUCT
#define IDS_MROUTERMIDIOUT      IDS_MROUTERPRODUCT


//		 globals

extern HANDLE		ghModule;		 /* our module handle */
extern PORTALLOC	gMidiInClient;  /* input client information structure */
extern PORTALLOC	gMidiOutClient; /* client information */
extern DWORD		gdwRefTime;
extern BOOL			gfMidiInStarted;
extern BOOL			gfEnabled;


//	 prototypes
extern LRESULT FAR PASCAL _loadds DriverProc(DWORD dwDriverID, HDRVR hDriver, UINT uiMessage, LPARAM lParam1, LPARAM lParam2);
extern int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize, LPSTR lpCmdLine);
extern void  FAR  PASCAL midiCallback(NPPORTALLOC pPort, WORD msg, DWORD dw1, DWORD dw2);
extern DWORD FAR  PASCAL _loadds modMessage(WORD id, UINT msg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2);
extern DWORD FAR  PASCAL _loadds midMessage(WORD id, UINT msg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2);
extern void NEAR PASCAL modGetDevCaps(LPBYTE lpCaps, WORD wSize);
extern void NEAR PASCAL midGetDevCaps(LPBYTE lpCaps, WORD wSize);
