/****************************************************************************
 *
 *   MIDI Router - allow internal re-routing of MIDI events in Windows 3.1
 *
 *   Written by Zoltan Janosy <janosy@tsys.hit.bme.hu>
 *   Version: 14.11.94
 *   This code is loosely based on the Soundblaster MIDI driver example
 *   of the Windows 3.1 Device Development Kit.
 *
 ***************************************************************************/


/******* History **************
 * 11.11.94 First public release in alt.binaries.sounds.midi
 * 14.11.94 Fixed problem with multiple attempts to open the driver
 *          Fixed task callback
 ******************************/

#include <windows.h>
#include <mmsystem.h>
#include <mem.h>			// memcpy
#include "mrouter.h"

// global variables

PORTALLOC   gMidiInClient;      /* input client information structure */
PORTALLOC   gMidiOutClient;         /* client information */
DWORD			gdwRefTime = 0L;
BOOL			gfMidiInStarted = FALSE;
BOOL			gfEnabled;
HANDLE		ghModule        = NULL;         /* our module handle */

void FAR PASCAL midiCallback(NPPORTALLOC pPort, WORD msg, DWORD dw1, DWORD dw2)
{

    /*  Invoke the callback function, if it exists.  dwFlags contains driver-
     *  specific flags in the LOWORD and generic driver flags in the HIWORD
	  */
	 if (pPort->dwCallback)
		switch (HIWORD(pPort->dwFlags))
		{
			case DCB_WINDOW :
				PostMessage(pPort->dwCallback,       /* client's window handle DWORD */
								msg,					 /* MMSYSTEM uses the same messages for windows */
								pPort->hMidi,            /* handle to the wave device */
								dw1);                    /* first DWORD */
            break;
			case DCB_FUNCTION :
	         DriverCallback(pPort->dwCallback,       /* client's callback DWORD */
     	                     HIWORD(pPort->dwFlags),  /* flags */
       	                  pPort->hMidi,            /* handle to the wave device */
          	               msg,                     /* the message */
              	            pPort->dwInstance,       /* client's instance data */
                 	         dw1,                     /* first DWORD */
									dw2);                    /* second DWORD */
				break;
		  case DCB_TASK :;
		  };
}


void NEAR PASCAL midDataRec(DWORD dwMessage)
{
DWORD   dwCurTime;

	if (gfMidiInStarted)
   {
    /* time data received */
		dwCurTime = timeGetTime() - gdwRefTime;

		midiCallback( &gMidiInClient, MIM_DATA, dwMessage, dwCurTime );
    }
}


DWORD FAR PASCAL _loadds modMessage(WORD id, UINT msg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2)
{

    if ( !gfEnabled ) {
        if ( msg == MODM_INIT ) {
//				InitDisplayConfigErrors();
            return 0L;
        }

//        D1("modMessage called while disabled");
        return ( (msg == MODM_GETNUMDEVS) ? 0L : MMSYSERR_NOTENABLED );
    }

    /* this driver only supports one device */
    if ( id != 0 ) {
//        D1("invalid midi device id");
        return MMSYSERR_BADDEVICEID;
    }

    switch ( msg ) {
        case MODM_GETNUMDEVS:
				return 1L;

        case MODM_GETDEVCAPS:
				modGetDevCaps((LPBYTE)dwParam1, (WORD)dwParam2);
            return 0L;

        case MODM_OPEN:

				if (HIWORD(dwParam2) == DCB_TASK)
            	return MMSYSERR_NOTSUPPORTED;

				/* now attempt to 'acquire' the MIDI output hardware */
				if ( gMidiOutClient.hMidi != NULL ) {
//                D1("MIDI output hardware is unavailable!");
                return MMSYSERR_ALLOCATED;
            }

            /* save client information */
            gMidiOutClient.dwCallback = ((LPMIDIOPENDESC)dwParam1)->dwCallback;
            gMidiOutClient.dwInstance = ((LPMIDIOPENDESC)dwParam1)->dwInstance;
            gMidiOutClient.hMidi      = ((LPMIDIOPENDESC)dwParam1)->hMidi;
				gMidiOutClient.dwFlags    = dwParam2;

				/* notify client */
            midiCallback(&gMidiOutClient, MOM_OPEN, 0L, 0L);

            return 0L;

        case MODM_CLOSE:

				/* notify client */
  	         midiCallback(&gMidiOutClient, MOM_CLOSE, 0L, 0L);

				gMidiOutClient.hMidi = NULL;
				return 0L;

        case MODM_RESET:
				return ( 0L );

/************************** The next case is the heart of this program:********************/

		  case MODM_DATA:             /* message is in dwParam1 */
        		midDataRec(dwParam1); 
				return ( 0L );

        case MODM_LONGDATA:         /* far pointer to header in dwParam1 */
// We do not support SysExs.
				return MMSYSERR_NOTSUPPORTED;

		  default:
            return MMSYSERR_NOTSUPPORTED;
	 }

    /* should never get here */
	 return MMSYSERR_NOTSUPPORTED;
}


static void NEAR PASCAL midGetDevCaps(LPBYTE lpCaps, WORD wSize)
{
MIDIINCAPS mc;

    mc.wMid = MM_MICROSOFT;
    mc.wPid = MM_SNDBLST_MIDIIN;
    mc.vDriverVersion = DRIVER_VERSION;
	 LoadString(ghModule, IDS_MROUTERMIDIIN, mc.szPname, MAXPNAMELEN);

	 memcpy(lpCaps, &mc, min(wSize, sizeof(MIDIINCAPS)));
}

static void NEAR PASCAL modGetDevCaps(LPBYTE lpCaps, WORD wSize)
{
MIDIOUTCAPS mc;

    mc.wMid = MM_MICROSOFT;
    mc.wPid = MM_SNDBLST_MIDIOUT;
    mc.vDriverVersion = DRIVER_VERSION;
    mc.wTechnology = MOD_MIDIPORT;
    mc.wVoices = 0;                   /* not used for ports */
    mc.wNotes = 0;                    /* not used for ports */
    mc.wChannelMask = 0xFFFF;         /* all channels */
    mc.dwSupport = 0L;
    LoadString(ghModule, IDS_MROUTERMIDIOUT, mc.szPname, MAXPNAMELEN);

    memcpy(lpCaps, &mc, min(wSize,sizeof(mc)));
}

DWORD FAR PASCAL _loadds midMessage(WORD id, UINT msg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2)
{
    if ( !gfEnabled ) {
        if ( msg == MIDM_INIT ) {
//				InitDisplayConfigErrors();
            return 0L;
        }

//        D1("midMessage called while disabled");
		  return ( (msg == MIDM_GETNUMDEVS) ? 0L : MMSYSERR_NOTENABLED );
    }

    /* this driver only supports one device */
    if ( id != 0 ) {
//        D1("invalid midi device id");
        return MMSYSERR_BADDEVICEID;
    }

    switch ( msg ) {
        case MIDM_GETNUMDEVS:
				return 1L;

        case MIDM_GETDEVCAPS:
				midGetDevCaps((LPBYTE)dwParam1, (WORD)dwParam2);
            return 0L;

        case MIDM_OPEN:

				if (HIWORD(dwParam2) == DCB_TASK)
            	return MMSYSERR_NOTSUPPORTED;

				if ( gMidiInClient.hMidi != NULL ) {
					 return MMSYSERR_ALLOCATED;
            }

            /* allocate my structure containing info about my client (global */
            /* because I only allow one client to access midi input). */
            gMidiInClient.dwCallback = ((LPMIDIOPENDESC)dwParam1)->dwCallback;
            gMidiInClient.dwInstance = ((LPMIDIOPENDESC)dwParam1)->dwInstance;
            gMidiInClient.hMidi      = ((LPMIDIOPENDESC)dwParam1)->hMidi;
				gMidiInClient.dwFlags    = dwParam2;

				gdwRefTime = timeGetTime();
            gfMidiInStarted = FALSE;

            /* notify client */
            midiCallback(&gMidiInClient, MIM_OPEN, 0L, 0L);

            return 0L;

		  case MIDM_CLOSE:

				/* notify client */
  	         midiCallback(&gMidiInClient, MIM_CLOSE, 0L, 0L);

				gMidiInClient.hMidi = NULL;
				gfMidiInStarted = FALSE;

				return 0L;

        case MIDM_ADDBUFFER:

				return MMSYSERR_NOTSUPPORTED;

        case MIDM_START:

				/* get a new reference time */
            gdwRefTime = timeGetTime();
				gfMidiInStarted = TRUE;

				return 0L;

        case MIDM_STOP:
				gfMidiInStarted = FALSE;
				return 0L;

        case MIDM_RESET:

				return 0L;

        default:
				return MMSYSERR_NOTSUPPORTED;
    }

    /* should never get here */
	 return MMSYSERR_NOTSUPPORTED;
}


LRESULT FAR PASCAL _loadds DriverProc(DWORD dwDriverID, HDRVR hDriver, UINT uiMessage, LPARAM lParam1, LPARAM lParam2)
{
    switch (uiMessage) {
        case DRV_LOAD:

				/*
					Sent to the driver when it is loaded. Always the first
               message received by a driver.

               dwDriverID is 0L. 
               lParam1 is 0L.
               lParam2 is 0L.
                
               Return 0L to fail the load.

               DefDriverProc will return NON-ZERO so we don't have to
               handle DRV_LOAD
            */

            return (LRESULT)1L;

        case DRV_FREE:

            /*
               Sent to the driver when it is about to be discarded. This
               will always be the last message received by a driver before
               it is freed. 

               dwDriverID is 0L. 
               lParam1 is 0L.
               lParam2 is 0L.

	       Return value is ignored.
	    */

	    return (LRESULT)1L;

	case DRV_OPEN:

	    /*
	       Sent to the driver when it is opened.

	       dwDriverID is 0L.

	       lParam1 is a far pointer to a zero-terminated string
	       containing the name used to open the driver.

	       lParam2 is passed through from the drvOpen call.

	       Return 0L to fail the open.

	       DefDriverProc will return ZERO so we do have to
	       handle the DRV_OPEN message.
	     */

	    return (LRESULT)1L;

	case DRV_CLOSE:

	    /*
	       Sent to the driver when it is closed. Drivers are unloaded
	       when the close count reaches zero.

	       dwDriverID is the driver identifier returned from the
	       corresponding DRV_OPEN.

	       lParam1 is passed through from the drvClose call.

	       lParam2 is passed through from the drvClose call.

	       Return 0L to fail the close.

	       DefDriverProc will return ZERO so we do have to
	       handle the DRV_CLOSE message.
	    */

	    return (LRESULT)1L;

	case DRV_ENABLE:

	    /*
	       Sent to the driver when the driver is loaded or reloaded
	       and whenever Windows is enabled. Drivers should only
	       hook interrupts or expect ANY part of the driver to be in
	       memory between enable and disable messages

	       dwDriverID is 0L.
	       lParam1 is 0L.
	       lParam2 is 0L.

	       Return value is ignored.
	    */

       gfEnabled = TRUE;
		 return (LRESULT)1L;

	case DRV_DISABLE:

	    /*
	       Sent to the driver before the driver is freed.
	       and whenever Windows is disabled

	       dwDriverID is 0L.
	       lParam1 is 0L.
	       lParam2 is 0L.

	       Return value is ignored.
	    */

		 gfEnabled = FALSE;
	    return (LRESULT)1L;

	case DRV_QUERYCONFIGURE:

	    /*
		Sent to the driver so that applications can
		determine whether the driver supports custom
		configuration. The driver should return a
		non-zero value to indicate that configuration
		is supported.

		dwDriverID is the value returned from the DRV_OPEN
		call that must have succeeded before this message
		was sent.

		lParam1 is passed from the app and is undefined.
		lParam2 is passed from the app and is undefined.

		Return 0L to indicate configuration NOT supported.
	    */

		 return (LRESULT)0L;

	case DRV_CONFIGURE:

	    /*
		Sent to the driver so that it can display a custom
		configuration dialog box.

		lParam1 is passed from the app. and should contain
		the parent window handle in the loword.
		lParam2 is passed from the app and is undefined.

		Return value is undefined.

		Drivers should create their own section in system.ini.
		The section name should be the driver name.
	    */

	    return (LRESULT)0L;

	case DRV_INSTALL:
		 return (LRESULT)DRVCNF_RESTART;

	case DRV_REMOVE:
//		 ConfigRemove();
	    return (LRESULT)DRVCNF_RESTART;

	default:
	    return DefDriverProc(dwDriverID, hDriver,uiMessage,lParam1,lParam2);
    }
}


int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize, LPSTR lpCmdLine)
{
	 /* save our module handle */
	ghModule = hInstance;
	return 1;
}
