{**********************************************************************
  Freemem 1.0
  This program may only be distributed in its original unmodified form.
  (C) R.P.Bellis 1993
**********************************************************************}

program FreeMem;

{$R freemem.res}

uses OWindows, ODialogs, BWCC, WinProcs, WinTypes, Strings;

const
  id_Timer = 1;
  idm_About = 100;

type
  PFreeMemApp = ^TFreeMemApp;
  TFreeMemApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

type
  PFreeMemWindow = ^TFreeMemWindow;
  TFreeMemWindow = object(TWindow)
    freeMemory : LongInt;
    hTimer : THandle;
    menu   : hMenu;
    constructor Init(AParent : PWindowsObject; title : PChar);
    destructor Done; virtual;
    function GetClassName : PChar; virtual;
    procedure GetWindowClass(var class : TWndClass); virtual;
    procedure SetupWindow; virtual;
    procedure WMQueryOpen(var Msg : TMessage); virtual wm_First + wm_QueryOpen;
    procedure WMTimer(var Msg : TMessage); virtual wm_First + wm_Timer;
    procedure WMSysCommand(var Msg : TMessage); virtual wm_First + wm_SysCommand;
  end;

procedure TFreeMemApp.InitMainWindow;
begin
  MainWindow := New(PFreeMemWindow, Init(Nil, 'Free Memory'));
end;

constructor TFreeMemWindow.Init(AParent : PWindowsObject; title : PChar);
begin
  inherited Init(AParent, title);
end;

procedure TFreeMemWindow.SetupWindow;
begin
  ShowWindow(hWindow, sw_ShowMinNoActive);
  menu := GetSystemMenu(hWindow, False);
  RemoveMenu(menu, sc_Restore, mf_ByCommand);
  RemoveMenu(menu, sc_Size, mf_ByCommand);
  RemoveMenu(menu, sc_Minimize, mf_ByCommand);
  RemoveMenu(menu, sc_Maximize, mf_ByCommand);
  InsertMenu(menu, sc_TaskList, mf_ByCommand, idm_About, 'About...');
  RemoveMenu(menu, sc_TaskList, mf_ByCommand);
  hTimer := SetTimer(hWindow, id_Timer, 500, Nil);
end;

destructor TFreeMemWindow.Done;
begin
  KillTimer(hWindow, id_Timer);
  inherited Done;
end;

function TFreeMemWindow.GetClassName : PChar;
begin
  GetClassName := 'FreeMem'
end;

procedure TFreeMemWindow.GetWindowClass(var class : TWndClass);
begin
  inherited GetWindowClass(class);
  with class do
    begin
      hIcon := LoadIcon(hInstance, 'FREEMEM')
    end
end;

procedure TFreeMemWindow.WMQueryOpen(var Msg : TMessage);
begin
  Msg.result := 0
end;

procedure TFreeMemWindow.WMTimer(var Msg : TMessage);
var
  curmem        : LongInt;
  title         : array [0..20] of char;
begin
  curmem := GetFreeSpace(0);
  curmem := Round(curmem / 1024.0);
  if (curmem <> freeMemory) then
    begin
      freeMemory := curmem;
      Str(freeMemory, title);
      StrCat(title, ' kB');
      SetCaption(title)
    end
end;

procedure TFreeMemWindow.WMSysCommand(var Msg : TMessage);
begin
  case Msg.wParam of
    idm_About:
      Application^.ExecDialog(New(PDialog, Init(@Self, 'ABOUT')));
  else
    DefWndProc(Msg);
  end;
end;

var
  app           : TFreeMemApp;

begin
  app.Init('Free');
  app.Run;
  app.Done;
end.
