#include <windows.h>
#include "malloc.h"
#include "memory.h"
#include "resource.h"
#include "..\convert.h"

typedef	struct _tagBMPReadHeader
{
	BITMAPFILEHEADER	fh;
	BITMAPINFOHEADER	bi;
	RGBQUAD				rgb[_MAX_RGB];
	BOOL					bReadColors;
} BMPREADHEADER;
const char *szReadColors = "ReadColors";
HINSTANCE	hinstLib;
char	szProfile[16];
char	szSection[4] = "bmp";

typedef BMPREADHEADER far *LPBMPREADHEADER;


BOOL CALLBACK _export Initialize(LPIMAGEINFO lpImg, LPBMPREADHEADER brh)
{
	brh->bReadColors = (GetPrivateProfileInt(szSection, szReadColors, 0, szProfile)>0);
	return TRUE;
}

void CALLBACK _export GetInfo(LPCONVERTERINFO CInf, LPCSTR lpstrProfileName)
{
	lstrcpy(CInf->szDescription, "Windows Bitmap");	// the file type description (used by File Open/Save Dialogs)
	lstrcpy(CInf->szExtension, szSection);			// the default extension.  This is used to 
	CInf->wCaps = CC_READ | CC_WRITE | CC_SETUPDIALOG;
	CInf->dwMem = (sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) *256);
	
	lstrcpy(szProfile, lpstrProfileName);  
		
	return;
}

BOOL CALLBACK _export WriteHeader(LPIMAGEINFO lpImg, void far *lpPrivate)
{  	
	BOOL		bRet = TRUE;	
	BITMAPFILEHEADER	bfh;
	/*
	LPBITMAPINFOHEADER pDIB = (LPBITMAPINFOHEADER)_fmalloc(sizeof(BITMAPINFOHEADER) + 
													lpImg->wNumColors * sizeof(RGBQUAD));
	
	if (!pDIB)
	{
		lpImg->iError = CE_MEMORY;
		return 0;
	}
	*/
	memset(&bfh	, 0, sizeof (bfh));
	bfh.bfType = (((WORD)'M')<<8) + (WORD)('B');	
	bfh.bfOffBits = sizeof (bfh) + sizeof(BITMAPINFOHEADER) + lpImg->wNumColors * sizeof (RGBQUAD);
	bfh.bfSize = bfh.bfOffBits + (DWORD)lpImg->wRowBytes * (DWORD)lpImg->wHeight;
	
	_llseek(lpImg->hFile, 0, 0);
	bRet = bRet && _lwrite(lpImg->hFile, &bfh, sizeof (bfh))==sizeof(bfh);
	//_hwrite(lpImg->hFile, lpImg->lpDIB, bfh.bfSize - sizeof (bfh));
/*	
	pDIB->biSize 	= sizeof (BITMAPINFOHEADER);
	pDIB->biHeight = lpImg->wHeight;
	pDIB->biWidth	= lpImg->wWidth;
	pDIB->biPlanes = 1;
	pDIB->biBitCount = DATABYTES(lpImg->iDataType) * 8;
	pDIB->biCompression = BI_RGB;
	pDIB->biSizeImage = 0;
	pDIB->biXPelsPerMeter = 0;
   pDIB->biYPelsPerMeter = 0;
	pDIB->biClrUsed= 	lpImg->wNumColors;
	pDIB->biClrImportant = lpImg->wNumColors;
	
   bRet = bRet && _lwrite(lpImg->hFile, pDIB, sizeof (BITMAPINFOHEADER))== sizeof(BITMAPINFOHEADER);
   bRet = bRet && _lwrite(lpImg->hFile, lpImg->lpRGB, lpImg->wNumColors * sizeof (RGBQUAD))
   							== lpImg->wNumColors * sizeof (RGBQUAD);
   lpImg->wFlags |= IF_INVERTWRITEROW;
*/ 	 
   if (!bRet)
   	lpImg->iError = CE_FILEACCESS;
   	   
   return bRet;	
}  

BOOL CALLBACK _export WriteRow(WORD wRow, WORD wFrame, WORD wSequence, LPIMAGEINFO lpImg, BITMAPFILEHEADER far *fh, void far *lpBuffer)
{
	DWORD		dwSize; 
	if (wRow ==(lpImg->wHeight-1))   
	{
	   dwSize = sizeof(BITMAPINFOHEADER) + (DWORD)lpImg->wNumColors * sizeof (RGBQUAD)
							+ (DWORD)(lpImg->wWidth + ((4-(lpImg->wWidth&3))&3)) * (DWORD)lpImg->wHeight;	
		_llseek(lpImg->hFile, sizeof(BITMAPFILEHEADER), 0);
		return (_hwrite(lpImg->hFile, (void far *)lpImg->lpDIB, (LONG)dwSize)==(LONG)dwSize);
	}
	else	
		return TRUE;
	//return (_lwrite(lpImg->hFile, lpBuffer, lpImg->wRowBytes)==lpImg->wRowBytes);
}

BOOL CALLBACK _export ReadRow(WORD wRow, WORD wFrame, WORD wSequence, LPIMAGEINFO lpImg, BITMAPFILEHEADER far *fh, void far *lpBuffer)
{  	
	BOOL		bRet;
	WORD		wRowBytes;
	LONG		lPos;
	
	wRowBytes = lpImg->wWidth + (((lpImg->wWidth^3)+1)&3);
	lPos = 	(LONG)fh->bfOffBits + 												// beginning of data dump					
				(LONG)(lpImg->wHeight - wRow - 1) * (LONG)wRowBytes,		// row in frame
	bRet = (_llseek(	lpImg->hFile, 
							lPos,
							0) == lPos);
					
	if (bRet)	
		bRet = (_hread(		lpImg->hFile, 
							lpBuffer,
							lpImg->wWidth
						) == (LONG)lpImg->wWidth);  
		
	return bRet;					
}

BOOL CALLBACK _export ReadHeader(LPIMAGEINFO lpImg,LPBMPREADHEADER h)
{  	
	BOOL bOK;
	WORD	wID;
	
	_llseek(lpImg->hFile, 0,0); 	// ID offset
	_lread(lpImg->hFile, &wID, sizeof (WORD));
	
	if (wID != 0x4d42)
		return FALSE;
		
	bOK = (	_llseek(lpImg->hFile, 0, 0)!=HFILE_ERROR &&
				_lread(lpImg->hFile, h, 
							sizeof(BITMAPFILEHEADER) + sizeof (BITMAPINFOHEADER)) != HFILE_ERROR );

	if (	h->bi.biBitCount !=8 || 
			h->bi.biCompression!=BI_RGB || 
			h->bi.biPlanes!=1 ||
			h->bi.biHeight>0xFFFF ||
			h->bi.biWidth>0xFFFF)
	{
		lpImg->iError = CE_UNSUPPORTEDFORMAT;
		bOK = FALSE;
	}
	if (bOK)
	{
		lpImg->wWidth = (WORD)h->bi.biWidth;		
		lpImg->wHeight = (WORD)h->bi.biHeight;
		lpImg->wNumFrames = 1;
		lpImg->wNumSequences = 1;	// SPE files don't have multiple frame series															
		lpImg->iDataType = U_BYTE;

		if (h->bReadColors)
		{
			lpImg->wFlags = IF_READCOLORS;
			lpImg->wNumColors = (WORD)(h->bi.biClrUsed ? h->bi.biClrUsed : (1<<h->bi.biBitCount));
			lpImg->wNumColors = max(lpImg->wNumColors, _MAX_RGB);
			_llseek(lpImg->hFile, sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER),0);
			bOK = (_lread(lpImg->hFile, h->rgb, lpImg->wNumColors * sizeof (RGBQUAD))
									== lpImg->wNumColors * sizeof (RGBQUAD));
			lpImg->lpRGB = h->rgb;
		}
	}
	return bOK;
	
} 

BOOL CALLBACK _export SetupDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{                        
	char	szBuffer[4];
	
	switch (message)
	{
		case WM_INITDIALOG:			
			CheckDlgButton(hDlg, IDC_READCOLORS,
				(GetPrivateProfileInt(szSection, szReadColors, 0, szProfile)>0));
		return 0;
		
		case WM_COMMAND:
		switch (wParam)
		{
			case IDOK:
				WritePrivateProfileString(szSection, szReadColors, 
							itoa(IsDlgButtonChecked(hDlg, IDC_READCOLORS),szBuffer, 10), szProfile);				
				EndDialog(hDlg, 1);
			return 0;
			
			case IDCANCEL:
				EndDialog(hDlg, 0);
			return 0;
		}
	}
	return 0;
}


BOOL CALLBACK _export SetupDialog(HWND hwnd)
{
	FARPROC	lpfnDlgProc;
	
	lpfnDlgProc = MakeProcInstance((FARPROC)SetupDialogProc, hinstLib);
	DialogBox(hinstLib, "SETUPDIALOG", hwnd, 	lpfnDlgProc);
	FreeProcInstance(lpfnDlgProc);
	
	return TRUE;
}









/***************************************************************************
 *
 *
 * LibMain()
 *
 *
 *--------------------------------------------------------------------------
 */
int FAR PASCAL LibMain( // DLL initialization, returns always 1
	HANDLE  hInst,      // handle to instance of App that required this DLL.
	WORD    wDataSeg,   // number of words in DLL's data segment.
	WORD    wHeapSize,  // number of bytes in DLL's heap.
	LPSTR   lpszCmdLine)// command line for App that required this DLL.
{  	
	if (wHeapSize > 0)
		UnlockData(0);
	hinstLib = hInst;
	return(1);
}

int CALLBACK WEP(int nExitType)
{
 	return TRUE;
}
 