;VSHRP   --  Algorithm for non linear sharpening  (P.Verbeek, TU-Delft)
;syntax:     *vshrp #       (# = window size)
;expects:    source image in a
;result:     image in p or h, depending on configuration
;uses:       images q, r, s
;****************************** 
parms
int wsize = 3
endparms

IMAGE img

if wsize == 0 wsize = 3              ;                   -----

if (((improp fg) & DIS_BIT) == DIS_BIT)
  img = "p"
else
  img = "h"
endif

dest img
show img

              ;                 /
dis a         ;org -->    ____/    ___
dis q         ;                   /
min p wsize   ;min -->    ______/
;unif wsize   ;                __
sub img q     ;org - min   ___/  \__  (p)
              ;                ___
dest r        ;               /
max img wsize ;max -->   ___/
;unif wsize   ;              __
sub r img     ;max - org ___/  \__    (r)
dest s        ;                _____
comp q > r    ;binary     _____
dis r
and r s       ;           _____\___
dest s        ;           _____
inv           ;                ____
dest q        ;
and q s       ;           ____/____
dest img
sub img q
add r img
stop
