;t_dde  --  test DDE functions
;
; This command file program measures several grey value properties
; of the objects in the 'cermet' image and sends them to an Excel
; spreadsheet using DDE. To run this program MS-Excel must be running
; and a sheet named 'SHEET1' must be present.
;
;dos "c:\excel\excel.exe"

int aant, nn

dest p
show p 
dis cermet >a
bord 0
aant = label -128
sub 1
dest q
set update 0              ;no automatic update

excelc                    ;close possible open link
excelo "sheet1"           ;open sheet1
for nn = 1 to aant step 1
  mark p nn               ;find next object
  and qc ac               ;use as a mask for grey value object
  stat qc -1              ;determine 15 grey value measures, store in Ibuf
  era qc
  excels 2 nn             ;send Ibuf data
endfor
excelc                    ;close link

stop

