;   TIM - DEMO                  1.12     DCOINS
;
; analysis of image 'muntsq' using distance transform
; expects: image 'muntsq' in 'a'
;
; The analysis is based on the fact, that the distance transform transforms
; a circular object to a cone, with a top consisting of exactly one pixel.
; This pixel's grey value represents its original size. The process is
; relatively insensitive to disturbances in shape due to touching objects.
; The position of the maximum can easily be found by producing the maximum
; of the distance transformed image. Pixels in both images having the same
; value represent the top (and the base).
;
;     -----    <--- maximum of cone
;    /  ^  \
;   /  / \  \
;         \-------- original cone
;
#include timdefs.h
parms
  int windis
endparms
int num = 2
int aant
int distance
int grv
int top = 4
int totaal = 0
int nGulden = 0
int nKwartje = 0
int nDubbeltje = 0 
int nStuiver = 0

*inilock         ;lock cursors (if necessary)
dest a
*windispl h (windis+WINLUT1)
dest p
perc a 7         ;remove noise
save r           ;keep as original
thre  8          ;keep coins
dt               ;distance transform. Circular objs are transformed to cones.
*windispl i windis
dest q			;
max p 7          ;get maximum:  
dest s			;
comp p == q      ;pixels                
curlock q s 1    ;couple cursors to access neccesary data in q and r
curlock r s 1    ;                    
mark 1           ;reset mark-pointer
aant = label
cls
scrs top 1
print "   C O I N                Number            Amount"
print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
;scrs (top+2) 1
print "100c piece (gulden): "
;scrs (top+3) 1
print " 25c piece (kwartje): " 
;scrs (top+4) 1
print " 10c piece (dubbeltje): " 
;scrs (top+5) 1
print "  5c piece (stuiver): " 
;scrs (top+6) 1
print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"



for num = 1 to aant step 1
  mark num /     ;search next object starting from reached position
    ;get grey value from corresponding position in dt-image
  if (distance = bgm q) > 95  ;analysis is based on size ...
     scrs (top+2) 1
     print  @30 ++nGulden,   @45 (nGulden*100), @z
     totaal += 100
  elseif distance > 70
     if (bgm r) < 40    ; ... and grey value
       scrs (top+5) 1
       print  @30 ++nStuiver,  @45 (nStuiver*5),  @z
     totaal += 5
     else
       scrs (top+3) 1
       print  @30 ++nKwartje,  @45 (nKwartje*25), @z
     totaal += 25
     endif
  elseif distance > 50
     scrs (top+4) 1
     print  @30 ++nDubbeltje, @45 (nDubbeltje*10), @z
     totaal += 10
  endif
  scrs (top+7) 1
  print @20 "Total:" @45 totaal
endfor

curlock r s 0
curlock q s 0
stop


