;dacross  --  TIMWIN DEMO   
;             Abingdon cross benchmark
;
; Expected: image in 'a'
;
#include timdefs.h
#include helpdefs.h

parms
 int windis
 file timdemo
 int hmode
endparms

int nn

;test availability images
if (((improp m16) & PIX16) != PIX16) stop "No 16-bits image available"

cls
; First generate Abingdon cross image
dis p
era16 m16
for nn = 1 to 6
;  dump 222
  noise nn
  sum m16 1
endfor

cp16 m16 p 6 /

curs 128 128
frmt 32 196
add pc 32
frmt 196 32
add pc 32
save a

*windispl h (windis+NO_DITHER+WINLUT1)
help timdemo DACrossBench, hmode

;perform benchmark in display (slower due to overhead)
lut 3

begin:
dis p

beep
 unif a 33
 thre  156
 lsk  1
beep
*windispl i (windis+NO_DITHER+WINLUT3)

print "Press key for Across benchmark in fast memory"
pause 
print ""

;perform benchmark in fast memory
dest b
beep
 unif a 33
 thre  156
 lsk  1
beep
copy b p
*windispl h (windis+NO_DITHER)
nn =  "Once more? (Yes = 1, No = 0)> "
if nn == 0 stop
cls

goto begin

stop
