/****************************************
 * stresc.c : translate escape sequences
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 ****************************************/

#include <ctype.h>

#include "system.h"
#include "stresc.h"


int StrEsc(s)
char *s;
{
    static char hex[] = "0123456789abcdef";
    char *t = s;
    int i;

    while (*s)
    {
        if (*s == '\\')
        {
            s++;
            switch(*s)
            {
                case '\\':
                    s++;
                    *t++ = '\\';
                break;

                case 'n':
                    s++;
                    *t++ = '\n';
                break;

                case 'r':
                    s++;
                    *t++ = '\r';
                break;

                case 't':
                    s++;
                    *t++ = '\t';
                break;

                case 'x':
                    s++;

                    for (i = 0; s[i] ;i++)
                        if (isupper(s[i]))
                            s[i] = tolower(s[i]);

                    for (*t = 0; *s ;s++)
                    {
                        for (i = 0; i < sizeof(hex) && *s != hex[i] ;i++);
                        if (i >= sizeof(hex))
                            break;

                        *t <<= 4;
                        *t += i;
                    }
                    t++;
                break;

                default:
                    *t++ = *s++;
            }
        }
        else if (*s == '^')
        {
            s++;
            *t++ = *s - 64;
            s++;
        }
        else
            *t++ = *s++;
    }

    *t = '\0';

    return(0);
}
