/**************************************
 * pcucp.c : the unix main() module
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 **************************************/

#include <sys/types.h>
#include <signal.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "system.h"
#include "config.h"
#include "usrmsg.h"
#include "bitcode.h"
#include "packetio.h"
#include "mux.h"
#include "connect.h"
#include "version.h"
#include "tty.h"

void MsgRealize(msg)
char *msg;
{
  fprintf(stderr,"%s\n",msg);
}

static int _disConnect = 0;

void CtrlClose(id)
int id;
{
  _disConnect = 1;
}

void Exit()
{
  char buf[256];
  int i;

  /* clean up after disconnect */

  for (i = 0; i < 10 && LineRead(buf,sizeof(buf)) > 0 ;i++)
    sleep(1);

  TtyRestore();

  printf("\n[pcucp : Connection closed.]\n");

  exit(0);
}

void SigHup()
{
  /* SIGHUP : terminate
   *  
   * MuxClose(0) performs local 
   * close on all channels, which
   * should also kill related
   * processes.
   */
   
  MsgDisplay(MSG_USER,"SIGHUP : terminating");
  MuxClose(0);
  exit(0);
}

void Sigtrap(sig)
int sig;
{
  /* generic signal action : disconnect */
  
  signal(sig,SIG_DFL); /* next time kills */

  MsgDisplay(MSG_USER,"signal %d : disconnecting",sig);
 
  ConDisconnect(10);
  while(ConDisconnect(0) == CON_WAIT)
    Sleep();

  MsgDisplay(MSG_USER,"Signal triggered disconnect done.");

  Exit();
}

main(argc,argv)
int argc;
char **argv;
{
  CONFIG c;
  int i, newerr, con;
  char buf[SYS_MAXPATH];

  if (argc > 1 && argv[1][0] == '-' && argv[1][1] == 'v')
    {
      printf("Pcucp version %s\n",VERSION_STRING);
      printf("%s\n",VERSION_COPYRIGHT);
      return(0);
    }

  if (ConfigRead(argc > 1 ? argv[1] : NULL,&c,NULL,NULL))
    return(1);

  PacketSetParams(c.packetSize,c.bitcode,c.padString);
  FileInit(c.inDir,c.outDir);

  sprintf(buf,"%s/pcucp.log",c.baseDir);
  newerr = open(buf,O_WRONLY | O_CREAT | O_TRUNC,S_IREAD | S_IWRITE);
  if (newerr < 0)
    {
      MsgError("main","cannot reopen stderr");
      exit(1);
    }
  dup2(newerr,2);
  close(newerr);
  
  /* catch common signals */

  signal(SIGHUP,SigHup);
  signal(SIGTERM,Sigtrap);
  signal(SIGABRT,Sigtrap);
  signal(SIGSYS,Sigtrap);
  signal(SIGSEGV,Sigtrap);
#ifdef SIGBUS
  signal(SIGBUS,Sigtrap);
#endif
  signal(SIGILL,Sigtrap);
  signal(SIGFPE,Sigtrap);
 
  /* initialize */
  
  TtyStore();
  TtyRaw();
  ConInit();

  /* wait for initial connection */

  printf("[pcucp : You have 10 seconds to connect.]\n");

  ConConnect(10);
  while ((con = ConConnect(0)) == CON_WAIT)
    Sleep();
  
  /* if connection ok, process packets until connection closed */

  if (con != CON_DONE)
    {
      TtyRestore();
      printf("[pcucp : Initial connection timed out.]\n");
      return(1);
    }
  else
    {
      while(!_disConnect)
    {
      ConFlush();
      Sleep();
    }
      
      /* flush */

      for (i = 0; i < 20 ;i++)
        {
          ConFlush();
          Sleep();
        }

      MsgDisplay(MSG_USER,"Disconnected on remote request");
      
    }

  Exit();
  /* NOTREACHED */
}
