/*****************************************************
 * tty.c : SysV tty handling
 *
 * by Jouni Lepp{j{rvi (C) 1992
 *****************************************************/

#include <termio.h>
#include "tty.h"

static struct termio _oldParams;

void TtyStore()
{
  ioctl(0,TCGETA,&_oldParams);
}

void TtyRestore()
{
  ioctl(0,TCSETAW,&_oldParams);
}

void TtyRaw()
{
  struct termio params;

  params = _oldParams;

  params.c_cc[VMIN] = 0;
  params.c_cc[VTIME] = 0;
  params.c_iflag = 0;
  params.c_oflag = 0;
  params.c_lflag = 0;
  params.c_line  = 0;

  ioctl(0,TCSETAW,&params);
}

void TtySane()
{
#ifdef TIOCSWINZ
  struct winsize ws;
#endif 

  TtyRestore();

#ifdef TIOCSWINZ
  ws.ws_row = 24;
  ws.ws_col = 80;
  ioctl(0,TIOCSWINSZ,&ws);
#endif
}
