/************************************************************
 * cttyopen.c : open a tty as the control tty (BSD / Ultrix)
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 ************************************************************/

#include <fcntl.h>
#include <sys/ioctl.h>

#include "system.h"
#include "cttyopen.h"

int CttyOpen(tty)
char *tty;
{
  int fd, pid;

  /* abadon old control terminal */

  fd = open("/dev/tty",O_RDWR);
  if (fd < 0)
    return(-1);
  ioctl(fd,TIOCNOTTY,NULL);
  close(fd);

  /* open stdin, stdout and stderr */

  fd = open(tty,O_RDWR); 
  if (fd < 0)
    return(-1);
    
  if (dup2(fd,0) != 0 || dup2(fd,1) != 1 || dup2(fd,2) != 2)
    {
      close(fd);
      return(-1);
    }

  close(fd);

  /* make it the control tty */

  pid = getpid();
  if (ioctl(0,TIOCSPGRP,&pid))
    return(-1);
  if (setpgrp(0,pid))
    return(-1);

  return(0);
}
