/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      : wstring.c                                                 */
/* Description  : draw a box in the color specified using bios              */
/*                  int 10h writepixel call                                 */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */
static int x, idx1, idx2, y, color;

/* ----------------------------------------------------------------------- */
/* as far as what we are actually doing here, now might be a good time to  */
/* review an assembly language listing of the int 10h function 0ch         */
/* ----------------------------------------------------------------------- */
void linebox(int x1, int y1, int x2, int y2, unsigned tempcolor)
{
  color = tempcolor&0xff;
  idx1 = x1;
  idx2 = x2;

  idx2++;             /* draw horizontal top line */
  x = idx1;
  y = y1;
  while (x < idx2) {
_asm {
      mov dx, y
      mov cx, x
      mov ax, color
      mov ah, 0ch
      sub bx, bx
      int 10h
}
    x++;
  }

  y++;                /* draw vertical sidelines */
  idx2--;
  while(y < y2) {
_asm {
      mov dx, y
      mov cx, idx1
      mov ax, color
      mov ah, 0ch
      sub bx, bx
      int 10h
      mov dx, y
      mov cx, idx2
      mov ax, color
      mov ah, 0ch
      sub bx, bx
      int 10h;
}
    y++;
  }
  
  idx2++;             /* draw horizontal bottom line */
  x = idx1;
  while(x < idx2) {
_asm {
      mov dx, y
      mov cx, x
      mov ax, color
      mov ah, 0ch
      sub bx, bx
      int 10h;
}
    x++;
  }
  return;
}
