/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      : crtmode.c                                                 */
/* Description  : use bios to set video mode                                */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */
#include <dos.h>
#include "stdkeys.h"


unsigned char setcrtmode(unsigned char vidmode)
{
    union REGS inregs, outregs;

    /* set mode */
    inregs.h.ah = 0;
    inregs.h.al = vidmode;
    int86( 0x10, &inregs, &outregs );

    /* get mode */
    inregs.h.ah = 0xf;
    int86( 0x10, &inregs, &outregs );

    /* return mode */
    return outregs.h.al;

}
