/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      : cgax.c                                                    */
/* Description  : cga xored drawing routines                                */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */

#include "stdkeys.h"

/* draw an xored horizontal line */
void cgahxline(int x, int y, int width)
{

   char far *crt;
   unsigned y1, x1, x2;
   unsigned char temp;

   y1 = ((y/CGA_Y_RATE) * CGA_LINE_SIZE) + (x/CGA_X_RATE);

   if (y%CGA_Y_RATE)
    crt = (char far *) 0xB8000000L + CGA_INTERLEAF + y1;
   else
    crt = (char far *) 0xB8000000L + y1;

   /* normalize pixel to memory offset (4 pixels per byte) */
   x2 = (width/CGA_X_RATE);
   for (x1 = 0; x1 < x2; x1++) {
    temp = *crt;
    *crt++ = temp^0xff;     /* reverse video */
   }
   return;
}


/* draw an xored box */
void cgaxbox(int x, int y, int width, int height)
{
  int idx;
  for (idx = 0; idx < height; idx++)
    cgahxline(x, y+idx, width);
  return;
}
