/* Program ShowFont */
/* Must be compiled using a SMALL memory model (read the FAQ for more info) */

#include <graphics.h>
#include <stdio.h>
#include <conio.h>

int main(int argc, char* argv[])
{
   const INTER_ROWS = 3;                     /* Blank pixels between two rows */
   const char* PATH_TO_BGI = "C:\\BC\\BGI";  /* Insert your path here! */

   char *FontName;
   int Driver, Mode, ErrCode, UserFont;
   int i;
   char ch[2];


   if (argc == 1)
   {
      printf("Syntax: SHOWFONT <FontName>\n");
      return 0;
   }

   FontName = argv[1];
   UserFont = installuserfont(FontName);
   if (graphresult() != grOk)
   {
      printf("Error installing %s", FontName);
      return 1;
   }

   Driver = DETECT;
   initgraph(&Driver, &Mode, PATH_TO_BGI);
   ErrCode = graphresult();
   if (ErrCode != grOk)
   {
      printf("Graphics error: %s\n", grapherrormsg(ErrCode));
      return 1;
   }

   settextstyle(UserFont, HORIZ_DIR, 4);
   ErrCode = graphresult();
   if (ErrCode != grOk)
   {
      closegraph();
      printf("Graphics error: %s\n", grapherrormsg(ErrCode));
      return 1;
   }

   bar(0,0, getmaxx(),getmaxy());  /* white background */
   settextjustify(LEFT_TEXT, TOP_TEXT);
   setcolor(BLACK);
   moveto(10,10);

   ch[1] = '\0';
   for (i = 0; i < 256; i++)
   {
      ch[0] = (char) i;
      if (textwidth(ch) > 0)  /* if char is defined ... */
      {
         if (getx() + textwidth(ch) >= getmaxx())  /* if current row is full ... */
            if (gety() + textheight("A") * 2 + INTER_ROWS < getmaxy())  /* if there is enough space for a row ... */
               moveto(10, gety() + textheight("A") + INTER_ROWS);
            else  /* the screen is full */
            {
               getch();  /* wait for a key */
               while (kbhit()) getch();  /* empty buffer */
               bar(0,0, getmaxx(),getmaxy());
               moveto(10,10);
            }
            outtext(ch);
      }
   }
   getch();  /* wait for a key */
   while (kbhit()) getch();  /* empty buffer */
   closegraph();
   return 0;
}
