/***********************************************************************

                      CSDB Library, Free Evaluation Version 2.0.5 
                                       Release: January 22th 1997 

       Header file of the VBAXE class.
       Just like the VBASE class but for very large
       databases.

                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSVBAXE_H
#define __CSVBAXE_H

#include "cstypes.h"
#include "cstbase.h"
#include "csvram.h"

////////////////////////////////////////////////////////////////////////

class VBASEi:public TBASE
{
   virtual int class_ID(void)  { return CS_CLID_VBASEi; }
};

////////////////////////////////////////////////////////////////////////

class VBASEd:public VRAM
{
   virtual int class_ID(void)  { return CS_CLID_VBASEd; }
};


////////////////////////////////////////////////////////////////////////



class VBAXE
{

    typedef struct
    {
      VPOI p;
      U16 len;
    }vbi;

    VBASEi  in;
    VBASEd  da;


public:

///////////////////////// Error & Messages ///////////////////////////

   void error_nr(U16 nr)          { in.error_nr(nr);}
   U16  error_nr(void  )          { return in.error_nr(); }

   U16  debug_error(U16 errnr)    { return in.debug_error(errnr); }

   U16  debug_error(U16 errnr,csCHAR *name)
                                  { return in.debug_error(errnr,name); }

   U16  visible_error(U16 errnr)  { return in.visible_error(errnr); }

   U16  visible_error(U16 errnr,csCHAR *name)
                                  { return in.visible_error(errnr,name); }



////////////////////////////////////////////////////////////////////////
////////////////////// PUBLIC FUNCTIONS ////////////////////////////////
////////////////////////////////////////////////////////////////////////
 public:


//////////////////////// Definition//////////////////////////////////////////
   int  define(csCHAR *name,U16 struclen);
   int  relocate_when_shrunk(void)    { return da.relocate_when_shrunk();}
   void relocate_when_shrunk(int ToF) { da.relocate_when_shrunk(ToF);    }


///////////////////////// Read-Only Mode ////////////////////////////////

   int  read_only(void)     { return read_only(TRUE); }
   int  read_only(int ToF);

   int  is_read_only(void)  { return in.is_read_only(); }


///////////////////////// Lock files ////////////////////////////////////

   void use_lock_file(int ToF)  { in.use_lock_file(ToF); da.use_lock_file(ToF); }
   int  use_lock_file(void   )  { return in.use_lock_file(); }

   int  lock_file_exist(csCHAR *DBNAME);

   int  remove_lock_file(csCHAR *DBName);

//////////////////////// Open & Close////////////////////////////////////////
   int  open(csCHAR *name,S16 kb_buf=100);
   int  close(void);
   int  save(void);



   int  IsOpen(void)        { return in.IsOpen(); }
   int  already_open(void)  { return in.already_open(); }


//////////////////////// Locate, Read & Writes records//////////////////////

   csCHAR *locate_rec(U32  rec);
   csCHAR *locate_rec_d(U32  rec);

   void read_rec(U32 pos,void *ptr,U16  &length);
   void read_rec(U32 pos,U16  maxlen,void *ptr,U16  &length);
   void write_rec(U32 i,void *d,U16 len);

//////////////////////// Add Records/////////////////////////////////////////
   U32  append_rec(void *p,U16 len);

//////////////////////// Number of Records///////////////////////////////////
   U32  numvrec(void)        { return in.numrec(); }

//////////////////////// Data in Header Page/////////////////////////////////
   int  data_2_header(void * ptr,U16 length)
        { return in.data_2_header(ptr,length); }
   int  header_2_data(void * ptr,U16 length)
        { return in.header_2_data(ptr,length); }
   U16  max_data_in_header(void)
        { return in.max_data_in_header(); }

////////////////////////// Deleting////////////////////////////////////////////
   int  is_delet(U32 k)      { return in.is_delet(k); }
   void delet(U32 k)         { in.delet(k);     }
   void undelet(U32 k )      { in.undelet(k);   }

////////////////////////// Record Length///////////////////////////////////////
   U16  rec_len(U32 k)       { return ((vbi *)in.locate_rec(k))->len; }
   U16  max_len(void)        { return da.max_len(); }

//////////////////////// Report Writing//////////////////////////////////////
   U16  report(csCHAR *name,S16 sub=1);
   void report(FILE *fipo,S16 sub);

////////////////////////// Miscellaneous///////////////////////////////////////

   int  background(void);
   int  pack(void);
// int  zap(void)              { return (da.zap() && in.zap()); }
   int  empty(void)            { return (da.empty() && in.empty()); }
   void info(void);

   virtual int class_ID(void)  { return CS_CLID_VBAXE; }
   void  echo_IO(int TF)       { in.echo_IO(TF); da.echo_IO(TF); }


// Made public to support the program generator.
   S32  sj_updated(void) { return in.sj_updated(); }
   S32  sj_created(void) { return in.sj_created(); }


};

#endif
