//// (c) gRayman 1996 ///////////////////////////////////////////////////////
// Project:        Screen Saver Quiz
// Author:         Gregor Rayman - Gregor.Rayman@anasoft.ana.sk
// Created:        21. 4. 1996
// Description:    Quite simple screen saver.
// Note:           This program is not freeware. You may freely use and
//                 distribute it, you may even freely use this source code.
//                 But all this only if you are not member of these Slovak
//                 political parties: HZDS, SNS and ZRS. There is nothing
//                 like registration, but I'd be glad to receive an e-mail,
//                 if you improve it.
// History:        21. 4. 1996 - first version
/////////////////////////////////////////////////////////////////////////////


#include <windows.h>
#include <windowsx.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <commdlg.h>

#include "quiz.h"
#include "resource.h"

/////////////////////////////////////////////////////////////////////////////
// Global Variables...
//
char const AppNameIniStr[] = "Screen Saver.Quiz";
char const ControlIniStr[] = "Control.Ini";
char const HeaderFontIniStr[] = "HeaderFont";
char const QuestionFontIniStr[] = "QuestionFont";
char const AnswerFontIniStr[] = "AnswerFont";
char const HeaderColorIniStr[] = "HeaderColor";
char const QuestionColorIniStr[] = "QuestionColor";
char const AnswerColorIniStr[] = "AnswerColor";
char const QuestionTimeIniStr[] = "QuestionTime";
char const AnswerTimeIniStr[] = "AnswerTime";
char const DataFilesIniStr[] = "DataFiles";
char const SmallIniStr[] = "Small";

HINSTANCE hInstance;
HWND hWnd;
POINT PrevPos;
SIZE ScreenSize;
int Height,
    Width;
int theX,
    theY,
    dirX,
    dirY;
LOGFONT HeaderLog,
        QuestionLog,
        AnswerLog;
LONG HeaderColor,
     QuestionColor,
     AnswerColor;
int QuestionTime,
    AnswerTime;
Quiz *theQuiz = NULL;
char *QuizPath = NULL,
     Sign,
     *SignFiles = NULL;
WORD nFiles = 0,
     nLeft = 0;
BOOL fTimerExists;
BOOL fSmall;
BOOL Mode = FALSE;
char *pszHeader,
     *pszQuestion,
     *pszAnswer;
int questionY,
    answerY;
LOGFONT hl,
        ql,
        al;
HBITMAP bitmap;

/////////////////////////////////////////////////////////////////////////////
// Function declarations
//

long CALLBACK __export MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
BOOL idleProc(DWORD count);
BOOL CALLBACK __export DialogProc(HWND, WORD, WORD, DWORD);
unsigned short random(unsigned short x);
BOOL ShowString(char const * s, int &y, HDC dc, BOOL draw);
void CountFiles(void);
void PickFile(void);
void Animate(void);
void WritePrivateProfileInt(char const * section, char const * line, int const val, char const * path);
void IniToLife(void);
void LifeToIni(void);
void About(HINSTANCE, HWND);

/////////////////////////////////////////////////////////////////////////////
// WinMain
//

int PASCAL WinMain(HINSTANCE hInst, HINSTANCE, LPSTR lpstrCmdLine, int)
{
    DWORD count = 0;
    MSG msgMain;
    hInstance = hInst;
    HWND hwndPre = GetActiveWindow();
    ScreenSize.cx = GetSystemMetrics(SM_CXSCREEN);
    ScreenSize.cy = GetSystemMetrics(SM_CYSCREEN);
    IniToLife();
    srand((unsigned) (GetCurrentTime() & 0xFFFF));
    while (random(2)==0);
    if ((lpstrCmdLine[0] == '-' || lpstrCmdLine[0] == '/') &&
        (lpstrCmdLine[1] == 'c' || lpstrCmdLine[1] == 'C'))
    {
        if (DialogBox(hInstance, MAKEINTRESOURCE(IDD_CONFIGURE),
            FindWindow(WC_DIALOG, "Desktop"), (FARPROC) DialogProc))
            LifeToIni();
    }
    else
    {
        CountFiles();
        PickFile();
        Width = ScreenSize.cx;
        Height = ScreenSize.cy;
        if (fSmall)
        {
            Width >>= 1;
            Height >>= 1;
            HeaderLog.lfHeight /= 2;
            HeaderLog.lfWidth /= 2;
            AnswerLog.lfHeight /= 2;
            AnswerLog.lfWidth /= 2;
            QuestionLog.lfHeight /= 2;
            QuestionLog.lfWidth /= 2;
            theX = random((unsigned short) Width);
            theY = random((unsigned short) Height);
            switch (random(4))
            {
            case 0:
                dirX = dirY = 1;
                break;
            case 1:
                dirX = dirY = -1;
                break;
            case 2:
                dirX = -(dirY = 1);
                break;
            default:
                dirX = -(dirY = -1);
            }
        }

        BOOL KeepRunning = TRUE;
        {
            // We do it in it's own block, so we get rid of temporary
            // variables needen only during the initialization.
            WNDCLASS wc;
            wc.style = CS_SAVEBITS;
            wc.lpfnWndProc = MainWndProc;
            wc.cbClsExtra = 0;
            wc.cbWndExtra = 0;
            wc.hInstance = hInstance;
            wc.hIcon = NULL;
            wc.hCursor = NULL;
            wc.hbrBackground = GetStockObject(BLACK_BRUSH);
            wc.lpszMenuName = NULL;
            wc.lpszClassName = "SCR_SAV_WINDOW";
            RegisterClass(&wc);
        }

        hWnd = CreateWindow("SCR_SAV_WINDOW",
                            NULL,
                WS_VISIBLE | WS_POPUP | 
                #ifndef _DEBUG
                WS_EX_TOPMOST | 
                #endif
                WS_MAXIMIZE,
                            0, 0, 0, 0, NULL, NULL, hInst, NULL);

        if (!hWnd)
            return 0;
        #ifndef _DEBUG
        ShowCursor(FALSE);
        #endif

        fTimerExists = fSmall ? FALSE : SetTimer(hWnd, 1, fSmall ? 100 : 1000, NULL) ? TRUE : FALSE;

        while (KeepRunning)
        {
            while (PeekMessage((LPMSG) & msgMain, NULL, 0, 0, PM_REMOVE) && KeepRunning)
            {
                if (msgMain.message == WM_QUIT)
                    KeepRunning = FALSE;
                else
                {
                    TranslateMessage((LPMSG) & msgMain);
                    DispatchMessage((LPMSG) & msgMain);
                }
            }
            if (!idleProc(count++))
                WaitMessage();
        }
        #ifndef _DEBUG
        ShowCursor(TRUE);
        #endif
        if (fTimerExists)
        {
            KillTimer(hWnd, 1);
        }
    }

    free(QuizPath);
    if (theQuiz)
        delete theQuiz;
    if (SignFiles)
        free(SignFiles);
    if (pszHeader)
        free(pszHeader);
    if (pszQuestion)
        free(pszQuestion);
    if (pszAnswer)
        free(pszAnswer);
    if (bitmap)
        DeleteObject(bitmap);
    if (hwndPre)
        SetActiveWindow(hwndPre);
    return 0;
}

/////////////////////////////////////////////////////////////////////////////
// MainWndProc - the procedure of our Window

long CALLBACK __export MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
    case WM_CREATE:
        GetCursorPos(&PrevPos);
        break;
    case WM_MOUSEMOVE:
        if (MAKEPOINT(lParam).x != PrevPos.x + 1 || MAKEPOINT(lParam).y != PrevPos.y + 1)
            PostQuitMessage(0);
        break;
    case WM_LBUTTONDOWN:
    case WM_RBUTTONDOWN:
    case WM_MBUTTONDOWN:
    case WM_LBUTTONDBLCLK:
    case WM_RBUTTONDBLCLK:
    case WM_MBUTTONDBLCLK:
    case WM_KEYDOWN:
        PostQuitMessage(0);
        break;
    case WM_ACTIVATE:
    case WM_ACTIVATEAPP:
        if (!wParam)
            PostQuitMessage(0);
        break;
    case WM_TIMER:
        Animate();
        break;
    default:
        return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (NULL);
}

/////////////////////////////////////////////////////////////////////////////
// idleProc - called when no message in queue. Returns TRUE if there is
//  something more to do. FALSE if there is nothing to do.

BOOL idleProc(DWORD)
{
    if (nFiles && !fTimerExists)
        Animate();
    return nFiles ? !fTimerExists : FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// ShowString - Shows wrapped text if draw==TRUE, stats drawing at x,y
//  y is increased by the total height. Returns TRUE if there was a word not
//  fitting into one line.

BOOL ShowString(char const * s, int &y, int x, int width, HDC dc, BOOL draw)
{
    if (!s) 
        return FALSE;
    BOOL result = FALSE;
    SIZE size;
    int i,
        j;
    i = 0;
    do
    {
        for (j = 0; s[i + j] != '\n' && s[i + j]; j++);
        if (j)
        {
            do
            {
                GetTextExtentPoint(dc, s + i, j, &size);
                if (size.cx > width)
                {
                    if (j)
                        j--;
                    while (s[i + j] != ' ' && j)
                        j--;
                }
            } while (size.cx > width && j);
    
            if (!j)
            {
                result = TRUE;
                for (j = 0; s[i + j] != '\n' && s[i + j] != ' ' && s[i + j]; j++);
            }
            if (draw)
                TextOut(dc, x, y, s + i, j);
            y += size.cy;
            i += j;
        }
        if (s[i] == '\n' || s[i] == ' ')
            i++;
    } while (s[i]);
    return result;
}


/////////////////////////////////////////////////////////////////////////////
// CountFiles - gets the number of aviable files and prepares internal
//  variables for selecting files

#ifdef __TURBOC__
#define _find_t         find_t
#endif

void CountFiles(void)
{
    _find_t ff;
    nFiles = 0;
    Sign = 0;
    if (!_dos_findfirst(QuizPath, ~_A_VOLID, &ff))
    {
        nFiles = 1;
        while (!_dos_findnext(&ff) && nFiles < 0xFFF0)
            nFiles++;
    }
    if (nFiles)
    {
        SignFiles = (char *) calloc(1, nFiles);
    }
    else
        SignFiles = NULL;
    nLeft = nFiles;
}

/////////////////////////////////////////////////////////////////////////////
// PickFile - gets one of the aviable quiz files

void PickFile(void)
{
    WORD picked = random(nFiles);
    if (nFiles > 1)
    {
        if (!nLeft--)
        {
            Sign = (char) !Sign;
            nLeft = nFiles - 1;
        }

        while (SignFiles[picked] != Sign)
            if (++picked >= nFiles)
                picked = 0;

        SignFiles[picked] = (char) !Sign;
    }
    _find_t ff;
    if (!_dos_findfirst(QuizPath, ~_A_VOLID, &ff))
    {
        while (picked && !_dos_findnext(&ff))
            picked--;
        char buff[_MAX_PATH];
        char buff2[_MAX_DIR];
        _splitpath(QuizPath, buff, buff2, NULL, NULL);
        strcat(buff, buff2);
        if (!*buff || buff[strlen(buff) - 1] != '\\')
            strcat(buff, "\\");
        strcat(buff, ff.name);
        theQuiz = new Quiz(buff);
    }
    else
        theQuiz = NULL;
}

/////////////////////////////////////////////////////////////////////////////
// LOGFONT <-> string conversions

static void LogFontFromString(const char *str, LOGFONT & logFont)
{
    char const *p = str;
    logFont.lfHeight = atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfWidth = atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfEscapement = atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfOrientation = atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfWeight = atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfItalic = (BYTE) atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfUnderline = (BYTE) atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfStrikeOut = (BYTE) atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfCharSet = (BYTE) atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfOutPrecision = (BYTE) atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfClipPrecision = (BYTE) atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfQuality = (BYTE) atoi(p);
    p = strchr(p, ';') + 1;
    logFont.lfPitchAndFamily = (BYTE) atoi(p);
    p = strchr(p, ';') + 1;
    strcpy(logFont.lfFaceName, p);
}

static void StringFromLogFont(char *str, LOGFONT & logFont)
{
    wsprintf(str, "%d;%d;%d;" "%d;%d;%d;" "%d;%d;%d;" "%d;%d;%d;" "%d;%s",
             logFont.lfHeight,
             logFont.lfWidth,
             logFont.lfEscapement,

             logFont.lfOrientation,
             logFont.lfWeight,
             (int) logFont.lfItalic,

             (int) logFont.lfUnderline,
             (int) logFont.lfStrikeOut,
             (int) logFont.lfCharSet,

             (int) logFont.lfOutPrecision,
             (int) logFont.lfClipPrecision,
             (int) logFont.lfQuality,

             (int) logFont.lfPitchAndFamily,
             logFont.lfFaceName);
}

/////////////////////////////////////////////////////////////////////////////
// RGB <-> string conversions

static long RGBFromString(char const * str)
{
    char const *p = str;
    BYTE r = (BYTE) atoi(p);
    p = strchr(p, ';') + 1;
    BYTE g = (BYTE) atoi(p);
    p = strchr(p, ';') + 1;
    BYTE b = (BYTE) atoi(p);
    return RGB(r, g, b);
}

void StringFromRGB(char *str, DWORD const rgb)
{
    wsprintf(str, "%d;%d;%d",
             (int) (rgb & 0xFF),
             (int) ((rgb >> 8) & 0xFF),
             (int) ((rgb >> 16) & 0xFF));
}

/////////////////////////////////////////////////////////////////////////////
// IniToLife - reads the CONTROL.INI file

void IniToLife(void)
{
    char buffer[128];
    GetPrivateProfileString(AppNameIniStr, HeaderFontIniStr,
                            "-32;0;0;0;400;0;0;0;238;3;2;1;34;Arial",
                            buffer, 127, ControlIniStr);
    WritePrivateProfileString(AppNameIniStr, HeaderFontIniStr, buffer, ControlIniStr);
    LogFontFromString(buffer, HeaderLog);
    GetPrivateProfileString(AppNameIniStr, QuestionFontIniStr,
                            "-42;0;0;0;400;0;0;0;238;3;2;1;34;Arial",
                            buffer, 127, ControlIniStr);
    WritePrivateProfileString(AppNameIniStr, QuestionFontIniStr, buffer, ControlIniStr);
    LogFontFromString(buffer, QuestionLog);
    GetPrivateProfileString(AppNameIniStr, AnswerFontIniStr,
                            "-42;0;0;0;400;0;0;0;238;3;2;1;34;Arial",
                            buffer, 127, ControlIniStr);
    WritePrivateProfileString(AppNameIniStr, AnswerFontIniStr, buffer, ControlIniStr);
    LogFontFromString(buffer, AnswerLog);
    GetPrivateProfileString(AppNameIniStr, HeaderColorIniStr, "255;255;0", buffer, 127, ControlIniStr);
    WritePrivateProfileString(AppNameIniStr, HeaderColorIniStr, buffer, ControlIniStr);
    HeaderColor = RGBFromString(buffer);
    GetPrivateProfileString(AppNameIniStr, QuestionColorIniStr, "255;255;0", buffer, 127, ControlIniStr);
    WritePrivateProfileString(AppNameIniStr, QuestionColorIniStr, buffer, ControlIniStr);
    QuestionColor = RGBFromString(buffer);
    GetPrivateProfileString(AppNameIniStr, AnswerColorIniStr, "255;255;255", buffer, 127, ControlIniStr);
    WritePrivateProfileString(AppNameIniStr, AnswerColorIniStr, buffer, ControlIniStr);
    AnswerColor = RGBFromString(buffer);
    QuestionTime = GetPrivateProfileInt(AppNameIniStr, QuestionTimeIniStr, 5, ControlIniStr);
    WritePrivateProfileInt(AppNameIniStr, QuestionTimeIniStr, QuestionTime, ControlIniStr);
    AnswerTime = GetPrivateProfileInt(AppNameIniStr, AnswerTimeIniStr, 5, ControlIniStr);
    WritePrivateProfileInt(AppNameIniStr, AnswerTimeIniStr, AnswerTime, ControlIniStr);
    fSmall = (BOOL) GetPrivateProfileInt(AppNameIniStr, SmallIniStr, 0, ControlIniStr);
    WritePrivateProfileInt(AppNameIniStr, SmallIniStr, (int) fSmall, ControlIniStr);
    GetPrivateProfileString(AppNameIniStr, DataFilesIniStr, "", buffer, 127, ControlIniStr);
    if (!*buffer)
    {
        GetWindowsDirectory(buffer, 127);
        if (buffer[strlen(buffer) - 1] != '\\')
            strcat(buffer, "\\");
        strcat(buffer, "*.qiz");
    }
    WritePrivateProfileString(AppNameIniStr, DataFilesIniStr, buffer, ControlIniStr);
    QuizPath = strdup(buffer);
}

/////////////////////////////////////////////////////////////////////////////
// LifeToIni store current settings to the CONTROL.INI file

void LifeToIni(void)
{
    char buffer[128];
    StringFromLogFont(buffer, HeaderLog);
    WritePrivateProfileString(AppNameIniStr, HeaderFontIniStr, buffer, ControlIniStr);

    StringFromLogFont(buffer, QuestionLog);
    WritePrivateProfileString(AppNameIniStr, QuestionFontIniStr, buffer, ControlIniStr);

    StringFromLogFont(buffer, AnswerLog);
    WritePrivateProfileString(AppNameIniStr, AnswerFontIniStr, buffer, ControlIniStr);

    StringFromRGB(buffer, HeaderColor);
    WritePrivateProfileString(AppNameIniStr, HeaderColorIniStr, buffer, ControlIniStr);

    StringFromRGB(buffer, QuestionColor);
    WritePrivateProfileString(AppNameIniStr, QuestionColorIniStr, buffer, ControlIniStr);

    StringFromRGB(buffer, AnswerColor);
    WritePrivateProfileString(AppNameIniStr, AnswerColorIniStr, buffer, ControlIniStr);

    WritePrivateProfileInt(AppNameIniStr, QuestionTimeIniStr, QuestionTime, ControlIniStr);
    WritePrivateProfileInt(AppNameIniStr, AnswerTimeIniStr, AnswerTime, ControlIniStr);
    WritePrivateProfileInt(AppNameIniStr, SmallIniStr, (int) fSmall, ControlIniStr);

    WritePrivateProfileString(AppNameIniStr, DataFilesIniStr, QuizPath, ControlIniStr);
}

/////////////////////////////////////////////////////////////////////////////
// Animate is called every now and then to draw the screen

#define shrink(X) {(X) = (int) (((long int)X*7)/8);}

void Animate()
{
    static DWORD LastTime = 0;
    static BOOL firstTime = TRUE;

    if (fSmall && bitmap)
    {
        HDC xdc = GetDC(hWnd);
        HDC dc = CreateCompatibleDC(xdc);
        SelectObject(dc, bitmap);
        theX += dirX;
        theY += dirY;
        if (theX < 0 || theX > Width)
        {
            dirX = -dirX;
            theX += dirX + dirX;
        }
        if (theY < 0 || theY > Height)
        {
            dirY = -dirY;
            theY += dirY + dirY;
        }
        BitBlt(xdc, theX, theY, Width, Height, dc, 0, 0, SRCCOPY);
        DeleteDC(dc);
        ReleaseDC(hWnd, xdc);
    }

    if (LastTime + 1000 * (Mode ? QuestionTime : AnswerTime) > GetCurrentTime())
        return;
    HDC xdc = GetDC(hWnd);
    HFONT headerFont,
          questionFont,
          answerFont;
    if (xdc)
    {                             
        if (firstTime)
        {                                                                                        
            #ifndef _DEBUG
            SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_NOREDRAW);
            #endif
            SelectObject(xdc, GetStockObject(BLACK_BRUSH));
            SelectObject(xdc, GetStockObject(BLACK_PEN));
            Rectangle(xdc, 0,0,ScreenSize.cx, ScreenSize.cy);
            firstTime = FALSE;
        }
        int y;
        LastTime = GetCurrentTime();

        if (!Mode)
        {
            hl = HeaderLog;
            ql = QuestionLog;
            al = AnswerLog;
        }

        headerFont = CreateFontIndirect(&hl);
        questionFont = CreateFontIndirect(&ql);
        answerFont = CreateFontIndirect(&al);
        if (!Mode && theQuiz && theQuiz->getLines())
        {
            if (!bitmap)
                bitmap = CreateCompatibleBitmap(xdc, Width, Height);
            HDC dc = CreateCompatibleDC(xdc);
            SetBkColor(dc, 0L);
            SelectObject(dc, bitmap);
            if (pszHeader)
                free(pszHeader);
            if (pszQuestion)
                free(pszQuestion);
            if (pszAnswer)
                free(pszAnswer);
            pszQuestion = theQuiz->getQuestion();
            pszHeader = theQuiz->getHeader();
            pszAnswer = theQuiz->getAnswer();

            BOOL goon;
            do
            {
                goon = FALSE;
                y = 1;
                SelectObject(dc, headerFont);
                if (ShowString(pszHeader, y, 1, Width - 2, dc, FALSE) && hl.lfHeight)
                {
                    shrink(hl.lfHeight);
                    shrink(hl.lfWidth);
                    DeleteObject(headerFont);
                    headerFont = CreateFontIndirect(&hl);
                    goon = TRUE;
                    continue;
                }
                questionY = y;
                SelectObject(dc, questionFont);
                if (ShowString(pszQuestion, y, 1, Width - 2, dc, FALSE) && ql.lfHeight)
                {
                    shrink(ql.lfHeight);
                    shrink(ql.lfWidth);
                    DeleteObject(questionFont);
                    questionFont = CreateFontIndirect(&ql);
                    goon = TRUE;
                    continue;
                }
                answerY = y;
                SelectObject(dc, answerFont);
                if (ShowString(pszAnswer, y, 1, Width - 2, dc, FALSE) && al.lfHeight)
                {
                    shrink(al.lfHeight);
                    shrink(al.lfWidth);
                    DeleteObject(answerFont);
                    answerFont = CreateFontIndirect(&al);
                    goon = TRUE;
                    continue;
                }
                answerY = Height - 1 - y + answerY;
                if (y > Height - 1 &&
                    (ql.lfHeight || al.lfHeight || hl.lfHeight))
                {
                    shrink(hl.lfHeight);
                    shrink(hl.lfWidth);
                    shrink(ql.lfHeight);
                    shrink(ql.lfWidth);
                    shrink(al.lfHeight);
                    shrink(al.lfWidth);
                    DeleteObject(headerFont);
                    headerFont = CreateFontIndirect(&hl);
                    DeleteObject(questionFont);
                    questionFont = CreateFontIndirect(&ql);
                    DeleteObject(answerFont);
                    answerFont = CreateFontIndirect(&al);
                    goon = TRUE;
                    continue;
                }
            } while (goon);

            SelectObject(dc, GetStockObject(BLACK_BRUSH));
            Rectangle(dc, 0, 0, Width, Height);
            y = 1;
            SelectObject(dc, headerFont);
            SetTextColor(dc, HeaderColor);
            ShowString(pszHeader, y, 1, Width - 2, dc, TRUE);

            if (!Sign)
            {
                SelectObject(dc, questionFont);
                SetTextColor(dc, QuestionColor);
                ShowString(pszQuestion, questionY, 1, Width - 2, dc, TRUE);
            }
            else
            {
                SelectObject(dc, answerFont);
                SetTextColor(dc, AnswerColor);
                ShowString(pszAnswer, answerY, 1, Width - 2, dc, TRUE);
            }
            SelectObject(dc, GetStockObject(NULL_BRUSH));
            SelectObject(dc, GetStockObject(BLACK_PEN));
            Rectangle(dc, 0, 0, Width, Height);
            BitBlt(xdc, theX, theY, Width, Height, dc, 0, 0, SRCCOPY);
            DeleteDC(dc);
        }
        else if (theQuiz && theQuiz->getLines())
        {
            {
                HDC dc = CreateCompatibleDC(xdc);
                SetBkColor(dc, 0L);
                SelectObject(dc, bitmap);
                if (Sign)
                {
                    SelectObject(dc, questionFont);
                    SetTextColor(dc, QuestionColor);
                    ShowString(pszQuestion, questionY, 1, Width - 2, dc, TRUE);
                }
                else
                {
                    SelectObject(dc, answerFont);
                    SetTextColor(dc, AnswerColor);
                    ShowString(pszAnswer, answerY, 1, Width - 2, dc, TRUE);
                }
                SelectObject(dc, GetStockObject(NULL_BRUSH));
                SelectObject(dc, GetStockObject(BLACK_PEN));
                Rectangle(dc, 0, 0, Width, Height);
                BitBlt(xdc, theX, theY, Width, Height, dc, 0, 0, SRCCOPY);
                DeleteDC(dc);
            }
        }
        Mode = 1 - Mode;
        DeleteObject(headerFont);
        DeleteObject(answerFont);
        DeleteObject(questionFont);
        ReleaseDC(hWnd, xdc);
    }
    if (!Mode && (theQuiz && theQuiz->getRepeating() || !theQuiz))
    {
        if (nFiles > 1)
        {
            if (theQuiz)
                delete theQuiz;
            PickFile();
        }
        else
        {
            theQuiz->setRepeating(0);
            Sign = (char) !Sign;
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
// Setup dialog procedure

BOOL __export CALLBACK DialogProc(HWND hDlg, WORD message, WORD wParam, DWORD lParam)
{
    switch (message)
    {
    case WM_INITDIALOG:
        {
            SetDlgItemInt(hDlg, IDC_QUESTION_TIME, QuestionTime, FALSE);
            SetDlgItemInt(hDlg, IDC_ANSWER_TIME, AnswerTime, FALSE);
            SetDlgItemText(hDlg, IDC_QUIZ_PATH, QuizPath);
            SendDlgItemMessage(hDlg, IDC_SMALL, BM_SETCHECK, fSmall ? 1 : 0, 0);
            InvalidateRect(hDlg, NULL, TRUE);
        }
        return (TRUE);
    case WM_COMMAND:
        {
            if (HIWORD(lParam) == BN_CLICKED)
            {
                if (wParam == IDC_HEADER_FONT ||
                    wParam == IDC_ANSWER_FONT ||
                    wParam == IDC_QUESTION_FONT)
                {
                    LOGFONT Log,
                           *LogPtr;
                    LONG *ColorPtr;

                    switch (wParam)
                    {
                    case IDC_HEADER_FONT:
                        LogPtr = &HeaderLog;
                        ColorPtr = &HeaderColor;
                        break;
                    case IDC_QUESTION_FONT:
                        LogPtr = &QuestionLog;
                        ColorPtr = &QuestionColor;
                        break;
                    default:
                        LogPtr = &AnswerLog;
                        ColorPtr = &AnswerColor;
                    }
                    Log = *LogPtr;
                    CHOOSEFONT cf;
                    memset(&cf, 0, sizeof(CHOOSEFONT));
                    cf.lStructSize = sizeof(CHOOSEFONT);
                    cf.hwndOwner = hDlg;
                    cf.lpLogFont = &Log;
                    cf.Flags = CF_SCREENFONTS | CF_EFFECTS | CF_INITTOLOGFONTSTRUCT |
                        CF_SCALABLEONLY | CF_FORCEFONTEXIST;
                    cf.rgbColors = *ColorPtr;
                    cf.nFontType = SCREEN_FONTTYPE;
                    if (ChooseFont(&cf))
                    {
                        *LogPtr = Log;
                        *ColorPtr = cf.rgbColors;
                    }
                }
                else if (wParam == IDOK)
                {
                    BOOL fTranslated;
                    QuestionTime = GetDlgItemInt(hDlg, IDC_QUESTION_TIME, &fTranslated, FALSE);
                    if (!QuestionTime || !fTranslated)
                    {
                        char buffer[100];
                        LoadString(hInstance, IDS_QUESTION_TIME, buffer, 100);
                        MessageBox(hDlg, buffer, "Quiz setup", MB_OK | MB_ICONEXCLAMATION);
                        return (TRUE);
                    }
                    AnswerTime = GetDlgItemInt(hDlg, IDC_ANSWER_TIME, &fTranslated, FALSE);
                    if (!QuestionTime || !fTranslated)
                    {
                        char buffer[100];
                        LoadString(hInstance, IDS_ANSWER_TIME, buffer, 100);
                        MessageBox(hDlg, buffer, "Quiz setup", MB_OK | MB_ICONEXCLAMATION);
                        return (TRUE);
                    }
                    free(QuizPath);
                    DWORD len = SendDlgItemMessage(hDlg, IDC_QUIZ_PATH, WM_GETTEXTLENGTH, 0, 0);
                    if (len > 127)
                    {
                        char buffer[100];
                        LoadString(hInstance, IDS_TOO_LONG_PATH, buffer, 100);
                        MessageBox(hDlg, buffer, "Quiz setup", MB_OK | MB_ICONEXCLAMATION);
                        return (TRUE);
                    }
                    QuizPath = (char *) malloc((size_t) len + 1);
                    GetDlgItemText(hDlg, IDC_QUIZ_PATH, QuizPath, (size_t) len + 1);
                    fSmall = SendDlgItemMessage(hDlg, IDC_SMALL, BM_GETSTATE, 0, 0) ? TRUE : FALSE;
                    EndDialog(hDlg, TRUE);
                }
                else if (wParam == IDCANCEL)
                    EndDialog(hDlg, FALSE);
                else if (wParam == IDC_ABOUT)
                    About(hInstance, hDlg);
                else
                    return (FALSE);
                return (TRUE);
            }
        }
    }
    return (FALSE);
}


/////////////////////////////////////////////////////////////////////////////
// Useful functions

unsigned short random(unsigned short x)
{
    return (unsigned short) (((unsigned long) rand() * (unsigned long) x) / (unsigned long) RAND_MAX);
}

void WritePrivateProfileInt(char const * section, char const * line, int const val, char const * path)
{
    char buffer[10];
    itoa(val, buffer, 10);
    WritePrivateProfileString(section, line, buffer, path);
}
