//// (c) gRayman 1996 ///////////////////////////////////////////////////////
// Project:        Screen Saver Quiz
// Author:         Gregor Rayman - Gregor.Rayman@anasoft.ana.sk
// Created:        21. 4. 1996
// Description:    Quite simple screen saver.
// Note:           This program is not freeware. You may freely use and
//                 distribute it, you may even freely use this source code.
//                 But all this only if you are not member of these Slovak
//                 political parties: HZDS, SNS and ZRS. There is nothing
//                 like registration, but I'd be glad to receive an e-mail,
//                 if you improve it.
// History:        21. 4. 1996 - first version
/////////////////////////////////////////////////////////////////////////////


#include <windows.h>
#include <windowsx.h>
#include <stdlib.h>
#include <string.h>
#include <commdlg.h>
#include <ver.h>

#include "resource.h"

static HINSTANCE hInstance;

BOOL __export CALLBACK AboutProc(HWND hDlg, WORD message, WORD wParam, DWORD lParam)
{
    if (message == WM_COMMAND && (wParam == IDOK || wParam == IDCANCEL)
        && HIWORD(lParam) == BN_CLICKED)
    {
        EndDialog(hDlg, wParam == IDOK);
        return TRUE;
    }
    if (message == WM_INITDIALOG)
    {
        char *fvData,
            *fvText;
        char FAR *lpBuffer;
        DWORD fvHandle;
        char fileName[256];
        char subBlockName[255];
        UINT wSize;
        BOOL fOK;
        WORD w1,
             w2;

        GetModuleFileName(hInstance, fileName, sizeof(fileName));
        OemToAnsi(fileName, fileName);
        DWORD dwSize = GetFileVersionInfoSize(fileName, &fvHandle);
        if (dwSize)
        {
            fvData = (char *) malloc((UINT) dwSize);
            fvText = (char *) malloc((UINT) dwSize);
            *fvText = '\0';
            if (GetFileVersionInfo(fileName, fvHandle, dwSize, fvData))
            {
                strcpy(subBlockName, "\\VarFileInfo\\Translation");
                fOK = VerQueryValue(fvData, subBlockName, (VOID FAR * FAR *) & lpBuffer, &wSize);
                if (fOK && wSize)
                {
                    w1 = ((WORD *) lpBuffer)[0];
                    w2 = ((WORD *) lpBuffer)[1];
                    wsprintf(subBlockName, "\\StringFileInfo\\%04X%04X\\ProductName", w1, w2);
                    fOK = VerQueryValue(fvData, subBlockName, (VOID FAR * FAR *) & lpBuffer, &wSize);
                    if (fOK && dwSize)
                    {
                        strcat(fvText, lpBuffer);
                    }
                    wsprintf(subBlockName, "\\StringFileInfo\\%04X%04X\\ProductVersion", w1, w2);
                    fOK = VerQueryValue(fvData, subBlockName, (VOID FAR * FAR *) & lpBuffer, &wSize);
                    if (fOK && dwSize)
                    {
                        strcat(fvText, "  ");
                        strcat(fvText, lpBuffer);
                    }
                    wsprintf(subBlockName, "\\StringFileInfo\\%04X%04X\\LegalCopyright", w1, w2);
                    fOK = VerQueryValue(fvData, subBlockName, (VOID FAR * FAR *) & lpBuffer, &wSize);
                    if (fOK && dwSize)
                    {
                        strcat(fvText, "\n");
                        strcat(fvText, lpBuffer);
                    }
                    wsprintf(subBlockName, "\\StringFileInfo\\%04X%04X\\LegalTrademarks", w1, w2);
                    fOK = VerQueryValue(fvData, subBlockName, (VOID FAR * FAR *) & lpBuffer, &wSize);
                    if (fOK && dwSize)
                    {
                        strcat(fvText, "\n");
                        strcat(fvText, lpBuffer);
                    }
                    wsprintf(subBlockName, "\\StringFileInfo\\%04X%04X\\Comment", w1, w2);
                    fOK = VerQueryValue(fvData, subBlockName, (VOID FAR * FAR *) & lpBuffer, &wSize);
                    if (fOK && dwSize)
                    {
                        strcat(fvText, "\n\n");
                        strcat(fvText, lpBuffer);
                    }
                    SetDlgItemText(hDlg, IDC_ABOUT_TEXT, fvText);
                }
            }
            free(fvData);
            free(fvText);
        }
        return TRUE;
    }
    return FALSE;
}

void About(HINSTANCE hInst, HWND hWnd)
{
    hInstance = hInst;
    DialogBox(hInstance, MAKEINTRESOURCE(IDD_ABOUT), hWnd, (FARPROC) AboutProc);
}