unit JwAutAbt;

interface

uses
  {$IFDEF WIN32} Windows, {$ELSE} WinProcs, WinTypes, {$ENDIF} Messages, SysUtils,
  Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TfrmAutoAbout = class(TForm)
    Bevel1: TBevel;
    imgIcon: TImage;
    lbProgName: TLabel;
    lbVersion: TLabel;
    memComments: TMemo;
    Label4: TLabel;
    lbLastEdited: TLabel;
    Label5: TLabel;
    lbControlCode: TLabel;
    Label7: TLabel;
    btOkay: TBitBtn;
    Bevel2: TBevel;
    procedure btOkayClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


 TJwAutoAbout = class(TComponent)
   private
     FAppName : String;
     FAppPic : TPicture;
     FComments : TStrings;
     FControlCode : String;
     FLastEdited : String;
     FVersion : String;

     function GetAppName : String;
     procedure SetAppName(Value : String);
     function GetAppPic : TPicture;
     procedure SetAppPic(Value : TPicture);
     function GetComments : TStrings;
     procedure SetComments(Value : TStrings);
     function GetControlCode : String;
     procedure SetControlCode(Value : String);
     function GetLastEdited : String;
     procedure SetLastEdited(Value : String);
     function GetVersion : String;
     procedure SetVersion(Value : String);
   protected
     procedure Loaded; override;
   public
     constructor Create(AOwner: TComponent); override;
     destructor Destroy; override;
     function Execute : Boolean;

   published
     property AppName : String read GetAppName write SetAppName;
     property AppPic : TPicture read GetAppPic write SetAppPic;
     property Comments : TStrings read GetComments write SetComments;
     property ControlCode : String read GetControlCode write SetControlCode;
     property LastEdited : String read GetLastEdited write SetLastEdited;
     property Version : String read GetVersion write SetVersion;
   end;


procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('JwTools', [TJwAutoAbout]);
end;

{$R *.DFM}

function TJwAutoAbout.GetAppName : String;
begin
  Result := FAppName;
end;

procedure TJwAutoAbout.SetAppName(Value : String);
begin
  FAppName := Value;
end;

function TJwAutoAbout.GetAppPic : TPicture;
begin
  Result := FAppPic;
end;

procedure TJwAutoAbout.SetAppPic(Value : TPicture);
begin
  FAppPic.Assign(Value);
end;

function TJwAutoAbout.GetComments : TStrings;
begin
  Result := FComments;
end;

procedure TJwAutoAbout.SetComments(Value : TStrings);
begin
  FComments.Assign(Value);
end;

function TJwAutoAbout.GetControlCode : String;
begin
  Result := FControlCode;
end;

procedure TJwAutoAbout.SetControlCode(Value : String);
begin
  FControlCode := Value;
end;

function TJwAutoAbout.GetLastEdited : String;
begin
  Result := FLastEdited;
end;

procedure TJwAutoAbout.SetLastEdited(Value : String);
begin
  FLastEdited := Value;
end;

function TJwAutoAbout.GetVersion : String;
begin
  Result := FVersion;
end;

procedure TJwAutoAbout.SetVersion(Value : String);
begin
  FVersion := Value;
end;

constructor TJwAutoAbout.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FAppPic := TPicture.Create;
  FComments := TStringList.Create;

  FAppName := '';
  FControlCode := 'XXX-XXXX-X';
  FLastEdited := DateToStr( Now );
  FVersion := '1.00';
end;

destructor TJwAutoAbout.Destroy;
begin
  FAppPic.Free;
  FComments.Free;
  inherited Destroy;
end;

function TJwAutoAbout.Execute : Boolean;
var
  Dlg: TfrmAutoAbout;
begin
  Dlg := TfrmAutoAbout.Create( Application );
  try
    Dlg.imgIcon.Picture.Assign( FAppPic );
    Dlg.lbProgName.Caption := FAppName;
    Dlg.lbVersion.Caption := FVersion;
    Dlg.memComments.Lines.Assign( FComments );
    Dlg.lbLastEdited.Caption := FLastEdited;
    Dlg.lbControlCode.Caption := FControlCode;

    Dlg.ShowModal;
  finally
    Dlg.Free;
  end;
  Result := True
end;

procedure TJwAutoAbout.Loaded;
begin
  inherited Loaded;
end;



procedure TfrmAutoAbout.btOkayClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TfrmAutoAbout.FormShow(Sender: TObject);
begin
  btOkay.SetFocus;
end;

end.
