#ifndef VGA3D_H
#define VGA3D_H

//      Objects instantiated from this class may be used to plot z=f(x,y) in
// in three dimensions on a VGA display.

//      This class uses the abstract class "plot3d" (3D plot) which in turn uses 
// the template "varray" (one dimensional virtual array) and the class
// "titillat" (to let the user know the code is running).

#include "plot3d.h"

typedef char * char_ptr;

// screen constants
#define HEIGHT_OF_SCREEN    6.0  
#define WIDTH_OF_SCREEN     8.0  // same units as HEIGHT_OF_SCREEN

// graphics constants
#define NUM_X_PIXELS      640
#define NUM_Y_PIXELS      480

class vga3d : public plot3d
  {
    private:
      double AspectRatio;
               // (HEIGHT_OF_SCREEN/WIDTH_OF_SCREEN)
               // /(((double) NUM_Y_PIXELS)/((double) NUM_X_PIXELS))
      int    graph_open;
               // TRUE if and only if the display has been initialized.
    public:
      double aspect_ratio(void) {return AspectRatio;}

      int    display_initialized(void);
               // Set display to 640x480x16 VGA mode.  Define shades of gray
               // and color for highlighting.

      int    num_x_pixels(void) {return NUM_X_PIXELS;}

      int    num_y_pixels(void) {return NUM_Y_PIXELS;}

      void   pset(int x,int y,int color_num);
               // Set the color of the pixel at (x,y).

             vga3d(void);

             ~vga3d(void);

      int    write_outfile(char *file_name) {return -1;}
  };

#endif
