/*
 *      test.c: Simple test program for passwd library
 *
 *      Stephen C. Trier
 *      March 26, 1990
 *
 */

#include <stdio.h>
#include <pwd.h>

main()
{
    int i;
    struct passwd *temp;

    for (i = 0; i < 2; i++)  {
	while ((temp = getpwent()) != NULL)  {
	    printf("Name: %s  Password: %s  User Num: %d  Group Num: %d\n",
		    temp->pw_name, temp->pw_passwd, temp->pw_uid, temp->pw_gid);
	    printf("Full Name: %s  Home Dir: %s  Shell: %s\n\n",
		    temp->pw_gecos, temp->pw_dir, temp->pw_shell);
	    }
	printf("setpwent returns %d\n", setpwent());
	}
    temp = getpwnam("user3");
    printf("Finding user3: %s\n", temp->pw_name);
    temp = getpwnam("user1");
    printf("Finding user1: %s\n", temp->pw_name);
    temp = getpwnam("user2");
    printf("Finding user2: %s\n", temp->pw_name);
    temp = getpwnam("user4");
    printf("Finding user4: %s  (Should be NULL)\n\n",
	    temp ? temp->pw_name : "NULL");

    temp = getpwuid(2);
    printf("Finding user id 2: %s\n", temp->pw_name);
    temp = getpwuid(1);
    printf("Finding user id 1: %s\n", temp->pw_name);
    temp = getpwuid(3);
    printf("Finding user id 3: %s\n", temp->pw_name);
    temp = getpwuid(4);
    printf("Finding user id 4: %s  (Should be NULL)\n\n",
	    temp ? temp->pw_name : "NULL");

    printf("endpwent returns %d\n", endpwent());
    return 0;  /* Keep Turbo C lint happy */
}
