;PPMPX6.ASM 3.3(for DPMI)
;	MACHINE LANGUAGE SUBROUTINES
;	FOR PPMPQS
;	1991-97 by YUJI KIDA
;
.386p

code	segment	use16
	assume	cs:code,ds:code


	INCLUDE	UBP.MAC
	include	ppmpx.h

	org	100h
start:
	JMP	start0

	include	dpmi4ub.h
	include	dpmi4ub.lib


  align	4
primebase		dd	?
ROWSbase		dd	?
decompdatabase		dd	?
decomppointerbase	dd	?
historybase		dd	?

totaloperations		dd	?

P_OFF		dd	?
E_OFF		dd	?

Y_OFF		dw	?
Y_SEG		dw	?

DRV_OFF		dw	?
DRV_SEG		dw	?

primes		dd	?
FBsize		dd	?
Rmatrixsize	dw	?

primehandle	dw	?
ROWShandle	dw	?
decomphandle	dw	?
anshandle	dw	?
histhandle	dw	?

databuffer	dw	?
ans_seg		dw	?

Rbytes		dw	?
Rwords		dw	?

Tbytes		dw	?
Twords		dw	?
Tdwords		dw	?

spmem		dw	?


;branch

START0:
	MOV_AX	AR0		;ARRAY[0] is the command number
	MOV	BX,OFFSET CMD_TBL
	SHL	AX,1
	ADD	BX,AX
	JMP	CS:[BX]

CMD_TBL:
	DW	final_init,square_ans,putPandE,closefiles

;
; close files and free DPMI memory
;
;command#=3

closefiles:
	mov	ah,3eh
	mov	bx,cs:[anshandle]
	or	bx,bx
	jz	short closefnext
	int	21h
closefnext:
	call	freemainDATAmemory
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

;
; answer exponents of p
;
;command#=2

putPandE:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	call	real2protB

	mov	ebx,[primebase]
	add	ebx,12			;exp part of 2
	mov	ecx,[primes]
putPE10:
	mov	eax,fs:[ebx]
	or	eax,eax
	jnz	short putPE100
	add	ebx,8
	dec	ecx
	jnz	putPE10

	mov	esi,[P_OFF]
	mov	word ptr fs:[esi],0		;set 0 = no more data

putPEret:
	call	prot2real
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

putPE100:
	mov	dword ptr fs:[ebx],0	;clear
	mov	esi,[E_OFF]
	call	seteax
	mov	eax,fs:[ebx-4]
	mov	esi,[P_OFF]
	call	seteax
	jmp	putPEret

seteax:
	mov	cx,2
	cmp	eax,10000h
	jae	short seteaxjp
	dec	cx
	or	ax,ax
	jnz	short seteaxjp
	dec	cx
seteaxjp:
	mov	fs:[esi],cx
	mov	fs:[esi+2],eax
	ret


;
; answer square data
;
;command#=1

square_ans:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	mov	[spmem],sp

ans_again:
	mov	dx,offset BUFFER	;read answer
	mov	cx,[Rbytes]
	mov	bx,[anshandle]
	mov	ah,3fh
	int	21h
	or	ax,ax
	jz	nomoreanswer

	add	ax,offset BUFFER
	add	ax,3
	and	ax,0fffch
	mov	[databuffer],ax

	call	real2protB
	call	translate
	call	backsubstitution
	call	prot2real

	mov	si,[databuffer]
	mov	cx,[Tbytes]
	mov	di,si
	add	di,cx
	sub	di,2		;di = highest word adr
	shr	cx,1

	xor	ax,ax
	std
	repe	scasw
	cld

	je	ans_again	;illegal answer

	inc	cx		;word length

	mov	es,[ans_seg]
	xor	di,di
	mov	ax,cx
	stosw			;word length
	rep	movsw

	call	real2protB
	call	countexponents
	call	prot2real

squareret:
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

nomoreanswer:
	mov	bx,AR0
	mov	word ptr [bx],0
	jmp	squareret


translate:
	mov	di,[databuffer]
	mov	cx,[Tdwords]
	xor	eax,eax
	rep	stosd

	mov	ebx,[ROWSbase]
	mov	si,offset BUFFER
	mov	cx,[Rwords]
trans10:
	push	cx
	lodsw
	mov	cx,16
trans20:
	shr	ax,1
	jnc	short trans30

	push	cx
	push	ax

	mov	edi,fs:[ebx]
	mov	cx,di
	and	cl,7
	shr	edi,3
	mov	al,1
	shl	al,cl
	add	di,[databuffer]
	or	[di],al

	pop	ax
	pop	cx

trans30:
	add	ebx,4
	loop	trans20

	pop	cx
	loop	trans10
	ret


backsubstitution:
	mov	bx,[databuffer]
	mov	edx,[totaloperations]
	mov	esi,edx
	dec	esi
	shl	esi,3			;*8
	add	esi,[historybase]
  align	4
backsubst10:
	mov	edi,fs:[esi]		;dest
	mov	cx,di
	and	cl,7
	shr	edi,3
	mov	al,1
	shl	al,cl
	test	[di+bx],al
	jnz	short backsubst30
backsubst20:
	sub	esi,8
	dec	edx
	jnz	backsubst10
	ret

  align	4
backsubst30:
	mov	edi,fs:[esi+4]		;source
	mov	cx,di
	and	cl,7
	shr	edi,3
	mov	al,1
	shl	al,cl
	xor	[di+bx],al
	jmp	backsubst20


countexponents:
	mov	edi,[primebase]
	add	edi,4			;adr of exponents
	mov	ecx,[FBsize]
	xor	eax,eax
ctexp10:
	mov	fs:[edi],eax		;clear exponents
	add	edi,8
	dec	ecx
	jnz	ctexp10

	mov	ebx,[decomppointerbase]
	mov	si,[databuffer]
	mov	cx,[Twords]
ctexp20:
	push	cx
	lodsw
	mov	cx,16
ctexp30:
	shr	ax,1
	jc	short ctexp100
ctexp40:
	add	ebx,4
	loop	ctexp30

	pop	cx
	dec	cx
	jnz	ctexp20
	ret

ctexp100:
	push	ax
	push	cx

	mov	edi,fs:[ebx]
	mov	cx,fs:[edi]
  align	4
ctexp110:
	add	edi,4
	mov	eax,fs:[edi]
	shl	eax,3			;*8
	add	eax,[primebase]
	add	eax,4
	inc	dword ptr fs:[eax]	;inc exponents
	loop	ctexp110

	pop	cx
	pop	ax
	jmp	ctexp40


;
;* Initialize
;
;COMMAND#=0
;

seg2linear:
	movzx	eax,word ptr [bx+2]
	movzx	edx,word ptr [bx]
	shl	eax,4
	add	eax,edx
	ret

	
final_init:
	;get parameters

	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	mov	[spmem],sp

	MOV_AX	V1+2		;memo the segment of ans%(0)
	ADD	AX,ARRAYHEADSEG
	MOV	[ANS_SEG],AX

	MOV	BX,V2		;memo the address of P
	call	seg2linear
	mov	[P_OFF],eax

	MOV	BX,V3		;memo the address of E
	call	seg2linear
	mov	[E_OFF],eax

	MOV	BX,V4		;memo the address of Y
	MOV	AX,[BX]
	MOV	[Y_OFF],AX
	MOV	AX,[BX+2]
	MOV	[Y_SEG],AX

	MOV	BX,V5		;memo the address of DataDrv$
	MOV	AX,[BX]
	MOV	[DRV_OFF],AX
	MOV	AX,[BX+2]
	MOV	[DRV_SEG],AX

	xor	eax,eax
	mov_ax	AR2
	shl	eax,5			;*32
	mov	[FBsize],eax
	dec	eax
	mov	[primes],eax
	inc	eax
	shr	eax,3			;/ 8
	mov	[Tbytes],ax		;this restrics FBsize < 8*2^16
	shr	ax,1
	mov	[Twords],ax
	shr	ax,1
	mov	[Tdwords],ax

	;get DPMI memory

	call	totalfilesize
	push	eax
	call	getdecompptrsize
	pop	edx
	add	eax,edx
	push	eax
	call	getprimeworksize
	pop	edx
	add	eax,edx
	add	eax,0fh		;for alignment safety *
	mov	[DPMImemorysize],eax

	call	DPMIinit
	jc	dpmierror

	mov	eax,dword ptr [DPMIaddresslow]
	add	eax,0fh		;
	and	al,0f0h		;*
	mov	[primebase],eax

	call	prot2real
	call	openANSFILE
	call	getPRIMES
	call	getROWS
	call	getDECOMPDATA
	call	gethistDATA

initout:
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

diskerror:
	mov	ax,8001h
initerror:
	mov	ds:[AR0],ax
	mov	sp,[spmem]
	jmp	initout

dpmierror:
;	call	prot2real
	mov	ax,8002h
	jmp	initerror


openANSFILE:
	mov	dx,offset ansfilename	;read matrix size
	mov	ax,3d00h		;from answer file
	int	21h
	jc	diskerror
	mov	[anshandle],ax

	mov	dx,offset Rmatrixsize	;get matrixsize
	mov	cx,2
	mov	bx,ax
	mov	ah,3fh			;read
	int	21h
	jc	diskerror

	mov	ax,[Rmatrixsize]
	shr	ax,3
	mov	[Rbytes],ax
	shr	ax,1
	mov	[Rwords],ax
	ret


gethistDATA:
	mov	ax,3d00h		;open for read
	mov	dx,offset historyfilename
	int	21h
	jc	diskerror
	mov	[histhandle],ax

	mov	edi,[historybase]
gethist10:
	mov	dx,offset BUFFER
	mov	cx,1000h
	mov	bx,[histhandle]
	mov	ah,3fh
	int	21h
	or	ax,ax
	jz	short gethisteof

	push	ax
	push	edi
	call	real2protB
	pop	edi
	pop	cx

	shr	cx,2
	mov	si,offset BUFFER
gethist20:
	lodsd
	mov	fs:[edi],eax
	add	edi,4
	loop	gethist20

	push	edi
	call	prot2real
	pop	edi
	jmp	gethist10

gethisteof:
	sub	edi,[historybase]
	shr	edi,3			;8bytes/unit
	mov	[totaloperations],edi

	mov	ah,3eh			;close file
	mov	bx,[histhandle]
	int	21h
	ret


getDECOMPDATA:
	mov	si,offset decompfilename
	call	setpathname
	mov	dx,offset BUFFER
	mov	ax,3d00h		;open for read
	int	21h
	jc	diskerror
	mov	[decomphandle],ax

	mov	edi,[decompdatabase]
getdecomp10:
	mov	dx,offset BUFFER
	mov	cx,1000h
	mov	bx,[decomphandle]
	mov	ah,3fh
	int	21h

	or	ax,ax
	jz	short getdecompeof

	push	ax
	push	edi
	call	real2protB
	pop	edi
	pop	cx

	shr	cx,2
	mov	si,offset BUFFER
getdecomp20:
	lodsd
	mov	fs:[edi],eax
	add	edi,4
	loop	getdecomp20

	push	edi
	call	prot2real
	pop	edi
	jmp	getdecomp10

getdecompeof:
	mov	[decomppointerbase],edi

	mov	ah,3eh			;close file
	mov	bx,[decomphandle]
	int	21h

	call	real2protB

	mov	ebx,[decomppointerbase]
	mov	eax,[decompdatabase]
getdecomp100:
	mov	fs:[ebx],eax
	mov	edx,fs:[eax]
	inc	edx
	shl	edx,2
	add	eax,edx
	add	ebx,4
	cmp	eax,[decomppointerbase]
	jb	getdecomp100

	mov	[historybase],ebx

	call	prot2real
	ret


getROWS:
	mov	ax,3d00h		;open for read
	mov	dx,offset ROWSfilename
	int	21h
	jc	diskerror
	mov	[ROWShandle],ax

	mov	edi,[ROWSbase]
getROWS10:
	mov	dx,offset BUFFER
	mov	cx,1000h
	mov	bx,[ROWShandle]
	mov	ah,3fh			;read
	int	21h
	or	ax,ax
	jz	short getROWSeof

	push	ax
	push	edi
	call	real2protB
	pop	edi
	pop	cx

	shr	cx,2
	mov	si,offset BUFFER
getROWS20:
	lodsd
	mov	fs:[edi],eax
	add	edi,4
	loop	getROWS20

	push	edi
	call	prot2real
	pop	edi
	jmp	getROWS10

getROWSeof:
	mov	[decompdatabase],edi

	mov	ah,3eh			;close file
	mov	bx,[ROWShandle]
	int	21h
	ret


getPRIMES:
	mov	si,offset primefilename
	call	setpathname
	mov	dx,offset BUFFER
	mov	ax,3d00h		;open for read
	int	21h
	jc	diskerror
	mov	[primehandle],ax

	mov	edi,[primebase]
primelp:
	mov	dx,offset BUFFER
	mov	cx,1000h
	mov	bx,[primehandle]
	mov	ah,3fh
	int	21h
	or	ax,ax
	jz	short primeeof

	push	ax
	push	edi
	call	real2protB
	pop	edi
	pop	cx

	shr	cx,2
	mov	si,offset BUFFER
prime50:
	lodsd
	mov	fs:[edi],eax
	add	edi,8		;additional dword is used for exponent
	loop	prime50

	push	edi
	call	prot2real
	pop	edi
	jmp	primelp

primeeof:
	mov	[ROWSbase],edi

	mov	ah,3eh
	mov	bx,[primehandle]
	int	21h
	ret


setpathname:				;input si
	push	ax
	push	cx
	push	di

	push	ds			;/*
	push	si

	lds	si,dword ptr [Drv_off]
	mov	di,offset BUFFER
	lodsw
	mov	cx,ax
	shl	cx,1
	and	cx,00ffh		;cut 255 chars
	shl	ax,1
	jnc	short setpath10
	dec	cx
setpath10:
	rep	movsb

	pop	si
	pop	ds			;*/

setpath20:
	lodsb
	stosb
	or	al,al
	jnz	setpath20

	pop	di
	pop	cx
	pop	ax
	ret


getdecompptrsize:
	mov	dx,offset DECOMPFILENAME
	mov	ax,3d00h		;read open
	int	21h

	mov	bx,ax
	xor	esi,esi
getdecompptrsize10:
	mov	ah,3fh		;read file
	mov	cx,4
	mov	dx,offset BUFFER
	int	21h
	or	ax,ax
	jz	getdecompptrsize20		;eof

	mov	edx,dword ptr [BUFFER]	;# of members
	shl	edx,2		;*4
	add	esi,4

	push	edx
	pop	dx
	pop	cx
	mov	ax,4201h		;move file ptr
	int	21h
	jmp	getdecompptrsize10

getdecompptrsize20:
	mov	ah,3eh			;close file
	int	21h
	mov	eax,esi			;eax = result
	ret


getprimeworksize:
	mov	dx,offset primefilename
	call	getfilesize
	shl	eax,1		;use additional area
	ret


totalfilesize:
	xor	esi,esi
	mov	dx,offset ROWSFILENAME
	call	getfilesize
	add	esi,eax
	mov	dx,offset DECOMPFILENAME
	call	getfilesize
	add	esi,eax
	mov	dx,offset historyfilename
	call	getfilesize
	add	eax,esi			;eax = result
	ret


getfilesize:
	;inp dx = offset of file name
	;out eax = size

	mov	ax,3d00h		;read open
	int	21h

	push	ax			;handle
	mov	bx,ax
	mov	ax,4202h		;move file ptr to end
	xor	cx,cx
	xor	dx,dx
	int	21h
					;now dx:ax = file size
	pop	bx
	push	dx
	push	ax

	mov	ah,3eh			;close file
	int	21h

	pop	eax
	ret


primefilename	db	'PPMPPRMS.PPM',0
ansfilename	db	'PPMPANS.PPM',0
historyfilename	db	'PPMPHIST.PPM',0
ROWSFILENAME	db	'PPMPROWS.PPM',0
DECOMPFILENAME	db	'PPMPDCMP.PPM',0


	align	4
BUFFER	dw	maxbufferwords dup(0)

CODE	ENDS
END	START
